/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_COM_TYPES__
#define __TIFFEP_COM_TYPES__

#include "calc_defs.h"

#define COMMON_MAXTYPES 48

#define TI82_MAXTYPES  48
#define TI83_MAXTYPES  48
#define TI83P_MAXTYPES 48
#define TI85_MAXTYPES  48
#define TI86_MAXTYPES  48
#define TI89_MAXTYPES  48
#define TI92_MAXTYPES  48
#define TI92P_MAXTYPES 48
#define TI83p_MAXTYPES TI83P_MAXTYPES
#define TI92p_MAXTYPES TI92P_MAXTYPES

extern gint TI82_TYPES_TO_COMMON_TYPES[TI82_MAXTYPES];
extern gint TI83_TYPES_TO_COMMON_TYPES[TI83_MAXTYPES];
extern gint TI83P_TYPES_TO_COMMON_TYPES[TI83P_MAXTYPES];
extern gint TI85_TYPES_TO_COMMON_TYPES[TI85_MAXTYPES];
extern gint TI86_TYPES_TO_COMMON_TYPES[TI86_MAXTYPES];
extern gint TI89_TYPES_TO_COMMON_TYPES[TI89_MAXTYPES];
extern gint TI92_TYPES_TO_COMMON_TYPES[TI92_MAXTYPES];
extern gint TI92P_TYPES_TO_COMMON_TYPES[TI92P_MAXTYPES];
gint TIxx_TYPES_TO_COMMON_TYPES(gint type, gint calc_type);

extern gint COMMON_TYPES_TO_TI82_TYPES[COMMON_MAXTYPES];
extern gint COMMON_TYPES_TO_TI83_TYPES[COMMON_MAXTYPES];
extern gint COMMON_TYPES_TO_TI83P_TYPES[COMMON_MAXTYPES];
extern gint COMMON_TYPES_TO_TI85_TYPES[COMMON_MAXTYPES];
extern gint COMMON_TYPES_TO_TI86_TYPES[COMMON_MAXTYPES];
extern gint COMMON_TYPES_TO_TI89_TYPES[COMMON_MAXTYPES];
extern gint COMMON_TYPES_TO_TI92_TYPES[COMMON_MAXTYPES];
extern gint COMMON_TYPES_TO_TI92P_TYPES[COMMON_MAXTYPES];
gint COMMON_TYPES_TO_TIxx_TYPES(gint type, gint calc_type);


extern const char* TI82_TYPES[TI82_MAXTYPES];
extern const char* TI83_TYPES[TI83_MAXTYPES];
extern const char* TI83P_TYPES[TI83P_MAXTYPES];
extern const char* TI85_TYPES[TI85_MAXTYPES];
extern const char* TI86_TYPES[TI86_MAXTYPES];
extern const char* TI89_TYPES[TI89_MAXTYPES];
extern const char* TI92_TYPES[TI92_MAXTYPES];
extern const char* TI92P_TYPES[TI92P_MAXTYPES];
#define TI83p_TYPES TI83P_TYPES
#define TI92p_TYPES TI92P_TYPES

extern const char* TI82_EXT[TI82_MAXTYPES];
extern const char* TI83_EXT[TI83_MAXTYPES];
extern const char* TI83P_EXT[TI83P_MAXTYPES];
extern const char* TI85_EXT[TI85_MAXTYPES];
extern const char* TI86_EXT[TI86_MAXTYPES];
extern const char* TI89_EXT[TI89_MAXTYPES];
extern const char* TI92_EXT[TI92_MAXTYPES];
extern const char* TI92P_EXT[TI92P_MAXTYPES];
#define TI83p_EXT TI83P_EXT
#define TI92p_EXT TI92P_EXT

extern const char GROUP_FILE_EXT[CALC_MAX][4];
extern const char BACKUP_FILE_EXT[CALC_MAX][4];
extern const char FLASH_APP_FILE_EXT[CALC_MAX][4];
extern const char FLASH_OS_FILE_EXT[CALC_MAX][4];

#endif

