# Configure paths for TIFFEP
# Owen Taylor     97-11-3

dnl AM_PATH_TIFFEP([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for TIFFEP, and define TIFFEP_CFLAGS and TIFFEP_LIBS, if "gmodule" or 
dnl gthread is specified in MODULES, pass to tiffep-config
dnl
AC_DEFUN(AM_PATH_TIFFEP,
[dnl 
dnl Get the cflags and libraries from the tiffep-config script
dnl
AC_ARG_WITH(tiffep-prefix,[  --with-tiffep-prefix=PFX   Prefix where TIFFEP is installed (optional)],
            tiffep_config_prefix="$withval", tiffep_config_prefix="")
AC_ARG_WITH(tiffep-exec-prefix,[  --with-tiffep-exec-prefix=PFX Exec prefix where TIFFEP is installed (optional)],
            tiffep_config_exec_prefix="$withval", tiffep_config_exec_prefix="")
AC_ARG_ENABLE(tiffeptest, [  --disable-tiffeptest       Do not try to compile and run a test TIFFEP program],
		    , enable_tiffeptest=yes)

  if test x$tiffep_config_exec_prefix != x ; then
     tiffep_config_args="$tiffep_config_args --exec-prefix=$tiffep_config_exec_prefix"
     if test x${TIFFEP_CONFIG+set} != xset ; then
        TIFFEP_CONFIG=$tiffep_config_exec_prefix/bin/tiffep-config
     fi
  fi
  if test x$tiffep_config_prefix != x ; then
     tiffep_config_args="$tiffep_config_args --prefix=$tiffep_config_prefix"
     if test x${TIFFEP_CONFIG+set} != xset ; then
        TIFFEP_CONFIG=$tiffep_config_prefix/bin/tiffep-config
     fi
  fi

  for module in . $4
  do
      case "$module" in
         gmodule) 
             tiffep_config_args="$tiffep_config_args gmodule"
         ;;
         gthread) 
             tiffep_config_args="$tiffep_config_args gthread"
         ;;
      esac
  done

  AC_PATH_PROG(TIFFEP_CONFIG, tiffep-config, no)
  min_tiffep_version=ifelse([$1], ,0.99.7,$1)
  AC_MSG_CHECKING(for TIFFEP - version >= $min_tiffep_version)
  no_tiffep=""
  if test "$TIFFEP_CONFIG" = "no" ; then
    no_tiffep=yes
  else
    TIFFEP_CFLAGS=`$TIFFEP_CONFIG $tiffep_config_args --cflags`
    TIFFEP_LIBS=`$TIFFEP_CONFIG $tiffep_config_args --libs`
    tiffep_config_major_version=`$TIFFEP_CONFIG $tiffep_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    tiffep_config_minor_version=`$TIFFEP_CONFIG $tiffep_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    tiffep_config_micro_version=`$TIFFEP_CONFIG $tiffep_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_tiffeptest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $TIFFEP_CFLAGS"
      LIBS="$TIFFEP_LIBS $LIBS"
dnl
dnl Now check if the installed TIFFEP is sufficiently new. (Also sanity
dnl checks the results of tiffep-config to some extent
dnl
      rm -f conf.tiffeptest
      AC_TRY_RUN([
#include <tiffep.h>
#include <stdio.h>
#include <stdlib.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.tiffeptest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = g_strdup("$min_tiffep_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_tiffep_version");
     exit(1);
   }

  if ((tiffep_major_version != $tiffep_config_major_version) ||
      (tiffep_minor_version != $tiffep_config_minor_version) ||
      (tiffep_micro_version != $tiffep_config_micro_version))
    {
      printf("\n*** 'tiffep-config --version' returned %d.%d.%d, but TIFFEP (%d.%d.%d)\n", 
             $tiffep_config_major_version, $tiffep_config_minor_version, $tiffep_config_micro_version,
             tiffep_major_version, tiffep_minor_version, tiffep_micro_version);
      printf ("*** was found! If tiffep-config was correct, then it is best\n");
      printf ("*** to remove the old version of TIFFEP. You may also be able to fix the error\n");
      printf("*** by modifying your LD_LIBRARY_PATH enviroment variable, or by editing\n");
      printf("*** /etc/ld.so.conf. Make sure you have run ldconfig if that is\n");
      printf("*** required on your system.\n");
      printf("*** If tiffep-config was wrong, set the environment variable TIFFEP_CONFIG\n");
      printf("*** to point to the correct copy of tiffep-config, and remove the file config.cache\n");
      printf("*** before re-running configure\n");
    } 
  else if ((tiffep_major_version != TIFFEP_MAJOR_VERSION) ||
	   (tiffep_minor_version != TIFFEP_MINOR_VERSION) ||
           (tiffep_micro_version != TIFFEP_MICRO_VERSION))
    {
      printf("*** TIFFEP header files (version %d.%d.%d) do not match\n",
	     TIFFEP_MAJOR_VERSION, TIFFEP_MINOR_VERSION, TIFFEP_MICRO_VERSION);
      printf("*** library (version %d.%d.%d)\n",
	     tiffep_major_version, tiffep_minor_version, tiffep_micro_version);
    }
  else
    {
      if ((tiffep_major_version > major) ||
        ((tiffep_major_version == major) && (tiffep_minor_version > minor)) ||
        ((tiffep_major_version == major) && (tiffep_minor_version == minor) && (tiffep_micro_version >= micro)))
      {
        return 0;
       }
     else
      {
        printf("\n*** An old version of TIFFEP (%d.%d.%d) was found.\n",
               tiffep_major_version, tiffep_minor_version, tiffep_micro_version);
        printf("*** You need a version of TIFFEP newer than %d.%d.%d. The latest version of\n",
	       major, minor, micro);
        printf("*** TIFFEP is always available from ftp://ftp.gtk.org.\n");
        printf("***\n");
        printf("*** If you have already installed a sufficiently new version, this error\n");
        printf("*** probably means that the wrong copy of the tiffep-config shell script is\n");
        printf("*** being found. The easiest way to fix this is to remove the old version\n");
        printf("*** of TIFFEP, but you can also set the TIFFEP_CONFIG environment to point to the\n");
        printf("*** correct copy of tiffep-config. (In this case, you will have to\n");
        printf("*** modify your LD_LIBRARY_PATH enviroment variable, or edit /etc/ld.so.conf\n");
        printf("*** so that the correct libraries are found at run-time))\n");
      }
    }
  return 1;
}
],, no_tiffep=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_tiffep" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$TIFFEP_CONFIG" = "no" ; then
       echo "*** The tiffep-config script installed by TIFFEP could not be found"
       echo "*** If TIFFEP was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the TIFFEP_CONFIG environment variable to the"
       echo "*** full path to tiffep-config."
     else
       if test -f conf.tiffeptest ; then
        :
       else
          echo "*** Could not run TIFFEP test program, checking why..."
          CFLAGS="$CFLAGS $TIFFEP_CFLAGS"
          LIBS="$LIBS $TIFFEP_LIBS"
          AC_TRY_LINK([
#include <tiffep.h>
#include <stdio.h>
],      [ return ((tiffep_major_version) || (tiffep_minor_version) || (tiffep_micro_version)); ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding TIFFEP or finding the wrong"
          echo "*** version of TIFFEP. If it is not finding TIFFEP, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***"
          echo "*** If you have a RedHat 5.0 system, you should remove the GTK package that"
          echo "*** came with the system with the command"
          echo "***"
          echo "***    rpm --erase --nodeps gtk gtk-devel" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means TIFFEP was incorrectly installed"
          echo "*** or that you have moved TIFFEP since it was installed. In the latter case, you"
          echo "*** may want to edit the tiffep-config script: $TIFFEP_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     TIFFEP_CFLAGS=""
     TIFFEP_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(TIFFEP_CFLAGS)
  AC_SUBST(TIFFEP_LIBS)
  rm -f conf.tiffeptest
])
