/*  libticables - link cable library, a part of the TiLP project
 *  Copyright (C) 1999-2002  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef VTLLINK_H
#define VTLLINK_H

#include "typedefs.h"

int vtl_init();
int vtl_open();
int vtl_put(byte data);
int vtl_get(byte *data);
int vtl_probe();
int vtl_close();
int vtl_exit();
int vtl_check(int *status);

int vtl_set_red_wire(int b);
int vtl_set_white_wire(int b);
int vtl_get_red_wire();
int vtl_get_white_wire();

int vtl_supported();

#endif
