/*
TerraLib - a library for developing GIS applications.
Copyright  2001, 2002, 2003 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular
purpose. The library provided hereunder is on an "as is" basis, and the
authors have no obligation to provide maintenance, support, updates,
enhancements, or modifications.
In no event shall INPE be held liable to any party
for direct, indirect, special, incidental, or consequential damages arising
out of the use of this library and its documentation.
*/

#ifndef TEPDILINEARFILTER_HPP
  #define TEPDILINEARFILTER_HPP

  #include "TePDIFilter.hpp"
  #include "TePDIParameters.hpp"

  #include "TePDISharedPtr.cpp"

  /**
   *   This is the class for image Linear filtering processing.
   */
  class TePDILinearFilter : public TePDIFilter{
    public :
      typedef TePDISharedPtr< TePDILinearFilter > pointer;
      typedef const TePDISharedPtr< TePDILinearFilter > const_pointer;

      /**
       * Default Constructor.
       *
       */
      TePDILinearFilter();

      /**
       * Alternative Constructor
       *
       * @param params Algoritm parameters.
       */
      TePDILinearFilter( const TePDIParameters& params );

      /**
       * Default Destructor
       */
      ~TePDILinearFilter();

      /**
       * Checks if the supplied parameters fits the requirements of each
       * PDI algorithm implementation.
       *
       * Error log messages must be generated. No exceptions generated.
       *
       * @param parameters The parameters to be checked.
       * @return true if the parameters are OK. false if not.
       */
      bool CheckParameters( const TePDIParameters& parameters );

    protected :

      /**
       * Runs the current algorithm implementation.
       *
       * @return true if OK. false on error.
       */
      bool RunImplementation();

      /**
       * Reset the internal state to the initial state.
       */
      void ResetState();

  };

#endif //TEPDILINEARFILTER_HPP
