#include "TePDIBox.hpp"

#include "TePDIAgnostic.hpp"


TePDIBox::TePDIBox( unsigned long int top_left_x,
                    unsigned long int top_left_y,
                    unsigned long int bottom_right_x,
                    unsigned long int bottom_right_y )
{
  Reset( top_left_x, top_left_y, bottom_right_x, bottom_right_y );
}


TePDIBox::~TePDIBox()
{

}


void TePDIBox::Reset( unsigned long int top_left_x,
                      unsigned long int top_left_y,
                      unsigned long int bottom_right_x,
                      unsigned long int bottom_right_y )
{

  PDIAGN_TRUE_OR_THROW( top_left_x < bottom_right_x,
    "Invalid supplied parameter X" );

  PDIAGN_TRUE_OR_THROW( top_left_y < bottom_right_y,
    "Invalid supplied parameter Y" );

  top_left_x_ = top_left_x;
  top_left_y_ = top_left_y;
  bottom_right_x_ = bottom_right_x;
  bottom_right_y_ = bottom_right_y;
}
