/*
 * Parser input using a std::string as input
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#pragma implementation

#include <tagcoll/StringParserInput.h>

using namespace std;

const string StringParserInput::fname("<string>");

StringParserInput::StringParserInput(const std::string& str) throw ()
	: _str(str), _s(str.begin()), _line(1) {}

int StringParserInput::nextChar() throw ()
{
	if (_s == _str.end())
		return ParserInput::Eof;
	
	if (*_s == '\n')
		_line++;
	return *_s++;
}

void StringParserInput::pushChar(int c) throw ()
{
	_s--;
}

// vim:set ts=4 sw=4:
