#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

/**
 * SwLastfmIface:
 *
 * Dummy typedef representing any implementation of this interface.
 */
typedef struct _SwLastfmIface SwLastfmIface;

/**
 * SwLastfmIfaceClass:
 *
 * The class of SwLastfmIface.
 */
typedef struct _SwLastfmIfaceClass SwLastfmIfaceClass;

GType sw_lastfm_iface_get_type (void);
#define SW_TYPE_LASTFM_IFACE \
  (sw_lastfm_iface_get_type ())
#define SW_LASTFM_IFACE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), SW_TYPE_LASTFM_IFACE, SwLastfmIface))
#define SW_IS_LASTFM_IFACE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), SW_TYPE_LASTFM_IFACE))
#define SW_LASTFM_IFACE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_INTERFACE((obj), SW_TYPE_LASTFM_IFACE, SwLastfmIfaceClass))


typedef void (*sw_lastfm_iface_now_playing_impl) (SwLastfmIface *self,
    const gchar *in_artist,
    const gchar *in_album,
    const gchar *in_track,
    guint in_length,
    guint in_tracknumber,
    const gchar *in_musicbrainz,
    DBusGMethodInvocation *context);
void sw_lastfm_iface_implement_now_playing (SwLastfmIfaceClass *klass, sw_lastfm_iface_now_playing_impl impl);
/**
 * sw_lastfm_iface_return_from_now_playing:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void sw_lastfm_iface_return_from_now_playing (DBusGMethodInvocation *context);
static inline void
sw_lastfm_iface_return_from_now_playing (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}

typedef void (*sw_lastfm_iface_submit_track_impl) (SwLastfmIface *self,
    const gchar *in_artist,
    const gchar *in_album,
    const gchar *in_track,
    gint64 in_time,
    const gchar *in_source,
    const gchar *in_rating,
    guint in_length,
    guint in_tracknumber,
    const gchar *in_musicbrainz,
    DBusGMethodInvocation *context);
void sw_lastfm_iface_implement_submit_track (SwLastfmIfaceClass *klass, sw_lastfm_iface_submit_track_impl impl);
/**
 * sw_lastfm_iface_return_from_submit_track:
 * @context: The D-Bus method invocation context
 *
 * Return successfully by calling dbus_g_method_return().
 * This inline function exists only to provide type-safety.
 */
static inline
/* this comment is to stop gtkdoc realising this is static */
void sw_lastfm_iface_return_from_submit_track (DBusGMethodInvocation *context);
static inline void
sw_lastfm_iface_return_from_submit_track (DBusGMethodInvocation *context)
{
  dbus_g_method_return (context);
}



G_END_DECLS
