# we don't currently package all files under buildroot. This is required so
# rpm doesn't complain.
%define _unpackaged_files_terminate_build	0

# automatically determine if we should build docs
%define build_docs %( ( which doxygen > /dev/null 2>&1 && echo 1) || echo 0 )

# build rpm containing everything statically linked
%define build_static 0

# build bios update tools rpm
%define run_cppunit %( ([ -e /usr/include/cppunit ] && echo 1) || echo 0)

%define major "0"
%define minor "12"
%define sub   "1"
%define extralevel ""

# allow --with[out] <feature> at rpm command line build, to override the above
# e.g. --with static    ...or...   --without static 
%{?_without_static: %{expand: %%define build_static 0}}
%{?_with_static: %{expand: %%define build_static 1}}
%{?_without_docs: %{expand: %%define build_docs 0}}
%{?_with_docs: %{expand: %%define build_docs 1}}
%{?_without_cppunit: %{expand: %%define run_cppunit 0}}
%{?_with_cppunit: %{expand: %%define run_cppunit 1}}

Name: libsmbios
Version: 0.12.1
Release: 2%{?dist:%{dist}}
License: Dell Proprietary
Packager: Michael E Brown <Michael_E_Brown@dell.com>
Source: libsmbios-0.12.1.tar.bz2
Summary: Open BIOS parsing libs
Group: Applications/Libraries
Buildroot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: libxml2-devel
BuildRequires: cppunit-devel

%description
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

%package libs
Summary: Libsmbios shared libraries.
Group: Applications/Libraries
Obsoletes: libsmbiosxml-libs


%package bin
Summary: The "supported" sample binaries that use libsmbios
Group: Applications/Binaries
Requires: libsmbios-libs = 0.12.1
Obsoletes: libsmbiosxml-bin

%package unsupported-bin
Summary: Unsupported sample binaries using libsmbios
Group: Applications/Binaries
Requires: libsmbios-libs = 0.12.1

%package devel
Summary: development headers and archives
Group: Applications/Development

%package static
Summary: All of the libsmbios binaries that can be statically built
Group: Applications/Binaries

%description libs
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

%description devel
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains the headers and .a files necessary to compile new 
client programs against libsmbios

%description bin
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains some sample binaries that use libsmbios.

%description unsupported-bin
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains some sample binaries that use libsmbios.

%description static
Libsmbios is a library and utilites that can be used by client programs 
to get information from standard BIOS tables, such as the SMBIOS table.

This package contains some sample binaries that use libsmbios.

%prep
%setup 

%build
make -e RELEASE_MAJOR=%{major} RELEASE_MINOR=%{minor} RELEASE_SUBLEVEL=%{sub} RELEASE_EXTRALEVEL=%{extralevel} default xml
%if %{build_static}
    make -e RELEASE_MAJOR=%{major} RELEASE_MINOR=%{minor} RELEASE_SUBLEVEL=%{sub} RELEASE_EXTRALEVEL=%{extralevel} static
%endif
%if %{build_docs}
    make -e RELEASE_MAJOR=%{major} RELEASE_MINOR=%{minor} RELEASE_SUBLEVEL=%{sub} RELEASE_EXTRALEVEL=%{extralevel} doxygen
%endif
%if %{run_cppunit}
    make -e RELEASE_MAJOR=%{major} RELEASE_MINOR=%{minor} RELEASE_SUBLEVEL=%{sub} RELEASE_EXTRALEVEL=%{extralevel} unit_test
%endif

%install

# %{_sysconfdir}/rc.d/init.d/  
# %{_sysconfdir}/firmware/      config
# %{_bindir}                    binaries
# %{_datadir}/firmware/         Firmware images

[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf ${RPM_BUILD_ROOT}
install -d -m 755                               \
    $RPM_BUILD_ROOT/%{_bindir}                  \
    $RPM_BUILD_ROOT/%{_libdir}                  \
    $RPM_BUILD_ROOT/usr/include/                \
    $RPM_BUILD_ROOT/%{_sysconfdir}              \
    $RPM_BUILD_ROOT/%{_sysconfdir}/rc.d/init.d/ \
    $RPM_BUILD_ROOT/%{_datadir}/firmware        

install -D -m 555 supported-bins/output/* $RPM_BUILD_ROOT/%{_bindir}
install -D -m 555 bins/output/* $RPM_BUILD_ROOT/%{_bindir}

cp    lib/libsmbios*                        $RPM_BUILD_ROOT/%{_libdir}/
cp -a include/smbios                        $RPM_BUILD_ROOT/usr/include/

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf ${RPM_BUILD_ROOT}

%post libs
ldconfig

%files libs
%defattr(-,root,root)
%doc COPYING-GPL COPYING-OSL README
%{_libdir}/libsmbios.so.*.*
%{_libdir}/libsmbiosxml.so.*.*

%files devel
%defattr(-,root,root)
%doc COPYING-GPL COPYING-OSL README
%{_libdir}/libsmbios.so
/usr/include/smbios
%{_libdir}/libsmbiosxml.so

%if %{build_docs}
    %doc doc/full/html
%endif


%files bin 
%defattr(-,root,root)
%doc COPYING-GPL COPYING-OSL README
%{_bindir}/assetTag
%{_bindir}/dellBiosUpdate
%{_bindir}/getSystemId
%{_bindir}/propertyTag
%{_bindir}/serviceTag
%{_bindir}/tokenCtl
%{_bindir}/verifySmiPassword
%{_bindir}/wakeupCtl
%{_bindir}/dellLcdBrightness

%files unsupported-bin 
%defattr(-,root,root)
%doc COPYING-GPL COPYING-OSL README
%{_bindir}/activateCmosToken
%{_bindir}/ascii2enUS_scancode
%{_bindir}/createUnitTestFiles
%{_bindir}/disable_console_redir
%{_bindir}/dumpCmos
%{_bindir}/getPasswordFormat
%{_bindir}/isCmosTokenActive
%{_bindir}/probes
%{_bindir}/smitest
%{_bindir}/stateByteCtl
%{_bindir}/upBootCtl
%{_bindir}/dumpSmbios

%if %{build_static}
%files static 
%defattr(-,root,root)
%doc COPYING-GPL COPYING-OSL README
%{_bindir}/*S
%endif
