package com.sap.dbtech.jdbc.packet;

import com.sap.dbtech.rte.comm.RteC;
import com.sap.dbtech.vsp001.Feature;
import com.sap.dbtech.vsp001.Packet;

/*


 ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


 */

public class ReplyPacketFactory {

    public static ReplyPacket getReplyPacket(
            com.sap.dbtech.util.StructuredMem rawPacket, boolean asciiOutputForAsciiColumns) {
        
        int encoding = rawPacket.getInt1(Packet.MessCode_O);
        if (encoding == RteC.asciiClient_C) {
            return new ReplyPacket(rawPacket);
        } else {
            if (asciiOutputForAsciiColumns){
                return new ReplyPacketUnicodeAsciiOutput(rawPacket);
            }else{
                return new ReplyPacketUnicode(rawPacket);
            }
        }
    }
}
