//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qnetworkcookie_c.h"

QNetworkCookieH QNetworkCookie_create(const QByteArrayH name, const QByteArrayH value)
{
	return (QNetworkCookieH) new QNetworkCookie(*(const QByteArray*)name, *(const QByteArray*)value);
}

void QNetworkCookie_destroy(QNetworkCookieH handle)
{
	delete (QNetworkCookie *)handle;
}

QNetworkCookieH QNetworkCookie_create2(const QNetworkCookieH other)
{
	return (QNetworkCookieH) new QNetworkCookie(*(const QNetworkCookie*)other);
}

bool QNetworkCookie_isSecure(QNetworkCookieH handle)
{
	return (bool) ((QNetworkCookie *)handle)->isSecure();
}

void QNetworkCookie_setSecure(QNetworkCookieH handle, bool enable)
{
	((QNetworkCookie *)handle)->setSecure(enable);
}

bool QNetworkCookie_isHttpOnly(QNetworkCookieH handle)
{
	return (bool) ((QNetworkCookie *)handle)->isHttpOnly();
}

void QNetworkCookie_setHttpOnly(QNetworkCookieH handle, bool enable)
{
	((QNetworkCookie *)handle)->setHttpOnly(enable);
}

bool QNetworkCookie_isSessionCookie(QNetworkCookieH handle)
{
	return (bool) ((QNetworkCookie *)handle)->isSessionCookie();
}

void QNetworkCookie_expirationDate(QNetworkCookieH handle, QDateTimeH retval)
{
	*(QDateTime *)retval = ((QNetworkCookie *)handle)->expirationDate();
}

void QNetworkCookie_setExpirationDate(QNetworkCookieH handle, const QDateTimeH date)
{
	((QNetworkCookie *)handle)->setExpirationDate(*(const QDateTime*)date);
}

void QNetworkCookie_domain(QNetworkCookieH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QNetworkCookie *)handle)->domain();
	copyQStringToPWideString(t_retval, retval);
}

void QNetworkCookie_setDomain(QNetworkCookieH handle, PWideString domain)
{
	QString t_domain;
	copyPWideStringToQString(domain, t_domain);
	((QNetworkCookie *)handle)->setDomain(t_domain);
}

void QNetworkCookie_path(QNetworkCookieH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QNetworkCookie *)handle)->path();
	copyQStringToPWideString(t_retval, retval);
}

void QNetworkCookie_setPath(QNetworkCookieH handle, PWideString path)
{
	QString t_path;
	copyPWideStringToQString(path, t_path);
	((QNetworkCookie *)handle)->setPath(t_path);
}

void QNetworkCookie_name(QNetworkCookieH handle, QByteArrayH retval)
{
	*(QByteArray *)retval = ((QNetworkCookie *)handle)->name();
}

void QNetworkCookie_setName(QNetworkCookieH handle, const QByteArrayH cookieName)
{
	((QNetworkCookie *)handle)->setName(*(const QByteArray*)cookieName);
}

void QNetworkCookie_value(QNetworkCookieH handle, QByteArrayH retval)
{
	*(QByteArray *)retval = ((QNetworkCookie *)handle)->value();
}

void QNetworkCookie_setValue(QNetworkCookieH handle, const QByteArrayH value)
{
	((QNetworkCookie *)handle)->setValue(*(const QByteArray*)value);
}

void QNetworkCookie_toRawForm(QNetworkCookieH handle, QByteArrayH retval, QNetworkCookie::RawForm form)
{
	*(QByteArray *)retval = ((QNetworkCookie *)handle)->toRawForm(form);
}

QNetworkCookieJarH QNetworkCookieJar_create(QObjectH parent)
{
	return (QNetworkCookieJarH) new QNetworkCookieJar((QObject*)parent);
}

void QNetworkCookieJar_destroy(QNetworkCookieJarH handle)
{
	delete (QNetworkCookieJar *)handle;
}

