//
// $Id: cv.hpp 6478 2014-07-08 20:01:38Z chambm $
//
//
// Darren Kessner <darren@proteowizard.org>
//
// Copyright 2007 Spielberg Family Center for Applied Proteomics
//   Cedars-Sinai Medical Center, Los Angeles, California  90048
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// This file was generated by cvgen.
//
// Do not edit this file! Your changes will be lost next time cvgen is run -
// see pwiz/scripts/misc/update_cv.bat for info on how that works.
// Instead, edit cvgen.cpp itself, or the cv.inl include file if adding static
// code or data.
//


#ifndef _CV_HPP_
#define _CV_HPP_


#include <string>
#include <vector>
#include <map>
#include "pwiz/utility/misc/Export.hpp"


// [psi-ms.obo]
#define _PSI_MS_OBO_
//   format-version: 1.2
//   data-version: 3.65.0
//   date: 02:07:2014 08:55
//   saved-by: Gerhard Mayer
//   auto-generated-by: OBO-Edit 2.3
//   import: http://pato.googlecode.com/svn/trunk/quality.obo
//   import: http://unit-ontology.googlecode.com/svn/trunk/unit.obo
//   default-namespace: MS
//   namespace-id-rule: * MS:$sequence(7,0,9999999)$
//   remark: namespace: MS
//   remark: version: 3.65.0
//   remark: release date: 2014-07-02
//   remark: coverage: Mass spectrometer output files and spectra interpretation
//   remark: creator: Matt Chambers <matt.chambers <-at-> vanderbilt.edu>
//   remark: creator: Andreas Bertsch <bertsch <-at-> informatik.uni-tuebingen.de>
//   remark: creator: Marius Kallhardt <Marius.Kallhardt <-at-> bdal.de>
//   remark: creator: Eric Deutsch <edeutsch <-at-> systemsbiology.org>
//   remark: creator: Fredrik Levander <fredrik.levander <-at-> immun.lth.se>
//   remark: creator: Pierre-Alain Binz <pierre-alain.binz <-at-> chuv.ch>
//   remark: creator: Gerhard Mayer <mayerg97 <-at-> rub.de>
//   remark: publisher: HUPO Proteomics Standards Initiative Mass Spectrometry Standards Working Group and HUPO Proteomics Standards Initiative Proteomics Informatics Working Group
//   remark: When appropriate the definition and synonyms of a term are reported exactly as in the chapter 12 of IUPAC orange book. See http://www.iupac.org/projects/2003/2003-056-2-500.html and http://mass-spec.lsu.edu/msterms/index.php/Main_Page
//   remark: This work is licensed under the Creative Commons Attribution 3.0 Unported License.
//   remark: To view a copy of this license, visit http://creativecommons.org/licenses/by/3.0/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
//   ontology: pato
//   ontology: uo
//
// [unimod.obo]
#define _UNIMOD_OBO_
//   format-version: 1.2
//   date: 2014:06:04 16:11
//
// [unit.obo]
#define _UNIT_OBO_
//   format-version: 1.2
//   date: 12:10:2011 11:21
//   saved-by: George Gkoutos
//   auto-generated-by: OBO-Edit 2.1-beta13
//   subsetdef: unit_group_slim "unit group slim"
//   subsetdef: unit_slim "unit slim"
//   default-namespace: unit.ontology
//   namespace-id-rule: * UO:$sequence(7,0,9999999)$
//   import: http://purl.obolibrary.org/obo/pato.obo
//


namespace pwiz {
namespace cv {


/// enumeration of controlled vocabulary (CV) terms, generated from OBO file(s)
enum PWIZ_API_DECL CVID
{
    CVID_Unknown = -1,

    /// Proteomics Standards Initiative Mass Spectrometry Vocabularies: Proteomics Standards Initiative Mass Spectrometry Vocabularies.
    MS_Proteomics_Standards_Initiative_Mass_Spectrometry_Vocabularies = 0,

    /// sample number: A reference number relevant to the sample under study.
    MS_sample_number = 1000001,

    /// sample name: A reference string relevant to the sample under study.
    MS_sample_name_OBSOLETE = 1000002,

    /// sample state: The chemical phase of a pure sample, or the state of a mixed sample.
    MS_sample_state = 1000003,

    /// sample mass: Total mass of sample used.
    MS_sample_mass = 1000004,

    /// sample volume: Total volume of solution used.
    MS_sample_volume = 1000005,

    /// sample concentration: Concentration of sample in picomol/ul, femtomol/ul or attomol/ul solution used.
    MS_sample_concentration = 1000006,

    /// inlet type: The nature of the sample inlet.
    MS_inlet_type = 1000007,

    /// ionization type: The method by which gas phase ions are generated from the sample.
    MS_ionization_type = 1000008,

    /// ionization mode: Whether positive or negative ions are selected for analysis by the spectrometer.
    MS_ionization_mode_OBSOLETE = 1000009,

    /// analyzer type: The common name of the particular analyzer stage being described. Synonym of mass analyzer, should be obsoleted.
    MS_analyzer_type_OBSOLETE = 1000010,

    /// mass resolution: Smallest mass difference between two equal magnitude peaks so that the valley between them is a specified fraction of the peak height.
    MS_mass_resolution = 1000011,

    /// resolution measurement method: Which of the available standard measures is used to define whether two peaks are separate.
    MS_resolution_measurement_method = 1000012,

    /// resolution type: Specify the nature of resolution for the mass analyzer. Resolution is usually either constant with respect to m/z or proportional to m/z.
    MS_resolution_type_OBSOLETE = 1000013,

    /// accuracy: Accuracy is the degree of conformity of a measured mass to its actual value.
    MS_accuracy = 1000014,

    /// scan rate: Rate in Th/sec for scanning analyzers.
    MS_scan_rate = 1000015,

    /// scan start time: The time that an analyzer started a scan, relative to the start of the MS run.
    MS_scan_start_time = 1000016,

    /// Scan Function: Describes the type of mass analysis being performed. Two primary modes are: typical acquisition over a range of masses (Mass Scan), and Selected Ion Detection. The primary difference is that Selected Ion Detection produces a single value for the signal at the selected mass rather than producing a mass spectrum.
    MS_Scan_Function = 1000017,

    /// scan direction: Direction in terms of m/z of the scan for scanning analyzers (low to high, or high to low).
    MS_scan_direction = 1000018,

    /// scan law: Describes the function in control of the m/z scan (for scanning instruments). Commonly the scan function is linear, but in principle any function can be used.
    MS_scan_law = 1000019,

    /// scanning method: Describes the acquisition data type produced by a tandem mass spectrometry experiment.
    MS_scanning_method_OBSOLETE = 1000020,

    /// reflectron state: Status of the reflectron, turned on or off.
    MS_reflectron_state = 1000021,

    /// TOF Total Path Length: The length of the field free drift space in a time of flight mass spectrometer.
    MS_TOF_Total_Path_Length = 1000022,

    /// isolation width: The total width (i.e. not half for plus-or-minus) of the gate applied around a selected precursor ion.
    MS_isolation_width_OBSOLETE = 1000023,

    /// final MS exponent: Final MS level achieved when performing PFF with the ion trap (e.g. MS E10).
    MS_final_MS_exponent = 1000024,

    /// magnetic field strength: A property of space that produces a force on a charged particle equal to qv x B where q is the particle charge and v its velocity.
    MS_magnetic_field_strength = 1000025,

    /// B (magnetic field strength): A property of space that produces a force on a charged particle equal to qv x B where q is the particle charge and v its velocity.
    MS_B = MS_magnetic_field_strength,

    /// detector type: Type of detector used in the mass spectrometer.
    MS_detector_type = 1000026,

    /// detector acquisition mode: Method by which detector signal is acquired by the data system.
    MS_detector_acquisition_mode = 1000027,

    /// detector resolution: The resolving power of the detector to detect the smallest difference between two ions so that the valley between them is a specified fraction of the peak height.
    MS_detector_resolution = 1000028,

    /// sampling frequency: The rate of signal sampling (measurement) with respect to time.
    MS_sampling_frequency = 1000029,

    /// vendor: Name of instrument vendor.
    MS_vendor_OBSOLETE = 1000030,

    /// instrument model: Instrument model name not including the vendor's name.
    MS_instrument_model = 1000031,

    /// customization: Free text description of a single customization made to the instrument; for several modifications, use several entries.
    MS_customization = 1000032,

    /// deisotoping: The removal of isotope peaks to represent the fragment ion as one data point and is commonly done to reduce complexity. It is done in conjunction with the charge state deconvolution.
    MS_deisotoping = 1000033,

    /// charge deconvolution: The determination of the mass of an ion based on the mass spectral peaks that represent multiple-charge ions.
    MS_charge_deconvolution = 1000034,

    /// peak picking: Spectral peak processing conducted on the acquired data to convert profile data to centroided data.
    MS_peak_picking = 1000035,

    /// scan mode: OBSOLETE.
    MS_scan_mode_OBSOLETE = 1000036,

    /// polarity: Terms to describe the polarity setting of the instrument.
    MS_polarity_OBSOLETE = 1000037,

    /// minute: Acquisition time in minutes.
    MS_minute_OBSOLETE = 1000038,

    /// second: Acquisition time in seconds.
    MS_second_OBSOLETE = 1000039,

    /// m/z: Three-character symbol m/z is used to denote the quantity formed by dividing the mass of an ion in unified atomic mass units by its charge number (regardless of sign). The symbol is written in italicized lower case letters with no spaces. Note 1: The term mass-to-charge-ratio is deprecated. Mass-to-charge ratio has been used for the abscissa of a mass spectrum, although the quantity measured is not the quotient of the ion's mass to its electric charge. The three-character symbol m/z is recommended for the quantity that is the independent variable in a mass spectrum Note 2: The proposed unit thomson (Th) is deprecated.
    MS_m_z = 1000040,

    /// mass-to-charge ratio (m/z): Three-character symbol m/z is used to denote the quantity formed by dividing the mass of an ion in unified atomic mass units by its charge number (regardless of sign). The symbol is written in italicized lower case letters with no spaces. Note 1: The term mass-to-charge-ratio is deprecated. Mass-to-charge ratio has been used for the abscissa of a mass spectrum, although the quantity measured is not the quotient of the ion's mass to its electric charge. The three-character symbol m/z is recommended for the quantity that is the independent variable in a mass spectrum Note 2: The proposed unit thomson (Th) is deprecated.
    MS_mass_to_charge_ratio = MS_m_z,

    /// Th (m/z): Three-character symbol m/z is used to denote the quantity formed by dividing the mass of an ion in unified atomic mass units by its charge number (regardless of sign). The symbol is written in italicized lower case letters with no spaces. Note 1: The term mass-to-charge-ratio is deprecated. Mass-to-charge ratio has been used for the abscissa of a mass spectrum, although the quantity measured is not the quotient of the ion's mass to its electric charge. The three-character symbol m/z is recommended for the quantity that is the independent variable in a mass spectrum Note 2: The proposed unit thomson (Th) is deprecated.
    MS_Th = MS_m_z,

    /// thomson (m/z): Three-character symbol m/z is used to denote the quantity formed by dividing the mass of an ion in unified atomic mass units by its charge number (regardless of sign). The symbol is written in italicized lower case letters with no spaces. Note 1: The term mass-to-charge-ratio is deprecated. Mass-to-charge ratio has been used for the abscissa of a mass spectrum, although the quantity measured is not the quotient of the ion's mass to its electric charge. The three-character symbol m/z is recommended for the quantity that is the independent variable in a mass spectrum Note 2: The proposed unit thomson (Th) is deprecated.
    MS_thomson = MS_m_z,

    /// charge state: The charge state of the ion, single or multiple and positive or negatively charged.
    MS_charge_state = 1000041,

    /// z (charge state): The charge state of the ion, single or multiple and positive or negatively charged.
    MS_z = MS_charge_state,

    /// peak intensity: Intensity of ions as measured by the height or area of a peak in a mass spectrum.
    MS_peak_intensity = 1000042,

    /// intensity unit: Intensity units are commonly arbitrary. Detected in counts per second (cps) when using counting detectors, but measured in volts when using analog detectors.
    MS_intensity_unit = 1000043,

    /// dissociation method: Fragmentation method used for dissociation or fragmentation.
    MS_dissociation_method = 1000044,

    /// collision energy: Energy for an ion experiencing collision with a stationary gas particle resulting in dissociation of the ion.
    MS_collision_energy = 1000045,

    /// energy unit: Energy units are represented in either eV or Joules.
    MS_energy_unit_OBSOLETE = 1000046,

    /// emulsion: State if the sample is in emulsion form.
    MS_emulsion = 1000047,

    /// gaseous sample state: State if the sample is in gaseous form.
    MS_gaseous_sample_state = 1000048,

    /// liquid sample state: State if the sample is in liquid form.
    MS_liquid_sample_state = 1000049,

    /// solid sample state: State if the sample is in solid form.
    MS_solid_sample_state = 1000050,

    /// solution: State if the sample is in solution form.
    MS_solution = 1000051,

    /// suspension: State if the sample is in suspension form.
    MS_suspension = 1000052,

    /// sample batch: Sample batch lot identifier.
    MS_sample_batch = 1000053,

    /// chromatography: Chromatographic conditions used to obtain the sample.
    MS_chromatography_OBSOLETE = 1000054,

    /// continuous flow fast atom bombardment: Fast atom bombardment ionization in which the analyte in solution is entrained in a flowing liquid matrix.
    MS_continuous_flow_fast_atom_bombardment = 1000055,

    /// CF-FAB (continuous flow fast atom bombardment): Fast atom bombardment ionization in which the analyte in solution is entrained in a flowing liquid matrix.
    MS_CF_FAB = MS_continuous_flow_fast_atom_bombardment,

    /// direct inlet: The sample is directly inserted into the ion source, usually on the end of a heatable probe.
    MS_direct_inlet = 1000056,

    /// electrospray inlet: Inlet used for introducing the liquid sample into an electrospray ionization source.
    MS_electrospray_inlet = 1000057,

    /// flow injection analysis: Sample is directly injected or infused into the ionization source.
    MS_flow_injection_analysis = 1000058,

    /// inductively coupled plasma: A gas discharge ion source in which the energy to the plasma is supplied by electromagnetic induction.
    MS_inductively_coupled_plasma = 1000059,

    /// infusion: The continuous flow of solution of a sample into the ionization source.
    MS_infusion = 1000060,

    /// jet separator: A device that separates carrier gas from gaseous analyte molecules on the basis of diffusivity.
    MS_jet_separator = 1000061,

    /// membrane separator: A device to separate carrier molecules from analyte molecules on the basis of ease of diffusion across a semipermeable membrane.
    MS_membrane_separator = 1000062,

    /// moving belt: Continuous moving surface in the form of a belt which passes through an ion source carrying analyte molecules.
    MS_moving_belt = 1000063,

    /// moving wire: Continuous moving surface in the form of a wire which passes through an ion source carrying analyte molecules.
    MS_moving_wire = 1000064,

    /// open split: A division of flowing stream of liquid into two streams.
    MS_open_split = 1000065,

    /// particle beam: Method for generating ions from a solution of an analyte.
    MS_particle_beam = 1000066,

    /// reservoir: A sample inlet method involving a reservoir.
    MS_reservoir = 1000067,

    /// septum: A disc composed of a flexible material that seals the entrance to the reservoir. Can also be entrance to the vacuum chamber.
    MS_septum = 1000068,

    /// thermospray inlet: A method for generating gas phase ions from a solution of an analyte by rapid heating of the sample.
    MS_thermospray_inlet = 1000069,

    /// atmospheric pressure chemical ionization: Chemical ionization that takes place at atmospheric pressure as opposed to the reduced pressure is normally used for chemical ionization.
    MS_atmospheric_pressure_chemical_ionization = 1000070,

    /// APCI (atmospheric pressure chemical ionization): Chemical ionization that takes place at atmospheric pressure as opposed to the reduced pressure is normally used for chemical ionization.
    MS_APCI = MS_atmospheric_pressure_chemical_ionization,

    /// chemical ionization: The formation of a new ion by the reaction of a neutral species with an ion. The process may involve transfer of an electron, a proton or other charged species between the reactants. When a positive ion results from chemical ionization the term may be used without qualification. When a negative ion results the term negative ion chemical ionization should be used. Note that this term is not synonymous with chemi-ionization.
    MS_chemical_ionization = 1000071,

    /// CI (chemical ionization): The formation of a new ion by the reaction of a neutral species with an ion. The process may involve transfer of an electron, a proton or other charged species between the reactants. When a positive ion results from chemical ionization the term may be used without qualification. When a negative ion results the term negative ion chemical ionization should be used. Note that this term is not synonymous with chemi-ionization.
    MS_CI = MS_chemical_ionization,

    /// Electronic Ionization: The ionization of an atom or molecule by electrons that are typically accelerated to energies between 50 and 150 eV. Usually 70 eV electrons are used to produce positive ions. The term 'electron impact' is not recommended.
    MS_Electronic_Ionization_OBSOLETE = 1000072,

    /// EI (Electronic Ionization): The ionization of an atom or molecule by electrons that are typically accelerated to energies between 50 and 150 eV. Usually 70 eV electrons are used to produce positive ions. The term 'electron impact' is not recommended.
    MS_EI_OBSOLETE = MS_Electronic_Ionization_OBSOLETE,

    /// electrospray ionization: A process in which ionized species in the gas phase are produced from an analyte-containing solution via highly charged fine droplets, by means of spraying the solution from a narrow-bore needle tip at atmospheric pressure in the presence of a high electric field. When a pressurized gas is used to aid in the formation of a stable spray, the term pneumatically assisted electrospray ionization is used. The term ion spray is not recommended.
    MS_electrospray_ionization = 1000073,

    /// ESI (electrospray ionization): A process in which ionized species in the gas phase are produced from an analyte-containing solution via highly charged fine droplets, by means of spraying the solution from a narrow-bore needle tip at atmospheric pressure in the presence of a high electric field. When a pressurized gas is used to aid in the formation of a stable spray, the term pneumatically assisted electrospray ionization is used. The term ion spray is not recommended.
    MS_ESI = MS_electrospray_ionization,

    /// fast atom bombardment ionization: The ionization of any species by the interaction of a focused beam of neutral atoms having a translational energy of several thousand eV with a sample that is typically dissolved in a solvent matrix. See also secondary ionization.
    MS_fast_atom_bombardment_ionization = 1000074,

    /// FAB (fast atom bombardment ionization): The ionization of any species by the interaction of a focused beam of neutral atoms having a translational energy of several thousand eV with a sample that is typically dissolved in a solvent matrix. See also secondary ionization.
    MS_FAB = MS_fast_atom_bombardment_ionization,

    /// matrix-assisted laser desorption ionization: The formation of gas-phase ions from molecules that are present in a solid or solvent matrix that is irradiated with a pulsed laser. See also laser desorption/ionization.
    MS_matrix_assisted_laser_desorption_ionization = 1000075,

    /// MALDI (matrix-assisted laser desorption ionization): The formation of gas-phase ions from molecules that are present in a solid or solvent matrix that is irradiated with a pulsed laser. See also laser desorption/ionization.
    MS_MALDI = MS_matrix_assisted_laser_desorption_ionization,

    /// negative ion mode: OBSOLETE.
    MS_negative_ion_mode_OBSOLETE = 1000076,

    /// positive ion mode: OBSOLETE.
    MS_positive_ion_mode_OBSOLETE = 1000077,

    /// axial ejection linear ion trap: A linear ion trap mass spectrometer where ions are ejected along the axis of the analyzer.
    MS_axial_ejection_linear_ion_trap = 1000078,

    /// fourier transform ion cyclotron resonance mass spectrometer: A mass spectrometer based on the principle of ion cyclotron resonance in which an ion in a magnetic field moves in a circular orbit at a frequency characteristic of its m/z value. Ions are coherently excited to a larger radius orbit using a pulse of radio frequency energy and their image charge is detected on receiver plates as a time domain signal. Fourier transformation of the time domain signal results in a frequency domain signal which is converted to a mass spectrum based in the inverse relationship between frequency and m/z.
    MS_fourier_transform_ion_cyclotron_resonance_mass_spectrometer = 1000079,

    /// FT_ICR (fourier transform ion cyclotron resonance mass spectrometer): A mass spectrometer based on the principle of ion cyclotron resonance in which an ion in a magnetic field moves in a circular orbit at a frequency characteristic of its m/z value. Ions are coherently excited to a larger radius orbit using a pulse of radio frequency energy and their image charge is detected on receiver plates as a time domain signal. Fourier transformation of the time domain signal results in a frequency domain signal which is converted to a mass spectrum based in the inverse relationship between frequency and m/z.
    MS_FT_ICR = MS_fourier_transform_ion_cyclotron_resonance_mass_spectrometer,

    /// magnetic sector: A device that produces a magnetic field perpendicular to a charged particle beam that deflects the beam to an extent that is proportional to the particle momentum per unit charge. For a monoenergetic beam, the deflection is proportional to m/z.
    MS_magnetic_sector = 1000080,

    /// quadrupole: A mass spectrometer that consists of four parallel rods whose centers form the corners of a square and whose opposing poles are connected. The voltage applied to the rods is a superposition of a static potential and a sinusoidal radio frequency potential. The motion of an ion in the x and y dimensions is described by the Matthieu equation whose solutions show that ions in a particular m/z range can be transmitted along the z axis.
    MS_quadrupole = 1000081,

    /// quadrupole ion trap: Quadrupole Ion Trap mass analyzer captures the ions in a three dimensional ion trap and then selectively ejects them by varying the RF and DC potentials.
    MS_quadrupole_ion_trap = 1000082,

    /// Paul Ion trap (quadrupole ion trap): Quadrupole Ion Trap mass analyzer captures the ions in a three dimensional ion trap and then selectively ejects them by varying the RF and DC potentials.
    MS_Paul_Ion_trap = MS_quadrupole_ion_trap,

    /// QIT (quadrupole ion trap): Quadrupole Ion Trap mass analyzer captures the ions in a three dimensional ion trap and then selectively ejects them by varying the RF and DC potentials.
    MS_QIT = MS_quadrupole_ion_trap,

    /// Quistor (quadrupole ion trap): Quadrupole Ion Trap mass analyzer captures the ions in a three dimensional ion trap and then selectively ejects them by varying the RF and DC potentials.
    MS_Quistor = MS_quadrupole_ion_trap,

    /// radial ejection linear ion trap: A linear ion trap mass spectrometer where ions are ejected along the radius of the analyzer.
    MS_radial_ejection_linear_ion_trap = 1000083,

    /// time-of-flight: Instrument that separates ions by m/z in a field-free region after acceleration to a fixed acceleration energy.
    MS_time_of_flight = 1000084,

    /// TOF (time-of-flight): Instrument that separates ions by m/z in a field-free region after acceleration to a fixed acceleration energy.
    MS_TOF = MS_time_of_flight,

    /// baseline: An attribute of resolution when recording the detector response in absence of the analyte.
    MS_baseline = 1000085,

    /// full width at half-maximum: A measure of resolution represented as width of the peak at half peak height.
    MS_full_width_at_half_maximum = 1000086,

    /// FWHM (full width at half-maximum): A measure of resolution represented as width of the peak at half peak height.
    MS_FWHM = MS_full_width_at_half_maximum,

    /// ten percent valley: An attribute of resolution when the ratio between adjacent signals is 10% of the signal height.
    MS_ten_percent_valley = 1000087,

    /// constant: When resolution is constant with respect to m/z.
    MS_constant_OBSOLETE = 1000088,

    /// proportional: When resolution is proportional with respect to m/z.
    MS_proportional_OBSOLETE = 1000089,

    /// mass scan: A variation of instrument where a selected mass is scanned.
    MS_mass_scan = 1000090,

    /// selected ion detection: Please see Single Ion Monitoring.
    MS_selected_ion_detection = 1000091,

    /// decreasing m/z scan: High to low direction in terms of m/z of the scan for scanning analyzers.
    MS_decreasing_m_z_scan = 1000092,

    /// increasing m/z scan: Low to high direction in terms of m/z of the scan for scanning analyzers.
    MS_increasing_m_z_scan = 1000093,

    /// exponential: The mass scan is done in exponential mode.
    MS_exponential = 1000094,

    /// linear: The mass scan is done in linear mode.
    MS_linear_OBSOLETE = 1000095,

    /// quadratic: The mass scan is done in quadratic mode.
    MS_quadratic = 1000096,

    /// constant neutral mass loss: A spectrum formed of all product ions that have been produced with a selected m/z decrement from any precursor ions. The spectrum shown correlates to the precursor ion spectrum. See also neutral loss spectrum.
    MS_constant_neutral_mass_loss_OBSOLETE = 1000097,

    /// multiple ion monitoring: Data acquired when monitoring the ion current of a few specific m/z values. Remap to MS:1000205 -Selected Ion Monitoring.
    MS_multiple_ion_monitoring_OBSOLETE = 1000098,

    /// multiple reaction monitoring: This term is not recommended. See Selected Reaction Monitoring.
    MS_multiple_reaction_monitoring_OBSOLETE = 1000099,

    /// MRM (multiple reaction monitoring): This term is not recommended. See Selected Reaction Monitoring.
    MS_MRM_OBSOLETE = MS_multiple_reaction_monitoring_OBSOLETE,

    /// precursor ion scan: The specific scan function or process that will record a precursor ion spectrum.
    MS_precursor_ion_scan_OBSOLETE = 1000100,

    /// product ion scan: The specific scan function or process that records product ion spectrum.
    MS_product_ion_scan_OBSOLETE = 1000101,

    /// single ion monitoring: The operation of a mass spectrometer to monitor a single ion rather than scanning entire mass spectrum.
    MS_single_ion_monitoring_OBSOLETE = 1000102,

    /// single reaction monitoring: This term is not recommended. See Selected Reaction Monitoring.
    MS_single_reaction_monitoring_OBSOLETE = 1000103,

    /// None ??: None.
    MS_None____OBSOLETE = 1000104,

    /// reflectron off: Reflectron is off.
    MS_reflectron_off = 1000105,

    /// reflectron on: Reflectron is on.
    MS_reflectron_on = 1000106,

    /// channeltron: A horn-shaped (or cone-shaped) continuous dynode particle multiplier. The ion strikes the inner surface of the device and induces the production of secondary electrons that in turn impinge on the inner surfaces to produce more secondary electrons. This avalanche effect produces an increase in signal in the final measured current pulse.
    MS_channeltron = 1000107,

    /// Channeltron Detector (channeltron): A horn-shaped (or cone-shaped) continuous dynode particle multiplier. The ion strikes the inner surface of the device and induces the production of secondary electrons that in turn impinge on the inner surfaces to produce more secondary electrons. This avalanche effect produces an increase in signal in the final measured current pulse.
    MS_Channeltron_Detector = MS_channeltron,

    /// conversion dynode electron multiplier: A surface that is held at high potential so that ions striking the surface produce electrons that are subsequently detected.
    MS_conversion_dynode_electron_multiplier = 1000108,

    /// conversion dynode photomultiplier: A detector in which ions strike a conversion dynode to produce electrons that in turn generate photons through a phosphorescent screen that are detected by a photomultiplier.
    MS_conversion_dynode_photomultiplier = 1000109,

    /// daly detector: Detector consisting of a conversion dynode, scintillator and photomultiplier. The metal knob at high potential emits secondary electrons when ions impinge on the surface. The secondary electrons are accelerated onto the scintillator that produces light that is then detected by the photomultiplier detector.
    MS_daly_detector = 1000110,

    /// Daly (daly detector): Detector consisting of a conversion dynode, scintillator and photomultiplier. The metal knob at high potential emits secondary electrons when ions impinge on the surface. The secondary electrons are accelerated onto the scintillator that produces light that is then detected by the photomultiplier detector.
    MS_Daly = MS_daly_detector,

    /// electron multiplier tube: A device to amplify the current of a beam or packet of charged particles or photons by incidence upon the surface of an electrode to produce secondary electrons.
    MS_electron_multiplier_tube = 1000111,

    /// EMT (electron multiplier tube): A device to amplify the current of a beam or packet of charged particles or photons by incidence upon the surface of an electrode to produce secondary electrons.
    MS_EMT = MS_electron_multiplier_tube,

    /// faraday cup: A conducting cup or chamber that intercepts a charged particle beam and is electrically connected to a current measuring device.
    MS_faraday_cup = 1000112,

    /// focal plane array: An array of detectors for spatially disperse ion beams in which all ions simultaneously impinge on the detector plane.
    MS_focal_plane_array = 1000113,

    /// microchannel plate detector: A thin plate that contains a closely spaced array of channels that each act as a continuous dynode particle multiplier. A charged particle, fast neutral particle, or photon striking the plate causes a cascade of secondary electrons that ultimately exits the opposite side of the plate.
    MS_microchannel_plate_detector = 1000114,

    /// multichannel plate (microchannel plate detector): A thin plate that contains a closely spaced array of channels that each act as a continuous dynode particle multiplier. A charged particle, fast neutral particle, or photon striking the plate causes a cascade of secondary electrons that ultimately exits the opposite side of the plate.
    MS_multichannel_plate = MS_microchannel_plate_detector,

    /// multi-collector: A detector system commonly used in inductively coupled plasma mass spectrometers.
    MS_multi_collector = 1000115,

    /// photomultiplier: A detector for conversion of the ion/electron signal into photon(s) which are then amplified and detected.
    MS_photomultiplier = 1000116,

    /// PMT (photomultiplier): A detector for conversion of the ion/electron signal into photon(s) which are then amplified and detected.
    MS_PMT = MS_photomultiplier,

    /// analog-digital converter: Analog-to-digital converter (abbreviated ADC, A/D or A to D) is an electronic integrated circuit (i/c) that converts continuous signals to discrete digital numbers.
    MS_analog_digital_converter = 1000117,

    /// ADC (analog-digital converter): Analog-to-digital converter (abbreviated ADC, A/D or A to D) is an electronic integrated circuit (i/c) that converts continuous signals to discrete digital numbers.
    MS_ADC = MS_analog_digital_converter,

    /// pulse counting: Definition to do.
    MS_pulse_counting = 1000118,

    /// time-digital converter: A device for converting a signal of sporadic pluses into a digital representation of their time indices.
    MS_time_digital_converter = 1000119,

    /// TDC (time-digital converter): A device for converting a signal of sporadic pluses into a digital representation of their time indices.
    MS_TDC = MS_time_digital_converter,

    /// transient recorder: A detector acquisition mode used for detecting transient signals.
    MS_transient_recorder = 1000120,

    /// AB SCIEX instrument model: The brand of instruments from the joint venture between Applied Biosystems and MDS Analytical Technologies (formerly MDS SCIEX). Previously branded as \"Applied Biosystems|MDS SCIEX\".
    MS_AB_SCIEX_instrument_model = 1000121,

    /// Bruker Daltonics instrument model: Bruker Daltonics' instrument model.
    MS_Bruker_Daltonics_instrument_model = 1000122,

    /// IonSpec instrument model: IonSpec corporation instrument model.
    MS_IonSpec_instrument_model = 1000123,

    /// Shimadzu instrument model: Shimadzu corporation instrument model.
    MS_Shimadzu_instrument_model = 1000124,

    /// Thermo Finnigan instrument model: ThermoFinnigan from Thermo Electron Corporation instrument model.
    MS_Thermo_Finnigan_instrument_model = 1000125,

    /// Waters instrument model: Waters Corporation instrument model.
    MS_Waters_instrument_model = 1000126,

    /// centroid spectrum: Processing of profile data to produce spectra that contains discrete peaks of zero width. Often used to reduce the size of dataset.
    MS_centroid_spectrum = 1000127,

    /// Discrete Mass Spectrum (centroid spectrum): Processing of profile data to produce spectra that contains discrete peaks of zero width. Often used to reduce the size of dataset.
    MS_Discrete_Mass_Spectrum = MS_centroid_spectrum,

    /// profile spectrum: A profile mass spectrum is created when data is recorded with ion current (counts per second) on one axis and mass/charge ratio on another axis.
    MS_profile_spectrum = 1000128,

    /// continuous mass spectrum (profile spectrum): A profile mass spectrum is created when data is recorded with ion current (counts per second) on one axis and mass/charge ratio on another axis.
    MS_continuous_mass_spectrum = MS_profile_spectrum,

    /// Continuum Mass Spectrum (profile spectrum): A profile mass spectrum is created when data is recorded with ion current (counts per second) on one axis and mass/charge ratio on another axis.
    MS_Continuum_Mass_Spectrum = MS_profile_spectrum,

    /// negative scan: Polarity of the scan is negative.
    MS_negative_scan = 1000129,

    /// positive scan: Polarity of the scan is positive.
    MS_positive_scan = 1000130,

    /// number of detector counts: The number of counted events observed in one or a group of elements of a detector.
    MS_number_of_detector_counts = 1000131,

    /// percent of base peak: The magnitude of a peak or measurement element expressed in terms of the percentage of the magnitude of the base peak intensity.
    MS_percent_of_base_peak = 1000132,

    /// collision-induced dissociation: The dissociation of an ion after collisional excitation. The term collisional-activated dissociation is not recommended.
    MS_collision_induced_dissociation = 1000133,

    /// CID (collision-induced dissociation): The dissociation of an ion after collisional excitation. The term collisional-activated dissociation is not recommended.
    MS_CID = MS_collision_induced_dissociation,

    /// CAD (collision-induced dissociation): The dissociation of an ion after collisional excitation. The term collisional-activated dissociation is not recommended.
    MS_CAD = MS_collision_induced_dissociation,

    /// collisionally activated dissociation (collision-induced dissociation): The dissociation of an ion after collisional excitation. The term collisional-activated dissociation is not recommended.
    MS_collisionally_activated_dissociation = MS_collision_induced_dissociation,

    /// plasma desorption: The ionization of material in a solid sample by bombarding it with ionic or neutral atoms formed as a result of the fission of a suitable nuclide, typically 252Cf. Synonymous with fission fragment ionization.
    MS_plasma_desorption = 1000134,

    /// PD (plasma desorption): The ionization of material in a solid sample by bombarding it with ionic or neutral atoms formed as a result of the fission of a suitable nuclide, typically 252Cf. Synonymous with fission fragment ionization.
    MS_PD = MS_plasma_desorption,

    /// post-source decay: A technique specific to reflectron time-of-flight mass spectrometers where product ions of metastable transitions or collision-induced dissociations generated in the drift tube prior to entering the reflectron are m/z separated to yield product ion spectra.
    MS_post_source_decay = 1000135,

    /// PSD (post-source decay): A technique specific to reflectron time-of-flight mass spectrometers where product ions of metastable transitions or collision-induced dissociations generated in the drift tube prior to entering the reflectron are m/z separated to yield product ion spectra.
    MS_PSD = MS_post_source_decay,

    /// surface-induced dissociation: Fragmentation that results from the collision of an ion with a surface.
    MS_surface_induced_dissociation = 1000136,

    /// SID (surface-induced dissociation): Fragmentation that results from the collision of an ion with a surface.
    MS_SID = MS_surface_induced_dissociation,

    /// electron volt: A non-SI unit of energy (eV) defined as the energy acquired by a particle containing one unit of charge through a potential difference of one volt. An electron-volt is equal to 1.602 176 53(14) x 10^-19 J.
    MS_electron_volt_OBSOLETE = 1000137,

    /// eV (electron volt): A non-SI unit of energy (eV) defined as the energy acquired by a particle containing one unit of charge through a potential difference of one volt. An electron-volt is equal to 1.602 176 53(14) x 10^-19 J.
    MS_eV_OBSOLETE = MS_electron_volt_OBSOLETE,

    /// normalized collision energy: Instrument setting, expressed in percent, for adjusting collisional energies of ions in an effort to provide equivalent excitation of all ions.
    MS_normalized_collision_energy = 1000138,

    /// 4000 QTRAP: Applied Biosystems/MDS SCIEX Q 4000 TRAP MS.
    MS_4000_QTRAP = 1000139,

    /// 4700 Proteomics Analyzer: Applied Biosystems/MDS SCIEX 4700 Proteomics Analyzer MS.
    MS_4700_Proteomics_Analyzer = 1000140,

    /// apex IV: Bruker Daltonics' apex IV: ESI, MALDI, Nanospray, APCI, APPI, Qh-FT_ICR.
    MS_apex_IV = 1000141,

    /// apex Q: Bruker Daltonics' apex Q: ESI, MALDI, Nanospray, APCI, APPI, Qh-FT_ICR.
    MS_apex_Q = 1000142,

    /// API 150EX: Applied Biosystems/MDS SCIEX API 150EX MS.
    MS_API_150EX = 1000143,

    /// API 150EX Prep: Applied Biosystems/MDS SCIEX API 150EX Prep MS.
    MS_API_150EX_Prep = 1000144,

    /// API 2000: Applied Biosystems/MDS SCIEX API 2000 MS.
    MS_API_2000 = 1000145,

    /// API 3000: Applied Biosystems/MDS SCIEX API 3000 MS.
    MS_API_3000 = 1000146,

    /// API 4000: Applied Biosystems/MDS SCIEX API 4000 MS.
    MS_API_4000 = 1000147,

    /// autoflex II: Bruker Daltonics' autoflex II: MALDI TOF.
    MS_autoflex_II = 1000148,

    /// autoflex TOF/TOF: Bruker Daltonics' autoflex TOF/TOF MS: MALDI TOF.
    MS_autoflex_TOF_TOF = 1000149,

    /// Auto Spec Ultima NT: Waters AutoSpec Ultima NT MS.
    MS_Auto_Spec_Ultima_NT = 1000150,

    /// BioTOF II: Bruker Daltonics' BioTOF II: ESI TOF.
    MS_BioTOF_II = 1000151,

    /// BioTOF-Q: Bruker Daltonics' BioTOF-Q: ESI Q-TOF.
    MS_BioTOF_Q = 1000152,

    /// DELTA plusAdvantage: ThermoFinnigan DELTA plusAdvantage MS.
    MS_DELTA_plusAdvantage = 1000153,

    /// DELTAplusXP: ThermoFinnigan DELTAplusXP MS.
    MS_DELTAplusXP = 1000154,

    /// ELEMENT2: ThermoFinnigan ELEMENT2 MS.
    MS_ELEMENT2_OBSOLETE = 1000155,

    /// esquire 4000: Bruker Daltonics' esquire 4000: linear ion trap, ESI, MALDI, Nanospray, APCI, APPI.
    MS_esquire_4000 = 1000156,

    /// esquire 6000: Bruker Daltonics' esquire 6000: linear ion trap, ESI, MALDI, Nanospray, APCI, APPI.
    MS_esquire_6000 = 1000157,

    /// explorer: IonSpec Explorer MS.
    MS_explorer = 1000158,

    /// GCT: Waters oa-ToF based GCT.
    MS_GCT = 1000159,

    /// HCT: Bruker Daltonics' HCT: ESI Q-TOF, Nanospray, APCI, APPI.
    MS_HCT = 1000160,

    /// HCTplus: Bruker Daltonics' HCTplus: ESI Q-TOF, Nanospray, APCI, APPI.
    MS_HCTplus = 1000161,

    /// HiRes ESI: IonSpec HiResESI MS.
    MS_HiRes_ESI = 1000162,

    /// HiRes MALDI: IonSpec HiResMALDI MS.
    MS_HiRes_MALDI = 1000163,

    /// IsoPrime: Waters IsoPrime MS.
    MS_IsoPrime = 1000164,

    /// IsoProbe: Waters IsoProbe MS.
    MS_IsoProbe = 1000165,

    /// IsoProbe T: Waters IsoProbe T MS.
    MS_IsoProbe_T = 1000166,

    /// LCQ Advantage: ThermoFinnigan LCQ Advantage MS.
    MS_LCQ_Advantage = 1000167,

    /// LCQ Classic: ThermoFinnigan LCQ Classic MS.
    MS_LCQ_Classic = 1000168,

    /// LCQ Deca XP Plus: ThermoFinnigan LCQ Deca XP Plus MS.
    MS_LCQ_Deca_XP_Plus = 1000169,

    /// M@LDI L: Waters oa-ToF based MALDI L.
    MS_M_LDI_L = 1000170,

    /// M@LDI LR: Waters oa-ToF based MALDI LR.
    MS_M_LDI_LR = 1000171,

    /// MAT253: ThermoFinnigan MAT253 MS.
    MS_MAT253 = 1000172,

    /// MAT900XP: ThermoFinnigan MAT900XP MS.
    MS_MAT900XP = 1000173,

    /// MAT900XP Trap: ThermoFinnigan MAT900XP Trap MS.
    MS_MAT900XP_Trap = 1000174,

    /// MAT95XP: ThermoFinnigan MAT95XP MS.
    MS_MAT95XP = 1000175,

    /// MAT95XP Trap: ThermoFinnigan MAT95XP Trap MS.
    MS_MAT95XP_Trap = 1000176,

    /// microflex: Bruker Daltonics' microflex: MALDI TOF.
    MS_microflex = 1000177,

    /// microTOF LC: Bruker Daltonics' microTOF LC: ESI TOF, Nanospray, APCI, APPI.
    MS_microTOF_LC = 1000178,

    /// neptune: ThermoFinnigan NEPTUNE MS.
    MS_neptune = 1000179,

    /// NG-5400: Waters NG-5400 MS.
    MS_NG_5400 = 1000180,

    /// OMEGA: IonSpec OMEGA MS.
    MS_OMEGA = 1000181,

    /// OMEGA-2001: IonSpec OMEGA-2001 MS.
    MS_OMEGA_2001 = 1000182,

    /// OmniFlex: Bruker Daltonics' OmniFlex: MALDI TOF.
    MS_OmniFlex = 1000183,

    /// Platform ICP: Waters Platform ICP MS.
    MS_Platform_ICP = 1000184,

    /// PolarisQ: ThermoFinnigan PolarisQ MS.
    MS_PolarisQ = 1000185,

    /// proteomics solution 1: Applied Biosystems/MDS SCIEX Proteomics Solution 1 MS.
    MS_proteomics_solution_1 = 1000186,

    /// Q TRAP: Applied Biosystems/MDS SCIEX Q TRAP MS.
    MS_Q_TRAP = 1000187,

    /// Q-Tof micro: Waters oa-ToF based Q-Tof micro.
    MS_Q_Tof_micro = 1000188,

    /// Q-Tof ultima: Waters oa-ToF based Q-Tof Ultima.
    MS_Q_Tof_ultima = 1000189,

    /// QSTAR: Applied Biosystems/MDS SCIEX QSTAR MS.
    MS_QSTAR = 1000190,

    /// quattro micro: Waters oa-ToF based micro.
    MS_quattro_micro = 1000191,

    /// Quattro UItima: Waters oa-ToF based Ultima.
    MS_Quattro_UItima = 1000192,

    /// Surveyor MSQ: ThermoFinnigan Surveyor MSQ MS.
    MS_Surveyor_MSQ = 1000193,

    /// SymBiot I: Applied Biosystems/MDS SCIEX SymBiot I MS.
    MS_SymBiot_I = 1000194,

    /// SymBiot XVI: Applied Biosystems/MDS SCIEX SymBiot XVI MS.
    MS_SymBiot_XVI = 1000195,

    /// TEMPUS TOF: ThermoFinnigan TEMPUS TOF MS.
    MS_TEMPUS_TOF = 1000196,

    /// TRACE DSQ: ThermoFinnigan TRACE DSQ MS.
    MS_TRACE_DSQ = 1000197,

    /// TRITON: ThermoFinnigan TRITON MS.
    MS_TRITON = 1000198,

    /// TSQ Quantum: ThermoFinnigan TSQ Quantum MS.
    MS_TSQ_Quantum = 1000199,

    /// ultima: IonSpec Ultima MS.
    MS_ultima = 1000200,

    /// ultraflex: Bruker Daltonics' ultraflex: MALDI TOF.
    MS_ultraflex = 1000201,

    /// ultraflex TOF/TOF: Bruker Daltonics' ultraflex TOF/TOF: MALDI TOF.
    MS_ultraflex_TOF_TOF = 1000202,

    /// Voyager-DE PRO: Applied Biosystems/MDS SCIEX Voyager-DE PRO MS.
    MS_Voyager_DE_PRO = 1000203,

    /// Voyager-DE STR: Applied Biosystems/MDS SCIEX Voyager-DE STR MS.
    MS_Voyager_DE_STR = 1000204,

    /// selected ion monitoring: The operation of a mass spectrometer in which the intensities of several specific m/z values are recorded rather than the entire mass spectrum.
    MS_selected_ion_monitoring = 1000205,

    /// Multiple Ion Monitoring (selected ion monitoring): The operation of a mass spectrometer in which the intensities of several specific m/z values are recorded rather than the entire mass spectrum.
    MS_Multiple_Ion_Monitoring = MS_selected_ion_monitoring,

    /// SIM (selected ion monitoring): The operation of a mass spectrometer in which the intensities of several specific m/z values are recorded rather than the entire mass spectrum.
    MS_SIM = MS_selected_ion_monitoring,

    /// selected reaction monitoring: Data acquired from specific product ions corresponding to m/z selected precursor ions recorded via multiple stages of mass spectrometry. Selected reaction monitoring can be performed in time or in space.
    MS_selected_reaction_monitoring = 1000206,

    /// SRM (selected reaction monitoring): Data acquired from specific product ions corresponding to m/z selected precursor ions recorded via multiple stages of mass spectrometry. Selected reaction monitoring can be performed in time or in space.
    MS_SRM = MS_selected_reaction_monitoring,

    /// accurate mass: An experimentally determined mass that is can be to determine a unique elemental formula. For ions less than 200 u, a measurement with 5 ppm accuracy is sufficient to determine the elemental composition.
    MS_accurate_mass = 1000207,

    /// average mass: The mass of an ion or molecule calculated using the average mass of each element weighted for its natural isotopic abundance.
    MS_average_mass = 1000208,

    /// appearance energy: The minimum energy that must be imparted to an atom or molecule to produce a specified ion. The term appearance potential is not recommended.
    MS_appearance_energy = 1000209,

    /// AE (appearance energy): The minimum energy that must be imparted to an atom or molecule to produce a specified ion. The term appearance potential is not recommended.
    MS_AE = MS_appearance_energy,

    /// base peak: The peak in a mass spectrum that has the greatest intensity. This term may be applied to the spectra of pure substances or mixtures.
    MS_base_peak = 1000210,

    /// BP (base peak): The peak in a mass spectrum that has the greatest intensity. This term may be applied to the spectra of pure substances or mixtures.
    MS_BP = MS_base_peak,

    /// OBSOLETE charge number: OBSOLETE. The total charge on an ion divided by the electron charge e. OBSOLETED 2009-10-27 since this was viewed as a duplication of 00041 charge state.
    MS_OBSOLETE_charge_number_OBSOLETE = 1000211,

    /// z (OBSOLETE charge number): OBSOLETE. The total charge on an ion divided by the electron charge e. OBSOLETED 2009-10-27 since this was viewed as a duplication of 00041 charge state.
    MS_z_OBSOLETE = MS_OBSOLETE_charge_number_OBSOLETE,

    /// dalton: A non-SI unit of mass (symbol Da) that is equal to the unified atomic mass unit: 1.660 538 86(28) x 10^-27 kg.
    MS_dalton_OBSOLETE = 1000212,

    /// Da (dalton): A non-SI unit of mass (symbol Da) that is equal to the unified atomic mass unit: 1.660 538 86(28) x 10^-27 kg.
    MS_Da_OBSOLETE = MS_dalton_OBSOLETE,

    /// electron affinity: The electron affinity of M is the minimum energy required for the process M- ? M + e where M- and M are in their ground rotational, vibrational and electronic states and the electron has zero kinetic energy.
    MS_electron_affinity = 1000213,

    /// EA (electron affinity): The electron affinity of M is the minimum energy required for the process M- ? M + e where M- and M are in their ground rotational, vibrational and electronic states and the electron has zero kinetic energy.
    MS_EA = MS_electron_affinity,

    /// electron energy obsolete: The potential difference through which electrons are accelerated before they are used to bring about electron ionization.
    MS_electron_energy_obsolete_OBSOLETE = 1000214,

    /// exact mass: The calculated mass of an ion or molecule containing a single isotope of each atom.
    MS_exact_mass = 1000215,

    /// field-free region: A section of a mass spectrometer in which there are no electric or magnetic fields.
    MS_field_free_region = 1000216,

    /// FFR (field-free region): A section of a mass spectrometer in which there are no electric or magnetic fields.
    MS_FFR = MS_field_free_region,

    /// ionization cross section: A measure of the probability that a given ionization process will occur when an atom or molecule interacts with a photon, electron, atom or molecule.
    MS_ionization_cross_section = 1000217,

    /// ionization efficiency: The ratio of the number of ions formed to the number of electrons, molecules or photons used.
    MS_ionization_efficiency_OBSOLETE = 1000218,

    /// ionization energy: The minimum energy required to remove an electron from an atom or molecule to produce a positive ion.
    MS_ionization_energy = 1000219,

    /// IE (ionization energy): The minimum energy required to remove an electron from an atom or molecule to produce a positive ion.
    MS_IE = MS_ionization_energy,

    /// isotope dilution mass spectrometry: A quantitative mass spectrometry technique in which an isotopically enriched compound is used as an internal standard.
    MS_isotope_dilution_mass_spectrometry_OBSOLETE = 1000220,

    /// IDMS (isotope dilution mass spectrometry): A quantitative mass spectrometry technique in which an isotopically enriched compound is used as an internal standard.
    MS_IDMS_OBSOLETE = MS_isotope_dilution_mass_spectrometry_OBSOLETE,

    /// magnetic deflection: The deflection of charged particles in a magnetic field due to a force equal to qvxB where q is the particle charge, v its velocity and B the magnetic field. Magnetic deflection of an ion beam is used for m/z separation in a magnetic sector mass spectrometer.
    MS_magnetic_deflection = 1000221,

    /// mass defect: The difference between the monoisotopic and nominal mass of a molecule or atom.
    MS_mass_defect = 1000222,

    /// mass number: The sum of the protons and neutrons in an atom, molecule or ion.
    MS_mass_number = 1000223,

    /// molecular mass: The mass of one mole of a molecular substance (6.022 1415(10) x 10^23 molecules).
    MS_molecular_mass = 1000224,

    /// monoisotopic mass: The mass of an ion or molecule calculated using the mass of the most abundant isotope of each element.
    MS_monoisotopic_mass = 1000225,

    /// molecular beam mass spectrometry: A mass spectrometry technique in which the sample is introduced into the mass spectrometer as a molecular beam.
    MS_molecular_beam_mass_spectrometry = 1000226,

    /// MBMS (molecular beam mass spectrometry): A mass spectrometry technique in which the sample is introduced into the mass spectrometer as a molecular beam.
    MS_MBMS = MS_molecular_beam_mass_spectrometry,

    /// multiphoton ionization: Photoionization of an atom or molecule in which in two or more photons are absorbed.
    MS_multiphoton_ionization = 1000227,

    /// MPI (multiphoton ionization): Photoionization of an atom or molecule in which in two or more photons are absorbed.
    MS_MPI = MS_multiphoton_ionization,

    /// nitrogen rule: An organic molecule containing the elements C, H, O, S, P, or halogen has an odd nominal mass if it contains an odd number of nitrogen atoms.
    MS_nitrogen_rule = 1000228,

    /// nominal mass: The mass of an ion or molecule calculated using the mass of the most abundant isotope of each element rounded to the nearest integer value.
    MS_nominal_mass = 1000229,

    /// odd-electron rule: Odd-electron ions may dissociate to form either odd or even-electron ions, whereas even-electron ions generally form even-electron fragment ions.
    MS_odd_electron_rule = 1000230,

    /// peak: A localized region of relatively large ion signal in a mass spectrum. Although peaks are often associated with particular ions, the terms peak and ion should not be used interchangeably.
    MS_peak = 1000231,

    /// peak intensity: The height or area of a peak in a mass spectrum.
    MS_peak_intensity_OBSOLETE = 1000232,

    /// proton affinity: The proton affinity of a species M is defined as the negative of the enthalpy change for the reaction M + H+ ->[M+H]+, where all species are in their ground rotational, vibrational and electronic states.
    MS_proton_affinity = 1000233,

    /// PA (proton affinity): The proton affinity of a species M is defined as the negative of the enthalpy change for the reaction M + H+ ->[M+H]+, where all species are in their ground rotational, vibrational and electronic states.
    MS_PA = MS_proton_affinity,

    /// mass resolving power: In a mass spectrum, the observed mass divided by the difference between two masses that can be separated. The method by which delta m was obtained and the mass at which the measurement was made should be reported.
    MS_mass_resolving_power_OBSOLETE = 1000234,

    /// total ion current chromatogram: Chromatogram obtained by plotting the total ion current detected in each of a series of mass spectra recorded as a function of retention time.
    MS_total_ion_current_chromatogram = 1000235,

    /// TIC chromatogram (total ion current chromatogram): Chromatogram obtained by plotting the total ion current detected in each of a series of mass spectra recorded as a function of retention time.
    MS_TIC_chromatogram = MS_total_ion_current_chromatogram,

    /// transmission: The ratio of the number of ions leaving a region of a mass spectrometer to the number entering that region.
    MS_transmission = 1000236,

    /// unified atomic mass unit: A non-SI unit of mass (u) defined as one twelfth of ^12 C in its ground state and equal to 1.660 538 86(28) x 10^-27 kg.
    MS_unified_atomic_mass_unit_OBSOLETE = 1000237,

    /// u (unified atomic mass unit): A non-SI unit of mass (u) defined as one twelfth of ^12 C in its ground state and equal to 1.660 538 86(28) x 10^-27 kg.
    MS_u_OBSOLETE = MS_unified_atomic_mass_unit_OBSOLETE,

    /// accelerator mass spectrometry: A mass spectrometry technique in which atoms extracted from a sample are ionized, accelerated to MeV energies and separated according to their momentum, charge and energy.
    MS_accelerator_mass_spectrometry = 1000238,

    /// AMS (accelerator mass spectrometry): A mass spectrometry technique in which atoms extracted from a sample are ionized, accelerated to MeV energies and separated according to their momentum, charge and energy.
    MS_AMS = MS_accelerator_mass_spectrometry,

    /// atmospheric pressure matrix-assisted laser desorption ionization: Matrix-assisted laser desorption ionization in which the sample target is at atmospheric pressure and the ions formed by the pulsed laser are sampled through a small aperture into the mass spectrometer.
    MS_atmospheric_pressure_matrix_assisted_laser_desorption_ionization = 1000239,

    /// AP MALDI (atmospheric pressure matrix-assisted laser desorption ionization): Matrix-assisted laser desorption ionization in which the sample target is at atmospheric pressure and the ions formed by the pulsed laser are sampled through a small aperture into the mass spectrometer.
    MS_AP_MALDI = MS_atmospheric_pressure_matrix_assisted_laser_desorption_ionization,

    /// atmospheric pressure ionization: Any ionization process in which ions are formed in the gas phase at atmospheric pressure.
    MS_atmospheric_pressure_ionization = 1000240,

    /// API (atmospheric pressure ionization): Any ionization process in which ions are formed in the gas phase at atmospheric pressure.
    MS_API = MS_atmospheric_pressure_ionization,

    /// Atmostpheric Pressure Photoionization: Atmospheric pressure chemical ionization in which the reactant ions are generated by photo-ionization.
    MS_Atmostpheric_Pressure_Photoionization_OBSOLETE = 1000241,

    /// APPI (Atmostpheric Pressure Photoionization): Atmospheric pressure chemical ionization in which the reactant ions are generated by photo-ionization.
    MS_APPI_OBSOLETE = MS_Atmostpheric_Pressure_Photoionization_OBSOLETE,

    /// blackbody infrared radiative dissociation: A special case of infrared multiphoton dissociation wherein excitation of the reactant ion is caused by absorption of infrared photons radiating from heated blackbody surroundings, which are usually the walls of a vacuum chamber. See also infrared multiphoton dissociation.
    MS_blackbody_infrared_radiative_dissociation = 1000242,

    /// BIRD (blackbody infrared radiative dissociation): A special case of infrared multiphoton dissociation wherein excitation of the reactant ion is caused by absorption of infrared photons radiating from heated blackbody surroundings, which are usually the walls of a vacuum chamber. See also infrared multiphoton dissociation.
    MS_BIRD = MS_blackbody_infrared_radiative_dissociation,

    /// charge-remote fragmentation: A fragmentation of an even-electron ion in which the cleaved bond is not adjacent to the apparent charge site.
    MS_charge_remote_fragmentation = 1000243,

    /// CRF (charge-remote fragmentation): A fragmentation of an even-electron ion in which the cleaved bond is not adjacent to the apparent charge site.
    MS_CRF = MS_charge_remote_fragmentation,

    /// consecutive reaction monitoring: MSn experiment with three or more stages of m/z separation and in which a particular multi-step reaction path is monitored.
    MS_consecutive_reaction_monitoring_OBSOLETE_1000244 = 1000244,

    /// CRM (consecutive reaction monitoring): MSn experiment with three or more stages of m/z separation and in which a particular multi-step reaction path is monitored.
    MS_CRM_OBSOLETE = MS_consecutive_reaction_monitoring_OBSOLETE_1000244,

    /// charge stripping: The reaction of a positive ion with an atom or molecule that results in the removal of one or more electrons from the ion.
    MS_charge_stripping = 1000245,

    /// CS (charge stripping): The reaction of a positive ion with an atom or molecule that results in the removal of one or more electrons from the ion.
    MS_CS = MS_charge_stripping,

    /// delayed extraction: The application of the accelerating voltage pulse after a time delay in desorption ionization from a surface. The extraction delay can produce energy focusing in a time-of-flight mass spectrometer.
    MS_delayed_extraction = 1000246,

    /// DE (delayed extraction): The application of the accelerating voltage pulse after a time delay in desorption ionization from a surface. The extraction delay can produce energy focusing in a time-of-flight mass spectrometer.
    MS_DE = MS_delayed_extraction,

    /// desorption ionization: The formation of ions from a solid or liquid material after the rapid vaporization of that sample.
    MS_desorption_ionization = 1000247,

    /// DI (desorption ionization): The formation of ions from a solid or liquid material after the rapid vaporization of that sample.
    MS_DI = MS_desorption_ionization,

    /// direct insertion probe: A device for introducing a solid or liquid sample into a mass spectrometer ion source for desorption ionization.
    MS_direct_insertion_probe = 1000248,

    /// DIP (direct insertion probe): A device for introducing a solid or liquid sample into a mass spectrometer ion source for desorption ionization.
    MS_DIP = MS_direct_insertion_probe,

    /// direct liquid introduction: The delivery of a liquid sample into a mass spectrometer for spray or desorption ionization.
    MS_direct_liquid_introduction = 1000249,

    /// DLI (direct liquid introduction): The delivery of a liquid sample into a mass spectrometer for spray or desorption ionization.
    MS_DLI = MS_direct_liquid_introduction,

    /// electron capture dissociation: A process in which a multiply protonated molecules interacts with a low energy electrons. Capture of the electron leads the liberation of energy and a reduction in charge state of the ion with the production of the (M + nH) (n-1)+ odd electron ion, which readily fragments.
    MS_electron_capture_dissociation = 1000250,

    /// ECD (electron capture dissociation): A process in which a multiply protonated molecules interacts with a low energy electrons. Capture of the electron leads the liberation of energy and a reduction in charge state of the ion with the production of the (M + nH) (n-1)+ odd electron ion, which readily fragments.
    MS_ECD = MS_electron_capture_dissociation,

    /// even-electron ion: An ion containing no unpaired electrons in its ground electronic state, e.g. CH3+ in its ground state.
    MS_even_electron_ion = 1000251,

    /// EE (even-electron ion): An ion containing no unpaired electrons in its ground electronic state, e.g. CH3+ in its ground state.
    MS_EE = MS_even_electron_ion,

    /// electron-induced excitation in organics: The reaction of an ion with an electron in which the translational energy of the collision is converted into internal energy of the ion.
    MS_electron_induced_excitation_in_organics = 1000252,

    /// EIEIO (electron-induced excitation in organics): The reaction of an ion with an electron in which the translational energy of the collision is converted into internal energy of the ion.
    MS_EIEIO = MS_electron_induced_excitation_in_organics,

    /// electron multiplier: A device to amplify the current of a beam or packet of charged particles or photons by incidence upon the surface of an electrode to produce secondary electrons. The secondary electrons are then accelerated to other electrodes or parts of a continuous electrode to produce further secondary electrons.
    MS_electron_multiplier = 1000253,

    /// EM (electron multiplier): A device to amplify the current of a beam or packet of charged particles or photons by incidence upon the surface of an electrode to produce secondary electrons. The secondary electrons are then accelerated to other electrodes or parts of a continuous electrode to produce further secondary electrons.
    MS_EM = MS_electron_multiplier,

    /// electrostatic energy analyzer: A device consisting of conducting parallel plates, concentric cylinders or concentric spheres that separates charged particles according to their kinetic energy by means of an electric field that is constant in time.
    MS_electrostatic_energy_analyzer = 1000254,

    /// ESA (electrostatic energy analyzer): A device consisting of conducting parallel plates, concentric cylinders or concentric spheres that separates charged particles according to their kinetic energy by means of an electric field that is constant in time.
    MS_ESA = MS_electrostatic_energy_analyzer,

    /// flowing afterglow: An ion source immersed in a flow of helium or other inert buffer gas that carries the ions through a meter-long reactor at pressures around 100 Pa.
    MS_flowing_afterglow = 1000255,

    /// FA (flowing afterglow): An ion source immersed in a flow of helium or other inert buffer gas that carries the ions through a meter-long reactor at pressures around 100 Pa.
    MS_FA = MS_flowing_afterglow,

    /// high-field asymmetric waveform ion mobility spectrometry: The separation of ions between two concentric cylindrical electrodes due to application of a high voltage asymmetric waveform whereby ions migrate towards one of the two electrodes depending on the ratio of the high- to low-field mobility of the ion.
    MS_high_field_asymmetric_waveform_ion_mobility_spectrometry = 1000256,

    /// FAIMS (high-field asymmetric waveform ion mobility spectrometry): The separation of ions between two concentric cylindrical electrodes due to application of a high voltage asymmetric waveform whereby ions migrate towards one of the two electrodes depending on the ratio of the high- to low-field mobility of the ion.
    MS_FAIMS = MS_high_field_asymmetric_waveform_ion_mobility_spectrometry,

    /// field desorption: The formation of gas-phase ions from a material deposited on a solid surface in the presence of a high electric field. Because this process may encompass ionization by field ionization or other mechanisms, it is not recommended as a synonym for field desorption ionization.
    MS_field_desorption = 1000257,

    /// FD (field desorption): The formation of gas-phase ions from a material deposited on a solid surface in the presence of a high electric field. Because this process may encompass ionization by field ionization or other mechanisms, it is not recommended as a synonym for field desorption ionization.
    MS_FD = MS_field_desorption,

    /// field ionization: The removal of electrons from any species by interaction with a high electric field.
    MS_field_ionization = 1000258,

    /// FI (field ionization): The removal of electrons from any species by interaction with a high electric field.
    MS_FI = MS_field_ionization,

    /// glow discharge ionization: The formation of ions in the gas phase and from solid samples at the cathode by application of a voltage to a low pressure gas.
    MS_glow_discharge_ionization = 1000259,

    /// GD-MS (glow discharge ionization): The formation of ions in the gas phase and from solid samples at the cathode by application of a voltage to a low pressure gas.
    MS_GD_MS = MS_glow_discharge_ionization,

    /// ion kinetic energy spectrometry: A method of analysis in which a beam of ions is separated according to the ratio of its translational energy to charge.
    MS_ion_kinetic_energy_spectrometry = 1000260,

    /// IKES (ion kinetic energy spectrometry): A method of analysis in which a beam of ions is separated according to the ratio of its translational energy to charge.
    MS_IKES = MS_ion_kinetic_energy_spectrometry,

    /// ion mobility spectrometry: The separation of ions according to their velocity through a buffer gas under the influence of an electric field.
    MS_ion_mobility_spectrometry = 1000261,

    /// IMS (ion mobility spectrometry): The separation of ions according to their velocity through a buffer gas under the influence of an electric field.
    MS_IMS = MS_ion_mobility_spectrometry,

    /// infrared multiphoton dissociation: Multiphoton ionization where the reactant ion dissociates as a result of the absorption of multiple infrared photons.
    MS_infrared_multiphoton_dissociation = 1000262,

    /// IRMPD (infrared multiphoton dissociation): Multiphoton ionization where the reactant ion dissociates as a result of the absorption of multiple infrared photons.
    MS_IRMPD = MS_infrared_multiphoton_dissociation,

    /// isotope ratio mass spectrometry: The measurement of the relative quantity of the different isotopes of an element in a material with a mass spectrometer.
    MS_isotope_ratio_mass_spectrometry_OBSOLETE = 1000263,

    /// IRMS (isotope ratio mass spectrometry): The measurement of the relative quantity of the different isotopes of an element in a material with a mass spectrometer.
    MS_IRMS_OBSOLETE = MS_isotope_ratio_mass_spectrometry_OBSOLETE,

    /// ion trap: A device for spatially confining ions using electric and magnetic fields alone or in combination.
    MS_ion_trap = 1000264,

    /// IT (ion trap): A device for spatially confining ions using electric and magnetic fields alone or in combination.
    MS_IT = MS_ion_trap,

    /// kinetic energy release distribution: Distribution of values of translational kinetic energy release for an ensemble of metastable ions undergoing a specific dissociation reaction.
    MS_kinetic_energy_release_distribution = 1000265,

    /// KERD (kinetic energy release distribution): Distribution of values of translational kinetic energy release for an ensemble of metastable ions undergoing a specific dissociation reaction.
    MS_KERD = MS_kinetic_energy_release_distribution,

    /// Laser Desorption: The formation of ions through the interaction of a laser with a material or with gas-phase ions or molecules.
    MS_Laser_Desorption_OBSOLETE = 1000266,

    /// Laser Ionization MERGE (Laser Desorption): The formation of ions through the interaction of a laser with a material or with gas-phase ions or molecules.
    MS_Laser_Ionization_MERGE_OBSOLETE = MS_Laser_Desorption_OBSOLETE,

    /// LD (Laser Desorption): The formation of ions through the interaction of a laser with a material or with gas-phase ions or molecules.
    MS_LD_OBSOLETE = MS_Laser_Desorption_OBSOLETE,

    /// mass analyzed ion kinetic energy spectrometry: Spectra that are obtained from a sector mass spectrometer that incorporates at least one magnetic sector plus one electric sector in reverse geometry. The accelerating voltage, V, and the magnetic sector field, B, are set at fixed values to select the precursor ions, which are then allowed to dissociate or to react in a field free region between the two sectors. The kinetic energy product ions of m/z selected precursor ions is analyzed by scanning the electric sector field, E. The width of the product ion spectrum peaks is related to the kinetic energy release distribution (KERD) for the dissociation process.
    MS_mass_analyzed_ion_kinetic_energy_spectrometry = 1000267,

    /// MIKES (mass analyzed ion kinetic energy spectrometry): Spectra that are obtained from a sector mass spectrometer that incorporates at least one magnetic sector plus one electric sector in reverse geometry. The accelerating voltage, V, and the magnetic sector field, B, are set at fixed values to select the precursor ions, which are then allowed to dissociate or to react in a field free region between the two sectors. The kinetic energy product ions of m/z selected precursor ions is analyzed by scanning the electric sector field, E. The width of the product ion spectrum peaks is related to the kinetic energy release distribution (KERD) for the dissociation process.
    MS_MIKES = MS_mass_analyzed_ion_kinetic_energy_spectrometry,

    /// mass spectrometry: The branch of science that deals with all aspects of mass spectrometers and the results obtained with these instruments.
    MS_mass_spectrometry_OBSOLETE = 1000268,

    /// MS (mass spectrometry): The branch of science that deals with all aspects of mass spectrometers and the results obtained with these instruments.
    MS_MS_OBSOLETE = MS_mass_spectrometry_OBSOLETE,

    /// mass spectrometry/mass spectrometry: The acquisition, study and spectra of the electrically charged products or precursors of a m/z selected ion or ions.
    MS_mass_spectrometry_mass_spectrometry = 1000269,

    /// MS/MS (mass spectrometry/mass spectrometry): The acquisition, study and spectra of the electrically charged products or precursors of a m/z selected ion or ions.
    MS_MS_MS = MS_mass_spectrometry_mass_spectrometry,

    /// multiple stage mass spectrometry: Multiple stages of precursor ion m/z selection followed by product ion detection for successive progeny ions.
    MS_multiple_stage_mass_spectrometry = 1000270,

    /// MSn (multiple stage mass spectrometry): Multiple stages of precursor ion m/z selection followed by product ion detection for successive progeny ions.
    MS_MSn = MS_multiple_stage_mass_spectrometry,

    /// Negative Ion chemical ionization: Chemical ionization that results in the formation of negative ions.
    MS_Negative_Ion_chemical_ionization = 1000271,

    /// NICI (Negative Ion chemical ionization): Chemical ionization that results in the formation of negative ions.
    MS_NICI = MS_Negative_Ion_chemical_ionization,

    /// neutralization reionization mass spectrometry: With this technique, m/z selected ions form neutrals by charge transfer to a collision gas or by dissociation. The neutrals are separated from the remaining ions and ionized in collisions with a second gas. This method is used to investigate reaction intermediates and other unstable species.
    MS_neutralization_reionization_mass_spectrometry = 1000272,

    /// NRMS (neutralization reionization mass spectrometry): With this technique, m/z selected ions form neutrals by charge transfer to a collision gas or by dissociation. The neutrals are separated from the remaining ions and ionized in collisions with a second gas. This method is used to investigate reaction intermediates and other unstable species.
    MS_NRMS = MS_neutralization_reionization_mass_spectrometry,

    /// photoionization: The ionization of an atom or molecule by a photon, written M + h? ? M^+ + e. The term photon impact is not recommended.
    MS_photoionization = 1000273,

    /// PI (photoionization): The ionization of an atom or molecule by a photon, written M + h? ? M^+ + e. The term photon impact is not recommended.
    MS_PI = MS_photoionization,

    /// pyrolysis mass spectrometry: A mass spectrometry technique in which the sample is heated to the point of decomposition and the gaseous decomposition products are introduced into the ion source.
    MS_pyrolysis_mass_spectrometry = 1000274,

    /// PyMS (pyrolysis mass spectrometry): A mass spectrometry technique in which the sample is heated to the point of decomposition and the gaseous decomposition products are introduced into the ion source.
    MS_PyMS = MS_pyrolysis_mass_spectrometry,

    /// collision quadrupole: A transmission quadrupole to which an oscillating potential is applied so as to focus a beam of ions through a collision gas with no m/z separation.
    MS_collision_quadrupole = 1000275,

    /// q (collision quadrupole): A transmission quadrupole to which an oscillating potential is applied so as to focus a beam of ions through a collision gas with no m/z separation.
    MS_q = MS_collision_quadrupole,

    /// resonance enhanced multiphoton ionization: Multiphoton ionization in which the ionization cross section is significantly enhanced because the energy of the incident photons is resonant with an intermediate excited state of the neutral species.
    MS_resonance_enhanced_multiphoton_ionization = 1000276,

    /// REMPI (resonance enhanced multiphoton ionization): Multiphoton ionization in which the ionization cross section is significantly enhanced because the energy of the incident photons is resonant with an intermediate excited state of the neutral species.
    MS_REMPI = MS_resonance_enhanced_multiphoton_ionization,

    /// residual gas analyzer: A mass spectrometer used to measure the composition and pressure of gasses in an evacuated chamber.
    MS_residual_gas_analyzer = 1000277,

    /// RGA (residual gas analyzer): A mass spectrometer used to measure the composition and pressure of gasses in an evacuated chamber.
    MS_RGA = MS_residual_gas_analyzer,

    /// surface enhanced laser desorption ionization: The formation of ionized species in the gas phase from analytes deposited on a particular surface substrate which is irradiated with a laser beam of which wavelength is absorbed by the surface. See also desorption/ionization on silicon and laser desorption/ionization.
    MS_surface_enhanced_laser_desorption_ionization = 1000278,

    /// SELDI (surface enhanced laser desorption ionization): The formation of ionized species in the gas phase from analytes deposited on a particular surface substrate which is irradiated with a laser beam of which wavelength is absorbed by the surface. See also desorption/ionization on silicon and laser desorption/ionization.
    MS_SELDI = MS_surface_enhanced_laser_desorption_ionization,

    /// surface enhanced neat desorption: Matrix-assisted laser desorption ionization in which the matrix is covalently linked to the target surface.
    MS_surface_enhanced_neat_desorption = 1000279,

    /// SEND (surface enhanced neat desorption): Matrix-assisted laser desorption ionization in which the matrix is covalently linked to the target surface.
    MS_SEND = MS_surface_enhanced_neat_desorption,

    /// suface ionization: The ionization of a neutral species when it interacts with a solid surface with an appropriate work function and temperature.
    MS_suface_ionization_OBSOLETE = 1000280,

    /// SI (suface ionization): The ionization of a neutral species when it interacts with a solid surface with an appropriate work function and temperature.
    MS_SI_OBSOLETE = MS_suface_ionization_OBSOLETE,

    /// selected ion flow tube: A device in which m/z selected ions are entrained in an inert carrier gas and undergo ion-molecule reactions.
    MS_selected_ion_flow_tube = 1000281,

    /// SIFT (selected ion flow tube): A device in which m/z selected ions are entrained in an inert carrier gas and undergo ion-molecule reactions.
    MS_SIFT = MS_selected_ion_flow_tube,

    /// sustained off-resonance irradiation: A technique associated with Fourier transform ion cyclotron resonance (FT-ICR) mass spectrometry to carry out ion/neutral reactions such as low-energy collision-induced dissociation. A radio-frequency electric field of slightly off-resonance to the cyclotron frequency of the reactant ion cyclically accelerates and decelerates the reactant ion that is confined in the Penning ion trap. The ion's orbit does not exceed the dimensions of ion trap while the ion undergoes an ion/neutral species process that produces a high average translational energy for an extended time.
    MS_sustained_off_resonance_irradiation = 1000282,

    /// SORI (sustained off-resonance irradiation): A technique associated with Fourier transform ion cyclotron resonance (FT-ICR) mass spectrometry to carry out ion/neutral reactions such as low-energy collision-induced dissociation. A radio-frequency electric field of slightly off-resonance to the cyclotron frequency of the reactant ion cyclically accelerates and decelerates the reactant ion that is confined in the Penning ion trap. The ion's orbit does not exceed the dimensions of ion trap while the ion undergoes an ion/neutral species process that produces a high average translational energy for an extended time.
    MS_SORI = MS_sustained_off_resonance_irradiation,

    /// Spark Source Mass Spectrometry: Mass spectrometry using spark ionization.
    MS_Spark_Source_Mass_Spectrometry_OBSOLETE = 1000283,

    /// SSMS (Spark Source Mass Spectrometry): Mass spectrometry using spark ionization.
    MS_SSMS_OBSOLETE = MS_Spark_Source_Mass_Spectrometry_OBSOLETE,

    /// stored waveform inverse fourier transform: A technique to create excitation waveforms for ions in FT-ICR mass spectrometer or Paul ion trap. An excitation waveform in the time-domain is generated by taking the inverse Fourier transform of an appropriate frequency-domain programmed excitation spectrum, in which the resonance frequencies of ions to be excited are included. This technique may be used for selection of precursor ions in MS/MS experiments.
    MS_stored_waveform_inverse_fourier_transform = 1000284,

    /// SWIFT (stored waveform inverse fourier transform): A technique to create excitation waveforms for ions in FT-ICR mass spectrometer or Paul ion trap. An excitation waveform in the time-domain is generated by taking the inverse Fourier transform of an appropriate frequency-domain programmed excitation spectrum, in which the resonance frequencies of ions to be excited are included. This technique may be used for selection of precursor ions in MS/MS experiments.
    MS_SWIFT = MS_stored_waveform_inverse_fourier_transform,

    /// total ion current: The sum of all the separate ion currents carried by the ions of different m/z contributing to a complete mass spectrum or in a specified m/z range of a mass spectrum.
    MS_total_ion_current = 1000285,

    /// TIC (total ion current): The sum of all the separate ion currents carried by the ions of different m/z contributing to a complete mass spectrum or in a specified m/z range of a mass spectrum.
    MS_TIC = MS_total_ion_current,

    /// time lag focusing: Energy focusing in a time-of-flight mass spectrometer that is accomplished by introducing a time delay between the formation of the ions and the application of the accelerating voltage pulse.
    MS_time_lag_focusing = 1000286,

    /// TLF (time lag focusing): Energy focusing in a time-of-flight mass spectrometer that is accomplished by introducing a time delay between the formation of the ions and the application of the accelerating voltage pulse.
    MS_TLF = MS_time_lag_focusing,

    /// time-of-flight mass spectrometer: An instrument that separates ions by m/z in a field-free region after acceleration to a fixed kinetic energy.
    MS_time_of_flight_mass_spectrometer = 1000287,

    /// TOF-MS (time-of-flight mass spectrometer): An instrument that separates ions by m/z in a field-free region after acceleration to a fixed kinetic energy.
    MS_TOF_MS = MS_time_of_flight_mass_spectrometer,

    /// cyclotron: A device that uses an oscillating electric field and magnetic field to accelerate charged particles.
    MS_cyclotron = 1000288,

    /// double-focusing mass spectrometer: A mass spectrometer that uses a magnetic sector for m/z focusing and an electric sector for energy focusing of an ion beam.
    MS_double_focusing_mass_spectrometer = 1000289,

    /// hybrid mass spectrometer: A mass spectrometer that combines m/z analyzers of different types to perform tandem mass spectrometry.
    MS_hybrid_mass_spectrometer = 1000290,

    /// linear ion trap: A two dimensional Paul ion trap in which ions are confined in the axial dimension by means of an electric field at the ends of the trap.
    MS_linear_ion_trap = 1000291,

    /// mass spectrograph obsolete: An instrument that separates a beam of ions according to their mass-to-charge ratio in which the ions are directed onto a focal plane detector such as a photographic plate.
    MS_mass_spectrograph_obsolete_OBSOLETE = 1000292,

    /// mass spectrometer: An instrument that measures the mass-to-charge ratio and relative abundances of ions.
    MS_mass_spectrometer = 1000293,

    /// mass spectrum: A plot of the relative abundance of a beam or other collection of ions as a function of the mass-to-charge ratio (m/z).
    MS_mass_spectrum = 1000294,

    /// mattauch-herzog geometry: An arrangement for a double-focusing mass spectrometer in which a deflection of ?/(4 ?(2)) radians in a radial electric field is followed by a magnetic deflection of ?/2 radians.
    MS_mattauch_herzog_geometry_OBSOLETE = 1000295,

    /// nier-johnson geometry: An arrangement for a double-focusing mass spectrometer in which a deflection of ?/2 radians in a radial electric field analyzer is followed by a magnetic deflection of ?/3 radians.
    MS_nier_johnson_geometry_OBSOLETE = 1000296,

    /// paul ion trap: A device that permits the trapping of ions by means of an alternating current voltage. The ejection of ions with a m/z less than a prescribed value and retention of those with higher mass depends on the application of radio frequency voltages between a ring electrode and two end-cap electrodes to confine the ions in a circular path. The choice of these voltages determines the m/z below which ions are ejected.
    MS_paul_ion_trap_OBSOLETE = 1000297,

    /// prolate traochoidal mass spectrometer: A mass spectrometer in which the ions of different m/z are separated by means of crossed electric and magnetic fields in such a way that the selected ions follow a prolate trochoidal path.
    MS_prolate_traochoidal_mass_spectrometer = 1000298,

    /// quistor: An abbreviation of quadrupole ion storage trap. This term is synonymous with Paul Ion Trap. If so then add a synonym to paul and obsolete this term.
    MS_quistor_OBSOLETE = 1000299,

    /// reflectron: A time-of-flight mass spectrometer that uses a static electric field to reverse the direction of travel of the ions entering it. A reflectron improves mass resolution by assuring that ions of the same m/z but different kinetic energy arrive at the detector at the same time.
    MS_reflectron = 1000300,

    /// sector mass spectrometer: A mass spectrometer consisting of one or more magnetic sectors for m/z selection in a beam of ions. Such instruments may also have one or more electric sectors for energy selection.
    MS_sector_mass_spectrometer = 1000301,

    /// tandem mass spectrometer: A mass spectrometer designed for mass spectrometry/mass spectrometry.
    MS_tandem_mass_spectrometer = 1000302,

    /// transmission quadrupole mass spectrometer: A mass spectrometer that consists of four parallel rods whose centers form the corners of a square and whose opposing poles are connected. The voltage applied to the rods is a superposition of a static potential and a sinusoidal radio frequency potential. The motion of an ion in the x and y dimensions is described by the Matthieu equation whose solutions show that ions in a particular m/z range can be transmitted along the z axis.
    MS_transmission_quadrupole_mass_spectrometer = 1000303,

    /// accelerating voltage: The electrical potential used to impart kinetic energy to ions in a mass spectrometer.
    MS_accelerating_voltage = 1000304,

    /// cyclotron motion: The circular motion of a charged particle moving at velocity v in a magnetic field B that results from the force qvB.
    MS_cyclotron_motion = 1000305,

    /// dynamic mass spectrometry: A mass spectrometer in which m/z separation using one or more electric fields that vary with time.
    MS_dynamic_mass_spectrometry = 1000306,

    /// einzel lens: Three element charged particle lens in which the first and third elements are held at the same voltage. Such a lens produces focusing without changing the translational energy of the particle.
    MS_einzel_lens = 1000307,

    /// electric field strength: The magnitude of the force per unit charge at a given point in space.
    MS_electric_field_strength = 1000308,

    /// first stability region: The region of a Mathieu stability diagram closest to the origin. Ions within this region can traverse the full length of a transmission quadrupole.
    MS_first_stability_region = 1000309,

    /// fringing field: The electric or magnetic field that extends from the edge of a sector, lens or other ion optics element.
    MS_fringing_field = 1000310,

    /// kinetic energy analyzer: A device for measuring the kinetic energy of charged particles using a retarding field, time-of-flight, or the extent of deflection in an electric or magnetic field.
    MS_kinetic_energy_analyzer = 1000311,

    /// mass limit: The m/z value above which ions cannot be detected in a mass spectrometer.
    MS_mass_limit_OBSOLETE = 1000312,

    /// scan m/z range?: The limit of m/z over which a mass spectrometer can detect ions.
    MS_scan_m_z_range__OBSOLETE = 1000313,

    /// mass selective axial ejection: The use of mass selective instability to eject ions of selected m/z values from an ion trap.
    MS_mass_selective_axial_ejection = 1000314,

    /// mass selective instability: A method for selective ejection of ions according to their m/z value in an ion trap.
    MS_mass_selective_instability = 1000315,

    /// mathieu stability diagram: A graphical representation expressed in terms of reduced coordinates that describes charged particle motion in a quadrupole mass filter or quadrupole ion trap mass spectrometer.
    MS_mathieu_stability_diagram = 1000316,

    /// orthogonal extraction: The pulsed acceleration of ions perpendicular to their direction of travel into a time-of-flight mass spectrometer. Ions may be extracted from a directional ion source, drift tube or m/z separation stage.
    MS_orthogonal_extraction = 1000317,

    /// resonance ion ejection: A mode of ion ejection in a quadrupole ion trap that relies on a auxiliary radio frequency voltage that is applied to the end-cap electrodes. The voltage is tuned to the secular frequency of a particular ion to eject it.
    MS_resonance_ion_ejection = 1000318,

    /// space charge effect: The mutual repulsion of particles of like charge that limits the current in a charged-particle beam and causes beams or packets of charged particles to expand radially over time.
    MS_space_charge_effect = 1000319,

    /// static field: An electric or magnetic field that does not change in time.
    MS_static_field = 1000320,

    /// 2E Mass Spectrum: A mass spectrum obtained by setting the electric sector field E to twice the value required to transmit the main ion-beam thereby allowing ions with a kinetic energy-to-charge ratio twice that of the main ion-beam to be transmitted. Product ions resulting from partial charge transfer reactions such as m^2+ + N ? m^+ + N^+ that occur in a collision cell (containing a gas, N) located in a field-free region preceding a magnetic and electric sector combination are detected. When the magnetic sector field B is scanned, a mass spectrum of singly charged product ions of doubly charged precursor ions is obtained.
    MS_2E_Mass_Spectrum = 1000321,

    /// charge inversion mass spectrum: The measurement of the relative abundance of ions that result from a charge inversion reaction as a function of m/z.
    MS_charge_inversion_mass_spectrum = 1000322,

    /// constant neutral loss scan: Spectrum of all precursor ions that undergo a selected m/z decrement.
    MS_constant_neutral_loss_scan_OBSOLETE = 1000323,

    /// constant neutral gain scan: Spectrum of all precursor ions that undergo a selected m/z increment.
    MS_constant_neutral_gain_scan_OBSOLETE = 1000324,

    /// Constant Neutral Mass Gain Scan (constant neutral gain scan): Spectrum of all precursor ions that undergo a selected m/z increment.
    MS_Constant_Neutral_Mass_Gain_Scan_OBSOLETE = MS_constant_neutral_gain_scan_OBSOLETE,

    /// constant neutral gain spectrum: A spectrum formed of all product ions that have been produced by gain of a pre-selected neutral mass following the reaction with and addition of the gas in a collision cell.
    MS_constant_neutral_gain_spectrum = 1000325,

    /// constant neutral mass gain spectrum (constant neutral gain spectrum): A spectrum formed of all product ions that have been produced by gain of a pre-selected neutral mass following the reaction with and addition of the gas in a collision cell.
    MS_constant_neutral_mass_gain_spectrum = MS_constant_neutral_gain_spectrum,

    /// constant neutral loss spectrum: A spectrum formed of all product ions that have been produced with a selected m/z decrement from any precursor ions. The spectrum shown correlates to the precursor ion spectrum. See also neutral loss spectrum.
    MS_constant_neutral_loss_spectrum = 1000326,

    /// constant neutral mass loss spectrum (constant neutral loss spectrum): A spectrum formed of all product ions that have been produced with a selected m/z decrement from any precursor ions. The spectrum shown correlates to the precursor ion spectrum. See also neutral loss spectrum.
    MS_constant_neutral_mass_loss_spectrum = MS_constant_neutral_loss_spectrum,

    /// consecutive reaction monitoring: A type of MS/MS experiments with three or more stages of m/z separation and in which a particular multi-step reaction path is monitored.
    MS_consecutive_reaction_monitoring_OBSOLETE_1000327 = 1000327,

    /// e/2 mass spectrum: A mass spectrum obtained using a sector mass spectrometer in which the electric sector field E is set to half the value required to transmit the main ion-beam. This spectrum records the signal from doubly charged product ions of charge-stripping reactions.
    MS_e_2_mass_spectrum = 1000328,

    /// linked scan: A scan in an instrument with two or more m/z analysers or in a sector mass spectrometer that incorporates at least one magnetic sector and one electric sector. Two or more of the analyzers are scanned simultaneously so as to preserve a predetermined relationship between scan parameters to produce a product ion, precursor ion or constant neutral loss spectrum.
    MS_linked_scan_OBSOLETE = 1000329,

    /// linked scan at constant b/e: A linked scan at constant B/E may be performed on a sector mass spectrometer that incorporates at least one magnetic sector plus one electric sector. The magnetic field B and the electric field E are scanned simultaneously while the accelerating voltage V is held constant, so as to maintain the ratio of the two fields constant. This linked scan may record a product ion spectrum of dissociation or other reactions occurring in a field free region preceding the two sectors.
    MS_linked_scan_at_constant_b_e_OBSOLETE = 1000330,

    /// Linked Scan at Constant E2/V: A linked scan performed on a sector instrument that incorporates at least one electric sector plus one magnetic sector. The electric sector field, E, and the accelerating voltage, V, are scanned simultaneously, so as to maintain the ratio E2/V at a constant value. This linked scan recordss a product ion spectrum of dissociation or other reactions occurring in a field free region (FFR) preceding the two sectors.
    MS_Linked_Scan_at_Constant_E2_V_OBSOLETE = 1000331,

    /// Linked Scan at Constant B2/E: A linked scan performed on a sector mass spectrometer that incorporates at least one electric sector plus one magnetic sector in either order. The accelerating voltage is fixed and the magnetic field, B, and the electric field, E, are scanned simultaneously so as to maintain the ratio B2/E at a constant value. This linked scan records a precursor ion spectrum of dissociation or other reactions occurring in the field free region preceding the two sectors. The term B2/E linked scan is not recommended.
    MS_Linked_Scan_at_Constant_B2_E_OBSOLETE = 1000332,

    /// Linked Scan at Constant B[1-(E/E0)]^1/2 / E: A linked scan performed on a sector instrument that incorporates at least one electric sector plus one magnetic sector placed in either order. The accelerating voltage is fixed while scanning the magnetic field, B, and electric field, E, simultaneously, so as to maintain the quantity B[1-(E/E0)]1/2/E at a constant value. This linked scan records a constant neutral mass loss (or gain) spectrum of dissociation or other reactions occurring in a field free region preceding the two sectors. E0 is the electric field required to transmit the singly charged analog of the desired neutral fragment. The term B[1-(E/E0)]1/2/E linked scan.
    MS_Linked_Scan_at_Constant_B_1__E_E0___1_2___E_OBSOLETE = 1000333,

    /// MS/MS in Time: A tandem mass spectrometry method in which product ion spectra are recorded in a single m/z analyzer (such as a Paul Ion Trap or FTMS) in discreet steps over time. Ions in a specific m/z range are selected, dissociated, and the product ions analyzed sequentially in time.
    MS_MS_MS_in_Time = 1000334,

    /// MS/MS in Space: A tandem mass spectrometry method in which product ion spectra are recorded in m/z analyzers separated in space. Specific m/z separation functions are designed such that in one section of the instrument ions are selected, dissociated in an intermediate region, and the product ions are then transmitted to another analyser for m/z separation and data acquisition.
    MS_MS_MS_in_Space = 1000335,

    /// neutral loss: The loss of an uncharged species during a rearrangement process.
    MS_neutral_loss = 1000336,

    /// nth generation product ion: Serial product ions from dissociation of selected precursor ions where n refers to the number of stages of dissociation. The term granddaughter ion is deprecated.
    MS_nth_generation_product_ion = 1000337,

    /// nth generation product ion scan: The specific scan functions or processes that record the appropriate generation of product ion or ions of any m/z selected precursor ions.
    MS_nth_generation_product_ion_scan_OBSOLETE = 1000338,

    /// nth generation product ion spectrum: The mass spectrum recorded from any mass spectrometer in which the appropriate scan function can be set to record the appropriate generation product ion or ions of m/z selected precursor ions.
    MS_nth_generation_product_ion_spectrum_OBSOLETE = 1000339,

    /// precursor ion: An ion that reacts to form particular product ions. The reaction can be unimolecular dissociation, ion/molecule reaction, isomerization, or change in charge state. The term parent ion is deprecated.
    MS_precursor_ion = 1000340,

    /// precursor ion spectrum: Spectrum generated by scanning precursor m/z while monitoring a fixed product m/z.
    MS_precursor_ion_spectrum = 1000341,

    /// product ion: An ion formed as the product of a reaction involving a particular precursor ion. The reaction can be unimolecular dissociation to form fragment ions, an ion/molecule reaction, or simply involve a change in the number of charges. The term fragment ion is deprecated. The term daughter ion is deprecated.
    MS_product_ion = 1000342,

    /// product ion spectrum: A mass spectrum recorded from any spectrometer in which the appropriate m/z separation scan function is set to record the product ion or ions of selected precursor ions.
    MS_product_ion_spectrum_OBSOLETE = 1000343,

    /// progeny ion: A charged product of a series of consecutive reactions that includes product ions, 1st generation product ions, 2nd generation product ions, etc. Given the sequential fragmentation scheme: M1+ -> M2+ -> M3+ -> M4+ -> M5+. M4+ is the precursor ion of M5+, a 1st generation product ion of M3+, a 2nd generation product ion of M2+ and a 3rd generation product ion of M1+.
    MS_progeny_ion = 1000344,

    /// Progeny Fragment Ion (progeny ion): A charged product of a series of consecutive reactions that includes product ions, 1st generation product ions, 2nd generation product ions, etc. Given the sequential fragmentation scheme: M1+ -> M2+ -> M3+ -> M4+ -> M5+. M4+ is the precursor ion of M5+, a 1st generation product ion of M3+, a 2nd generation product ion of M2+ and a 3rd generation product ion of M1+.
    MS_Progeny_Fragment_Ion = MS_progeny_ion,

    /// array detector: Detector comprising several ion collection elements, arranged in a line or grid where each element is an individual detector.
    MS_array_detector = 1000345,

    /// conversion dynode: A surface that is held at high potential such that ions striking the surface produce electrons that are subsequently detected.
    MS_conversion_dynode = 1000346,

    /// dynode: One of a series of electrodes in a photomultiplier tube. Such an arrangement is able to amplify the current emitted by the photocathode.
    MS_dynode = 1000347,

    /// focal plane collector: A detector for spatially disperse ion beams in which all ions simultaneously impinge on the detector plane.
    MS_focal_plane_collector = 1000348,

    /// ion-to-photon detector: A detector in which ions strike a conversion dynode to produce electrons that in turn strike a phosphor and the resulting photons are detected by a photomultiplier.
    MS_ion_to_photon_detector = 1000349,

    /// point collector: A detector in which the ion beam is focused onto a point and the individual ions arrive sequentially.
    MS_point_collector = 1000350,

    /// postacceleration detector: A detector in which the charged particles are accelerated to a high velocity and impinge on a conversion dynode, emitting secondary electrons. The electrons are accelerated onto a phosphor screen, which emits photons that are in turn detected using a photomultiplier or other photon detector.
    MS_postacceleration_detector = 1000351,

    /// secondary electron: Electrons that are ejected from a sample surface as a result of bombardment by a primary beam of atoms, ions or photons. WAS IN DETECTOR TYPE. Where should it go.
    MS_secondary_electron_OBSOLETE = 1000352,

    /// adduct ion: Ion formed by the interaction of an ion with one or more atoms or molecules to form an ion containing all the constituent atoms of the precursor ion as well as the additional atoms from the associated atoms or molecules.
    MS_adduct_ion = 1000353,

    /// aromatic ion: A planar cyclic ion that obeys the Hueckel (4n + 2) rule where n is a positive integer representing the number of conjugated Pi electrons. Charge delocalization leads to greater stability compared to a hypothetical localized structure.
    MS_aromatic_ion = 1000354,

    /// analog ion: Ions that have similar chemical valence, for example the acetyl cation CH3-CO+ and the thioacetyl cation CH3-CS+.
    MS_analog_ion = 1000355,

    /// anti-aromatic ion: A planar cyclic ion with 4n ? electrons and is therefore not aromatic.
    MS_anti_aromatic_ion = 1000356,

    /// cationized molecule: An ion formed by the association of a cation with a neutral molecule, M, for example [M+ Na]+ and [M + K]+. The terms quasi-molecular ion and pseudo-molecular ion should not be used.
    MS_cationized_molecule = 1000357,

    /// cluster ion: An ion formed by a multi-component atomic or molecular assembly of one or more ions with atoms or molecules, such as [(H20)nH]+, [(NaCl)nNa]+ and [(H3PO3)nHPO3]-.
    MS_cluster_ion = 1000358,

    /// Conventional ion: A radical cation or anion in which the charge site and the unpaired electron spin are both formally located in the same atom or group of atoms, as opposed to the spatially separate electronic configuration of distonic ions. The radical cation of methanol, CH3OH+, in which the charge and spin sites are formally located at the O atom is an example of a conventional ion, whereas .CH2-OH2+ is a distonic ion.
    MS_Conventional_ion = 1000359,

    /// diagnostic ion: A product ion whose formation reveals structural or compositional information of its precursor. For instance, the phenyl cation in an electron ionization mass spectrum is a diagnostic ion for benzene and derivatives.
    MS_diagnostic_ion = 1000360,

    /// dimeric ion: An ion formed by ionization of a dimer or by the association of an ion with its neutral counterpart such as [M2]+ or [M-H-M]+.
    MS_dimeric_ion = 1000361,

    /// distonic ion: A radical cation or anion in which the charge site and the unpaired electron spin cannot be both formally located in the same atom or group of atoms as it can be with a conventional ion. For example, CH2-OH2+ is a distonic ion whereas the radical cation of methanol, CH3OH+ is a conventional ion.
    MS_distonic_ion = 1000362,

    /// enium ion: A positively charged lower-valency ion of the nonmetallic elements. The methenium ion is CH3+. Other examples are the oxenium, sulfenium, nitrenium, phosphenium, and halenium ions.
    MS_enium_ion = 1000363,

    /// fragment ion: A product ion that results from the dissociation of a precursor ion.
    MS_fragment_ion_OBSOLETE = 1000364,

    /// ion?: An atomic or molecular species having a net positive or negative electric charge.
    MS_ion_ = 1000365,

    /// Isotopologue ion: An ion that differs only in the isotopic composition of one or more of its constituent atoms. For example CH4+ and CH3D+ or 10BF3 and 11BF3. The term isotopologue is a contraction of isotopic homologue.
    MS_Isotopologue_ion = 1000366,

    /// Isotopomeric ion: Isomeric ion having the same numbers of each isotopic atom but differing in their positions. Isotopomeric ions can be either configurational isomers in which two atomic isotopes exchange positions or isotopic stereoisomers. The term isotopomer is a shortening of isotopic isomer.
    MS_Isotopomeric_ion = 1000367,

    /// metastable ion: An ion that is formed with internal energy higher than the threshold for dissociation but with a lifetime great enough to allow it to exit the ion source and enter the mass spectrometer where it dissociates before detection.
    MS_metastable_ion = 1000368,

    /// molecular ion: An ion formed by the removal of one or more electrons to form a positive ion or the addition off one or more electrons to form a negative ion.
    MS_molecular_ion = 1000369,

    /// negative ion: An atomic or molecular species having a net negative electric charge.
    MS_negative_ion = 1000370,

    /// non-classical ion: Hyper-coordinated carbonium ion such as the penta-coordinated norbornyl cation. Note: Tri-coordinated carbenium ions are termed classical ions.
    MS_non_classical_ion = 1000371,

    /// onium ion: A positively charged hypervalent ion of the nonmetallic elements. Examples are the methonium ion CH5+, the hydrogenonium ion H3+ and the hydronium ion H3O+. Other examples are the carbonium, oxonium, sulfonium, nitronium, diazonium, phosphonium, and halonium ions. Onium ions are not limited to monopositive ions; multiply-charged onium ions exist such as the gitonic (proximal) oxonium dication H4O2+ and the distonic oxonium dication H2O+-CH2-CH2-OH2+.
    MS_onium_ion = 1000372,

    /// principal ion: Most abundant ion of an isotope cluster, such as the 11B79Br2 81Br+ ion of m/z 250 of the cluster of isotopologue molecular ions of BBr3. The term principal ion has also been used to describe ions that have been artificially isotopically enriched in one or more positions such as CH3 13CH3+ or CH2D2 +, but those are best defined as isotopologue ions.
    MS_principal_ion = 1000373,

    /// positive ion: An atomic or molecular species having a net positive electric charge.
    MS_positive_ion = 1000374,

    /// protonated molecule: An ion formed by interaction of a neutral molecule with a proton and represented by the symbol [M + H]+, where M is the neutral molecule. The term 'protonated molecular ion,' 'quasi-molecular ion' and 'pseudo-molecular ion' are not recommended.
    MS_protonated_molecule = 1000375,

    /// radical ion: An ion, either a cation or anion, containing unpaired electrons in its ground state. The unpaired electron is denoted by a superscript dot alongside the superscript symbol for charge, such as for the molecular ion of a molecule M, that is, M+. Radical ions with more than one charge and/or more than one unpaired electron are denoted such as M(2+)(2). Unless the positions of the unpaired electron and charge can be associated with specific atoms, superscript charge designation should be placed before the superscript dot designation.
    MS_radical_ion = 1000376,

    /// reference ion: A stable ion whose structure is known with certainty. These ions are usually formed by direct ionization of a neutral molecule of known structure and are used to verify by comparison the structure of an unknown ion.
    MS_reference_ion = 1000377,

    /// stable ion: An ion with internal energy sufficiently low that it does not rearrange or dissociate prior to detection in a mass spectrometer.
    MS_stable_ion = 1000378,

    /// unstable ion: An ion with sufficient energy to dissociate within the ion source.
    MS_unstable_ion = 1000379,

    /// adiabatic ionization: A process whereby an electron is removed from an atom, ion, or molecule to produce an ion in its lowest energy state.
    MS_adiabatic_ionization = 1000380,

    /// associative ionization: An ionization process in which two excited atoms or molecules react to form a single positive ion and an electron.
    MS_associative_ionization = 1000381,

    /// atmospheric pressure photoionization: Atmospheric pressure chemical ionization in which the reactant ions are generated by photo-ionization.
    MS_atmospheric_pressure_photoionization = 1000382,

    /// autodetachment: The formation of a neutral when a negative ion in a discrete state with an energy greater than the detachment threshold loses an electron spontaneously without further interaction with an energy source.
    MS_autodetachment = 1000383,

    /// autoionization: The formation of an ion when an atom or molecule in a discrete state with an energy greater than the ionization threshold loses an electron spontaneously without further interaction with an energy source.
    MS_autoionization = 1000384,

    /// charge exchange ionization: The interaction of an ion with an atom or molecule in which the charge on the ion is transferred to the neutral without the dissociation of either. Synonymous with charge transfer ionization.
    MS_charge_exchange_ionization = 1000385,

    /// chemi-ionization: The reaction of a neutral molecule with an internally excited molecule to form an ion. Note that this term is not synonymous with chemical ionization.
    MS_chemi_ionization = 1000386,

    /// desorption/ionization on silicon: The formation of ions by laser desorption ionization of a sample deposited on a porous silicon surface.
    MS_desorption_ionization_on_silicon = 1000387,

    /// dissociative ionization: The reaction of a gas-phase molecule that results in its decomposition to form products, one of which is an ion.
    MS_dissociative_ionization = 1000388,

    /// electron ionization: The ionization of an atom or molecule by electrons that are typically accelerated to energies between 50 and 150 eV. Usually 70 eV electrons are used to produce positive ions. The term 'electron impact' is not recommended.
    MS_electron_ionization = 1000389,

    /// ion desolvation: The removal of solvent molecules clustered around a gas-phase ion by means of heating and/or collisions with gas molecules.
    MS_ion_desolvation = 1000390,

    /// ion-pair formation: The reaction of a molecule to form both a positive ion and negative ion fragment among the products.
    MS_ion_pair_formation = 1000391,

    /// ionization efficiency: The ratio of the number of ions formed to the number of electrons, molecules or photons used.
    MS_ionization_efficiency = 1000392,

    /// laser desorption ionization: The formation of gas-phase ions by the interaction of a pulsed laser with a solid or liquid material.
    MS_laser_desorption_ionization = 1000393,

    /// liquid secondary ionization: The ionization of any species by the interaction of a focused beam of ions with a sample that is dissolved in a solvent matrix. See also fast atom bombardment and secondary ionization.
    MS_liquid_secondary_ionization = 1000395,

    /// membrane inlet: A semi-permeable membrane separator that permits the passage of gas sample directly to the mass spectrometer ion source.
    MS_membrane_inlet = 1000396,

    /// microelectrospray: Electrospray ionization at a solvent flow rate of 300-800 nL/min where the flow is a result of a mechanical pump. See nanoelectrospray.
    MS_microelectrospray = 1000397,

    /// nanoelectrospray: Electrospray ionization at a flow rate less than ~25 nL/min. Nanoelectrospray is synonymous with nanospray. The flow is dependent on the potenial on the tip of the electrospray needle and/or a gas presure to push the sample through the needle. See also electrospray ionization and microelectrospray.
    MS_nanoelectrospray = 1000398,

    /// nanospray (nanoelectrospray): Electrospray ionization at a flow rate less than ~25 nL/min. Nanoelectrospray is synonymous with nanospray. The flow is dependent on the potenial on the tip of the electrospray needle and/or a gas presure to push the sample through the needle. See also electrospray ionization and microelectrospray.
    MS_nanospray = MS_nanoelectrospray,

    /// penning ionization: Ionization that occurs through the interaction of two or more neutral gaseous species, at least one of which is internally excited.
    MS_penning_ionization = 1000399,

    /// plasma desorption ionization: The ionization of material in a solid sample by bombarding it with ionic or neutral atoms formed as a result of the fission of a suitable nuclide, typically 252Cf. Synonymous with fission fragment ionization.
    MS_plasma_desorption_ionization = 1000400,

    /// pre-ionization state: An electronic state capable of undergoing auto-Ionization.
    MS_pre_ionization_state = 1000401,

    /// secondary ionization: The process in which ions are ejected from a sample surface as a result of bombardment by a primary beam of atoms or ions.
    MS_secondary_ionization = 1000402,

    /// soft ionization: The formation of gas-phase ions without extensive fragmentation.
    MS_soft_ionization = 1000403,

    /// spark ionization: The formation of ions from a solid material by an intermittent electrical discharge.
    MS_spark_ionization = 1000404,

    /// surface-assisted laser desorption ionization: The formation of gas-phase ions from molecules that are deposited on a particular surface substrate that is irradiated with a pulsed laser. See also matrix-assisted laser desorption ionization.
    MS_surface_assisted_laser_desorption_ionization = 1000405,

    /// surface ionization: The ionization of a neutral species when it interacts with a solid surface with an appropriate work function and temperature.
    MS_surface_ionization = 1000406,

    /// thermal ionization: The ionization of a neutral species through contact with a high temperature surface.
    MS_thermal_ionization = 1000407,

    /// vertical ionization: A process in which an electron is removed from or added to a molecule without a change in the positions of the atoms. The resulting ion is typically in an excited vibrational state.
    MS_vertical_ionization = 1000408,

    /// association reaction: The reaction of an ion with a neutral species in which the reactants combine to form a single ion.
    MS_association_reaction = 1000409,

    /// alpha-cleavage: A homolytic cleavage where the bond fission occurs between at the atom adjacent to the atom at the apparent charge site and an atom removed from the aparent charge site by two bonds.
    MS_alpha_cleavage = 1000410,

    /// beta-cleavage: A homolytic cleavage where the bond fission occurs between at an atom removed from the apparent charge site atom by two bonds and an atom adjacent to that atom and removed from the aparent charge site by three bonds.
    MS_beta_cleavage = 1000411,

    /// buffer gas: An inert gas used for collisional deactivation of internally excited ions.
    MS_buffer_gas = 1000412,

    /// charge-induced fragmentation: Fragmentation of an odd electron ion in which the cleaved bond is adjacent to the apparent charge site. Synonymous with charge mediated fragmentation.
    MS_charge_induced_fragmentation = 1000413,

    /// charge inversion reaction: Reaction of an ion with a neutral species in which the charge on the product ion is reversed in sign with respect to the reactant ion.
    MS_charge_inversion_reaction = 1000414,

    /// charge permutation reaction: The reaction of an ion with a neutral species with a resulting change in the magnitude or sign of the charge on the reactant ion.
    MS_charge_permutation_reaction = 1000415,

    /// charge stripping reaction: Reaction of a positive ion with a neutral species in which the positive charge on the product ion is greater than that on the reactant ion.
    MS_charge_stripping_reaction = 1000416,

    /// charge transfer reaction: The reaction of an ion with a neutral species in which some or all of the charge of the reactant ion is transferred to the neutral species.
    MS_charge_transfer_reaction = 1000417,

    /// collisional excitation: The reaction of an ion with a neutral species in which the translational energy of the collision is converted into internal energy of the ion.
    MS_collisional_excitation = 1000418,

    /// collision gas: An inert gas used for collisional excitation. The term target gas is not recommended.
    MS_collision_gas = 1000419,

    /// heterolytic cleavage: Fragmentation of a molecule or ion in which both electrons forming the single bond that is broken remain on one of the atoms that were originally bonded. This term is synonymous with heterolysis.
    MS_heterolytic_cleavage = 1000420,

    /// high energy collision: Collision-induced dissociation process wherein the projectile ion has laboratory-frame translational energy higher than 1 keV.
    MS_high_energy_collision = 1000421,

    /// beam-type collision-induced dissociation: A collision-induced dissociation process that occurs in a beam-type collision cell.
    MS_beam_type_collision_induced_dissociation = 1000422,

    /// HCD (beam-type collision-induced dissociation): A collision-induced dissociation process that occurs in a beam-type collision cell.
    MS_HCD = MS_beam_type_collision_induced_dissociation,

    /// homolytic cleavage: Fragmentation of an odd electron ion that results from one of a pair of electrons that form a bond between two atoms moving to form a pair with the odd electron on the atom at the apparent charge site. Fragmentation results in the formation of an even electron ion and a radical. This reaction involves the movement of a single electron and is symbolized by a single-barbed arrow. Synonymous with Homolysis.
    MS_homolytic_cleavage = 1000423,

    /// hydrogen/deuterium exchange: Exchange of hydrogen atoms with deuterium atoms in a molecule or pre-formed ion in solution prior to introduction into a mass spectrometer, or by reaction of an ion with a deuterated collision gas inside a mass spectrometer.
    MS_hydrogen_deuterium_exchange = 1000424,

    /// ion energy loss spectrum: A plot of the relative abundance of a beam or other collection of ions as a function their loss of translational energy in reactions with neutral species.
    MS_ion_energy_loss_spectrum_OBSOLETE = 1000425,

    /// ionizing collision: The reaction of an ion with a neutral species in which one or more electrons are removed from either the ion or neutral.
    MS_ionizing_collision = 1000426,

    /// ion/molecule reaction: The reaction of an ion with a neutral molecule. The term ion-molecule reaction is not recommended because the hyphen suggests a single species that is that is both an ion and a molecule.
    MS_ion_molecule_reaction = 1000427,

    /// ion/neutral complex: A particular type of transition state that lies between precursor and product ions on the reaction coordinate of some ion reactions.
    MS_ion_neutral_complex = 1000428,

    /// ion/neutral species reaction: A process wherein a charged species interacts with a neutral reactant to produce either chemically different species or changes in the internal energy of one or both of the reactants.
    MS_ion_neutral_species_reaction = 1000429,

    /// ion/neutral species exchange reaction: In this reaction an association reaction is accompanied by the subsequent or simultaneous liberation of a different neutral species as a product.
    MS_ion_neutral_species_exchange_reaction = 1000430,

    /// kinetic method: An approach to determination of ion thermodynamic quantities by a bracketing procedure in which the relative probabilities of competing ion fragmentations are measured via the relative abundances of the reaction products. The extended kinetic method takes the associated entropy changes into account.
    MS_kinetic_method = 1000431,

    /// low energy collisions: A collision between an ion and neutral species with translational energy approximately 1000 eV or lower.
    MS_low_energy_collisions = 1000432,

    /// low-energy collision-induced dissociation: A collision-induced dissociation process wherein the precursor ion has the translational energy lower than approximately 1000 eV. This process typically requires multiple collisions and the collisional excitation is cumulative.
    MS_low_energy_collision_induced_dissociation = 1000433,

    /// McLafferty Rearrangement: A dissociation reaction triggered by transfer of a hydrogen atom via a 6-member transition state to the formal radical/charge site from a carbon atom four atoms removed from the charge/radical site (the gamma-carbon); subsequent rearrangement of electron density leads to expulsion of an olefin molecule. This term was originally applied to ketone ions where the charge/radical site is the carbonyl oxygen, but it is now more widely applied.
    MS_McLafferty_Rearrangement = 1000434,

    /// photodissociation: A process wherein the reactant ion is dissociated as a result of absorption of one or more photons.
    MS_photodissociation = 1000435,

    /// multiphoton dissociation (photodissociation): A process wherein the reactant ion is dissociated as a result of absorption of one or more photons.
    MS_multiphoton_dissociation = MS_photodissociation,

    /// MPD (photodissociation): A process wherein the reactant ion is dissociated as a result of absorption of one or more photons.
    MS_MPD = MS_photodissociation,

    /// partial charge transfer reaction: Reaction of an ion with a neutral species in which some but not all of the ion charge is transferred to the neutral.
    MS_partial_charge_transfer_reaction = 1000436,

    /// ion reaction: Chemical transformation involving an ion.
    MS_ion_reaction = 1000437,

    /// superelastic collision: Collision in which the translational energy of the fast-moving collision partner is increased at the expense of internal energy of one or both collision partners.
    MS_superelastic_collision = 1000438,

    /// surface-induced reaction: A process wherein a reactant ion interacts with a surface to produce either chemically different species or a change in the internal energy of the reactant ion.
    MS_surface_induced_reaction = 1000439,

    /// unimolecular dissociation: Fragmentation reaction in which the molecularity is treated as one, irrespective of whether the dissociative state is that of a metastable ion produced in the ion source or results from collisional excitation of a stable ion.
    MS_unimolecular_dissociation = 1000440,

    /// scan: Function or process of the mass spectrometer where it records a spectrum.
    MS_scan = 1000441,

    /// spectrum: A mass spectrum is an intensity vs m/z (mass-to-charge ratio) plot representing a chemical analysis.
    MS_spectrum = 1000442,

    /// mass analyzer type: Mass analyzer separates the ions according to their mass-to-charge ratio.
    MS_mass_analyzer_type = 1000443,

    /// m/z Separation Method: Mass/charge separation Method.
    MS_m_z_Separation_Method = 1000444,

    /// sequential m/z separation method: Sequential m/z separation method.
    MS_sequential_m_z_separation_method = 1000445,

    /// fast ion bombardment: The ionization of any species by the interaction of a focused beam of ions having a translational energy of several thousand eV with a solid sample.
    MS_fast_ion_bombardment = 1000446,

    /// FIB (fast ion bombardment): The ionization of any species by the interaction of a focused beam of ions having a translational energy of several thousand eV with a solid sample.
    MS_FIB = MS_fast_ion_bombardment,

    /// LTQ: Finnigan LTQ MS.
    MS_LTQ = 1000447,

    /// LTQ FT: Finnigan LTQ FT MS.
    MS_LTQ_FT = 1000448,

    /// LTQ Orbitrap: Finnigan LTQ Orbitrap MS.
    MS_LTQ_Orbitrap = 1000449,

    /// LXQ: Finnigan LXQ MS.
    MS_LXQ = 1000450,

    /// mass analyzer: Terms used to describe the Analyzer.
    MS_mass_analyzer = 1000451,

    /// analyzer (mass analyzer): Terms used to describe the Analyzer.
    MS_analyzer = MS_mass_analyzer,

    /// data transformation: Terms used to describe types of data processing.
    MS_data_transformation = 1000452,

    /// data processing (data transformation): Terms used to describe types of data processing.
    MS_data_processing = MS_data_transformation,

    /// detector: The device that detects ions.
    MS_detector = 1000453,

    /// instrument additional description: Additional terms to describe the instrument as outlined in the mass spec doc, Appendix 1, section 1.5.
    MS_instrument_additional_description_OBSOLETE = 1000454,

    /// ion selection attribute: Ion selection properties that are associated with a value.
    MS_ion_selection_attribute = 1000455,

    /// precursor activation: Terms to describe the precursor activation.
    MS_precursor_activation = 1000456,

    /// activation (precursor activation): Terms to describe the precursor activation.
    MS_activation = MS_precursor_activation,

    /// sample: Terms to describe the sample.
    MS_sample = 1000457,

    /// source: Terms to describe the source.
    MS_source = 1000458,

    /// spectrum instrument description: Terms used to describe the spectrum.
    MS_spectrum_instrument_description_OBSOLETE = 1000459,

    /// unit: Terms to describe units.
    MS_unit_OBSOLETE = 1000460,

    /// additional description: Terms to describe Additional.
    MS_additional_description_OBSOLETE = 1000461,

    /// ion optics: Device used in the construction of a mass spectrometer to focus, contain or otherwise manipulate ions.
    MS_ion_optics = 1000462,

    /// instrument: Description of the instrument or the mass spectrometer.
    MS_instrument = 1000463,

    /// instrument configuration (instrument): Description of the instrument or the mass spectrometer.
    MS_instrument_configuration = MS_instrument,

    /// mass unit: A unit of measurement for mass.
    MS_mass_unit_OBSOLETE = 1000464,

    /// scan polarity: An acquisition mode to which specifies weather polarity is negative, positive or alternating.
    MS_scan_polarity = 1000465,

    /// alternating: Alternating.
    MS_alternating_OBSOLETE = 1000466,

    /// 1200 series LC/MSD SL: The 1200 Series LC/MSD SL ion trap belongs to the Agilent LC/MSD ion trap family. It provides fast polarity switching and multisignal data acquisition capabilities in a single run while also providing 5 stages of automated data dependent MS/MS and 11 stages of manual MS/MS.
    MS_1200_series_LC_MSD_SL = 1000467,

    /// 6110 Quadrupole LC/MS: The 6110 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with an entry level single quadrupole mass spectrometer from the 6100 Series of Agilent quadrupole mass spectrometers. 6110 Quadrupole mass spectrometer has m/z range of 10-1500 and 2500 u/s scan speed. It proves useful for wide range of SIM quantitative applications.
    MS_6110_Quadrupole_LC_MS = 1000468,

    /// 6120 Quadrupole LC/MS: The 6120 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a single quadrupole mass spectrometer from the 6100 Series of Agilent mass spectrometers. 6120 quadrupole mass spectrometer has m/z range of 10-1500, 2500 u/s scan speed and utilizes multiple signal acquisition.
    MS_6120_Quadrupole_LC_MS = 1000469,

    /// 6130 Quadrupole LC/MS: The 6130 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a single quadrupole mass spectrometer from the 6100 series of Agilent mass spectrometers. The 6130 quadrupole mass spectrometer has m/z range of 2-3000, 2500 u/s scan speed in standard mode and 5250 u/s speed in fast-scan mode. It also uses multiple signal acquisition.
    MS_6130_Quadrupole_LC_MS = 1000470,

    /// 6140 Quadrupole LC/MS: The 6140 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a single quadrupole mass spectrometer from the 6100 Series of Agilent quadrupole mass spectrometers. 6140 Quadrupole mass spectrometer has m/z range of 10-1350, 2500 u/s scan speed in standard mode and 10000 u/s speed in fast-scan mode. It also uses multiple signal acquisition.
    MS_6140_Quadrupole_LC_MS = 1000471,

    /// 6210 Time-of-Flight LC/MS: The 6210 Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer. This time of flight mass spectrometer has a m/z range of 50-12000, mass accuracy of less than 2 ppm and resolution greater than 13,000 at m/z 2722. It has multiple ion sources and can be used with multimode ion sources.
    MS_6210_Time_of_Flight_LC_MS = 1000472,

    /// 6310 Ion Trap LC/MS: The 6310 Ion Trap LC/MS is a Agilent liquid chromatography instrument combined with a 6300 series Agilent ion trap. It has a mass range of 50-2200 between 0.6 to 0.35 resolution and mass range of 200-4000 with resolution of 3-4. The scan speed varies from 1650-27000 for the respective mass ranges.
    MS_6310_Ion_Trap_LC_MS = 1000473,

    /// 6320 Ion Trap LC/MS: The 6320 Ion Trap LC/MS is a Agilent liquid chromatography instrument combined with a 6300 series Agilent ion trap. It has a mass range of 50-2200 between 0.6 to 0.25 resolution and mass range of 200-4000 with resolution of less than 3. The scan speed varies from 1650-27000 for the respective mass ranges.
    MS_6320_Ion_Trap_LC_MS = 1000474,

    /// 6330 Ion Trap LC/MS: The 6330 Ion Trap LC/MS is a Agilent liquid chromatography instrument combined with a 6300 series Agilent ion trap. It has a mass range of 50-2200 between 0.6 to 0.25 resolution and mass range of 200-4000 with resolution of less than 3. The scan speed varies from 1650-27000 for the respective mass ranges.
    MS_6330_Ion_Trap_LC_MS = 1000475,

    /// 6340 Ion Trap LC/MS: The 6340 Ion Trap LC/MS is a Agilent liquid chromatography instrument combined with a 6300 series Agilent ion trap. It has a mass range of 50-2200 between 0.6 to 0.25 resolution and mass range of 200-4000 with resolution of less than 3. The scan speed varies from 1650-27000 for the respective mass ranges.
    MS_6340_Ion_Trap_LC_MS = 1000476,

    /// 6410 Triple Quadrupole LC/MS: The 6410 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer. Mass range of the mass spectrometer is 15-1650 m/z, resolution is at three settings of 0.7 u (unit), 1.2 u (wide) and 2.5 u (widest). The mass accuracy for 6410 mass spectrometer is 0.1 across the mass range. The collision cell is a hexapole with linear acceleration.
    MS_6410_Triple_Quadrupole_LC_MS = 1000477,

    /// 6410 Triple Quad LC/MS (6410 Triple Quadrupole LC/MS): The 6410 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer. Mass range of the mass spectrometer is 15-1650 m/z, resolution is at three settings of 0.7 u (unit), 1.2 u (wide) and 2.5 u (widest). The mass accuracy for 6410 mass spectrometer is 0.1 across the mass range. The collision cell is a hexapole with linear acceleration.
    MS_6410_Triple_Quad_LC_MS = MS_6410_Triple_Quadrupole_LC_MS,

    /// 1200 series LC/MSD VL: The LC/MSD VL ion trap is part of the family of Agilent ion trap mass spectrometers. It has ESI, APCI and APPI ion sources and is a useful ion trap when the amount of sample is not the limiting factor.
    MS_1200_series_LC_MSD_VL = 1000478,

    /// purgatory: Terms that will likely become obsolete unless there are wails of dissent.
    MS_purgatory = 1000479,

    /// mass analyzer attribute: Analyzer properties that are associated with a value.
    MS_mass_analyzer_attribute = 1000480,

    /// detector attribute: Detector attribute recognized as a value.
    MS_detector_attribute = 1000481,

    /// source attribute: Property of a source device that need a value.
    MS_source_attribute = 1000482,

    /// Thermo Fisher Scientific instrument model: Thermo Fisher Scientific instrument model. The company has gone through several names including Thermo Finnigan, Thermo Scientific.
    MS_Thermo_Fisher_Scientific_instrument_model = 1000483,

    /// orbitrap: An ion trapping device that consists of an outer barrel-like electrode and a coaxial inner spindle-like electrode that form an electrostatic field with quadro-logarithmic potential distribution. The frequency of harmonic oscillations of the orbitally trapped ions along the axis of the electrostatic field is independent of the ion velocity and is inversely proportional to the square root of m/z so that the trap can be used as a mass analyzer.
    MS_orbitrap = 1000484,

    /// nanospray inlet: Nanospray Inlet.
    MS_nanospray_inlet = 1000485,

    /// source potential: Potential difference at the MS source in volts.
    MS_source_potential = 1000486,

    /// ion optics attribute: Ion optics involves components that help focus ion streams in mass spectrometry.
    MS_ion_optics_attribute = 1000487,

    /// Hitachi instrument model: Hitachi instrument model.
    MS_Hitachi_instrument_model = 1000488,

    /// Varian instrument model: Varian instrument model.
    MS_Varian_instrument_model = 1000489,

    /// Agilent instrument model: Agilent instrument model.
    MS_Agilent_instrument_model = 1000490,

    /// Dionex instrument model: Dionex instrument model.
    MS_Dionex_instrument_model = 1000491,

    /// Thermo Electron instrument model: Thermo Electron Corporation instrument model.
    MS_Thermo_Electron_instrument_model = 1000492,

    /// Finnigan MAT instrument model: Finnigan MAT instrument model.
    MS_Finnigan_MAT_instrument_model = 1000493,

    /// Thermo Scientific instrument model: Thermo Scientific instrument model.
    MS_Thermo_Scientific_instrument_model = 1000494,

    /// Applied Biosystems instrument model: Applied Biosystems instrument model.
    MS_Applied_Biosystems_instrument_model = 1000495,

    /// ABI (Applied Biosystems instrument model): Applied Biosystems instrument model.
    MS_ABI = MS_Applied_Biosystems_instrument_model,

    /// instrument attribute: Instrument properties that are associated with a value.
    MS_instrument_attribute = 1000496,

    /// zoom scan: Special scan mode, where data with improved resolution is acquired. This is typically achieved by scanning a more narrow m/z window or scanning with a lower scan rate.
    MS_zoom_scan = 1000497,

    /// enhanced resolution scan (zoom scan): Special scan mode, where data with improved resolution is acquired. This is typically achieved by scanning a more narrow m/z window or scanning with a lower scan rate.
    MS_enhanced_resolution_scan = MS_zoom_scan,

    /// full scan: Feature of the ion trap mass spectrometer where MS data is acquired over a mass range.
    MS_full_scan_OBSOLETE = 1000498,

    /// spectrum attribute: Spectrum properties that are associated with a value.
    MS_spectrum_attribute = 1000499,

    /// scan window upper limit: The lower m/z bound of a mass spectrometer scan window.
    MS_scan_window_upper_limit = 1000500,

    /// scan window lower limit: The upper m/z bound of a mass spectrometer scan window.
    MS_scan_window_lower_limit = 1000501,

    /// dwell time: The time spent gathering data across a peak.
    MS_dwell_time = 1000502,

    /// scan attribute: Scan properties that are associated with a value.
    MS_scan_attribute = 1000503,

    /// base peak m/z: M/z value of the signal of highest intensity in the mass spectrum.
    MS_base_peak_m_z = 1000504,

    /// base peak intensity: The intensity of the greatest peak in the mass spectrum.
    MS_base_peak_intensity = 1000505,

    /// ion role: Ion Role.
    MS_ion_role = 1000506,

    /// ion attribute: Ion properties that are associated with a value.
    MS_ion_attribute = 1000507,

    /// ion chemical type: Ion Type.
    MS_ion_chemical_type = 1000508,

    /// activation energy: Activation Energy.
    MS_activation_energy = 1000509,

    /// precursor activation attribute: Precursor Activation Attribute.
    MS_precursor_activation_attribute = 1000510,

    /// ms level: Stages of ms achieved in a multi stage mass spectrometry experiment.
    MS_ms_level = 1000511,

    /// filter string: A string unique to Thermo instrument describing instrument settings for the scan.
    MS_filter_string = 1000512,

    /// binary data array: A data array of values.
    MS_binary_data_array = 1000513,

    /// m/z array: A data array of m/z values.
    MS_m_z_array = 1000514,

    /// intensity array: A data array of intensity values.
    MS_intensity_array = 1000515,

    /// charge array: A data array of charge values.
    MS_charge_array = 1000516,

    /// signal to noise array: A data array of signal-to-noise values.
    MS_signal_to_noise_array = 1000517,

    /// binary data type: Encoding type of binary data specifying the binary representation and precision, e.g. 64-bit float.
    MS_binary_data_type = 1000518,

    /// 32-bit integer: Signed 32-bit little-endian integer.
    MS_32_bit_integer = 1000519,

    /// 16-bit float: Signed 16-bit float.
    MS_16_bit_float_OBSOLETE = 1000520,

    /// 32-bit float: 32-bit precision little-endian floating point conforming to IEEE-754.
    MS_32_bit_float = 1000521,

    /// 64-bit integer: Signed 64-bit little-endian integer.
    MS_64_bit_integer = 1000522,

    /// 64-bit float: 64-bit precision little-endian floating point conforming to IEEE-754.
    MS_64_bit_float = 1000523,

    /// data file content: Describes the data content on the file.
    MS_data_file_content = 1000524,

    /// spectrum representation: Way in which the spectrum is represented, either with regularly spaced data points or with a list of centroided peaks.
    MS_spectrum_representation = 1000525,

    /// Waters raw format: Waters data file format found in a Waters RAW directory, generated from an MS acquisition.
    MS_Waters_raw_format = 1000526,

    /// highest observed m/z: Highest m/z value observed in the m/z array.
    MS_highest_observed_m_z = 1000527,

    /// lowest observed m/z: Lowest m/z value observed in the m/z array.
    MS_lowest_observed_m_z = 1000528,

    /// instrument serial number: Serial Number of the instrument.
    MS_instrument_serial_number = 1000529,

    /// file format conversion: Conversion of one file format to another.
    MS_file_format_conversion = 1000530,

    /// software: Software related to the recording or transformation of spectra.
    MS_software = 1000531,

    /// Xcalibur: Thermo Finnigan software for data acquisition and analysis.
    MS_Xcalibur = 1000532,

    /// Bioworks: Thermo Finnigan software for data analysis of peptides and proteins.
    MS_Bioworks = 1000533,

    /// MassLynx: Micromass software for data acquisition and analysis.
    MS_MassLynx = 1000534,

    /// FlexAnalysis: Bruker software for data analysis.
    MS_FlexAnalysis = 1000535,

    /// Data Explorer: Applied Biosystems software for data acquisition and analysis.
    MS_Data_Explorer = 1000536,

    /// 4700 Explorer: Applied Biosystems software for data acquisition and analysis.
    MS_4700_Explorer = 1000537,

    /// massWolf: A software for converting Waters raw directory format to mzXML or mzML. MassWolf was originally developed at the Institute for Systems Biology.
    MS_massWolf = 1000538,

    /// wolf (massWolf): A software for converting Waters raw directory format to mzXML or mzML. MassWolf was originally developed at the Institute for Systems Biology.
    MS_wolf = MS_massWolf,

    /// Voyager Biospectrometry Workstation System: Applied Biosystems MALDI-TOF data acquisition and analysis system.
    MS_Voyager_Biospectrometry_Workstation_System = 1000539,

    /// FlexControl: Bruker software for data acquisition.
    MS_FlexControl = 1000540,

    /// ReAdW: A software program for converting Thermo Finnigan RAW file format to mzXML or mzML. ReAdW was originally developed at the Institute for Systems Biology. Its whimsical interleaved spelling and capitalization is pronounced \"readraw\".
    MS_ReAdW = 1000541,

    /// MzStar: A software program for converting Applied Biosystems wiff file format to mzXML format. MzStar was originally developed at the Institute for Systems Biology. It is now obsoleted by the MzWiff program.
    MS_MzStar = 1000542,

    /// data processing action: Data processing attribute used to describe the type of data processing performed on the data file.
    MS_data_processing_action = 1000543,

    /// Conversion to mzML: Conversion of a file format to Proteomics Standards Initiative mzML file format.
    MS_Conversion_to_mzML = 1000544,

    /// Conversion to mzXML: Conversion of a file format to Institute of Systems Biology mzXML file format.
    MS_Conversion_to_mzXML = 1000545,

    /// Conversion to mzData: Conversion of a file format to Proteomics Standards Initiative mzData file format.
    MS_Conversion_to_mzData = 1000546,

    /// object attribute: Object Attribute.
    MS_object_attribute = 1000547,

    /// sample attribute: Sample properties that are associated with a value.
    MS_sample_attribute = 1000548,

    /// selection window attribute: Selection window properties that are associated with a value.
    MS_selection_window_attribute = 1000549,

    /// time unit: Time Unit.
    MS_time_unit_OBSOLETE = 1000550,

    /// Analyst: AB SCIEX or Applied Biosystems|MDS SCIEX software for data acquisition.
    MS_Analyst = 1000551,

    /// maldi spot identifier: Maldi Spot Identifier.
    MS_maldi_spot_identifier_OBSOLETE = 1000552,

    /// Trapper: A software program for converting Agilent MassHunter format to mzXML or mzML. Trapper was originally developed at the Institute for Systems Biology.
    MS_Trapper = 1000553,

    /// LCQ Deca: ThermoFinnigan LCQ Deca.
    MS_LCQ_Deca = 1000554,

    /// LTQ Orbitrap Discovery: LTQ Orbitrap Discovery.
    MS_LTQ_Orbitrap_Discovery = 1000555,

    /// LTQ Orbitrap XL: LTQ Orbitrap XL.
    MS_LTQ_Orbitrap_XL = 1000556,

    /// LTQ FT Ultra: LTQ FT Ultra.
    MS_LTQ_FT_Ultra = 1000557,

    /// GC Quantum: GC Quantum.
    MS_GC_Quantum = 1000558,

    /// spectrum type: Spectrum type.
    MS_spectrum_type = 1000559,

    /// mass spectrometer file format: The format of the file being used. This could be a instrument or vendor specific proprietary file format or a converted open file format.
    MS_mass_spectrometer_file_format = 1000560,

    /// data file checksum type: Checksum is a form of redundancy check, a simple way to protect the integrity of data by detecting errors in data.
    MS_data_file_checksum_type = 1000561,

    /// ABI WIFF format: Applied Biosystems WIFF file format.
    MS_ABI_WIFF_format = 1000562,

    /// Thermo RAW format: Thermo Scientific RAW file format.
    MS_Thermo_RAW_format = 1000563,

    /// PSI mzData format: Proteomics Standards Inititative mzData file format.
    MS_PSI_mzData_format = 1000564,

    /// Micromass PKL format: Micromass PKL file format.
    MS_Micromass_PKL_format = 1000565,

    /// ISB mzXML format: Institute of Systems Biology mzXML file format.
    MS_ISB_mzXML_format = 1000566,

    /// Bruker/Agilent YEP format: Bruker/Agilent YEP file format.
    MS_Bruker_Agilent_YEP_format = 1000567,

    /// MD5: MD5 (Message-Digest algorithm 5) is a cryptographic hash function with a 128-bit hash value used to check the integrity of files.
    MS_MD5 = 1000568,

    /// SHA-1: SHA-1 (Secure Hash Algorithm-1) is a cryptographic hash function designed by the National Security Agency (NSA) and published by the NIST as a U. S. government standard. It is also used to verify file integrity.
    MS_SHA_1 = 1000569,

    /// spectra combination: Method used to combine the mass spectra.
    MS_spectra_combination = 1000570,

    /// sum of spectra: Spectra Sum.
    MS_sum_of_spectra = 1000571,

    /// binary data compression type: Compression Type.
    MS_binary_data_compression_type = 1000572,

    /// median of spectra: Spectra is combined by calculating the median of the spectra.
    MS_median_of_spectra = 1000573,

    /// zlib compression: Zlib.
    MS_zlib_compression = 1000574,

    /// mean of spectra: Spectra is combined by calculating the mean of the spectra.
    MS_mean_of_spectra = 1000575,

    /// no compression: No Compression.
    MS_no_compression = 1000576,

    /// raw data file: Describes the type of file and its content.
    MS_raw_data_file = 1000577,

    /// source file (raw data file): Describes the type of file and its content.
    MS_source_file = MS_raw_data_file,

    /// LCQ Fleet: LCQ Fleet.
    MS_LCQ_Fleet = 1000578,

    /// MS1 spectrum: Mass spectrum created by a single-stage MS experiment or the first stage of a multi-stage experiment.
    MS_MS1_spectrum = 1000579,

    /// full spectrum (MS1 spectrum): Mass spectrum created by a single-stage MS experiment or the first stage of a multi-stage experiment.
    MS_full_spectrum = MS_MS1_spectrum,

    /// Q1 spectrum (MS1 spectrum): Mass spectrum created by a single-stage MS experiment or the first stage of a multi-stage experiment.
    MS_Q1_spectrum = MS_MS1_spectrum,

    /// Q3 spectrum (MS1 spectrum): Mass spectrum created by a single-stage MS experiment or the first stage of a multi-stage experiment.
    MS_Q3_spectrum = MS_MS1_spectrum,

    /// Single-Stage Mass Spectrometry (MS1 spectrum): Mass spectrum created by a single-stage MS experiment or the first stage of a multi-stage experiment.
    MS_Single_Stage_Mass_Spectrometry = MS_MS1_spectrum,

    /// MSn spectrum: MSn refers to multi-stage MS/MS experiments designed to record product ion spectra where n is the number of product ion stages (progeny ions). For ion traps, sequential MS/MS experiments can be undertaken where n > 2 whereas for a simple triple quadrupole system n=2. Use the term ms level (MS:1000511) for specifying n.
    MS_MSn_spectrum = 1000580,

    /// multiple-stage mass spectrometry spectrum (MSn spectrum): MSn refers to multi-stage MS/MS experiments designed to record product ion spectra where n is the number of product ion stages (progeny ions). For ion traps, sequential MS/MS experiments can be undertaken where n > 2 whereas for a simple triple quadrupole system n=2. Use the term ms level (MS:1000511) for specifying n.
    MS_multiple_stage_mass_spectrometry_spectrum = MS_MSn_spectrum,

    /// nth generation product ion spectrum (MSn spectrum): MSn refers to multi-stage MS/MS experiments designed to record product ion spectra where n is the number of product ion stages (progeny ions). For ion traps, sequential MS/MS experiments can be undertaken where n > 2 whereas for a simple triple quadrupole system n=2. Use the term ms level (MS:1000511) for specifying n.
    MS_nth_generation_product_ion_spectrum = MS_MSn_spectrum,

    /// product ion spectrum (MSn spectrum): MSn refers to multi-stage MS/MS experiments designed to record product ion spectra where n is the number of product ion stages (progeny ions). For ion traps, sequential MS/MS experiments can be undertaken where n > 2 whereas for a simple triple quadrupole system n=2. Use the term ms level (MS:1000511) for specifying n.
    MS_product_ion_spectrum = MS_MSn_spectrum,

    /// CRM spectrum: Spectrum generated from MSn experiment with three or more stages of m/z separation and in which a particular multi-step reaction path is monitored.
    MS_CRM_spectrum = 1000581,

    /// SIM spectrum: Spectrum obtained with the operation of a mass spectrometer in which the abundances of one ion or several ions of specific m/z values are recorded rather than the entire mass spectrum (Selected Ion Monitoring).
    MS_SIM_spectrum = 1000582,

    /// MIM spectrum (SIM spectrum): Spectrum obtained with the operation of a mass spectrometer in which the abundances of one ion or several ions of specific m/z values are recorded rather than the entire mass spectrum (Selected Ion Monitoring).
    MS_MIM_spectrum = MS_SIM_spectrum,

    /// multiple ion monitoring spectrum (SIM spectrum): Spectrum obtained with the operation of a mass spectrometer in which the abundances of one ion or several ions of specific m/z values are recorded rather than the entire mass spectrum (Selected Ion Monitoring).
    MS_multiple_ion_monitoring_spectrum = MS_SIM_spectrum,

    /// selected ion monitoring spectrum (SIM spectrum): Spectrum obtained with the operation of a mass spectrometer in which the abundances of one ion or several ions of specific m/z values are recorded rather than the entire mass spectrum (Selected Ion Monitoring).
    MS_selected_ion_monitoring_spectrum = MS_SIM_spectrum,

    /// SRM spectrum: Spectrum obtained when data are acquired from specific product ions corresponding to m/z values of selected precursor ions a recorded via two or more stages of mass spectrometry. The precursor/product ion pair is called a transition pair. Data can be obtained for a single transition pair or multiple transition pairs. Multiple time segments of different transition pairs can exist in a single file. Single precursor ions can have multiple product ions consitituting multiple transition pairs. Selected reaction monitoring can be performed as tandem mass spectrometry in time or tandem mass spectrometry in space.
    MS_SRM_spectrum = 1000583,

    /// MRM spectrum (SRM spectrum): Spectrum obtained when data are acquired from specific product ions corresponding to m/z values of selected precursor ions a recorded via two or more stages of mass spectrometry. The precursor/product ion pair is called a transition pair. Data can be obtained for a single transition pair or multiple transition pairs. Multiple time segments of different transition pairs can exist in a single file. Single precursor ions can have multiple product ions consitituting multiple transition pairs. Selected reaction monitoring can be performed as tandem mass spectrometry in time or tandem mass spectrometry in space.
    MS_MRM_spectrum = MS_SRM_spectrum,

    /// multiple reaction monitoring spectrum (SRM spectrum): Spectrum obtained when data are acquired from specific product ions corresponding to m/z values of selected precursor ions a recorded via two or more stages of mass spectrometry. The precursor/product ion pair is called a transition pair. Data can be obtained for a single transition pair or multiple transition pairs. Multiple time segments of different transition pairs can exist in a single file. Single precursor ions can have multiple product ions consitituting multiple transition pairs. Selected reaction monitoring can be performed as tandem mass spectrometry in time or tandem mass spectrometry in space.
    MS_multiple_reaction_monitoring_spectrum = MS_SRM_spectrum,

    /// selected reaction monitoring spectrum (SRM spectrum): Spectrum obtained when data are acquired from specific product ions corresponding to m/z values of selected precursor ions a recorded via two or more stages of mass spectrometry. The precursor/product ion pair is called a transition pair. Data can be obtained for a single transition pair or multiple transition pairs. Multiple time segments of different transition pairs can exist in a single file. Single precursor ions can have multiple product ions consitituting multiple transition pairs. Selected reaction monitoring can be performed as tandem mass spectrometry in time or tandem mass spectrometry in space.
    MS_selected_reaction_monitoring_spectrum = MS_SRM_spectrum,

    /// mzML format: Proteomics Standards Inititative mzML file format.
    MS_mzML_format = 1000584,

    /// contact attribute: Details about a person or organization to contact in case of concern or discussion about the file.
    MS_contact_attribute = 1000585,

    /// contact name: Name of the contact person or organization.
    MS_contact_name = 1000586,

    /// contact address: Postal address of the contact person or organization.
    MS_contact_address = 1000587,

    /// contact URL: Uniform Resource Locator related to the contact person or organization.
    MS_contact_URL = 1000588,

    /// contact email: Email address of the contact person or organization.
    MS_contact_email = 1000589,

    /// contact affiliation: Home institution of the contact person.
    MS_contact_affiliation = 1000590,

    /// MzWiff: A software program for converting Applied Biosystems wiff file format to the mzXML or mzML format. MzWiff is currently maintained at the Institute for Systems Biology. It replaces the slower mzStar program.
    MS_MzWiff = 1000591,

    /// smoothing: A process of reducing spikes of intensity in order to reduce noise while preserving real peak signal. Many algorithms can be applied for this process.
    MS_smoothing = 1000592,

    /// baseline reduction: A process of removal of varying intensities generated due to variable energy absorption before further processing can take place. Baseline reduction facilitates meaningful comparision between intensities of m/z values.
    MS_baseline_reduction = 1000593,

    /// low intensity data point removal: The removal of very low intensity data points that are likely to be spurious noise rather than real signal.
    MS_low_intensity_data_point_removal = 1000594,

    /// thresholding (low intensity data point removal): The removal of very low intensity data points that are likely to be spurious noise rather than real signal.
    MS_thresholding = MS_low_intensity_data_point_removal,

    /// time array: A data array of relative time offset values from a reference time.
    MS_time_array = 1000595,

    /// measurement method: An attribute of resolution when recording the detector response in absence of the analyte.
    MS_measurement_method = 1000596,

    /// ion optics type: The electrical potential used to impart kinetic energy to ions in a mass spectrometer.
    MS_ion_optics_type = 1000597,

    /// electron transfer dissociation: A process to fragment ions in a mass spectrometer by inducing fragmentation of cations (e.g. peptides or proteins) by transferring electrons to them.
    MS_electron_transfer_dissociation = 1000598,

    /// ETD (electron transfer dissociation): A process to fragment ions in a mass spectrometer by inducing fragmentation of cations (e.g. peptides or proteins) by transferring electrons to them.
    MS_ETD = MS_electron_transfer_dissociation,

    /// pulsed q dissociation: A process that involves precursor ion activation at high Q, a time delay to allow the precursor to fragment, then a rapid pulse to low Q where all fragment ions are trapped. The product ions can then be scanned out of the ion trap and detected.
    MS_pulsed_q_dissociation = 1000599,

    /// PQD (pulsed q dissociation): A process that involves precursor ion activation at high Q, a time delay to allow the precursor to fragment, then a rapid pulse to low Q where all fragment ions are trapped. The product ions can then be scanned out of the ion trap and detected.
    MS_PQD = MS_pulsed_q_dissociation,

    /// Proteios: Database application and analysis platform for proteomics.
    MS_Proteios = 1000600,

    /// ProteinLynx Global Server: Waters software for data analysis.
    MS_ProteinLynx_Global_Server = 1000601,

    /// Shimadzu MALDI-TOF instrument model: Shimadzu MALDI-TOF instrument model.
    MS_Shimadzu_MALDI_TOF_instrument_model = 1000602,

    /// Shimadzu Scientific Instruments instrument model: Shimadzu Scientific Instruments instrument model.
    MS_Shimadzu_Scientific_Instruments_instrument_model = 1000603,

    /// LCMS-IT-TOF: Shimadzu Scientific Instruments LCMS-IT-TOF MS.
    MS_LCMS_IT_TOF = 1000604,

    /// LCMS-2010EV: Shimadzu Scientific Instruments LCMS-2010EV MS.
    MS_LCMS_2010EV = 1000605,

    /// LCMS-2010A: Shimadzu Scientific Instruments LCMS-2010A MS.
    MS_LCMS_2010A = 1000606,

    /// AXIMA CFR MALDI-TOF: Shimadzu Biotech AXIMA CFR MALDI-TOF MS.
    MS_AXIMA_CFR_MALDI_TOF = 1000607,

    /// AXIMA-QIT: Shimadzu Biotech AXIMA-QIT MS.
    MS_AXIMA_QIT = 1000608,

    /// AXIMA-CFR plus: Shimadzu Biotech AXIMA-CFR plus MS.
    MS_AXIMA_CFR_plus = 1000609,

    /// AXIMA Performance MALDI-TOF/TOF: Shimadzu Biotech AXIMA Performance MALDI-TOF/TOF MS.
    MS_AXIMA_Performance_MALDI_TOF_TOF = 1000610,

    /// AXIMA Confidence MALDI-TOF: Shimadzu Biotech AXIMA Confidence MALDI-TOF (curved field reflectron) MS.
    MS_AXIMA_Confidence_MALDI_TOF = 1000611,

    /// AXIMA Assurance Linear MALDI-TOF: Shimadzu Biotech AXIMA Assurance Linear MALDI-TOF MS.
    MS_AXIMA_Assurance_Linear_MALDI_TOF = 1000612,

    /// DTA format: SEQUEST DTA file format.
    MS_DTA_format = 1000613,

    /// ProteinLynx Global Server mass spectrum XML format: Peak list file format used by ProteinLynx Global Server.
    MS_ProteinLynx_Global_Server_mass_spectrum_XML_format = 1000614,

    /// ProteoWizard software: ProteoWizard software for data processing and analysis. Primarily developed by the labs of P. Malick and D. Tabb.
    MS_ProteoWizard_software = 1000615,

    /// pwiz (ProteoWizard software): ProteoWizard software for data processing and analysis. Primarily developed by the labs of P. Malick and D. Tabb.
    MS_pwiz = MS_ProteoWizard_software,

    /// preset scan configuration: A user-defined scan configuration that specifies the instrumental settings in which a spectrum is acquired. An instrument may cycle through a list of preset scan configurations to acquire data. This is a more generic term for the Thermo \"scan event\", which is defined in the Thermo Xcalibur glossary as: a mass spectrometer scan that is defined by choosing the necessary scan parameter settings. Multiple scan events can be defined for each segment of time.
    MS_preset_scan_configuration = 1000616,

    /// wavelength array: A data array of electromagnetic radiation wavelength values.
    MS_wavelength_array = 1000617,

    /// highest observed wavelength: Highest wavelength observed in an EMR spectrum.
    MS_highest_observed_wavelength = 1000618,

    /// lowest observed wavelength: Lowest wavelength observed in an EMR spectrum.
    MS_lowest_observed_wavelength = 1000619,

    /// PDA spectrum: Spectrum generated from a photodiode array detector (ultraviolet/visible spectrum).
    MS_PDA_spectrum_OBSOLETE = 1000620,

    /// photodiode array detector: An array detector used to record spectra in the ultraviolet and visible region of light.
    MS_photodiode_array_detector = 1000621,

    /// PDA (photodiode array detector): An array detector used to record spectra in the ultraviolet and visible region of light.
    MS_PDA = MS_photodiode_array_detector,

    /// Surveyor PDA: Surveyor PDA.
    MS_Surveyor_PDA = 1000622,

    /// Accela PDA: Accela PDA.
    MS_Accela_PDA = 1000623,

    /// inductive detector: Inductive detector.
    MS_inductive_detector = 1000624,

    /// image current detector (inductive detector): Inductive detector.
    MS_image_current_detector = MS_inductive_detector,

    /// chromatogram: The representation of detector response versus time.
    MS_chromatogram = 1000625,

    /// chromatogram type: Broad category or type of a chromatogram.
    MS_chromatogram_type = 1000626,

    /// selected ion current chromatogram: Chromatogram created by creating an array of the measurements of a specific single ion current at each time point.
    MS_selected_ion_current_chromatogram = 1000627,

    /// SIC chromatogram (selected ion current chromatogram): Chromatogram created by creating an array of the measurements of a specific single ion current at each time point.
    MS_SIC_chromatogram = MS_selected_ion_current_chromatogram,

    /// basepeak chromatogram: Chromatogram created by creating an array of the most intense peaks at each time point.
    MS_basepeak_chromatogram = 1000628,

    /// low intensity threshold: Threshold below which some action is taken.
    MS_low_intensity_threshold = 1000629,

    /// data processing parameter: Data processing parameter used in the data processing performed on the data file.
    MS_data_processing_parameter = 1000630,

    /// high intensity threshold: Threshold above which some action is taken.
    MS_high_intensity_threshold = 1000631,

    /// Q-Tof Premier: Waters oa-ToF based Q-Tof Premier.
    MS_Q_Tof_Premier = 1000632,

    /// possible charge state: A possible charge state of the ion in a situation where the charge of an ion is known to be one of several possible values rather than a completely unknown value or determined to be a specific charge with reasonable certainty.
    MS_possible_charge_state = 1000633,

    /// DSQ: ThermoFinnigan DSQ GC-MS.
    MS_DSQ = 1000634,

    /// ITQ 700: Thermo Scientific ITQ 700 GC-MS.
    MS_ITQ_700 = 1000635,

    /// ITQ 900: Thermo Scientific ITQ 900 GC-MS.
    MS_ITQ_900 = 1000636,

    /// ITQ 1100: Thermo Scientific ITQ 1100 GC-MS.
    MS_ITQ_1100 = 1000637,

    /// LTQ XL ETD: Thermo Scientific LTQ XL MS with ETD.
    MS_LTQ_XL_ETD = 1000638,

    /// LTQ Orbitrap XL ETD: Thermo Scientific LTQ Orbitrap XL MS with ETD.
    MS_LTQ_Orbitrap_XL_ETD = 1000639,

    /// DFS: Thermo Scientific DFS HR GC-MS.
    MS_DFS = 1000640,

    /// DSQ II: Thermo Scientific DSQ II GC-MS.
    MS_DSQ_II = 1000641,

    /// MALDI LTQ XL: Thermo Scientific MALDI LTQ XL MS.
    MS_MALDI_LTQ_XL = 1000642,

    /// MALDI LTQ Orbitrap: Thermo Scientific MALDI LTQ Orbitrap MS.
    MS_MALDI_LTQ_Orbitrap = 1000643,

    /// TSQ Quantum Access: Thermo Scientific TSQ Quantum Access MS.
    MS_TSQ_Quantum_Access = 1000644,

    /// Element XR: Thermo Scientific Element XR HR-ICP-MS.
    MS_Element_XR = 1000645,

    /// Element 2: Thermo Scientific Element 2 HR-ICP-MS.
    MS_Element_2 = 1000646,

    /// Element GD: Thermo Scientific Element GD Glow Discharge MS.
    MS_Element_GD = 1000647,

    /// GC IsoLink: Thermo Scientific GC IsoLink Isotope Ratio MS.
    MS_GC_IsoLink = 1000648,

    /// Exactive: Thermo Scientific Exactive MS.
    MS_Exactive = 1000649,

    /// Proteome Discoverer: Thermo Scientific software for data analysis of peptides and proteins.
    MS_Proteome_Discoverer = 1000650,

    /// 3200 QTRAP: AB SCIEX or Applied Biosystems|MDS SCIEX QTRAP 3200.
    MS_3200_QTRAP = 1000651,

    /// 4800 Plus MALDI TOF/TOF: AB SCIEX or Applied Biosystems|MDS SCIEX 4800 Plus MALDI TOF-TOF Analyzer.
    MS_4800_Plus_MALDI_TOF_TOF = 1000652,

    /// API 3200: AB SCIEX or Applied Biosystems|MDS SCIEX API 3200 MS.
    MS_API_3200 = 1000653,

    /// API 5000: AB SCIEX or Applied Biosystems|MDS SCIEX API 5000 MS.
    MS_API_5000 = 1000654,

    /// QSTAR Elite: AB SCIEX or Applied Biosystems|MDS SCIEX QSTAR Elite.
    MS_QSTAR_Elite = 1000655,

    /// QSTAR Pulsar: Applied Biosystems|MDS SCIEX QSTAR Pulsar.
    MS_QSTAR_Pulsar = 1000656,

    /// QSTAR XL: Applied Biosystems|MDS SCIEX QSTAR XL.
    MS_QSTAR_XL = 1000657,

    /// 4800 Proteomics Analyzer: Applied Biosystems|MDS SCIEX 4800 Proteomics Analyzer.
    MS_4800_Proteomics_Analyzer = 1000658,

    /// 4000 Series Explorer Software: AB SCIEX or Applied Biosystems software for data acquisition and analysis.
    MS_4000_Series_Explorer_Software = 1000659,

    /// GPS Explorer: AB SCIEX or Applied Biosystems software for data acquisition and analysis.
    MS_GPS_Explorer = 1000661,

    /// LightSight Software: AB SCIEX or Applied Biosystems|MDS SCIEX software metabolite identification.
    MS_LightSight_Software = 1000662,

    /// ProteinPilot Software: AB SCIEX or Applied Biosystems|MDS SCIEX software for protein ID and quant.
    MS_ProteinPilot_Software = 1000663,

    /// TissueView Software: Applied Biosystems|MDS SCIEX software for tissue imaging.
    MS_TissueView_Software = 1000664,

    /// MarkerView Software: Applied Biosystems|MDS SCIEX software for metabolomics and biomarker profiling.
    MS_MarkerView_Software = 1000665,

    /// MRMPilot Software: Applied Biosystems|MDS SCIEX software for MRM assay development.
    MS_MRMPilot_Software = 1000666,

    /// BioAnalyst: Applied Biosystems|MDS SCIEX software for bio-related data exploration.
    MS_BioAnalyst = 1000667,

    /// Pro ID: Applied Biosystems|MDS SCIEX software for protein identification.
    MS_Pro_ID = 1000668,

    /// Pro ICAT: Applied Biosystems|MDS SCIEX software for protein ID and quant by ICAT.
    MS_Pro_ICAT = 1000669,

    /// Pro Quant: Applied Biosystems|MDS SCIEX software for protein ID and quant by iTRAQ.
    MS_Pro_Quant = 1000670,

    /// Pro BLAST: Applied Biosystems|MDS SCIEX software for MS-BLAST identification.
    MS_Pro_BLAST = 1000671,

    /// Cliquid: AB SCIEX Cliquid software for data analysis and quantitation.
    MS_Cliquid = 1000672,

    /// MIDAS Workflow Designer: Applied Biosystems|MDS SCIEX software for MRM assay development.
    MS_MIDAS_Workflow_Designer = 1000673,

    /// MultiQuant: Applied Biosystems|MDS SCIEX software for MRM-based quantitation.
    MS_MultiQuant = 1000674,

    /// 6220 Time-of-Flight LC/MS: The 6220 Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer. This time of flight mass spectrometer has a m/z range of 50-12000, mass accuracy of less than 2 ppm and resolution greater than 13,000 at m/z 2722. It has multiple ion sources and can be used with multimode ion sources.
    MS_6220_Time_of_Flight_LC_MS = 1000675,

    /// 6510 Quadrupole Time-of-Flight LC/MS: The 6510 Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer. This time of flight mass spectrometer has a m/z range of 50-12000, mass accuracy of less than 2 ppm and resolution greater than 13,000 at m/z 2722. It has multiple ion sources and can be used with multimode ion sources.
    MS_6510_Quadrupole_Time_of_Flight_LC_MS = 1000676,

    /// 6520 Quadrupole Time-of-Flight LC/MS: The 6520 Quadrupole Time-of-Flight LC/MS is a Agilent liquid chromatography instrument combined with a Agilent time of flight mass spectrometer. This time of flight mass spectrometer has a m/z range of 50-12000, mass accuracy of less than 2 ppm and resolution greater than 26,000 at m/z 2722. It has multiple ion sources and can be used with multimode ion sources.
    MS_6520_Quadrupole_Time_of_Flight_LC_MS = 1000677,

    /// MassHunter Data Acquisition: Software for data acquisition of 6000 series instruments.
    MS_MassHunter_Data_Acquisition = 1000678,

    /// MassHunter Easy Access: Software for open access data acquisition.
    MS_MassHunter_Easy_Access = 1000679,

    /// MassHunter Qualitative Analysis: Software for data analysis of data from 6000 series instruments.
    MS_MassHunter_Qualitative_Analysis = 1000680,

    /// MassHunter Quantitative Analysis: Software for quantitation of Triple Quadrupole and Quadrupole Time-of-Flight data.
    MS_MassHunter_Quantitative_Analysis = 1000681,

    /// MassHunter Metabolite ID: Software for identification of metabolites.
    MS_MassHunter_Metabolite_ID = 1000682,

    /// MassHunter BioConfirm: Software for protein characterization.
    MS_MassHunter_BioConfirm = 1000683,

    /// Genespring MS: Software for quantitation and statistical analysis of TOF and Q-TOF LC/MS data.
    MS_Genespring_MS = 1000684,

    /// MassHunter Mass Profiler: Software for quantitation and statistical analysis of TOF and Q-TOF LC/MS data.
    MS_MassHunter_Mass_Profiler = 1000685,

    /// METLIN: Personal Metabolite Database for MassHunter Workstation. Software for identification of human metabolites.
    MS_METLIN = 1000686,

    /// Spectrum Mill for MassHunter Workstation: Software for protein identification and characterization of complex protein digest mixtures.
    MS_Spectrum_Mill_for_MassHunter_Workstation = 1000687,

    /// 6300 Series Ion Trap Data Analysis Software: Software for data analysis of 6300 series ion trap mass spectrometers.
    MS_6300_Series_Ion_Trap_Data_Analysis_Software = 1000688,

    /// Agilent software: Agilent software for data acquisition and analysis.
    MS_Agilent_software = 1000689,

    /// AB SCIEX software: AB SCIEX or Applied Biosystems software for data acquisition and analysis.
    MS_AB_SCIEX_software = 1000690,

    /// Applied Biosystems software: Applied Biosystems|MDS SCIEX software for data acquisition and analysis.
    MS_Applied_Biosystems_software = 1000691,

    /// Bruker software: Bruker software for data acquisition and analysis.
    MS_Bruker_software = 1000692,

    /// Thermo Finnigan software: Thermo Finnigan software for data acquisition and analysis.
    MS_Thermo_Finnigan_software = 1000693,

    /// Waters software: Waters software for data acquisition and analysis.
    MS_Waters_software = 1000694,

    /// apex ultra: Bruker Daltonics' apex ultra: ESI, MALDI, Nanospray, APCI, APPI, Qh-FT_ICR.
    MS_apex_ultra = 1000695,

    /// autoflex III smartbeam: Bruker Daltonics' autoflex III smartbeam: MALDI TOF.
    MS_autoflex_III_smartbeam = 1000696,

    /// Bruker Daltonics HCT Series: Bruker Daltonics' HCT Series.
    MS_Bruker_Daltonics_HCT_Series = 1000697,

    /// HCTultra: Bruker Daltonics' HCTultra: ESI TOF, Nanospray, APCI, APPI.
    MS_HCTultra = 1000698,

    /// HCTultra PTM: Bruker Daltonics' HCTultra PTM: ESI TOF, Nanospray, APCI, APPI, PTR.
    MS_HCTultra_PTM = 1000699,

    /// HCTultra ETD II: Bruker Daltonics' HCTultra ETD II: ESI Q-TOF, Nanospray, APCI, APPI, ETD.
    MS_HCTultra_ETD_II = 1000700,

    /// microflex LT: Bruker Daltonics' microflex LT: MALDI TOF.
    MS_microflex_LT = 1000701,

    /// micrOTOF: Bruker Daltonics' micrOTOF: ESI TOF, APCI, APPI.
    MS_micrOTOF = 1000702,

    /// micrOTOF-Q: Bruker Daltonics' micrOTOF-Q: ESI Q-TOF, Nanospray, APCI, APPI.
    MS_micrOTOF_Q = 1000703,

    /// micrOTOF-Q II: Bruker Daltonics' micrOTOF-Q II: ESI Q-TOF, Nanospray, APCI, APPI.
    MS_micrOTOF_Q_II = 1000704,

    /// ultraflex III TOF/TOF: Bruker Daltonics' ultraflex III TOF/TOF: MALDI TOF.
    MS_ultraflex_III_TOF_TOF = 1000705,

    /// apexControl: Bruker software for data acquisition.
    MS_apexControl = 1000706,

    /// BioTools: Bruker software for data analysis.
    MS_BioTools = 1000707,

    /// CLINPROT: Bruker CLINPROT software.
    MS_CLINPROT = 1000708,

    /// CLINPROT micro: Bruker CLINPROT micro software.
    MS_CLINPROT_micro = 1000709,

    /// CLINPROT robot: Bruker CLINPROT robot software.
    MS_CLINPROT_robot = 1000710,

    /// ClinProTools: Bruker ClinProTools software.
    MS_ClinProTools = 1000711,

    /// Compass: Bruker Compass software.
    MS_Compass = 1000712,

    /// Compass for HCT/esquire: Bruker Compass for HCT/esquire software.
    MS_Compass_for_HCT_esquire = 1000713,

    /// Compass for micrOTOF: Bruker Compass for micrOTOF software.
    MS_Compass_for_micrOTOF = 1000714,

    /// Compass OpenAccess: Bruker compass OpenAccess software.
    MS_Compass_OpenAccess = 1000715,

    /// Compass Security Pack: Bruker compass Security Pack software.
    MS_Compass_Security_Pack = 1000716,

    /// CompassXport: Bruker stand-alone software for data conversion.
    MS_CompassXport = 1000717,

    /// CompassXtract: Bruker software library for data access.
    MS_CompassXtract = 1000718,

    /// DataAnalysis: Bruker software for data analysis.
    MS_DataAnalysis = 1000719,

    /// dpControl: Bruker software for data acquisition.
    MS_dpControl = 1000720,

    /// esquireControl: Bruker software for data acquisition.
    MS_esquireControl = 1000721,

    /// flexImaging: Bruker software for data analysis.
    MS_flexImaging = 1000722,

    /// GENOLINK: Bruker GENOLINK software.
    MS_GENOLINK = 1000723,

    /// GenoTools: Bruker GenoTools software.
    MS_GenoTools = 1000724,

    /// HCTcontrol: Bruker software for data acquisition.
    MS_HCTcontrol = 1000725,

    /// micrOTOFcontrol: Bruker software for data acquisition.
    MS_micrOTOFcontrol = 1000726,

    /// PolyTools: Bruker PolyTools software.
    MS_PolyTools = 1000727,

    /// ProfileAnalysis: Bruker software for data analysis.
    MS_ProfileAnalysis = 1000728,

    /// PROTEINEER: Bruker PROTEINEER software.
    MS_PROTEINEER = 1000729,

    /// PROTEINEER dp: Bruker PROTEINEER dp software.
    MS_PROTEINEER_dp = 1000730,

    /// PROTEINEER fc: Bruker PROTEINEER fc software.
    MS_PROTEINEER_fc = 1000731,

    /// PROTEINEER spII: Bruker PROTEINEER spII software.
    MS_PROTEINEER_spII = 1000732,

    /// PROTEINEER-LC: Bruker PROTEINEER-LC software.
    MS_PROTEINEER_LC = 1000733,

    /// ProteinScape: Bruker ProteinScape software.
    MS_ProteinScape = 1000734,

    /// PureDisk: BrukerPureDisk software.
    MS_PureDisk = 1000735,

    /// QuantAnalysis: Bruker software for data analysis.
    MS_QuantAnalysis = 1000736,

    /// spControl: Bruker software for data acquisition.
    MS_spControl = 1000737,

    /// TargetAnalysis: Bruker TargetAnalysis software.
    MS_TargetAnalysis = 1000738,

    /// WARP-LC: Bruker WARP-LC software.
    MS_WARP_LC = 1000739,

    /// parameter file: Parameter file used to configure the acquisition of raw data on the instrument.
    MS_parameter_file = 1000740,

    /// Conversion to dta: Conversion to dta format.
    MS_Conversion_to_dta = 1000741,

    /// Bioworks SRF format: Thermo Finnigan SRF file format.
    MS_Bioworks_SRF_format = 1000742,

    /// TSQ Quantum Ultra AM: Thermo Scientific TSQ Quantum Ultra AM.
    MS_TSQ_Quantum_Ultra_AM = 1000743,

    /// selected ion m/z: Mass-to-charge ratio of an selected ion.
    MS_selected_ion_m_z = 1000744,

    /// retention time alignment: The correction of the spectrum scan times, as used e.g. in label-free proteomics.
    MS_retention_time_alignment = 1000745,

    /// high intensity data point removal: The removal of very high intensity data points.
    MS_high_intensity_data_point_removal = 1000746,

    /// completion time: The time that a data processing action was finished.
    MS_completion_time = 1000747,

    /// SSQ 7000: ThermoFinnigan SSQ 7000 MS.
    MS_SSQ_7000 = 1000748,

    /// TSQ 7000: ThermoFinnigan TSQ 7000 MS.
    MS_TSQ_7000 = 1000749,

    /// TSQ: ThermoFinnigan TSQ MS.
    MS_TSQ = 1000750,

    /// TSQ Quantum Ultra: Thermo Scientific TSQ Quantum Ultra.
    MS_TSQ_Quantum_Ultra = 1000751,

    /// TOPP software: TOPP (The OpenMS proteomics pipeline) software.
    MS_TOPP_software = 1000752,

    /// BaselineFilter: Removes the baseline from profile spectra using a top-hat filter.
    MS_BaselineFilter = 1000753,

    /// DBExporter: Exports data from an OpenMS database to a file.
    MS_DBExporter = 1000754,

    /// DBImporter: Imports data to an OpenMS database.
    MS_DBImporter = 1000755,

    /// FileConverter: Converts between different MS file formats.
    MS_FileConverter = 1000756,

    /// FileFilter: Extracts or manipulates portions of data from peak, feature or consensus feature files.
    MS_FileFilter = 1000757,

    /// FileMerger: Merges several MS files into one file.
    MS_FileMerger = 1000758,

    /// InternalCalibration: Applies an internal calibration.
    MS_InternalCalibration = 1000759,

    /// MapAligner: Corrects retention time distortions between maps.
    MS_MapAligner_OBSOLETE = 1000760,

    /// MapNormalizer: Normalizes peak intensities in an MS run.
    MS_MapNormalizer = 1000761,

    /// NoiseFilter: Removes noise from profile spectra by using different smoothing techniques.
    MS_NoiseFilter_OBSOLETE = 1000762,

    /// PeakPicker: Finds mass spectrometric peaks in profile mass spectra.
    MS_PeakPicker_OBSOLETE = 1000763,

    /// Resampler: Transforms an LC/MS map into a resampled map or a png image.
    MS_Resampler = 1000764,

    /// SpectraFilter: Applies a filter to peak spectra.
    MS_SpectraFilter_OBSOLETE = 1000765,

    /// TOFCalibration: Applies time of flight calibration.
    MS_TOFCalibration = 1000766,

    /// native spectrum identifier format: Describes how the native spectrum identifiers are formated.
    MS_native_spectrum_identifier_format = 1000767,

    /// nativeID format (native spectrum identifier format): Describes how the native spectrum identifiers are formated.
    MS_nativeID_format = MS_native_spectrum_identifier_format,

    /// Thermo nativeID format: Native format defined by controllerType=xsd:nonNegativeInteger controllerNumber=xsd:positiveInteger scan=xsd:positiveInteger.
    MS_Thermo_nativeID_format = 1000768,

    /// Waters nativeID format: Native format defined by function=xsd:positiveInteger process=xsd:nonNegativeInteger scan=xsd:nonNegativeInteger.
    MS_Waters_nativeID_format = 1000769,

    /// WIFF nativeID format: Native format defined by sample=xsd:nonNegativeInteger period=xsd:nonNegativeInteger cycle=xsd:nonNegativeInteger experiment=xsd:nonNegativeInteger.
    MS_WIFF_nativeID_format = 1000770,

    /// Bruker/Agilent YEP nativeID format: Native format defined by scan=xsd:nonNegativeInteger.
    MS_Bruker_Agilent_YEP_nativeID_format = 1000771,

    /// Bruker BAF nativeID format: Native format defined by scan=xsd:nonNegativeInteger.
    MS_Bruker_BAF_nativeID_format = 1000772,

    /// Bruker FID nativeID format: Native format defined by file=xsd:IDREF.
    MS_Bruker_FID_nativeID_format = 1000773,

    /// multiple peak list nativeID format: Native format defined by index=xsd:nonNegativeInteger.
    MS_multiple_peak_list_nativeID_format = 1000774,

    /// single peak list nativeID format: Native format defined by file=xsd:IDREF.
    MS_single_peak_list_nativeID_format = 1000775,

    /// scan number only nativeID format: Native format defined by scan=xsd:nonNegativeInteger.
    MS_scan_number_only_nativeID_format = 1000776,

    /// spectrum identifier nativeID format: Native format defined by spectrum=xsd:nonNegativeInteger.
    MS_spectrum_identifier_nativeID_format = 1000777,

    /// charge state calculation: A process that infers the charge state of an MSn spectrum's precursor(s) by the application of some algorithm.
    MS_charge_state_calculation = 1000778,

    /// below precursor intensity dominance charge state calculation: Infers charge state as single or ambiguously multiple by determining the fraction of intensity below the precursor m/z.
    MS_below_precursor_intensity_dominance_charge_state_calculation = 1000779,

    /// precursor recalculation: A process that recalculates existing precursor selected ions with one or more algorithmically determined precursor selected ions.
    MS_precursor_recalculation = 1000780,

    /// msPrefix precursor recalculation: Recalculates one or more precursor selected ions by peak detection in the isolation windows of high accuracy MS precursor scans.
    MS_msPrefix_precursor_recalculation = 1000781,

    /// Savitzky-Golay smoothing: Reduces intensity spikes by applying local polynomial regression (of degree k) on a distribution (of at least k+1 equally spaced points) to determine the smoothed value for each point. It tends to preserve features of the distribution such as relative maxima, minima and width, which are usually 'flattened' by other adjacent averaging techniques.
    MS_Savitzky_Golay_smoothing = 1000782,

    /// LOWESS smoothing: Reduces intensity spikes by applying a modelling method known as locally weighted polynomial regression. At each point in the data set a low-degree polynomial is fit to a subset of the data, with explanatory variable values near the point whose response is being estimated. The polynomial is fit using weighted least squares, giving more weight to points near the point whose response is being estimated and less weight to points further away. The value of the regression function for the point is then obtained by evaluating the local polynomial using the explanatory variable values for that data point. The LOESS fit is complete after regression function values have been computed for each of the n data points. Many of the details of this method, such as the degree of the polynomial model and the weights, are flexible.
    MS_LOWESS_smoothing = 1000783,

    /// Gaussian smoothing: Reduces intensity spikes by convolving the data with a one-dimensional Gaussian function.
    MS_Gaussian_smoothing = 1000784,

    /// binomial smoothing (Gaussian smoothing): Reduces intensity spikes by convolving the data with a one-dimensional Gaussian function.
    MS_binomial_smoothing = MS_Gaussian_smoothing,

    /// Weierstrass transform (Gaussian smoothing): Reduces intensity spikes by convolving the data with a one-dimensional Gaussian function.
    MS_Weierstrass_transform = MS_Gaussian_smoothing,

    /// moving average smoothing: Reduces intensity spikes by averaging each point with two or more adjacent points. The more adjacent points that used, the stronger the smoothing effect.
    MS_moving_average_smoothing = 1000785,

    /// box smoothing (moving average smoothing): Reduces intensity spikes by averaging each point with two or more adjacent points. The more adjacent points that used, the stronger the smoothing effect.
    MS_box_smoothing = MS_moving_average_smoothing,

    /// boxcar smoothing (moving average smoothing): Reduces intensity spikes by averaging each point with two or more adjacent points. The more adjacent points that used, the stronger the smoothing effect.
    MS_boxcar_smoothing = MS_moving_average_smoothing,

    /// sliding average smoothing (moving average smoothing): Reduces intensity spikes by averaging each point with two or more adjacent points. The more adjacent points that used, the stronger the smoothing effect.
    MS_sliding_average_smoothing = MS_moving_average_smoothing,

    /// non-standard data array: A data array that contains data not covered by any other term in this group. Please do not use this term, if the binary data array type might be commonly used - contact the PSI-MS working group in order to have another CV term added.
    MS_non_standard_data_array = 1000786,

    /// inclusive low intensity threshold: Threshold at or below which some action is taken.
    MS_inclusive_low_intensity_threshold = 1000787,

    /// inclusive high intensity threshold: Threshold at or above which some action is taken.
    MS_inclusive_high_intensity_threshold = 1000788,

    /// enhanced multiply charged spectrum: MS1 spectrum that is enriched in multiply-charged ions compared to singly-charged ions.
    MS_enhanced_multiply_charged_spectrum = 1000789,

    /// time-delayed fragmentation spectrum: MSn spectrum in which the product ions are collected after a time delay, which allows the observation of lower energy fragmentation processes after precursor ion activation.
    MS_time_delayed_fragmentation_spectrum = 1000790,

    /// enhanced resolution scan: Scan with enhanced resolution.
    MS_enhanced_resolution_scan_OBSOLETE = 1000791,

    /// isolation window attribute: Isolation window parameter.
    MS_isolation_window_attribute = 1000792,

    /// isolation window upper limit: The highest m/z being isolated in an isolation window.
    MS_isolation_window_upper_limit_OBSOLETE = 1000793,

    /// isolation window lower limit: The lowest m/z being isolated in an isolation window.
    MS_isolation_window_lower_limit_OBSOLETE = 1000794,

    /// no combination: Use this term if only one scan was recorded or there is no information about scans available.
    MS_no_combination = 1000795,

    /// spectrum title: A free-form text title describing a spectrum.
    MS_spectrum_title = 1000796,

    /// peak list scans: A list of scan numbers and or scan ranges associated with a peak list. If possible the list of scans should be converted to native spectrum identifiers instead of using this term.
    MS_peak_list_scans = 1000797,

    /// peak list raw scans: A list of raw scans and or scan ranges used to generate a peak list. If possible the list of scans should be converted to native spectrum identifiers instead of using this term.
    MS_peak_list_raw_scans = 1000798,

    /// custom unreleased software tool: A software tool that has not yet been released. The value should describe the software. Please do not use this term for publicly available software - contact the PSI-MS working group in order to have another CV term added.
    MS_custom_unreleased_software_tool = 1000799,

    /// mass resolving power: The observed mass divided by the difference between two masses that can be separated: m/dm. The procedure by which dm was obtained and the mass at which the measurement was made should be reported.
    MS_mass_resolving_power = 1000800,

    /// area peak picking: Spectral peak processing conducted on the acquired data to convert profile data to centroided data. The area defined by all raw data points that belong to the peak is reported.
    MS_area_peak_picking = 1000801,

    /// sum peak picking (area peak picking): Spectral peak processing conducted on the acquired data to convert profile data to centroided data. The area defined by all raw data points that belong to the peak is reported.
    MS_sum_peak_picking = MS_area_peak_picking,

    /// height peak picking: Spectral peak processing conducted on the acquired data to convert profile data to centroided data. The maximum intensity of all raw data points that belong to the peak is reported.
    MS_height_peak_picking = 1000802,

    /// max peak picking (height peak picking): Spectral peak processing conducted on the acquired data to convert profile data to centroided data. The maximum intensity of all raw data points that belong to the peak is reported.
    MS_max_peak_picking = MS_height_peak_picking,

    /// analyzer scan offset: Offset between two analyzers in a constant neutral loss or neutral gain scan. The value corresponds to the neutral loss or neutral gain value.
    MS_analyzer_scan_offset = 1000803,

    /// electromagnetic radiation spectrum: A plot of the relative intensity of electromagnetic radiation as a function of the wavelength.
    MS_electromagnetic_radiation_spectrum = 1000804,

    /// EMR spectrum (electromagnetic radiation spectrum): A plot of the relative intensity of electromagnetic radiation as a function of the wavelength.
    MS_EMR_spectrum = MS_electromagnetic_radiation_spectrum,

    /// emission spectrum: A plot of the relative intensity of electromagnetic radiation emitted by atoms or molecules when excited.
    MS_emission_spectrum = 1000805,

    /// absorption spectrum: A plot of the relative intensity of electromagnetic radiation absorbed by atoms or molecules when excited.
    MS_absorption_spectrum = 1000806,

    /// Th/s: Unit describing the scan rate of a spectrum in Thomson per second.
    MS_Th_s = 1000807,

    /// chromatogram attribute: Chromatogram properties that are associated with a value.
    MS_chromatogram_attribute = 1000808,

    /// chromatogram title: A free-form text title describing a chromatogram.
    MS_chromatogram_title = 1000809,

    /// mass chromatogram: A plot of the relative abundance of a beam or other collection of ions as a function of the retention time.
    MS_mass_chromatogram = 1000810,

    /// electromagnetic radiation chromatogram: The measurement of electromagnetic properties as a function of the retention time.
    MS_electromagnetic_radiation_chromatogram = 1000811,

    /// EMR radiation chromatogram (electromagnetic radiation chromatogram): The measurement of electromagnetic properties as a function of the retention time.
    MS_EMR_radiation_chromatogram = MS_electromagnetic_radiation_chromatogram,

    /// absorption chromatogram: The measurement of light absorbed by the sample as a function of the retention time.
    MS_absorption_chromatogram = 1000812,

    /// emission chromatogram: The measurement of light emitted by the sample as a function of the retention time.
    MS_emission_chromatogram = 1000813,

    /// counts per second: The number of counted events observed per second in one or a group of elements of a detector.
    MS_counts_per_second = 1000814,

    /// Bruker BAF format: Bruker BAF raw file format.
    MS_Bruker_BAF_format = 1000815,

    /// Bruker U2 format: Bruker HyStar U2 file format.
    MS_Bruker_U2_format = 1000816,

    /// HyStar: Bruker software for hyphenated experiments.
    MS_HyStar = 1000817,

    /// Acquity UPLC PDA: Acquity UPLC Photodiode Array Detector.
    MS_Acquity_UPLC_PDA = 1000818,

    /// Acquity UPLC FLR: Acquity UPLC Fluorescence Detector.
    MS_Acquity_UPLC_FLR = 1000819,

    /// flow rate array: A data array of flow rate measurements.
    MS_flow_rate_array = 1000820,

    /// pressure array: A data array of pressure measurements.
    MS_pressure_array = 1000821,

    /// temperature array: A data array of temperature measurements.
    MS_temperature_array = 1000822,

    /// Bruker U2 nativeID format: Native format defined by declaration=xsd:nonNegativeInteger collection=xsd:nonNegativeInteger scan=xsd:nonNegativeInteger.
    MS_Bruker_U2_nativeID_format = 1000823,

    /// no nativeID format: No nativeID format indicates that the file tagged with this term does not contain spectra that can have a nativeID format.
    MS_no_nativeID_format = 1000824,

    /// Bruker FID format: Bruker FID file format.
    MS_Bruker_FID_format = 1000825,

    /// elution time: The time of elution from all used chromatographic columns (one or more) in the chromatographic separation step, relative to the start of the chromatography.
    MS_elution_time = 1000826,

    /// isolation window target m/z: The primary or reference m/z about which the isolation window is defined.
    MS_isolation_window_target_m_z = 1000827,

    /// isolation window lower offset: The extent of the isolation window in m/z below the isolation window target m/z. The lower and upper offsets may be asymmetric about the target m/z.
    MS_isolation_window_lower_offset = 1000828,

    /// isolation window upper offset: The extent of the isolation window in m/z above the isolation window target m/z. The lower and upper offsets may be asymmetric about the target m/z.
    MS_isolation_window_upper_offset = 1000829,

    /// sample preparation: Properties of the preparation steps which took place before the measurement was performed.
    MS_sample_preparation = 1000831,

    /// MALDI matrix application: Attributes to describe the technique how the sample is prepared with the matrix solution.
    MS_MALDI_matrix_application = 1000832,

    /// matrix application type: Describes the technique how the matrix is put on the sample target.
    MS_matrix_application_type = 1000833,

    /// matrix solution: Describes the chemical solution used as matrix.
    MS_matrix_solution = 1000834,

    /// matrix solution concentration: Concentration of the chemical solution used as matrix.
    MS_matrix_solution_concentration = 1000835,

    /// dried droplet MALDI matrix preparation: Dried droplet in MALDI matrix preparation.
    MS_dried_droplet_MALDI_matrix_preparation = 1000836,

    /// printed MALDI matrix preparation: Printed MALDI matrix preparation.
    MS_printed_MALDI_matrix_preparation = 1000837,

    /// sprayed MALDI matrix preparation: Sprayed MALDI matrix preparation.
    MS_sprayed_MALDI_matrix_preparation = 1000838,

    /// precoated MALDI sample plate: Precoated MALDI sample plate.
    MS_precoated_MALDI_sample_plate = 1000839,

    /// laser: Device that emits light (electromagnetic radiation) through a process called stimulated emission. The term is an acronym for Light Amplification by Stimulated Emission of Radiation.
    MS_laser = 1000840,

    /// laser attribute: Laser properties that are associated with a value.
    MS_laser_attribute = 1000841,

    /// laser type: Type of laser used used for desorption purpose.
    MS_laser_type = 1000842,

    /// wavelength: The distance between two peaks of the emitted laser beam.
    MS_wavelength_OBSOLETE = 1000843,

    /// focus diameter x: Describes the diameter of the laser beam in x direction.
    MS_focus_diameter_x = 1000844,

    /// focus diameter y: Describes the diameter of the laser beam in y direction.
    MS_focus_diameter_y = 1000845,

    /// pulse energy: Describes output energy of the laser system. May be attenuated by filters or other means.
    MS_pulse_energy = 1000846,

    /// pulse duration: Describes how long the laser beam was emitted from the laser device.
    MS_pulse_duration = 1000847,

    /// attenuation: Describes the reduction of the intensity of the laser beam energy.
    MS_attenuation = 1000848,

    /// impact angle: Describes the angle between the laser beam and the sample target.
    MS_impact_angle = 1000849,

    /// gas laser: Laser which is powered by a gaseous medium.
    MS_gas_laser = 1000850,

    /// solid-state laser: Solid state laser materials are commonly made by doping a crystalline solid host with ions that provide the required energy states.
    MS_solid_state_laser = 1000851,

    /// dye-laser: Dye lasers use an organic dye as the gain medium.
    MS_dye_laser = 1000852,

    /// free electron laser: Free electron laser uses a relativistic electron beam as the lasing medium which move freely through a magnetic structure, hence the term.
    MS_free_electron_laser = 1000853,

    /// LTQ XL: Thermo Scientific LTQ XL MS.
    MS_LTQ_XL = 1000854,

    /// LTQ Velos: Thermo Scientific LTQ Velos MS.
    MS_LTQ_Velos = 1000855,

    /// LTQ Velos ETD: Thermo Scientific LTQ Velos MS with ETD.
    MS_LTQ_Velos_ETD = 1000856,

    /// run attribute: Properties of the described run.
    MS_run_attribute = 1000857,

    /// fraction identifier: Identier string that describes the sample fraction. This identifier should contain the fraction number(s) or similar information.
    MS_fraction_identifier = 1000858,

    /// molecule: A molecules is a fundamental component of a chemical compound that is the smallest part of the compound that can participate in a chemical reaction.
    MS_molecule = 1000859,

    /// peptide: A compound of low molecular weight that is composed of two or more amino acids.
    MS_peptide = 1000860,

    /// chemical compound attribute: A describable property of a chemical compound.
    MS_chemical_compound_attribute = 1000861,

    /// isoelectric point: The pH of a solution at which a charged molecule does not migrate in an electric field.
    MS_isoelectric_point = 1000862,

    /// pI (isoelectric point): The pH of a solution at which a charged molecule does not migrate in an electric field.
    MS_pI = MS_isoelectric_point,

    /// predicted isoelectric point: The pH of a solution at which a charged molecule would not migrate in an electric field, as predicted by a software algorithm.
    MS_predicted_isoelectric_point = 1000863,

    /// predicted pI (predicted isoelectric point): The pH of a solution at which a charged molecule would not migrate in an electric field, as predicted by a software algorithm.
    MS_predicted_pI = MS_predicted_isoelectric_point,

    /// chemical compound formula: A combination of symbols used to express the chemical composition of a compound.
    MS_chemical_compound_formula = 1000864,

    /// empirical formula: A chemical formula which expresses the proportions of the elements present in a substance.
    MS_empirical_formula = 1000865,

    /// molecular formula: A chemical compound formula expressing the number of atoms of each element present in a compound, without indicating how they are linked.
    MS_molecular_formula = 1000866,

    /// structural formula: A chemical formula showing the number of atoms of each element in a molecule, their spatial arrangement, and their linkage to each other.
    MS_structural_formula = 1000867,

    /// SMILES string: The simplified molecular input line entry specification or SMILES is a specification for unambiguously describing the structure of a chemical compound using a short ASCII string.
    MS_SMILES_string = 1000868,

    /// collision gas pressure: The gas pressure of the collision gas used for collisional excitation.
    MS_collision_gas_pressure = 1000869,

    /// 4000 QTRAP: AB SCIEX or Applied Biosystems|MDS SCIEX QTRAP 4000.
    MS_4000_QTRAP_OBSOLETE = 1000870,

    /// SRM software: Software used to predict, select, or optimize transitions or analyze the results of selected reaction monitoring runs.
    MS_SRM_software = 1000871,

    /// MaRiMba: Software used to predict transitions for selected reaction monitoring experiments based on observed spectrum libraries developed and distributed by the Institute for Systems Biology.
    MS_MaRiMba = 1000872,

    /// peptide attribute calculation software: Software used to predict or calculate numerical attributes of peptides.
    MS_peptide_attribute_calculation_software = 1000873,

    /// SSRCalc: Sequence Specific Retention Calculator estimates the retention time of peptides based on their sequence.
    MS_SSRCalc = 1000874,

    /// declustering potential: Potential difference between the orifice and the skimmer in volts.
    MS_declustering_potential = 1000875,

    /// cone voltage: Potential difference between the sampling cone/orifice in volts.
    MS_cone_voltage = 1000876,

    /// tube lens voltage: Potential difference setting of the tube lens in volts.
    MS_tube_lens_voltage = 1000877,

    /// external reference identifier: An identifier/accession number to an external reference database.
    MS_external_reference_identifier = 1000878,

    /// PubMed identifier: A unique identifier for a publication in the PubMed database (MIR:00000015).
    MS_PubMed_identifier = 1000879,

    /// interchannel delay: The duration of intervals between scanning, during which the instrument configuration is switched.
    MS_interchannel_delay = 1000880,

    /// chemical compound: A substance formed by chemical union of two or more elements or ingredients in definite proportion by weight.
    MS_chemical_compound = 1000881,

    /// protein: A compound composed of one or more chains of amino acids in a specific order determined by the base sequence of nucleotides in the DNA coding for the protein.
    MS_protein = 1000882,

    /// protein short name: A short name or symbol of a protein (e.g., HSF 1 or HSF1_HUMAN).
    MS_protein_short_name = 1000883,

    /// protein attribute: An nonphysical attribute describing a specific protein.
    MS_protein_attribute = 1000884,

    /// protein accession: Accession number for a specific protein in a database.
    MS_protein_accession = 1000885,

    /// protein name: A long name describing the function of the protein.
    MS_protein_name = 1000886,

    /// peptide attribute: A nonphysical attribute that can be used to describe a peptide.
    MS_peptide_attribute = 1000887,

    /// unmodified peptide sequence: A sequence of letter symbols denoting the order of amino acids that compose the peptide, without encoding any amino acid mass modifications that might be present.
    MS_unmodified_peptide_sequence = 1000888,

    /// modified peptide sequence: A sequence of letter symbols denoting the order of amino acids that compose the peptide plus the encoding any amino acid modifications that are present.
    MS_modified_peptide_sequence = 1000889,

    /// peptide labeling state: A state description of how a peptide might be isotopically or isobarically labelled.
    MS_peptide_labeling_state = 1000890,

    /// heavy labeled peptide: A peptide that has been created or labelled with some heavier-than-usual isotopes.
    MS_heavy_labeled_peptide = 1000891,

    /// unlabeled peptide: A peptide that has not been labelled with heavier-than-usual isotopes. This is often referred to as \"light\" to distinguish from \"heavy\".
    MS_unlabeled_peptide = 1000892,

    /// light labeled peptide (unlabeled peptide): A peptide that has not been labelled with heavier-than-usual isotopes. This is often referred to as \"light\" to distinguish from \"heavy\".
    MS_light_labeled_peptide = MS_unlabeled_peptide,

    /// peptide group label: An arbitrary string label used to mark a set of peptides that belong together in a set, whereby the members are differentiated by different isotopic labels. For example, the heavy and light forms of the same peptide will both be assigned the same peptide group label.
    MS_peptide_group_label = 1000893,

    /// retention time: A time interval from the start of chromatography when an analyte exits a chromatographic column.
    MS_retention_time = 1000894,

    /// local retention time: A time interval from the start of chromatography when an analyte exits an unspecified local chromatographic column and instrumental setup.
    MS_local_retention_time = 1000895,

    /// normalized retention time: A time interval from the start of chromatography when an analyte exits a standardized reference chromatographic column and instrumental setup.
    MS_normalized_retention_time = 1000896,

    /// predicted retention time: A time interval from the start of chromatography when an analyte exits a chromatographic column as predicted by a referenced software application.
    MS_predicted_retention_time = 1000897,

    /// standard: Something, such as a practice or a product, that is widely recognized or employed, especially because of its excellence.
    MS_standard = 1000898,

    /// de facto standard: A practice or product that has become a standard not because it has been approved by a standards organization but because it is widely used and recognized by the industry as being standard.
    MS_de_facto_standard = 1000899,

    /// minimum information standard: A specification of a minimum amount of information needed to reproduce or fully interpret a scientific result.
    MS_minimum_information_standard = 1000900,

    /// retention time normalization standard: A standard providing the retention times at which a set of reference compounds exit the reference chromatographic column.
    MS_retention_time_normalization_standard = 1000901,

    /// H-PINS retention time normalization standard: The de facto standard providing the retention times at which a set of halogenated reference peptides exit the reference chromatographic column.
    MS_H_PINS_retention_time_normalization_standard = 1000902,

    /// product ion series ordinal: The ordinal of the fragment within a specified ion series. (e.g. 8 for a y8 ion).
    MS_product_ion_series_ordinal = 1000903,

    /// product ion m/z delta: The difference in m/z of the predicted m/z based on the assigned product ion minus the actual observed peak m/z.
    MS_product_ion_m_z_delta = 1000904,

    /// percent of base peak times 100: The magnitude of a peak expressed in terms of the percentage of the magnitude of the base peak intensity multiplied by 100. The base peak is therefore 10000. This unit is common in normalized spectrum libraries.
    MS_percent_of_base_peak_times_100 = 1000905,

    /// peak intensity rank: Ordinal specifying the rank in intensity of a peak in a spectrum. Base peak is 1. The next most intense peak is 2, etc.
    MS_peak_intensity_rank = 1000906,

    /// peak targeting suitability rank: Ordinal specifying the rank of a peak in a spectrum in terms of suitability for targeting. The most suitable peak is 1. The next most suitability peak is 2, etc. Suitability is algorithm and context dependant.
    MS_peak_targeting_suitability_rank = 1000907,

    /// transition: A set of two m/z values corresponding to the precursor m/z and a fragment m/z that in combination can be used to identify or quantify a specific ion, although not necessarily uniquely.
    MS_transition = 1000908,

    /// reaction (transition): A set of two m/z values corresponding to the precursor m/z and a fragment m/z that in combination can be used to identify or quantify a specific ion, although not necessarily uniquely.
    MS_reaction = MS_transition,

    /// transition validation method: The strategy used to validate that a transition is effective.
    MS_transition_validation_method = 1000909,

    /// transition optimized on specified instrument: The transition has been optimized by direct injection of the peptide into an instrument specified in a separate term, and the optimum voltages and fragmentation energies have been determined.
    MS_transition_optimized_on_specified_instrument = 1000910,

    /// transition validated with an MS/MS spectrum on specified instrument: The transition has been validated by obtaining an MS/MS spectrum and demonstrating that the peak is detectable on the instrument specified with a separate term.
    MS_transition_validated_with_an_MS_MS_spectrum_on_specified_instrument = 1000911,

    /// transition purported from an MS/MS spectrum on a different, specified instrument: The transition has been purported by obtaining an MS/MS spectrum and demonstrating that the peak is detectable on the instrument specified with a separate term. However, the detecting instrument is of a different type (e.g. ion trap) than the instrument that the transition will eventually be used on (e.g. triple quad).
    MS_transition_purported_from_an_MS_MS_spectrum_on_a_different__specified_instrument = 1000912,

    /// transition predicted by informatic analysis: The transition has been predicted by informatics software without any direct spectral evidence.
    MS_transition_predicted_by_informatic_analysis = 1000913,

    /// tab delimited text format: A file format that has two or more columns of tabular data where each column is separated by a TAB character.
    MS_tab_delimited_text_format = 1000914,

    /// retention time window attribute: An attribute of a window in time about which a peptide might elute from the column.
    MS_retention_time_window_attribute = 1000915,

    /// retention time window lower offset: The extent of the retention time window in time units below the target retention time. The lower and upper offsets may be asymmetric about the target time.
    MS_retention_time_window_lower_offset = 1000916,

    /// retention time window upper offset: The extent of the retention time window in time units above the target retention time. The lower and upper offsets may be asymmetric about the target time.
    MS_retention_time_window_upper_offset = 1000917,

    /// target list: A list of peptides or compounds and their expected m/z coordinates that can be used to cause a mass spectrometry to obtain spectra of those molecules specifically.
    MS_target_list = 1000918,

    /// target inclusion exclusion priority: A priority setting specifying whether included or excluded targets have priority over the other.
    MS_target_inclusion_exclusion_priority = 1000919,

    /// includes supersede excludes: A priority setting specifying that included targets have priority over the excluded targets if there is a conflict.
    MS_includes_supersede_excludes = 1000920,

    /// excludes supersede includes: A priority setting specifying that excluded targets have priority over the included targets if there is a conflict.
    MS_excludes_supersede_includes = 1000921,

    /// Skyline: Software used to predict, select, and optimize transitions as well as analyze the results of selected reaction monitoring runs developed and distributed by the MacCoss lab at the University of Washington.
    MS_Skyline = 1000922,

    /// TIQAM: Software used to predict, select, and optimize transitions for selected reaction monitoring experiments developed and distributed by the Institute for Systems Biology.
    MS_TIQAM = 1000923,

    /// MaRiMba: Software used to predict transitions for selected reaction monitoring experiments based on observed spectrum libraries developed and distributed by the Institute for Systems Biology.
    MS_MaRiMba_OBSOLETE = 1000924,

    /// ATAQS: Software suite used to predict, select, and optimize transitions as well as analyze the results of selected reaction monitoring runs developed and distributed by the Institute for Systems Biology.
    MS_ATAQS = 1000925,

    /// product interpretation rank: The integer rank given an interpretation of an observed product ion. For example, if y8 is selected as the most likely interpretation of a peak, then it is assigned a rank of 1.
    MS_product_interpretation_rank = 1000926,

    /// ion injection time: The length of time spent filling an ion trapping device.
    MS_ion_injection_time = 1000927,

    /// calibration spectrum: A spectrum derived from a special calibration source, rather than from the primary injected sample. A calibration spectrum is typically derived from a substance that can be used to correct systematic shift in m/z for spectra of the primary inject sample.
    MS_calibration_spectrum = 1000928,

    /// Shimadzu Biotech nativeID format: Native format defined by source=xsd:string start=xsd:nonNegativeInteger end=xsd:nonNegativeInteger.
    MS_Shimadzu_Biotech_nativeID_format = 1000929,

    /// Shimadzu Biotech database entity: Shimadzu Biotech format.
    MS_Shimadzu_Biotech_database_entity = 1000930,

    /// QTRAP 5500: Applied Biosystems|MDS SCIEX QTRAP 5500.
    MS_QTRAP_5500 = 1000931,

    /// TripleTOF 5600: AB SCIEX TripleTOF 5600, a quadrupole - quadrupole - time-of-flight mass spectrometer.
    MS_TripleTOF_5600 = 1000932,

    /// protein modifications: Encoding of modifications of the protein sequence from the specified accession, written in PEFF notation.
    MS_protein_modifications = 1000933,

    /// gene name: Name of the gene from which the protein is translated.
    MS_gene_name = 1000934,

    /// spectrum interpretation: Collection of terms from the PSI Proteome Informatics standards describing the interpretation of spectra.
    MS_spectrum_interpretation = 1001000,

    /// SEQUEST:CleavesAt: 
    MS_SEQUEST_CleavesAt = 1001005,

    /// SEQUEST:ViewCV: SEQUEST View Input Parameters.
    MS_SEQUEST_ViewCV = 1001006,

    /// SEQUEST:OutputLines: Number of peptide results to show.
    MS_SEQUEST_OutputLines = 1001007,

    /// SEQUEST:DescriptionLines: Number of full protein descriptions to show for top N peptides.
    MS_SEQUEST_DescriptionLines = 1001009,

    /// de novo search: A de novo sequencing search (without database).
    MS_de_novo_search = 1001010,

    /// search database details: Details about the database searched.
    MS_search_database_details = 1001011,

    /// database source: The organisation, project or laboratory from where the database is obtained (UniProt, NCBI, EBI, other).
    MS_database_source = 1001012,

    /// database name: The name of the search database (nr, SwissProt or est_human).
    MS_database_name = 1001013,

    /// database local file path: OBSOLETE: Use attribute in mzIdentML instead. Local file path of the search database from the search engine's point of view.
    MS_database_local_file_path_OBSOLETE = 1001014,

    /// database original uri: URI, from where the search database was originally downloaded.
    MS_database_original_uri = 1001015,

    /// database version: OBSOLETE: Use attribute in mzIdentML instead. Version of the search database.
    MS_database_version_OBSOLETE = 1001016,

    /// database release date: OBSOLETE: Use attribute in mzIdentML instead. Release date of the search database.
    MS_database_release_date_OBSOLETE = 1001017,

    /// database type: Database containing amino acid or nucleic acid sequences.
    MS_database_type = 1001018,

    /// database filtering: Was there filtering used on the database.
    MS_database_filtering = 1001019,

    /// DB filter taxonomy: A taxonomy filter was to the database search.
    MS_DB_filter_taxonomy = 1001020,

    /// DB filter on accession numbers: Filtering applied specifically by accession number pattern.
    MS_DB_filter_on_accession_numbers = 1001021,

    /// DB MW filter: Filtering applied specifically by protein molecular weight, specified as either a range or above/below a threshold value.
    MS_DB_MW_filter = 1001022,

    /// DB PI filter: Filtering applied specifically by predicted protein isoelectric focussing point (pI), specified as either a range or above/below a threshold value.
    MS_DB_PI_filter = 1001023,

    /// translation frame: The translated open reading frames from a nucleotide database considered in the search (range: 1-6).
    MS_translation_frame = 1001024,

    /// translation table: The translation table used to translate the nucleotides to amino acids.
    MS_translation_table = 1001025,

    /// SEQUEST:NormalizeXCorrValues: 
    MS_SEQUEST_NormalizeXCorrValues = 1001026,

    /// DB filter on sequence pattern: Filtering applied specifically by amino acid sequence pattern.
    MS_DB_filter_on_sequence_pattern = 1001027,

    /// SEQUEST:SequenceHeaderFilter: String in the header of a sequence entry for that entry to be searched.
    MS_SEQUEST_SequenceHeaderFilter = 1001028,

    /// number of sequences searched: The number of sequences (proteins / nucleotides) from the database search after filtering.
    MS_number_of_sequences_searched = 1001029,

    /// number of peptide seqs compared to each spectrum: Number of peptide seqs compared to each spectrum.
    MS_number_of_peptide_seqs_compared_to_each_spectrum = 1001030,

    /// spectral library search: A search using a library of spectra.
    MS_spectral_library_search = 1001031,

    /// SEQUEST:SequencePartialFilter: 
    MS_SEQUEST_SequencePartialFilter = 1001032,

    /// date / time search performed: OBSOLETE: use attribute in mzIdentML instead. Date and time of the actual search run.
    MS_date___time_search_performed_OBSOLETE = 1001035,

    /// search time taken: The time taken to complete the search in seconds.
    MS_search_time_taken = 1001036,

    /// SEQUEST:ShowFragmentIons: Flag indicating that fragment ions should be shown.
    MS_SEQUEST_ShowFragmentIons = 1001037,

    /// SEQUEST:Consensus: Specify depth as value of the CVParam.
    MS_SEQUEST_Consensus = 1001038,

    /// intermediate analysis format: Type of the source file, the mzIdentML was created from.
    MS_intermediate_analysis_format = 1001040,

    /// SEQUEST:sortCV: SEQUEST View / Sort Input Parameters.
    MS_SEQUEST_sortCV = 1001041,

    /// SEQUEST:LimitTo: Specify \"number of dtas shown\" as value of the CVParam.
    MS_SEQUEST_LimitTo = 1001042,

    /// cleavage agent details: Details of cleavage agent (enzyme).
    MS_cleavage_agent_details = 1001044,

    /// cleavage agent name: The name of the cleavage agent.
    MS_cleavage_agent_name = 1001045,

    /// SEQUEST:sort by dCn: Sort order of SEQUEST search results by the delta of the normalized correlation score.
    MS_SEQUEST_sort_by_dCn = 1001046,

    /// SEQUEST:sort by dM: Sort order of SEQUEST search results by the difference between a theoretically calculated and the corresponding experimentally measured molecular mass M.
    MS_SEQUEST_sort_by_dM = 1001047,

    /// SEQUEST:sort by Ions: Sort order of SEQUEST search results given by the ions.
    MS_SEQUEST_sort_by_Ions = 1001048,

    /// SEQUEST:sort by MH+: Sort order of SEQUEST search results given by the mass of the protonated ion.
    MS_SEQUEST_sort_by_MH_ = 1001049,

    /// SEQUEST:sort by P: Sort order of SEQUEST search results given by the probability.
    MS_SEQUEST_sort_by_P = 1001050,

    /// multiple enzyme combination rules: OBSOLETE: use attribute independent in mzIdentML instead. Description of multiple enzyme digestion protocol, if any.
    MS_multiple_enzyme_combination_rules_OBSOLETE = 1001051,

    /// SEQUEST:sort by PreviousAminoAcid: Sort order of SEQUEST search results given by the previous amino acid.
    MS_SEQUEST_sort_by_PreviousAminoAcid = 1001052,

    /// SEQUEST:sort by Ref: Sort order of SEQUEST search results given by the reference.
    MS_SEQUEST_sort_by_Ref = 1001053,

    /// modification parameters: Modification parameters for the search engine run.
    MS_modification_parameters = 1001055,

    /// modification specificity rule: The specificity rules for the modifications applied by the search engine.
    MS_modification_specificity_rule = 1001056,

    /// tolerance on types: OBSOLETE: Tolerance on types.
    MS_tolerance_on_types_OBSOLETE = 1001057,

    /// quality estimation by manual validation: The quality estimation was done manually.
    MS_quality_estimation_by_manual_validation = 1001058,

    /// SEQUEST:sort by RSp: Sort order of SEQUEST search results given by the result 'Sp' of 'Rank/Sp' in the out file (peptide).
    MS_SEQUEST_sort_by_RSp = 1001059,

    /// quality estimation method details: Method for quality estimation (manually or with decoy database).
    MS_quality_estimation_method_details = 1001060,

    /// neutral loss: OBSOLETE: replaced by MS:1000336 (neutral loss): Leave this to PSI-MOD.
    MS_neutral_loss_OBSOLETE = 1001061,

    /// Mascot MGF format: Mascot MGF file format.
    MS_Mascot_MGF_format = 1001062,

    /// TODOscoring model: OBSOLETE: There is Phenyx:ScoringModel for Phenyx! Scoring model (more detailed granularity). TODO: add some child terms.
    MS_TODOscoring_model_OBSOLETE = 1001065,

    /// ions series considered in search: The description of the DEPRECATED ion fragment series (including charges and neutral losses) that are considered by the search engine.
    MS_ions_series_considered_in_search = 1001066,

    /// SEQUEST:sort by Sp: Sort order of SEQUEST search results by the Sp score.
    MS_SEQUEST_sort_by_Sp = 1001068,

    /// SEQUEST:sort by TIC: Sort order of SEQUEST search results given by the total ion current.
    MS_SEQUEST_sort_by_TIC = 1001069,

    /// SEQUEST:sort by Scan: Sort order of SEQUEST search results given by the scan number.
    MS_SEQUEST_sort_by_Scan = 1001070,

    /// SEQUEST:sort by Sequence: Sort order of SEQUEST search results given by the sequence.
    MS_SEQUEST_sort_by_Sequence = 1001071,

    /// SEQUEST:sort by Sf: Sort order of SEQUEST search results given by the SEQUEST result 'Sf'.
    MS_SEQUEST_sort_by_Sf = 1001072,

    /// database type amino acid: Database contains amino acid sequences.
    MS_database_type_amino_acid = 1001073,

    /// database type nucleotide: Database contains nucleic acid sequences.
    MS_database_type_nucleotide = 1001079,

    /// search type: Enumeration of type of search value (i.e. from PMF, sequence tag, MS-MS).
    MS_search_type = 1001080,

    /// pmf search: A peptide mass fingerprint search.
    MS_pmf_search = 1001081,

    /// tag search: A sequence tag search.
    MS_tag_search = 1001082,

    /// ms-ms search: An ms/ms search (with fragment ions).
    MS_ms_ms_search = 1001083,

    /// database nr: Non-redundant GenBank sequence database.
    MS_database_nr = 1001084,

    /// protein result details: Protein level information.
    MS_protein_result_details = 1001085,

    /// SEQUEST:sort by XCorr: Sort order of SEQUEST search results by the correlation score.
    MS_SEQUEST_sort_by_XCorr = 1001086,

    /// SEQUEST:ProcessCV: SEQUEST View / Process Input Parameters.
    MS_SEQUEST_ProcessCV = 1001087,

    /// protein description: The protein description line from the sequence entry in the source database FASTA file.
    MS_protein_description = 1001088,

    /// molecule taxonomy: The taxonomy of the resultant molecule from the search.
    MS_molecule_taxonomy = 1001089,

    /// taxonomy nomenclature: OBSOLETE: The system used to indicate taxonomy. There should be an enumerated list of options: latin name, NCBI TaxID, common name, Swiss-Prot species ID (ex. RABIT from the full protein ID ALBU_RABIT).
    MS_taxonomy_nomenclature_OBSOLETE = 1001090,

    /// NoEnzyme: 
    MS_NoEnzyme_OBSOLETE = 1001091,

    /// peptide identification confidence metric: Identification confidence metric for a peptide.
    MS_peptide_identification_confidence_metric = 1001092,

    /// sequence coverage: The percent coverage for the protein based upon the matched peptide sequences (can be calculated).
    MS_sequence_coverage = 1001093,

    /// SEQUEST:sort by z: Sort order of SEQUEST search results given by the charge.
    MS_SEQUEST_sort_by_z = 1001094,

    /// SEQUEST:ProcessAll: 
    MS_SEQUEST_ProcessAll = 1001095,

    /// SEQUEST:TopPercentMostIntense: Specify \"percentage\" as value of the CVParam.
    MS_SEQUEST_TopPercentMostIntense = 1001096,

    /// distinct peptide sequences: This counts distinct sequences hitting the protein without regard to a minimal confidence threshold.
    MS_distinct_peptide_sequences = 1001097,

    /// confident distinct peptide sequences: This counts the number of distinct peptide sequences. Multiple charge states and multiple modification states do NOT count as multiple sequences. The definition of 'confident' must be qualified elsewhere.
    MS_confident_distinct_peptide_sequences = 1001098,

    /// confident peptide qualification: The point of this entry is to define what is meant by confident for the term Confident distinct peptide sequence and/or Confident peptides. Example 1 - metric=Paragon:Confidence value=95 sense=greater than Example 2 - metric=Mascot:Eval value=0.05 sense=less than.
    MS_confident_peptide_qualification = 1001099,

    /// confident peptide sequence number: This counts the number of peptide sequences without regard to whether they are distinct. Multiple charges states and multiple modification states DO count as multiple peptides. The definition of 'confident' must be qualified elsewhere.
    MS_confident_peptide_sequence_number = 1001100,

    /// protein group or subset relationship: Protein group or subset relationships.
    MS_protein_group_or_subset_relationship = 1001101,

    /// SEQUEST:Chromatogram: 
    MS_SEQUEST_Chromatogram = 1001102,

    /// SEQUEST:InfoAndLog: 
    MS_SEQUEST_InfoAndLog = 1001103,

    /// database UniProtKB/Swiss-Prot: The name of the UniProtKB/Swiss-Prot knowledgebase.
    MS_database_UniProtKB_Swiss_Prot = 1001104,

    /// peptide result details: Peptide level information.
    MS_peptide_result_details = 1001105,

    /// SEQUEST:TopNumber: Specify \"number\" as value of the CVParam.
    MS_SEQUEST_TopNumber = 1001106,

    /// data stored in database: Source file for this mzIdentML was a data set in a database.
    MS_data_stored_in_database = 1001107,

    /// param: a ion: Parameter information, type of product: a ion with charge on the N-terminal side.
    MS_param__a_ion = 1001108,

    /// SEQUEST:CullTo: Specify cull string as value of the CVParam.
    MS_SEQUEST_CullTo = 1001109,

    /// SEQUEST:modeCV: SEQUEST Mode Input Parameters.
    MS_SEQUEST_modeCV = 1001110,

    /// SEQUEST:Full: 
    MS_SEQUEST_Full = 1001111,

    /// n-terminal flanking residue: The residue preceding the first amino acid in the peptide sequence as it occurs in the protein. Use 'N-term' to denote if the peptide starts at the N terminus of the protein.
    MS_n_terminal_flanking_residue = 1001112,

    /// c-terminal flanking residue: The residue following the last amino acid in the peptide sequence as it occurs in the protein. Use 'C-term' to denote if the peptide ends at the C terminus of the protein.
    MS_c_terminal_flanking_residue = 1001113,

    /// retention time(s): Retention time of the spectrum from the source file.
    MS_retention_time_s__OBSOLETE = 1001114,

    /// scan number(s): OBSOLETE: use spectrumID attribute of SpectrumIdentificationResult. Take from mzData.
    MS_scan_number_s__OBSOLETE = 1001115,

    /// single protein result details: Results specific for one protein as part of a protein ambiguity group (a result not valid for all the other proteins in the protein ambiguity group).
    MS_single_protein_result_details = 1001116,

    /// theoretical mass: The theoretical mass of the molecule (e.g. the peptide sequence and its modifications).
    MS_theoretical_mass = 1001117,

    /// param: b ion: Parameter information, type of product: b ion with charge on the N-terminal side.
    MS_param__b_ion = 1001118,

    /// param: c ion: Parameter information, type of product: c ion with charge on the N-terminal side.
    MS_param__c_ion = 1001119,

    /// SEQUEST:FormatAndLinks: 
    MS_SEQUEST_FormatAndLinks = 1001120,

    /// number of matched peaks: The number of peaks that were matched as qualified by the ion series considered field. If a peak matches multiple ions then only 1 would be added the count.
    MS_number_of_matched_peaks = 1001121,

    /// ions series considered: The ion series that were used during the calculation of the count (e.g. a, b, c, d, v, w, x, y, z, a-H2O, a-NH3, b-H2O, b-NH3, y-H2O, y-NH3, b-H20, b+, z-, z+1, z+2, b-H3PO4, y-H3PO4, immonium, internal ya, internal yb).
    MS_ions_series_considered = 1001122,

    /// number of peaks used: The number of peaks from the original peak list that are used to calculate the scores for a particular search engine. All ions that have the opportunity to match or be counted even if they don't.
    MS_number_of_peaks_used = 1001123,

    /// number of peaks submitted: The number of peaks from the original peaks listed that were submitted to the search engine.
    MS_number_of_peaks_submitted = 1001124,

    /// manual validation: Result of quality estimation: decision of a manual validation.
    MS_manual_validation = 1001125,

    /// SEQUEST:Fast: 
    MS_SEQUEST_Fast = 1001126,

    /// peptide sharing details: Accessions Containing Sequence - Accessions for each protein containing this peptide.
    MS_peptide_sharing_details = 1001127,

    /// SEQUEST:selectCV: SEQUEST Select Input Parameters.
    MS_SEQUEST_selectCV = 1001128,

    /// quantification information: Quantification information.
    MS_quantification_information = 1001129,

    /// peptide raw area: Peptide raw area.
    MS_peptide_raw_area_OBSOLETE = 1001130,

    /// error on peptide area: Error on peptide area.
    MS_error_on_peptide_area = 1001131,

    /// peptide ratio: Peptide ratio.
    MS_peptide_ratio = 1001132,

    /// error on peptide ratio: Error on peptide ratio.
    MS_error_on_peptide_ratio = 1001133,

    /// protein ratio: Protein ratio.
    MS_protein_ratio = 1001134,

    /// error on protein ratio: Error on protein ratio.
    MS_error_on_protein_ratio = 1001135,

    /// p-value (protein diff from 1 randomly): P-value (protein diff from 1 randomly).
    MS_p_value__protein_diff_from_1_randomly__OBSOLETE = 1001136,

    /// absolute quantity: Absolute quantity in terms of real concentration or molecule copy number in sample.
    MS_absolute_quantity = 1001137,

    /// error on absolute quantity: Error on absolute quantity.
    MS_error_on_absolute_quantity = 1001138,

    /// quantitation software name: Quantitation software name.
    MS_quantitation_software_name = 1001139,

    /// quantitation software version: Quantitation software version.
    MS_quantitation_software_version_OBSOLETE = 1001140,

    /// intensity of precursor ion: The intensity of the precursor ion.
    MS_intensity_of_precursor_ion = 1001141,

    /// database IPI_human: International Protein Index database for Homo sapiens sequences.
    MS_database_IPI_human = 1001142,

    /// search engine specific score for PSMs: Search engine specific peptide spectrum match scores.
    MS_search_engine_specific_score_for_PSMs = 1001143,

    /// SEQUEST:SelectDefault: 
    MS_SEQUEST_SelectDefault = 1001144,

    /// SEQUEST:SelectAdvancedCV: SEQUEST Select Advanced Input Parameters.
    MS_SEQUEST_SelectAdvancedCV = 1001145,

    /// param: a ion-NH3 DEPRECATED: Ion a-NH3 parameter information, type of product: a ion with lost ammonia.
    MS_param__a_ion_NH3_DEPRECATED = 1001146,

    /// protein ambiguity group result details: 
    MS_protein_ambiguity_group_result_details = 1001147,

    /// param: a ion-H2O DEPRECATED: Ion a-H2O if a significant and fragment includes STED.
    MS_param__a_ion_H2O_DEPRECATED = 1001148,

    /// param: b ion-NH3 DEPRECATED: Ion b-NH3 parameter information, type of product: b ion with lost ammonia.
    MS_param__b_ion_NH3_DEPRECATED = 1001149,

    /// param: b ion-H2O DEPRECATED: Ion b-H2O if b significant and fragment includes STED.
    MS_param__b_ion_H2O_DEPRECATED = 1001150,

    /// param: y ion-NH3 DEPRECATED: Ion y-NH3 parameter information, type of product: y ion with lost ammonia.
    MS_param__y_ion_NH3_DEPRECATED = 1001151,

    /// param: y ion-H2O DEPRECATED: 
    MS_param__y_ion_H2O_DEPRECATED = 1001152,

    /// search engine specific score: Search engine specific scores.
    MS_search_engine_specific_score = 1001153,

    /// SEQUEST:probability: The SEQUEST result 'Probability'.
    MS_SEQUEST_probability = 1001154,

    /// SEQUEST:xcorr: The SEQUEST result 'XCorr'.
    MS_SEQUEST_xcorr = 1001155,

    /// SEQUEST:deltacn: The SEQUEST result 'DeltaCn'.
    MS_SEQUEST_deltacn = 1001156,

    /// SEQUEST:sp: The SEQUEST result 'Sp' (protein).
    MS_SEQUEST_sp = 1001157,

    /// SEQUEST:Uniq: 
    MS_SEQUEST_Uniq = 1001158,

    /// SEQUEST:expectation value: The SEQUEST result 'Expectation value'.
    MS_SEQUEST_expectation_value = 1001159,

    /// SEQUEST:sf: The SEQUEST result 'Sf'.
    MS_SEQUEST_sf = 1001160,

    /// SEQUEST:matched ions: The SEQUEST result 'Matched Ions'.
    MS_SEQUEST_matched_ions = 1001161,

    /// SEQUEST:total ions: The SEQUEST result 'Total Ions'.
    MS_SEQUEST_total_ions = 1001162,

    /// SEQUEST:consensus score: The SEQUEST result 'Consensus Score'.
    MS_SEQUEST_consensus_score = 1001163,

    /// Paragon:unused protscore: The Paragon result 'Unused ProtScore'.
    MS_Paragon_unused_protscore = 1001164,

    /// Paragon:total protscore: The Paragon result 'Total ProtScore'.
    MS_Paragon_total_protscore = 1001165,

    /// Paragon:score: The Paragon result 'Score'.
    MS_Paragon_score = 1001166,

    /// Paragon:confidence: The Paragon result 'Confidence'.
    MS_Paragon_confidence = 1001167,

    /// Paragon:expression error factor: The Paragon result 'Expression Error Factor'.
    MS_Paragon_expression_error_factor = 1001168,

    /// Paragon:expression change p-value: The Paragon result 'Expression change P-value'.
    MS_Paragon_expression_change_p_value = 1001169,

    /// Paragon:contrib: The Paragon result 'Contrib'.
    MS_Paragon_contrib = 1001170,

    /// Mascot:score: The Mascot result 'Score'.
    MS_Mascot_score = 1001171,

    /// Mascot:expectation value: The Mascot result 'expectation value'.
    MS_Mascot_expectation_value = 1001172,

    /// Mascot:matched ions: The Mascot result 'Matched ions'.
    MS_Mascot_matched_ions = 1001173,

    /// Mascot:total ions: The Mascot result 'Total ions'.
    MS_Mascot_total_ions = 1001174,

    /// peptide shared in multiple proteins: A peptide matching multiple proteins.
    MS_peptide_shared_in_multiple_proteins = 1001175,

    /// (?<=[KR])(?!P): Regular expression for Trypsin.
    MS______KR_____P_ = 1001176,

    /// number of molecular hypothesis considered: Number of Molecular Hypothesis Considered - This is the number of molecules (e.g. peptides for proteomics) considered for a particular search.
    MS_number_of_molecular_hypothesis_considered = 1001177,

    /// database EST: Expressed sequence tag nucleotide sequence database.
    MS_database_EST = 1001178,

    /// Cleavage agent regular expression: Regular expressions for cleavage enzymes.
    MS_Cleavage_agent_regular_expression = 1001180,

    /// search statistics: The details of the actual run of the search.
    MS_search_statistics = 1001184,

    /// modification specificity peptide N-term: As parameter for search engine: apply the modification only at the N-terminus of a peptide.
    MS_modification_specificity_peptide_N_term = 1001189,

    /// modification specificity peptide C-term: As parameter for search engine: apply the modification only at the C-terminus of a peptide.
    MS_modification_specificity_peptide_C_term = 1001190,

    /// p-value: Quality estimation by p-value.
    MS_p_value_OBSOLETE = 1001191,

    /// Expect value: Result of quality estimation: Expect value.
    MS_Expect_value = 1001192,

    /// confidence score: Result of quality estimation: confidence score.
    MS_confidence_score = 1001193,

    /// quality estimation with decoy database: Quality estimation by decoy database.
    MS_quality_estimation_with_decoy_database = 1001194,

    /// decoy DB type reverse: Decoy type: Amino acids of protein sequences are used in reverse order.
    MS_decoy_DB_type_reverse = 1001195,

    /// decoy DB type randomized: Decoy type: Amino acids of protein sequences are randomized (keeping the original protein mass).
    MS_decoy_DB_type_randomized = 1001196,

    /// DB composition target+decoy: Decoy database composition: database contains original (target) and decoy entries.
    MS_DB_composition_target_decoy = 1001197,

    /// protein identification confidence metric: Identification confidence metric for a protein.
    MS_protein_identification_confidence_metric = 1001198,

    /// Mascot DAT format: Source file for this mzIdentML was in Mascot DAT file format.
    MS_Mascot_DAT_format = 1001199,

    /// SEQUEST out file format: Source file for this mzIdentML was in SEQUEST out file format.
    MS_SEQUEST_out_file_format = 1001200,

    /// DB MW filter maximum: Maximum value of molecular weight filter.
    MS_DB_MW_filter_maximum = 1001201,

    /// DB MW filter minimum: Minimum value of molecular weight filter.
    MS_DB_MW_filter_minimum = 1001202,

    /// DB PI filter maximum: Maximum value of isoelectric point filter.
    MS_DB_PI_filter_maximum = 1001203,

    /// DB PI filter minimum: Minimum value of isoelectric point filter.
    MS_DB_PI_filter_minimum = 1001204,

    /// Mascot: The name of the Mascot search engine.
    MS_Mascot = 1001207,

    /// SEQUEST: The name of the SEQUEST search engine.
    MS_SEQUEST = 1001208,

    /// Phenyx: The name of the Phenyx search engine.
    MS_Phenyx = 1001209,

    /// mass type settings: The type of mass difference value to be considered by the search engine (monoisotopic or average).
    MS_mass_type_settings = 1001210,

    /// parent mass type mono: Mass type setting for parent mass was monoisotopic.
    MS_parent_mass_type_mono = 1001211,

    /// parent mass type average: Mass type setting for parent mass was average isotopic.
    MS_parent_mass_type_average = 1001212,

    /// search result details: OBSOLETE: Scores and global result characteristics.
    MS_search_result_details_OBSOLETE = 1001213,

    /// protein-level global FDR: Estimation of the global false discovery rate of proteins.
    MS_protein_level_global_FDR = 1001214,

    /// SEQUEST:PeptideSp: The SEQUEST result 'Sp' in out file (peptide).
    MS_SEQUEST_PeptideSp = 1001215,

    /// SEQUEST:PeptideRankSp: The SEQUEST result 'Sp' of 'Rank/Sp' in out file (peptide). Also called 'rsp'.
    MS_SEQUEST_PeptideRankSp = 1001217,

    /// SEQUEST:PeptideNumber: The SEQUEST result '#' in out file (peptide).
    MS_SEQUEST_PeptideNumber = 1001218,

    /// SEQUEST:PeptideIdnumber: The SEQUEST result 'Id#' in out file (peptide).
    MS_SEQUEST_PeptideIdnumber = 1001219,

    /// frag: y ion: Fragmentation information, type of product: y ion.
    MS_frag__y_ion = 1001220,

    /// fragmentation information: Fragmentation information like ion types.
    MS_fragmentation_information = 1001221,

    /// frag: b ion - H2O: Fragmentation information, type of product: b ion without water.
    MS_frag__b_ion___H2O = 1001222,

    /// frag: y ion - H2O: Fragmentation information, type of product: y ion without water.
    MS_frag__y_ion___H2O = 1001223,

    /// frag: b ion: Fragmentation information, type of product: b ion.
    MS_frag__b_ion = 1001224,

    /// product ion m/z: The m/z of the product ion.
    MS_product_ion_m_z = 1001225,

    /// fragment ion m/z (product ion m/z): The m/z of the product ion.
    MS_fragment_ion_m_z = MS_product_ion_m_z,

    /// product ion intensity: The intensity of a single product ion.
    MS_product_ion_intensity = 1001226,

    /// fragment ion intensity (product ion intensity): The intensity of a single product ion.
    MS_fragment_ion_intensity = MS_product_ion_intensity,

    /// product ion m/z error: The product ion m/z error.
    MS_product_ion_m_z_error = 1001227,

    /// frag: x ion: Fragmentation information, type of product: x ion.
    MS_frag__x_ion = 1001228,

    /// frag: a ion: Fragmentation information, type of product: a ion.
    MS_frag__a_ion = 1001229,

    /// frag: z ion: Fragmentation information, type of product: z ion.
    MS_frag__z_ion = 1001230,

    /// frag: c ion: Fragmentation information, type of product: c ion.
    MS_frag__c_ion = 1001231,

    /// frag: b ion - NH3: Ion b-NH3 fragmentation information, type of product: b ion without ammonia.
    MS_frag__b_ion___NH3 = 1001232,

    /// frag: y ion - NH3: Ion y-NH3 fragmentation information, type of product: y ion without ammonia.
    MS_frag__y_ion___NH3 = 1001233,

    /// frag: a ion - H2O: Fragmentation information, type of product: a ion without water.
    MS_frag__a_ion___H2O = 1001234,

    /// frag: a ion - NH3: Ion a-NH3 fragmentation information, type of product: a ion without ammonia.
    MS_frag__a_ion___NH3 = 1001235,

    /// frag: d ion: Fragmentation information, type of product: d ion.
    MS_frag__d_ion = 1001236,

    /// frag: v ion: Fragmentation information, type of product: v ion.
    MS_frag__v_ion = 1001237,

    /// frag: w ion: Fragmentation information, type of product: w ion.
    MS_frag__w_ion = 1001238,

    /// frag: immonium ion: Fragmentation information, type of product: immonium ion.
    MS_frag__immonium_ion = 1001239,

    /// non-identified ion: Non-identified ion.
    MS_non_identified_ion = 1001240,

    /// co-eluting ion: Co-eluting ion.
    MS_co_eluting_ion = 1001241,

    /// SEQUEST out folder: Source file for this mzIdentML was a SEQUEST folder with its out files.
    MS_SEQUEST_out_folder = 1001242,

    /// SEQUEST summary: Source file for this mzIdentML was a SEQUEST summary page (proteins).
    MS_SEQUEST_summary = 1001243,

    /// PerSeptive PKS format: PerSeptive peak list file format.
    MS_PerSeptive_PKS_format = 1001245,

    /// Sciex API III format: PE Sciex peak list file format.
    MS_Sciex_API_III_format = 1001246,

    /// Bruker XML format: Bruker data exchange XML format.
    MS_Bruker_XML_format = 1001247,

    /// search input details: Details describing the search input.
    MS_search_input_details = 1001249,

    /// local FDR: Result of quality estimation: the local FDR at the current position of a sorted list.
    MS_local_FDR = 1001250,

    /// Trypsin: Enzyme trypsin.
    MS_Trypsin = 1001251,

    /// DB source EBI: Database source EBI.
    MS_DB_source_EBI = 1001252,

    /// DB source NCBI: Database source NCBI.
    MS_DB_source_NCBI = 1001253,

    /// DB source UniProt: Database source UniProt.
    MS_DB_source_UniProt = 1001254,

    /// fragment mass type average: Mass type setting for fragment mass was average isotopic.
    MS_fragment_mass_type_average = 1001255,

    /// fragment mass type mono: Mass type setting for fragment mass was monoisotopic.
    MS_fragment_mass_type_mono = 1001256,

    /// param: v ion: Parameter information, type of product: side chain loss v ion.
    MS_param__v_ion = 1001257,

    /// param: d ion: Parameter information, type of product: side chain loss d ion.
    MS_param__d_ion = 1001258,

    /// param: immonium ion: Parameter information, type of product: immonium ion.
    MS_param__immonium_ion = 1001259,

    /// param: w ion: Parameter information, type of product: side chain loss w ion.
    MS_param__w_ion = 1001260,

    /// param: x ion: Parameter information, type of product: x ion with charge on the C-terminal side.
    MS_param__x_ion = 1001261,

    /// param: y ion: Parameter information, type of product: y ion with charge on the C-terminal side.
    MS_param__y_ion = 1001262,

    /// param: z ion: Parameter information, type of product: z ion with charge on the C-terminal side.
    MS_param__z_ion = 1001263,

    /// role type: Role of a Person or Organization.
    MS_role_type = 1001266,

    /// software vendor: Software vendor role.
    MS_software_vendor = 1001267,

    /// programmer: Programmer role.
    MS_programmer = 1001268,

    /// instrument vendor: Instrument vendor role.
    MS_instrument_vendor = 1001269,

    /// lab personnel: Lab personnel role.
    MS_lab_personnel = 1001270,

    /// researcher: Researcher role.
    MS_researcher = 1001271,

    /// (?<=R)(?!P): Regular expression for Arg-C.
    MS_____R____P_ = 1001272,

    /// (?=[BD]): Regular expression for Asp-N.
    MS_____BD__ = 1001273,

    /// (?=[DE]): Regular expression for Asp-N-ambic.
    MS_____DE__ = 1001274,

    /// ProteinScape SearchEvent: Source data for this mzIdentML was a ProteinScape SearchEvent.
    MS_ProteinScape_SearchEvent = 1001275,

    /// ProteinScape Gel: Source data for this mzIdentML was a ProteinScape Gel.
    MS_ProteinScape_Gel = 1001276,

    /// decoy DB accession regexp: Specify the regular expression for decoy accession numbers.
    MS_decoy_DB_accession_regexp = 1001283,

    /// decoy DB derived from: The name of the database, the search database was derived from.
    MS_decoy_DB_derived_from_OBSOLETE = 1001284,

    /// database IPI_mouse: International Protein Index database for Mus musculus sequences.
    MS_database_IPI_mouse = 1001285,

    /// database IPI_rat: International Protein Index database for Rattus norvegicus sequences.
    MS_database_IPI_rat = 1001286,

    /// database IPI_zebrafish: International Protein Index database for Danio rerio sequences.
    MS_database_IPI_zebrafish = 1001287,

    /// database IPI_chicken: International Protein Index database for Gallus gallus sequences.
    MS_database_IPI_chicken = 1001288,

    /// database IPI_cow: International Protein Index database for Bos taurus sequences.
    MS_database_IPI_cow = 1001289,

    /// database IPI_arabidopsis: International Protein Index database for Arabidopsis thaliana sequences.
    MS_database_IPI_arabidopsis = 1001290,

    /// decoy DB from nr: Decoy database from a non-redundant GenBank sequence database.
    MS_decoy_DB_from_nr_OBSOLETE = 1001291,

    /// decoy DB from IPI_rat: Decoy database from a International Protein Index database for Rattus norvegicus.
    MS_decoy_DB_from_IPI_rat_OBSOLETE = 1001292,

    /// decoy DB from IPI_mouse: Decoy database from a International Protein Index database for Mus musculus.
    MS_decoy_DB_from_IPI_mouse_OBSOLETE = 1001293,

    /// decoy DB from IPI_arabidopsis: Decoy database from a International Protein Index database for Arabidopsis thaliana.
    MS_decoy_DB_from_IPI_arabidopsis_OBSOLETE = 1001294,

    /// decoy DB from EST: Decoy database from an expressed sequence tag nucleotide sequence database.
    MS_decoy_DB_from_EST_OBSOLETE = 1001295,

    /// decoy DB from IPI_zebrafish: Decoy database from a International Protein Index database for Danio rerio.
    MS_decoy_DB_from_IPI_zebrafish_OBSOLETE = 1001296,

    /// decoy DB from UniProtKB/Swiss-Prot: Decoy database from a Swiss-Prot protein sequence database.
    MS_decoy_DB_from_UniProtKB_Swiss_Prot_OBSOLETE = 1001297,

    /// decoy DB from IPI_chicken: Decoy database from a International Protein Index database for Gallus gallus.
    MS_decoy_DB_from_IPI_chicken_OBSOLETE = 1001298,

    /// decoy DB from IPI_cow: Decoy database from a International Protein Index database for Bos taurus.
    MS_decoy_DB_from_IPI_cow_OBSOLETE = 1001299,

    /// decoy DB from IPI_human: Decoy database from a International Protein Index database for Homo sapiens.
    MS_decoy_DB_from_IPI_human_OBSOLETE = 1001300,

    /// protein rank: The rank of the protein in a list sorted by the search engine.
    MS_protein_rank = 1001301,

    /// search engine specific input parameter: Search engine specific input parameters.
    MS_search_engine_specific_input_parameter = 1001302,

    /// Arg-C: Endoproteinase Arg-C.
    MS_Arg_C = 1001303,

    /// Clostripain (Arg-C): Endoproteinase Arg-C.
    MS_Clostripain = MS_Arg_C,

    /// Asp-N: Endoproteinase Asp-N.
    MS_Asp_N = 1001304,

    /// Asp-N_ambic: Enzyme Asp-N, Ammonium Bicarbonate (AmBic).
    MS_Asp_N_ambic = 1001305,

    /// Chymotrypsin: Enzyme chymotrypsin.
    MS_Chymotrypsin = 1001306,

    /// CNBr: Cyanogen bromide.
    MS_CNBr = 1001307,

    /// Formic_acid: Formic acid.
    MS_Formic_acid = 1001308,

    /// Lys-C: Endoproteinase Lys-C.
    MS_Lys_C = 1001309,

    /// Lys-C/P: Proteinase Lys-C/P.
    MS_Lys_C_P = 1001310,

    /// PepsinA: PepsinA proteinase.
    MS_PepsinA = 1001311,

    /// TrypChymo: Cleavage agent TrypChymo.
    MS_TrypChymo = 1001312,

    /// Trypsin/P: Cleavage agent Trypsin/P.
    MS_Trypsin_P = 1001313,

    /// V8-DE: Cleavage agent V8-DE.
    MS_V8_DE = 1001314,

    /// V8-E: Cleavage agent V8-E.
    MS_V8_E = 1001315,

    /// Mascot:SigThreshold: Significance threshold below which the p-value of a peptide match must lie to be considered statistically significant (default 0.05).
    MS_Mascot_SigThreshold = 1001316,

    /// Mascot:MaxProteinHits: The number of protein hits to display in the report. If 'Auto', all protein hits that have a protein score exceeding the average peptide identity threshold are reported. Otherwise an integer at least 1.
    MS_Mascot_MaxProteinHits = 1001317,

    /// Mascot:ProteinScoringMethod: Mascot protein scoring method; either 'Standard' or 'MudPIT'.
    MS_Mascot_ProteinScoringMethod = 1001318,

    /// Mascot:MinMSMSThreshold: Mascot peptide match ion score threshold. If between 0 and 1, then peptide matches whose expect value exceeds the thresholds are suppressed; if at least 1, then peptide matches whose ion score is below the threshold are suppressed.
    MS_Mascot_MinMSMSThreshold = 1001319,

    /// Mascot:ShowHomologousProteinsWithSamePeptides: If true, show (sequence or spectrum) same-set proteins. Otherwise they are suppressed.
    MS_Mascot_ShowHomologousProteinsWithSamePeptides = 1001320,

    /// Mascot:ShowHomologousProteinsWithSubsetOfPeptides: If true, show (sequence or spectrum) sub-set and subsumable proteins. Otherwise they are suppressed.
    MS_Mascot_ShowHomologousProteinsWithSubsetOfPeptides = 1001321,

    /// Mascot:RequireBoldRed: Only used in Peptide Summary and Select Summary reports. If true, a peptide match must be 'bold red' to be included in the report; bold red means the peptide is a top ranking match in a query and appears for the first time (in linear order) in the list of protein hits.
    MS_Mascot_RequireBoldRed = 1001322,

    /// Mascot:UseUnigeneClustering: If true, then the search results are against a nucleic acid database and Unigene clustering is enabled. Otherwise UniGene clustering is not in use.
    MS_Mascot_UseUnigeneClustering = 1001323,

    /// Mascot:IncludeErrorTolerantMatches: If true, then the search results are error tolerant and peptide matches from the second pass are included in search results. Otherwise no error tolerant peptide matches are included.
    MS_Mascot_IncludeErrorTolerantMatches = 1001324,

    /// Mascot:ShowDecoyMatches: If true, then the search results are against an automatically generated decoy database and the reported peptide matches and protein hits come from the decoy database. Otherwise peptide matches and protein hits come from the original database.
    MS_Mascot_ShowDecoyMatches = 1001325,

    /// add_others: OBSOLETE.
    MS_add_others_OBSOLETE = 1001326,

    /// OMSSA:evalue: OMSSA E-value.
    MS_OMSSA_evalue = 1001328,

    /// OMSSA:pvalue: OMSSA p-value.
    MS_OMSSA_pvalue = 1001329,

    /// X!Tandem:expect: The X!Tandem expectation value.
    MS_X_Tandem_expect = 1001330,

    /// X!Tandem:hyperscore: The X!Tandem hyperscore.
    MS_X_Tandem_hyperscore = 1001331,

    /// (?<=[FYWL])(?!P): Regular expression for Chymotrypsin.
    MS______FYWL_____P_ = 1001332,

    /// (?<=M): Regular expression for CNBr.
    MS_____M_ = 1001333,

    /// ((?<=D))|((?=D)): Regular expression for formic acid.
    MS______D_______D__ = 1001334,

    /// (?<=K)(?!P): Regular expression for Lys-C.
    MS_____K____P_ = 1001335,

    /// (?<=K): Regular expression for Lys-C/P.
    MS_____K_ = 1001336,

    /// (?<=[FL]): Regular expression for PepsinA.
    MS______FL__ = 1001337,

    /// (?<=[FYWLKR])(?!P): Regular expression for TrypChymo.
    MS______FYWLKR_____P_ = 1001338,

    /// (?<=[KR]): Regular expression for Trypsin/P.
    MS______KR__ = 1001339,

    /// (?<=[BDEZ])(?!P): Regular expression for V8-DE.
    MS______BDEZ_____P_ = 1001340,

    /// (?<=[EZ])(?!P): Regular expression for V8-E.
    MS______EZ_____P_ = 1001341,

    /// database sequence details: Details about a single database sequence.
    MS_database_sequence_details = 1001342,

    /// NA sequence: The sequence is a nucleic acid sequence.
    MS_NA_sequence = 1001343,

    /// AA sequence: The sequence is a amino acid sequence.
    MS_AA_sequence = 1001344,

    /// mass table source: Children of this term specify the source of the mass table used.
    MS_mass_table_source = 1001345,

    /// AAIndex mass table: The masses used in the mass table are taken from AAIndex.
    MS_AAIndex_mass_table = 1001346,

    /// database file formats: The children of this term define file formats of the sequence database used.
    MS_database_file_formats = 1001347,

    /// FASTA format: The sequence database was stored in the FASTA format.
    MS_FASTA_format = 1001348,

    /// ASN.1: The sequence database was stored in the Abstract Syntax Notation 1 format.
    MS_ASN_1 = 1001349,

    /// NCBI *.p*: The sequence database was stored in the NCBI formatdb (*.p*) format.
    MS_NCBI___p_ = 1001350,

    /// clustal aln: ClustalW ALN (multiple alignment) format.
    MS_clustal_aln = 1001351,

    /// embl em: EMBL entry format.
    MS_embl_em = 1001352,

    /// NBRF PIR: The NBRF PIR was used as format.
    MS_NBRF_PIR = 1001353,

    /// mass table options: Root node for options for the mass table used.
    MS_mass_table_options = 1001354,

    /// peptide descriptions: Descriptions of peptides.
    MS_peptide_descriptions = 1001355,

    /// spectrum descriptions: Descriptions of the input spectra.
    MS_spectrum_descriptions = 1001356,

    /// spectrum quality descriptions: Description of the quality of the input spectrum.
    MS_spectrum_quality_descriptions = 1001357,

    /// msmsEval quality: This term reports the quality of the spectrum assigned by msmsEval.
    MS_msmsEval_quality = 1001358,

    /// ambiguous residues: Children of this term describe ambiguous residues.
    MS_ambiguous_residues = 1001359,

    /// alternate single letter codes: List of standard residue one letter codes which are used to replace a non-standard.
    MS_alternate_single_letter_codes = 1001360,

    /// alternate mass: List of masses a non-standard letter code is replaced with.
    MS_alternate_mass = 1001361,

    /// number of unmatched peaks: The number of unmatched peaks.
    MS_number_of_unmatched_peaks = 1001362,

    /// peptide unique to one protein: A peptide matching only one.
    MS_peptide_unique_to_one_protein = 1001363,

    /// distinct peptide-level global FDR: Estimation of the global false discovery rate for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).
    MS_distinct_peptide_level_global_FDR = 1001364,

    /// frag: internal yb ion: Fragmentation information, type of product: internal yb ion.
    MS_frag__internal_yb_ion = 1001365,

    /// frag: internal ya ion: Fragmentation information, type of product: internal ya ion.
    MS_frag__internal_ya_ion = 1001366,

    /// frag: z+1 ion: Fragmentation information, type of product: z+1 ion.
    MS_frag__z_1_ion = 1001367,

    /// frag: z+2 ion: Fragmentation information, type of product: z+2 ion.
    MS_frag__z_2_ion = 1001368,

    /// text format: Simple text file format of \"m/z [intensity]\" values for a PMF (or single MS-MS) search.
    MS_text_format = 1001369,

    /// Mascot:homology threshold: The Mascot result 'homology threshold'.
    MS_Mascot_homology_threshold = 1001370,

    /// Mascot:identity threshold: The Mascot result 'identity threshold'.
    MS_Mascot_identity_threshold = 1001371,

    /// SEQUEST:Sequences: 
    MS_SEQUEST_Sequences = 1001372,

    /// SEQUEST:TIC: SEQUEST total ion current.
    MS_SEQUEST_TIC = 1001373,

    /// SEQUEST:Sum: 
    MS_SEQUEST_Sum = 1001374,

    /// Phenyx:Instrument Type: The instrument type parameter value in Phenyx.
    MS_Phenyx_Instrument_Type = 1001375,

    /// Phenyx:Scoring Model: The selected scoring model in Phenyx.
    MS_Phenyx_Scoring_Model = 1001376,

    /// Phenyx:Default Parent Charge: The default parent charge value in Phenyx.
    MS_Phenyx_Default_Parent_Charge = 1001377,

    /// Phenyx:Trust Parent Charge: The parameter in Phenyx that specifies if the experimental charge state is to be considered as correct.
    MS_Phenyx_Trust_Parent_Charge = 1001378,

    /// Phenyx:Turbo: The turbo mode parameter in Phenyx.
    MS_Phenyx_Turbo = 1001379,

    /// Phenyx:Turbo:ErrorTol: The maximal allowed fragment m/z error filter considered in the turbo mode of Phenyx.
    MS_Phenyx_Turbo_ErrorTol = 1001380,

    /// Phenyx:Turbo:Coverage: The minimal peptide sequence coverage value, expressed in percent, considered in the turbo mode of Phenyx.
    MS_Phenyx_Turbo_Coverage = 1001381,

    /// Phenyx:Turbo:Series: The list of ion series considered in the turbo mode of Phenyx.
    MS_Phenyx_Turbo_Series = 1001382,

    /// Phenyx:MinPepLength: The minimal number of residues for a peptide to be considered for a valid identification in Phenyx.
    MS_Phenyx_MinPepLength = 1001383,

    /// Phenyx:MinPepzscore: The minimal peptide z-score for a peptide to be considered for a valid identification in Phenyx.
    MS_Phenyx_MinPepzscore = 1001384,

    /// Phenyx:MaxPepPvalue: The maximal peptide p-value for a peptide to be considered for a valid identification in Phenyx.
    MS_Phenyx_MaxPepPvalue = 1001385,

    /// Phenyx:AC Score: The minimal protein score required for a protein database entry to be displayed in the list of identified proteins in Phenyx.
    MS_Phenyx_AC_Score = 1001386,

    /// Phenyx:Conflict Resolution: The parameter in Phenyx that specifies if the conflict resolution algorithm is to be used.
    MS_Phenyx_Conflict_Resolution = 1001387,

    /// Phenyx:AC: The primary sequence database identifier of a protein in Phenyx.
    MS_Phenyx_AC = 1001388,

    /// Phenyx:ID: A secondary sequence database identifier of a protein in Phenyx.
    MS_Phenyx_ID = 1001389,

    /// Phenyx:Score: The protein score of a protein match in Phenyx.
    MS_Phenyx_Score = 1001390,

    /// Phenyx:Peptides1: First number of phenyx result \"#Peptides\".
    MS_Phenyx_Peptides1 = 1001391,

    /// Phenyx:Peptides2: Second number of phenyx result \"#Peptides\".
    MS_Phenyx_Peptides2 = 1001392,

    /// Phenyx:Auto: The value of the automatic peptide acceptance filter in Phenyx.
    MS_Phenyx_Auto = 1001393,

    /// Phenyx:User: The value of the user-defined peptide acceptance filter in Phenyx.
    MS_Phenyx_User = 1001394,

    /// Phenyx:Pepzscore: The z-score value of a peptide sequence match in Phenyx.
    MS_Phenyx_Pepzscore = 1001395,

    /// Phenyx:PepPvalue: The p-value of a peptide sequence match in Phenyx.
    MS_Phenyx_PepPvalue = 1001396,

    /// Phenyx:NumberOfMC: The number of missed cleavages of a peptide sequence in Phenyx.
    MS_Phenyx_NumberOfMC = 1001397,

    /// Phenyx:Modif: The expression of the nature and position(s) of modified residue(s) on a matched peptide sequence in Phenyx.
    MS_Phenyx_Modif = 1001398,

    /// OMSSA csv format: Source file for this mzIdentML was in OMSSA csv file format.
    MS_OMSSA_csv_format = 1001399,

    /// OMSSA xml format: Source file for this mzIdentML was in OMSSA xml file format.
    MS_OMSSA_xml_format = 1001400,

    /// X!Tandem xml format: Source file for this mzIdentML was in X!Tandem xml file format.
    MS_X_Tandem_xml_format = 1001401,

    /// spectrum identification result details: This subsection describes terms which can describe details of spectrum identification results.
    MS_spectrum_identification_result_details = 1001405,

    /// param: internal yb ion: Parameter information, type of product: internal yb ion.
    MS_param__internal_yb_ion = 1001406,

    /// param: internal ya ion: Parameter information, type of product: internal ya ion.
    MS_param__internal_ya_ion = 1001407,

    /// param: z+1 ion: Parameter information, type of product: z+1 ion.
    MS_param__z_1_ion = 1001408,

    /// param: z+2 ion: Parameter information, type of product: z+2 ion.
    MS_param__z_2_ion = 1001409,

    /// translation start codons: The translation start codons used to translate the nucleotides to amino acids.
    MS_translation_start_codons = 1001410,

    /// search tolerance specification: Specification of the search tolerance.
    MS_search_tolerance_specification = 1001411,

    /// search tolerance plus value: 
    MS_search_tolerance_plus_value = 1001412,

    /// search tolerance minus value: 
    MS_search_tolerance_minus_value = 1001413,

    /// MGF scans: OBSOLETE: replaced by MS:1000797 (peak list scans): This term can hold the scans attribute from an MGF input file.
    MS_MGF_scans_OBSOLETE = 1001414,

    /// MGF raw scans: OBSOLETE: replaced by MS:1000798 (peak list raw scans): This term can hold the raw scans attribute from an MGF input file.
    MS_MGF_raw_scans_OBSOLETE = 1001415,

    /// spectrum title: OBSOLETE: replaced by MS:1000796 (spectrum title): Holds the spectrum title from different input file formats, e.g. MGF TITLE.
    MS_spectrum_title_OBSOLETE = 1001416,

    /// SpectraST:dot: SpectraST dot product of two spectra, measuring spectral similarity.
    MS_SpectraST_dot = 1001417,

    /// SpectraST:dot_bias: SpectraST measure of how much of the dot product is dominated by a few peaks.
    MS_SpectraST_dot_bias = 1001418,

    /// SpectraST:discriminant score F: SpectraST spectrum score.
    MS_SpectraST_discriminant_score_F = 1001419,

    /// SpectraST:delta: SpectraST normalised difference between dot product of top hit and runner-up.
    MS_SpectraST_delta = 1001420,

    /// pepXML format: Source file for this mzIdentML was in a pepXML file format.
    MS_pepXML_format = 1001421,

    /// protXML format: Source file for this mzIdentML was in protXML file format.
    MS_protXML_format = 1001422,

    /// translation table description: A URL that describes the translation table used to translate the nucleotides to amino acids.
    MS_translation_table_description = 1001423,

    /// ProteinExtractor:Methodname: Name of the used method in the ProteinExtractor algorithm.
    MS_ProteinExtractor_Methodname = 1001424,

    /// ProteinExtractor:GenerateNonRedundant: Flag indicating if a non redundant scoring should be generated.
    MS_ProteinExtractor_GenerateNonRedundant = 1001425,

    /// ProteinExtractor:IncludeIdentified: Flag indicating if identified proteins should be included.
    MS_ProteinExtractor_IncludeIdentified = 1001426,

    /// ProteinExtractor:MaxNumberOfProteins: The maximum number of proteins to consider.
    MS_ProteinExtractor_MaxNumberOfProteins = 1001427,

    /// ProteinExtractor:MaxProteinMass: The maximum considered mass for a protein.
    MS_ProteinExtractor_MaxProteinMass = 1001428,

    /// ProteinExtractor:MinNumberOfPeptides: The minimum number of proteins to consider.
    MS_ProteinExtractor_MinNumberOfPeptides = 1001429,

    /// ProteinExtractor:UseMascot: Flag indicating to include Mascot scoring for calculation of the ProteinExtractor meta score.
    MS_ProteinExtractor_UseMascot = 1001430,

    /// ProteinExtractor:MascotPeptideScoreThreshold: Only peptides with scores higher than that threshold are taken into account in Mascot scoring for calculation of the ProteinExtractor meta score.
    MS_ProteinExtractor_MascotPeptideScoreThreshold = 1001431,

    /// ProteinExtractor:MascotUniqueScore: In the final result each protein must have at least one peptide above this Mascot score threshold in ProteinExtractor meta score calculation.
    MS_ProteinExtractor_MascotUniqueScore = 1001432,

    /// ProteinExtractor:MascotUseIdentityScore: 
    MS_ProteinExtractor_MascotUseIdentityScore = 1001433,

    /// ProteinExtractor:MascotWeighting: Influence of Mascot search engine in the process of merging the search engine specific protein lists into the global protein list of ProteinExtractor.
    MS_ProteinExtractor_MascotWeighting = 1001434,

    /// ProteinExtractor:UseSequest: Flag indicating to include SEQUEST scoring for calculation of the ProteinExtractor meta score.
    MS_ProteinExtractor_UseSequest = 1001435,

    /// ProteinExtractor:SequestPeptideScoreThreshold: Only peptides with scores higher than that threshold are taken into account in SEQUEST scoring for calculation of the ProteinExtractor meta score.
    MS_ProteinExtractor_SequestPeptideScoreThreshold = 1001436,

    /// ProteinExtractor:SequestUniqueScore: In the final result each protein must have at least one peptide above this SEQUEST score threshold in ProteinExtractor meta score calculation.
    MS_ProteinExtractor_SequestUniqueScore = 1001437,

    /// ProteinExtractor:SequestWeighting: Influence of SEQUEST search engine in the process of merging the search engine specific protein lists into the global protein list of ProteinExtractor.
    MS_ProteinExtractor_SequestWeighting = 1001438,

    /// ProteinExtractor:UseProteinSolver: Flag indicating to include ProteinSolver scoring for calculation of the ProteinExtractor meta score.
    MS_ProteinExtractor_UseProteinSolver = 1001439,

    /// ProteinExtractor:ProteinSolverPeptideScoreThreshold: Only peptides with scores higher than that threshold are taken into account in ProteinSolver scoring for calculation of the ProteinExtractor meta score.
    MS_ProteinExtractor_ProteinSolverPeptideScoreThreshold = 1001440,

    /// ProteinExtractor:ProteinSolverUniqueScore: In the final result each protein must have at least one peptide above this ProteinSolver score threshold in ProteinExtractor meta score calculation.
    MS_ProteinExtractor_ProteinSolverUniqueScore = 1001441,

    /// ProteinExtractor:ProteinSolverWeighting: Influence of ProteinSolver search engine in the process of merging the search engine specific protein lists into the global protein list of ProteinExtractor.
    MS_ProteinExtractor_ProteinSolverWeighting = 1001442,

    /// ProteinExtractor:UsePhenyx: Flag indicating to include Phenyx scoring for calculation of the ProteinExtractor meta score.
    MS_ProteinExtractor_UsePhenyx = 1001443,

    /// ProteinExtractor:PhenyxPeptideScoreThreshold: Only peptides with scores higher than that threshold are taken into account in Phenyx scoring for calculation of the ProteinExtractor meta score.
    MS_ProteinExtractor_PhenyxPeptideScoreThreshold = 1001444,

    /// ProteinExtractor:PhenyxUniqueScore: In the final result each protein must have at least one peptide above this Phenyx score threshold in ProteinExtractor meta score calculation.
    MS_ProteinExtractor_PhenyxUniqueScore = 1001445,

    /// ProteinExtractor:PhenyxWeighting: Influence of Phenyx search engine in the process of merging the search engine specific protein lists into the global protein list of ProteinExtractor.
    MS_ProteinExtractor_PhenyxWeighting = 1001446,

    /// prot:FDR threshold: False-discovery rate threshold for proteins.
    MS_prot_FDR_threshold = 1001447,

    /// pep:FDR threshold: False-discovery rate threshold for peptides.
    MS_pep_FDR_threshold = 1001448,

    /// OMSSA e-value threshold: Threshold for OMSSA e-value for quality estimation.
    MS_OMSSA_e_value_threshold = 1001449,

    /// decoy DB details: Details of decoy generation and database structure.
    MS_decoy_DB_details = 1001450,

    /// decoy DB generation algorithm: Name of algorithm used for decoy generation.
    MS_decoy_DB_generation_algorithm = 1001451,

    /// decoy DB type shuffle: Decoy type: Amino acids of protein sequences are used in a random order.
    MS_decoy_DB_type_shuffle = 1001452,

    /// DB composition only decoy: Decoy database composition: database contains only decoy entries.
    MS_DB_composition_only_decoy = 1001453,

    /// quality estimation with implicite decoy sequences: Decoy entries are generated during the search, not explicitly stored in a database (like Mascot Decoy).
    MS_quality_estimation_with_implicite_decoy_sequences = 1001454,

    /// acquisition software: Acquisition software.
    MS_acquisition_software = 1001455,

    /// analysis software: Analysis software.
    MS_analysis_software = 1001456,

    /// data processing software: Data processing software.
    MS_data_processing_software = 1001457,

    /// spectrum generation information: Vocabularies describing the spectrum generation information.
    MS_spectrum_generation_information = 1001458,

    /// file format: Format of data files.
    MS_file_format = 1001459,

    /// unknown modification: This term should be given if the modification was unknown.
    MS_unknown_modification = 1001460,

    /// greylag: Greylag identification software.
    MS_greylag = 1001461,

    /// PEFF format: The sequence database was stored in the PEFF (PSI enhanced FastA file) format.
    MS_PEFF_format = 1001462,

    /// Phenyx XML format: Phenyx open XML file format.
    MS_Phenyx_XML_format = 1001463,

    /// DTASelect format: DTASelect file format.
    MS_DTASelect_format = 1001464,

    /// MS2 format: MS2 file format for MS/MS spectral data.
    MS_MS2_format = 1001466,

    /// taxonomy: NCBI TaxID: This term is used if a NCBI TaxID is specified, e.g. 9606 for Homo sapiens.
    MS_taxonomy__NCBI_TaxID = 1001467,

    /// taxonomy: common name: This term is used if a common name is specified, e.g. human. Recommend using MS:1001467 (taxonomy: NCBI TaxID) where possible.
    MS_taxonomy__common_name = 1001468,

    /// taxonomy: scientific name: This term is used if a scientific name is specified, e.g. Homo sapiens. Recommend using MS:1001467 (taxonomy: NCBI TaxID) where possible.
    MS_taxonomy__scientific_name = 1001469,

    /// taxonomy: Swiss-Prot ID: This term is used if a swiss prot taxonomy id is specified, e.g. Human. Recommend using MS:1001467 (taxonomy: NCBI TaxID) where possible.
    MS_taxonomy__Swiss_Prot_ID = 1001470,

    /// peptide modification details: The children of this term can be used to describe modifications.
    MS_peptide_modification_details = 1001471,

    /// selected ion monitoring chromatogram: Chromatogram created by creating an array of the measurements of a selectively monitored ion at each time point.
    MS_selected_ion_monitoring_chromatogram = 1001472,

    /// SIM chromatogram (selected ion monitoring chromatogram): Chromatogram created by creating an array of the measurements of a selectively monitored ion at each time point.
    MS_SIM_chromatogram = MS_selected_ion_monitoring_chromatogram,

    /// selected reaction monitoring chromatogram: Chromatogram created by creating an array of the measurements of a selectively monitored reaction at each time point.
    MS_selected_reaction_monitoring_chromatogram = 1001473,

    /// SRM chromatogram (selected reaction monitoring chromatogram): Chromatogram created by creating an array of the measurements of a selectively monitored reaction at each time point.
    MS_SRM_chromatogram = MS_selected_reaction_monitoring_chromatogram,

    /// consecutive reaction monitoring chromatogram: Chromatogram created by creating an array of the measurements of a series of monitored reactions at each time point.
    MS_consecutive_reaction_monitoring_chromatogram_OBSOLETE = 1001474,

    /// CRM chromatogram (consecutive reaction monitoring chromatogram): Chromatogram created by creating an array of the measurements of a series of monitored reactions at each time point.
    MS_CRM_chromatogram_OBSOLETE = MS_consecutive_reaction_monitoring_chromatogram_OBSOLETE,

    /// OMSSA: Open Mass Spectrometry Search Algorithm was used to analyze the spectra.
    MS_OMSSA = 1001475,

    /// X!Tandem: X!Tandem was used to analyze the spectra.
    MS_X_Tandem = 1001476,

    /// SpectraST: SpectraST was used to analyze the spectra.
    MS_SpectraST = 1001477,

    /// Mascot Parser: Mascot Parser was used to analyze the spectra.
    MS_Mascot_Parser = 1001478,

    /// null-terminated ASCII string: Sequence of zero or more non-zero ASCII characters terminated by a single null (0) byte.
    MS_null_terminated_ASCII_string = 1001479,

    /// AB SCIEX TOF/TOF nativeID format: Native format defined by jobRun=xsd:nonNegativeInteger spotLabel=xsd:string spectrum=xsd:nonNegativeInteger.
    MS_AB_SCIEX_TOF_TOF_nativeID_format = 1001480,

    /// AB SCIEX TOF/TOF database: Applied Biosystems/MDS Analytical Technologies TOF/TOF instrument database.
    MS_AB_SCIEX_TOF_TOF_database = 1001481,

    /// TOF/TOF 5800: AB SCIEX or Applied Biosystems|MDS Analytical Technologies AB SCIEX TOF/TOF 5800 Analyzer.
    MS_TOF_TOF_5800 = 1001482,

    /// AB SCIEX TOF/TOF Series Explorer Software: AB SCIEX or Applied Biosystems software for TOF/TOF data acquisition and analysis.
    MS_AB_SCIEX_TOF_TOF_Series_Explorer_Software = 1001483,

    /// intensity normalization: Normalization of data point intensities.
    MS_intensity_normalization = 1001484,

    /// m/z calibration: Calibration of data point m/z positions.
    MS_m_z_calibration = 1001485,

    /// data filtering: Filtering out part of the data.
    MS_data_filtering = 1001486,

    /// ProteinExtractor: An algorithm for protein determination/assembly integrated into Bruker's ProteinScape.
    MS_ProteinExtractor = 1001487,

    /// Mascot Distiller: Mascot Distiller.
    MS_Mascot_Distiller = 1001488,

    /// Mascot Integra: Mascot Integra.
    MS_Mascot_Integra = 1001489,

    /// Percolator: Percolator.
    MS_Percolator = 1001490,

    /// percolator:Q value: Percolator:Q value.
    MS_percolator_Q_value = 1001491,

    /// percolator:score: Percolator:score.
    MS_percolator_score = 1001492,

    /// percolator:PEP: Posterior error probability.
    MS_percolator_PEP = 1001493,

    /// no threshold: In case no threshold was used.
    MS_no_threshold = 1001494,

    /// ProteinScape:SearchResultId: The SearchResultId of this peptide as SearchResult in the ProteinScape database.
    MS_ProteinScape_SearchResultId = 1001495,

    /// ProteinScape:SearchEventId: The SearchEventId of the SearchEvent in the ProteinScape database.
    MS_ProteinScape_SearchEventId = 1001496,

    /// ProteinScape:ProfoundProbability: The Profound probability score stored by ProteinScape.
    MS_ProteinScape_ProfoundProbability = 1001497,

    /// Profound:z value: The Profound z value.
    MS_Profound_z_value = 1001498,

    /// Profound:Cluster: The Profound cluster score.
    MS_Profound_Cluster = 1001499,

    /// Profound:ClusterRank: The Profound cluster rank.
    MS_Profound_ClusterRank = 1001500,

    /// MSFit:Mowse score: The MSFit Mowse score.
    MS_MSFit_Mowse_score = 1001501,

    /// Sonar:Score: The Sonar score.
    MS_Sonar_Score = 1001502,

    /// ProteinScape:PFFSolverExp: The ProteinSolver exp value stored by ProteinScape.
    MS_ProteinScape_PFFSolverExp = 1001503,

    /// ProteinScape:PFFSolverScore: The ProteinSolver score stored by ProteinScape.
    MS_ProteinScape_PFFSolverScore = 1001504,

    /// ProteinScape:IntensityCoverage: The intensity coverage of the identified peaks in the spectrum calculated by ProteinScape.
    MS_ProteinScape_IntensityCoverage = 1001505,

    /// ProteinScape:SequestMetaScore: The SEQUEST meta score calculated by ProteinScape from the original SEQUEST scores.
    MS_ProteinScape_SequestMetaScore = 1001506,

    /// ProteinExtractor:Score: The score calculated by ProteinExtractor.
    MS_ProteinExtractor_Score = 1001507,

    /// Agilent MassHunter nativeID format: Native format defined by scanId=xsd:nonNegativeInteger.
    MS_Agilent_MassHunter_nativeID_format = 1001508,

    /// Agilent MassHunter format: A data file format found in an Agilent MassHunter directory which contains raw data acquired by an Agilent mass spectrometer.
    MS_Agilent_MassHunter_format = 1001509,

    /// TSQ Vantage: TSQ Vantage.
    MS_TSQ_Vantage = 1001510,

    /// Sequence database filter types: Filter types which are used to filter a sequence database.
    MS_Sequence_database_filter_types = 1001511,

    /// Sequence database filters: Sequence database filters which actually can contains values, e.g. to limit PI value of the sequences used to search.
    MS_Sequence_database_filters = 1001512,

    /// DB sequence filter pattern: DB sequence filter pattern.
    MS_DB_sequence_filter_pattern = 1001513,

    /// DB accession filter string: DB accession filter string.
    MS_DB_accession_filter_string = 1001514,

    /// frag: c ion - H2O: Fragmentation information, type of product: c ion without water.
    MS_frag__c_ion___H2O = 1001515,

    /// frag: c ion - NH3: Fragmentation information, type of product: c ion without ammonia.
    MS_frag__c_ion___NH3 = 1001516,

    /// frag: z ion - H2O: Fragmentation information, type of product: z ion without water.
    MS_frag__z_ion___H2O = 1001517,

    /// frag: z ion - NH3: Fragmentation information, type of product: z ion without ammonia.
    MS_frag__z_ion___NH3 = 1001518,

    /// frag: x ion - H2O: Fragmentation information, type of product: x ion without water.
    MS_frag__x_ion___H2O = 1001519,

    /// frag: x ion - NH3: Fragmentation information, type of product: x ion without ammonia.
    MS_frag__x_ion___NH3 = 1001520,

    /// frag: precursor ion - H2O: Fragmentation information, type of product: precursor ion without water.
    MS_frag__precursor_ion___H2O = 1001521,

    /// frag: precursor ion - NH3: Fragmentation information, type of product: precursor ion without ammonia.
    MS_frag__precursor_ion___NH3 = 1001522,

    /// frag: precursor ion: Fragmentation information, type of product: precursor ion.
    MS_frag__precursor_ion = 1001523,

    /// fragment neutral loss: This term can describe a neutral loss m/z value that is lost from an ion.
    MS_fragment_neutral_loss = 1001524,

    /// precursor neutral loss: This term can describe a neutral loss m/z value that is lost from an ion.
    MS_precursor_neutral_loss = 1001525,

    /// spectrum from database integer nativeID format: Native format defined by databasekey=xsd:long.
    MS_spectrum_from_database_integer_nativeID_format = 1001526,

    /// Proteinscape spectra: Spectra from Bruker/Protagen Proteinscape database.
    MS_Proteinscape_spectra = 1001527,

    /// Mascot query number: Native format defined by query=xsd:nonNegativeInteger.
    MS_Mascot_query_number = 1001528,

    /// spectra data details: Child-terms contain information to map the results back to spectra.
    MS_spectra_data_details = 1001529,

    /// mzML unique identifier: Native format defined by mzMLid=xsd:IDREF.
    MS_mzML_unique_identifier = 1001530,

    /// spectrum from ProteinScape database nativeID format: Native format defined by databasekey=xsd:long.
    MS_spectrum_from_ProteinScape_database_nativeID_format = 1001531,

    /// spectrum from database string nativeID format: Native format defined by databasekey=xsd:string.
    MS_spectrum_from_database_string_nativeID_format = 1001532,

    /// Bruker Daltonics esquire series: Bruker Daltonics' esquire series.
    MS_Bruker_Daltonics_esquire_series = 1001533,

    /// Bruker Daltonics flex series: Bruker Daltonics' flex series.
    MS_Bruker_Daltonics_flex_series = 1001534,

    /// Bruker Daltonics BioTOF series: Bruker Daltonics' BioTOF series.
    MS_Bruker_Daltonics_BioTOF_series = 1001535,

    /// Bruker Daltonics micrOTOF series: Bruker Daltonics' micrOTOF series.
    MS_Bruker_Daltonics_micrOTOF_series = 1001536,

    /// BioTOF: Bruker Daltonics' BioTOF: ESI TOF.
    MS_BioTOF = 1001537,

    /// BioTOF III: Bruker Daltonics' BioTOF III: ESI TOF.
    MS_BioTOF_III = 1001538,

    /// UltroTOF-Q: Bruker Daltonics' UltroTOF-Q: ESI Q-TOF (MALDI optional).
    MS_UltroTOF_Q = 1001539,

    /// micrOTOF II: Bruker Daltonics' micrOTOF II: ESI TOF, Nanospray, APCI, APPI.
    MS_micrOTOF_II = 1001540,

    /// maXis: Bruker Daltonics' maXis: ESI Q-TOF, Nanospray, APCI, APPI.
    MS_maXis = 1001541,

    /// amaZon ETD: Bruker Daltonics' amaZon ETD: ESI quadrupole ion trap, Nanospray, APCI, APPI, ETD, PTR.
    MS_amaZon_ETD = 1001542,

    /// microflex LRF: Bruker Daltonics' microflex LRF: MALDI TOF.
    MS_microflex_LRF = 1001543,

    /// ultrafleXtreme: Bruker Daltonics' ultrafleXtreme: MALDI TOF.
    MS_ultrafleXtreme = 1001544,

    /// Bruker Daltonics amaZon series: Bruker Daltonics' amaZon series.
    MS_Bruker_Daltonics_amaZon_series = 1001545,

    /// amaZon X: Bruker Daltonics' amaZon X: ESI quadrupole ion trap, APCI, APPI, ETD, PTR.
    MS_amaZon_X = 1001546,

    /// Bruker Daltonics maXis series: Bruker Daltonics' maXis series.
    MS_Bruker_Daltonics_maXis_series = 1001547,

    /// Bruker Daltonics solarix series: Bruker Daltonics' solarix: ESI quadrupole ion trap, APCI, APPI, ETD, PTR.
    MS_Bruker_Daltonics_solarix_series = 1001548,

    /// solariX: Bruker Daltonics' solariX: ESI, MALDI, Qh-FT_ICR.
    MS_solariX = 1001549,

    /// microflex II: Bruker Daltonics' microflex II: MALDI TOF.
    MS_microflex_II = 1001550,

    /// autoflex II TOF/TOF: Bruker Daltonics' autoflex II TOF/TOF: MALDI TOF.
    MS_autoflex_II_TOF_TOF = 1001553,

    /// autoflex III TOF/TOF smartbeam: Bruker Daltonics' autoflex III TOF/TOF smartbeam: MALDI TOF.
    MS_autoflex_III_TOF_TOF_smartbeam = 1001554,

    /// autoflex: Bruker Daltonics' autoflex: MALDI TOF.
    MS_autoflex = 1001555,

    /// Bruker Daltonics apex series: Bruker Daltonics' apex series.
    MS_Bruker_Daltonics_apex_series = 1001556,

    /// Shimadzu Corporation software: Shimadzu Corporation software.
    MS_Shimadzu_Corporation_software = 1001557,

    /// MALDI Solutions: Shimadzu Biotech software for data acquisition, processing, and analysis.
    MS_MALDI_Solutions = 1001558,

    /// AB SCIEX TOF/TOF T2D nativeID format: Native format defined by file=xsd:IDREF.
    MS_AB_SCIEX_TOF_TOF_T2D_nativeID_format = 1001559,

    /// AB SCIEX TOF/TOF T2D format: Applied Biosystems/MDS Analytical Technologies TOF/TOF instrument export format.
    MS_AB_SCIEX_TOF_TOF_T2D_format = 1001560,

    /// Scaffold: Scaffold analysis software.
    MS_Scaffold = 1001561,

    /// Scaffold nativeID format: Scaffold native ID format.
    MS_Scaffold_nativeID_format = 1001562,

    /// SEQUEST SQT format: Source file for this mzIdentML was in SEQUEST SQT format.
    MS_SEQUEST_SQT_format = 1001563,

    /// Discoverer MSF format: Source file for this mzIdentML was in Thermo Scientific Discoverer MSF format.
    MS_Discoverer_MSF_format = 1001564,

    /// IdentityE XML format: Source file for this mzIdentML was in Waters IdentityE XML format.
    MS_IdentityE_XML_format = 1001565,

    /// ProteinLynx XML format: Source file for this mzIdentML was in Waters ProteinLynx XML format.
    MS_ProteinLynx_XML_format = 1001566,

    /// SpectrumMill directories: Source file for this mzIdentML was in Agilent SpectrumMill directory format.
    MS_SpectrumMill_directories = 1001567,

    /// Scaffold:Peptide Probability: Scaffold peptide probability score.
    MS_Scaffold_Peptide_Probability = 1001568,

    /// IdentityE Score: Waters IdentityE peptide score.
    MS_IdentityE_Score = 1001569,

    /// ProteinLynx:Log Likelihood: ProteinLynx log likelihood score.
    MS_ProteinLynx_Log_Likelihood = 1001570,

    /// ProteinLynx:Ladder Score: Waters ProteinLynx Ladder score.
    MS_ProteinLynx_Ladder_Score = 1001571,

    /// SpectrumMill:Score: Spectrum mill peptide score.
    MS_SpectrumMill_Score = 1001572,

    /// SpectrumMill:SPI: SpectrumMill SPI score (%).
    MS_SpectrumMill_SPI = 1001573,

    /// report only spectra assigned to identified proteins: Flag indicating to report only the spectra assigned to identified proteins.
    MS_report_only_spectra_assigned_to_identified_proteins = 1001574,

    /// Scaffold: Minimum Peptide Count: Minimum number of peptides a protein must have to be accepted.
    MS_Scaffold__Minimum_Peptide_Count = 1001575,

    /// Scaffold: Minimum Protein Probability: Minimum protein probability a protein must have to be accepted.
    MS_Scaffold__Minimum_Protein_Probability = 1001576,

    /// Scaffold: Minimum Peptide Probability: Minimum probability a peptide must have to be accepted for protein scoring.
    MS_Scaffold__Minimum_Peptide_Probability = 1001577,

    /// minimum number of enzymatic termini: Minimum number of enzymatic termini a peptide must have to be accepted.
    MS_minimum_number_of_enzymatic_termini = 1001578,

    /// Scaffold:Protein Probability: Scaffold protein probability score.
    MS_Scaffold_Protein_Probability = 1001579,

    /// SpectrumMill:Discriminant Score: Discriminant score from Agilent SpectrumMill software.
    MS_SpectrumMill_Discriminant_Score = 1001580,

    /// FAIMS compensation voltage: The DC potential applied to the asymmetric waveform in FAIMS that compensates for the difference between high and low field mobility of an ion.
    MS_FAIMS_compensation_voltage = 1001581,

    /// FAIMS CV (FAIMS compensation voltage): The DC potential applied to the asymmetric waveform in FAIMS that compensates for the difference between high and low field mobility of an ion.
    MS_FAIMS_CV = MS_FAIMS_compensation_voltage,

    /// XCMS: Bioconductor package XCMS for preprocessing high-throughput, untargeted analyte profiling data.
    MS_XCMS = 1001582,

    /// MaxQuant: MaxQuant is a quantitative proteomics software package designed for analyzing large mass spectrometric data sets. It is specifically aimed at high resolution MS data.
    MS_MaxQuant = 1001583,

    /// combined pmf + ms-ms search: Search that includes data from Peptide Mass Fingerprint (PMF) and MS/MS (aka Peptide Fragment Fingerprint - PFF).
    MS_combined_pmf___ms_ms_search = 1001584,

    /// MyriMatch: Tabb Lab software for directly comparing peptides in a database to tandem mass spectra.
    MS_MyriMatch = 1001585,

    /// DirecTag: Tabb Lab software for generating sequence tags from tandem mass spectra.
    MS_DirecTag = 1001586,

    /// TagRecon: Tabb Lab software for reconciling sequence tags to a protein database.
    MS_TagRecon = 1001587,

    /// Pepitome: Tabb Lab software for spectral library searches on tandem mass spectra.
    MS_Pepitome = 1001588,

    /// MyriMatch:MVH: Using the multivariate hypergeometric distribution and a peak list divided into several intensity classes, this score is the negative natural log probability that the predicted peaks matched to experimental peaks by random chance.
    MS_MyriMatch_MVH = 1001589,

    /// Pepitome:MVH (MyriMatch:MVH): Using the multivariate hypergeometric distribution and a peak list divided into several intensity classes, this score is the negative natural log probability that the predicted peaks matched to experimental peaks by random chance.
    MS_Pepitome_MVH = MS_MyriMatch_MVH,

    /// TagRecon:MVH (MyriMatch:MVH): Using the multivariate hypergeometric distribution and a peak list divided into several intensity classes, this score is the negative natural log probability that the predicted peaks matched to experimental peaks by random chance.
    MS_TagRecon_MVH = MS_MyriMatch_MVH,

    /// MyriMatch:mzFidelity: The negative natural log probability that predicted peaks match to experimental peaks by random chance by scoring the m/z delta of the matches in a multinomial distribution.
    MS_MyriMatch_mzFidelity = 1001590,

    /// Pepitome:mzFidelity (MyriMatch:mzFidelity): The negative natural log probability that predicted peaks match to experimental peaks by random chance by scoring the m/z delta of the matches in a multinomial distribution.
    MS_Pepitome_mzFidelity = MS_MyriMatch_mzFidelity,

    /// TagRecon:mzFidelity (MyriMatch:mzFidelity): The negative natural log probability that predicted peaks match to experimental peaks by random chance by scoring the m/z delta of the matches in a multinomial distribution.
    MS_TagRecon_mzFidelity = MS_MyriMatch_mzFidelity,

    /// anchor protein: A representative protein selected from a set of sequence same-set or spectrum same-set proteins.
    MS_anchor_protein = 1001591,

    /// family member protein: A protein with significant homology to another protein, but some distinguishing peptide matches.
    MS_family_member_protein = 1001592,

    /// group member with undefined relationship OR ortholog protein: TO ENDETAIL: a really generic relationship OR ortholog protein.
    MS_group_member_with_undefined_relationship_OR_ortholog_protein = 1001593,

    /// sequence same-set protein: A protein which is indistinguishable or equivalent to another protein, having matches to an identical set of peptide sequences.
    MS_sequence_same_set_protein = 1001594,

    /// spectrum same-set protein: A protein which is indistinguishable or equivalent to another protein, having matches to a set of peptide sequences that cannot be distinguished using the evidence in the mass spectra.
    MS_spectrum_same_set_protein = 1001595,

    /// sequence sub-set protein: A protein with a sub-set of the peptide sequence matches for another protein, and no distinguishing peptide matches.
    MS_sequence_sub_set_protein = 1001596,

    /// spectrum sub-set protein: A protein with a sub-set of the matched spectra for another protein, where the matches cannot be distinguished using the evidence in the mass spectra, and no distinguishing peptide matches.
    MS_spectrum_sub_set_protein = 1001597,

    /// sequence subsumable protein: A sequence same-set or sequence sub-set protein where the matches are distributed across two or more proteins.
    MS_sequence_subsumable_protein = 1001598,

    /// spectrum subsumable protein: A spectrum same-set or spectrum sub-set protein where the matches are distributed across two or more proteins.
    MS_spectrum_subsumable_protein = 1001599,

    /// protein inference confidence category: Confidence category of inferred protein (conclusive, non conclusive, ambiguous group or indistinguishable).
    MS_protein_inference_confidence_category = 1001600,

    /// ProteomeDiscoverer:Spectrum Files:Raw File names: Name and location of the .raw file or files.
    MS_ProteomeDiscoverer_Spectrum_Files_Raw_File_names_OBSOLETE = 1001601,

    /// ProteomeDiscoverer:SRF File Selector:SRF File Path: Path and name of the .srf (SEQUEST Result Format) file.
    MS_ProteomeDiscoverer_SRF_File_Selector_SRF_File_Path_OBSOLETE = 1001602,

    /// ProteomeDiscoverer:Spectrum Selector:Ionization Source: Ionization source (electro-, nano-, thermospray, electron impact, APCI, MALDI, FAB etc).
    MS_ProteomeDiscoverer_Spectrum_Selector_Ionization_Source_OBSOLETE = 1001603,

    /// ProteomeDiscoverer:Activation Type: Fragmentation method used (CID, MPD, ECD, PQD, ETD, HCD, Any).
    MS_ProteomeDiscoverer_Activation_Type_OBSOLETE = 1001604,

    /// ProteomeDiscoverer:Spectrum Selector:Lower RT Limit: Lower retention-time limit.
    MS_ProteomeDiscoverer_Spectrum_Selector_Lower_RT_Limit = 1001605,

    /// ProteomeDiscoverer:Mass Analyzer: Type of mass spectrometer used (ITMS, FTMS, TOFMS, SQMS, TQMS, SectorMS).
    MS_ProteomeDiscoverer_Mass_Analyzer_OBSOLETE = 1001606,

    /// ProteomeDiscoverer:Max Precursor Mass: Maximum mass limit of a singly charged precursor ion.
    MS_ProteomeDiscoverer_Max_Precursor_Mass = 1001607,

    /// ProteomeDiscoverer:Min Precursor Mass: Minimum mass limit of a singly charged precursor ion.
    MS_ProteomeDiscoverer_Min_Precursor_Mass = 1001608,

    /// ProteomeDiscoverer:Spectrum Selector:Minimum Peak Count: Minimum number of peaks in a tandem mass spectrum that is allowed to pass the filter and to be subjected to further processing in the workflow.
    MS_ProteomeDiscoverer_Spectrum_Selector_Minimum_Peak_Count = 1001609,

    /// ProteomeDiscoverer:MS Order: Level of the mass spectrum (MS/MS=MS2 ... MS10).
    MS_ProteomeDiscoverer_MS_Order_OBSOLETE = 1001610,

    /// ProteomeDiscoverer:Polarity Mode: Polarity mode (positive or negative).
    MS_ProteomeDiscoverer_Polarity_Mode_OBSOLETE = 1001611,

    /// ProteomeDiscoverer:Spectrum Selector:Precursor Selection: Determines which precursor mass to use for a given MSn scan. This option applies only to higher-order MSn scans (n >= 3).
    MS_ProteomeDiscoverer_Spectrum_Selector_Precursor_Selection = 1001612,

    /// ProteomeDiscoverer:SN Threshold: Signal-to-Noise ratio below which peaks are removed.
    MS_ProteomeDiscoverer_SN_Threshold = 1001613,

    /// ProteomeDiscoverer:Scan Type: Scan type for the precursor ion (full, Single Ion Monitoring (SIM), Single Reaction Monitoring (SRM)).
    MS_ProteomeDiscoverer_Scan_Type_OBSOLETE = 1001614,

    /// ProteomeDiscoverer:Spectrum Selector:Total Intensity Threshold: Used to filter out tandem mass spectra that have a total intensity current(sum of the intensities of all peaks in a spectrum) below the specified value.
    MS_ProteomeDiscoverer_Spectrum_Selector_Total_Intensity_Threshold = 1001615,

    /// ProteomeDiscoverer:Spectrum Selector:Unrecognized Activation Type Replacements: Specifies the fragmentation method to use in the search algorithm if it is not included in the scan header.
    MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Activation_Type_Replacements = 1001616,

    /// ProteomeDiscoverer:Spectrum Selector:Unrecognized Charge Replacements: Specifies the charge state of the precursor ions, if it is not defined in the scan header.
    MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Charge_Replacements = 1001617,

    /// ProteomeDiscoverer:Spectrum Selector:Unrecognized Mass Analyzer Replacements: Specifies the mass spectrometer to use to produce the spectra, if it is not included in the scan header.
    MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Mass_Analyzer_Replacements = 1001618,

    /// ProteomeDiscoverer:Spectrum Selector:Unrecognized MS Order Replacements: Specifies the MS scan order used to produce the product spectra, if it is not included in the scan header.
    MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_MS_Order_Replacements = 1001619,

    /// ProteomeDiscoverer:Spectrum Selector:Unrecognized Polarity Replacements: Specifies the polarity of the ions monitored if it is not included in the scan header.
    MS_ProteomeDiscoverer_Spectrum_Selector_Unrecognized_Polarity_Replacements = 1001620,

    /// ProteomeDiscoverer:Spectrum Selector:Upper RT Limit: Upper retention-time limit.
    MS_ProteomeDiscoverer_Spectrum_Selector_Upper_RT_Limit = 1001621,

    /// ProteomeDiscoverer:Non-Fragment Filter:Mass Window Offset: Specifies the size of the mass-to-charge ratio (m/z) window in daltons used to remove precursors.
    MS_ProteomeDiscoverer_Non_Fragment_Filter_Mass_Window_Offset = 1001622,

    /// ProteomeDiscoverer:Non-Fragment Filter:Maximum Neutral Loss Mass: Maximum allowed mass of a neutral loss.
    MS_ProteomeDiscoverer_Non_Fragment_Filter_Maximum_Neutral_Loss_Mass = 1001623,

    /// ProteomeDiscoverer:Non-Fragment Filter:Remove Charge Reduced Precursor: Determines whether the charge-reduced precursor peaks found in an ETD or ECD spectrum are removed.
    MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Charge_Reduced_Precursor = 1001624,

    /// ProteomeDiscoverer:Non-Fragment Filter:Remove Neutral Loss Peaks: Determines whether neutral loss peaks are removed from ETD and ECD spectra.
    MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Neutral_Loss_Peaks = 1001625,

    /// ProteomeDiscoverer:Non-Fragment Filter:Remove Only Known Masses: Determines whether overtone peaks are removed from LTQ FT or LTQ FT Ultra ECD spectra.
    MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Only_Known_Masses = 1001626,

    /// ProteomeDiscoverer:Non-Fragment Filter:Remove Precursor Overtones: Determines whether precursor overtone peaks in the spectrum are removed from the input spectrum.
    MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Precursor_Overtones = 1001627,

    /// ProteomeDiscoverer:Non-Fragment Filter:Remove Precursor Peak: Determines whether precursor artifact peaks from the MS/MS input spectra are removed.
    MS_ProteomeDiscoverer_Non_Fragment_Filter_Remove_Precursor_Peak = 1001628,

    /// ProteomeDiscoverer:Spectrum Grouper:Allow Mass Analyzer Mismatch: Determines whether the fragment spectrum for scans with the same precursor mass is grouped, regardless of mass analyzer and activation type.
    MS_ProteomeDiscoverer_Spectrum_Grouper_Allow_Mass_Analyzer_Mismatch = 1001629,

    /// ProteomeDiscoverer:Spectrum Grouper:Allow MS Order Mismatch: Determines whether spectra from different MS order scans can be grouped together.
    MS_ProteomeDiscoverer_Spectrum_Grouper_Allow_MS_Order_Mismatch = 1001630,

    /// ProteomeDiscoverer:Spectrum Grouper:Max RT Difference: Chromatographic window where precursors to be grouped must reside to be considered the same species.
    MS_ProteomeDiscoverer_Spectrum_Grouper_Max_RT_Difference_OBSOLETE = 1001631,

    /// ProteomeDiscoverer:Spectrum Grouper:Precursor Mass Criterion: Groups spectra measured within the given mass and retention-time tolerances into a single spectrum for analysis.
    MS_ProteomeDiscoverer_Spectrum_Grouper_Precursor_Mass_Criterion = 1001632,

    /// ProteomeDiscoverer:Xtract:Highest Charge: Highest charge state that is allowed for the deconvolution of multiply charged data.
    MS_ProteomeDiscoverer_Xtract_Highest_Charge = 1001633,

    /// ProteomeDiscoverer:Xtract:Highest MZ: Highest mass-to-charge (mz) value for spectral peaks in the measured spectrum that are considered for Xtract.
    MS_ProteomeDiscoverer_Xtract_Highest_MZ_OBSOLETE = 1001634,

    /// ProteomeDiscoverer:Xtract:Lowest Charge: Lowest charge state that is allowed for the deconvolution of multiply charged data.
    MS_ProteomeDiscoverer_Xtract_Lowest_Charge = 1001635,

    /// ProteomeDiscoverer:Xtract:Lowest MZ: Lowest mass-to-charge (mz) value for spectral peaks in the measured spectrum that are considered for Xtract.
    MS_ProteomeDiscoverer_Xtract_Lowest_MZ_OBSOLETE = 1001636,

    /// ProteomeDiscoverer:Xtract:Monoisotopic Mass Only: Determines whether the isotopic pattern, i.e. all isotopes of a mass are removed from the spectrum.
    MS_ProteomeDiscoverer_Xtract_Monoisotopic_Mass_Only = 1001637,

    /// ProteomeDiscoverer:Xtract:Overlapping Remainder: Fraction of the more abundant peak that an overlapping multiplet must exceed in order to be processed (deconvoluted).
    MS_ProteomeDiscoverer_Xtract_Overlapping_Remainder = 1001638,

    /// ProteomeDiscoverer:Xtract:Required Fitting Accuracy: Accuracy required for a pattern fit to be considered valid.
    MS_ProteomeDiscoverer_Xtract_Required_Fitting_Accuracy = 1001639,

    /// ProteomeDiscoverer:Xtract:Resolution At 400: Resolution at mass 400.
    MS_ProteomeDiscoverer_Xtract_Resolution_At_400 = 1001640,

    /// ProteomeDiscoverer:Lowest Charge State: Minimum charge state below which peptides are filtered out.
    MS_ProteomeDiscoverer_Lowest_Charge_State = 1001641,

    /// ProteomeDiscoverer:Highest Charge State: Maximum charge above which peptides are filtered out.
    MS_ProteomeDiscoverer_Highest_Charge_State = 1001642,

    /// ProteomeDiscoverer:Spectrum Score Filter:Let Pass Above Scores: Determines whether spectra with scores above the threshold score are retained rather than filtered out.
    MS_ProteomeDiscoverer_Spectrum_Score_Filter_Let_Pass_Above_Scores = 1001643,

    /// ProteomeDiscoverer:Dynamic Modifications: Determine dynamic post-translational modifications (PTMs).
    MS_ProteomeDiscoverer_Dynamic_Modifications = 1001644,

    /// ProteomeDiscoverer:Static Modifications: Static Modification to all occurrences of a named amino acid.
    MS_ProteomeDiscoverer_Static_Modifications = 1001645,

    /// ProteomeDiscoverer:Mascot:Decoy Search: Determines whether the Proteome Discoverer application searches an additional decoy database.
    MS_ProteomeDiscoverer_Mascot_Decoy_Search_OBSOLETE = 1001646,

    /// ProteomeDiscoverer:Mascot:Error tolerant Search: Determines whether to search error-tolerant.
    MS_ProteomeDiscoverer_Mascot_Error_tolerant_Search = 1001647,

    /// ProteomeDiscoverer:Mascot:Max MGF File Size: Maximum size of the .mgf (Mascot Generic Format) file in MByte.
    MS_ProteomeDiscoverer_Mascot_Max_MGF_File_Size = 1001648,

    /// ProteomeDiscoverer:Mascot:Mascot Server URL: URL (Uniform resource Locator) of the Mascot server.
    MS_ProteomeDiscoverer_Mascot_Mascot_Server_URL = 1001649,

    /// ProteomeDiscoverer:Mascot:Number of attempts to submit the search: Number of attempts to submit the Mascot search.
    MS_ProteomeDiscoverer_Mascot_Number_of_attempts_to_submit_the_search = 1001650,

    /// ProteomeDiscoverer:Mascot:X Static Modification: Number of attempts to submit the Mascot search.
    MS_ProteomeDiscoverer_Mascot_X_Static_Modification = 1001651,

    /// ProteomeDiscoverer:Mascot:User Name: Name of the user submitting the Mascot search.
    MS_ProteomeDiscoverer_Mascot_User_Name_OBSOLETE = 1001652,

    /// ProteomeDiscoverer:Mascot:Time interval between attempts to submit a search: Time interval between attempts to submit a search in seconds.
    MS_ProteomeDiscoverer_Mascot_Time_interval_between_attempts_to_submit_a_search = 1001653,

    /// ProteomeDiscoverer:Enzyme Name: Specifies the enzyme reagent used for protein digestion.
    MS_ProteomeDiscoverer_Enzyme_Name_OBSOLETE = 1001654,

    /// ProteomeDiscoverer:Fragment Mass Tolerance: Mass tolerance used for matching fragment peaks in Da or mmu.
    MS_ProteomeDiscoverer_Fragment_Mass_Tolerance_OBSOLETE = 1001655,

    /// Mascot:Instrument: Type of instrument used to acquire the data in the raw file.
    MS_Mascot_Instrument = 1001656,

    /// ProteomeDiscoverer:Maximum Missed Cleavage Sites: Maximum number of missed cleavage sites to consider during the digest.
    MS_ProteomeDiscoverer_Maximum_Missed_Cleavage_Sites = 1001657,

    /// ProteomeDiscoverer:Mascot:Peptide CutOff Score: Minimum score in the IonScore column that each peptide must exceed in order to be reported.
    MS_ProteomeDiscoverer_Mascot_Peptide_CutOff_Score = 1001658,

    /// ProteomeDiscoverer:Precursor Mass Tolerance: Mass window for which precursor ions are considered to be the same species.
    MS_ProteomeDiscoverer_Precursor_Mass_Tolerance_OBSOLETE = 1001659,

    /// ProteomeDiscoverer:Mascot:Protein CutOff Score: Minimum protein score in the IonScore column that each protein must exceed in order to be reported.
    MS_ProteomeDiscoverer_Mascot_Protein_CutOff_Score = 1001660,

    /// ProteomeDiscoverer:Protein Database: Database to use in the search (configured on the Mascot server).
    MS_ProteomeDiscoverer_Protein_Database_OBSOLETE = 1001661,

    /// ProteomeDiscoverer:Mascot:Protein Relevance Factor: Specifies a factor that is used in calculating a threshold that determines whether a protein appears in the results report.
    MS_ProteomeDiscoverer_Mascot_Protein_Relevance_Factor = 1001662,

    /// ProteomeDiscoverer:Target FDR Relaxed: Specifies the relaxed target false discovery rate (FDR, 0.0 - 1.0) for peptide hits with moderate confidence.
    MS_ProteomeDiscoverer_Target_FDR_Relaxed = 1001663,

    /// ProteomeDiscoverer:Target FDR Strict: Specifies the strict target false discovery rate (FDR, 0.0 - 1.0) for peptide hits with high confidence.
    MS_ProteomeDiscoverer_Target_FDR_Strict = 1001664,

    /// ProteomeDiscoverer:Mascot:Taxonomy: Limits searches to entries from a particular species or group of species.
    MS_ProteomeDiscoverer_Mascot_Taxonomy_OBSOLETE = 1001665,

    /// ProteomeDiscoverer:Use Average Precursor Mass: Use average mass for the precursor.
    MS_ProteomeDiscoverer_Use_Average_Precursor_Mass_OBSOLETE = 1001666,

    /// Mascot:use MudPIT scoring: Determines whether to use MudPIT or normal scoring.
    MS_Mascot_use_MudPIT_scoring_OBSOLETE = 1001667,

    /// ProteomeDiscoverer:Absolute XCorr Threshold: Minimum cross-correlation threshold that determines whether peptides in an .srf file are imported.
    MS_ProteomeDiscoverer_Absolute_XCorr_Threshold = 1001668,

    /// ProteomeDiscoverer:SEQUEST:Calculate Probability Score: Determines whether to calculate a probability score for every peptide match.
    MS_ProteomeDiscoverer_SEQUEST_Calculate_Probability_Score = 1001669,

    /// ProteomeDiscoverer:SEQUEST:CTerminal Modification: Dynamic C-terminal modification that is used during the search.
    MS_ProteomeDiscoverer_SEQUEST_CTerminal_Modification = 1001670,

    /// ProteomeDiscoverer:SEQUEST:Fragment Ion Cutoff Percentage: Percentage of the theoretical ions that must be found in order for a peptide to be scored and retained.
    MS_ProteomeDiscoverer_SEQUEST_Fragment_Ion_Cutoff_Percentage = 1001671,

    /// ProteomeDiscoverer:SEQUEST:Max Identical Modifications Per Peptide: Maximum number of identical modifications that a single peptide can have.
    MS_ProteomeDiscoverer_SEQUEST_Max_Identical_Modifications_Per_Peptide = 1001672,

    /// ProteomeDiscoverer:Max Modifications Per Peptide: Maximum number of different modifications that a peptide can have, e.g. because of steric hindrance.
    MS_ProteomeDiscoverer_Max_Modifications_Per_Peptide = 1001673,

    /// ProteomeDiscoverer:SEQUEST:Maximum Peptides Considered: Maximum number of peptides that are searched and scored per spectrum.
    MS_ProteomeDiscoverer_SEQUEST_Maximum_Peptides_Considered = 1001674,

    /// ProteomeDiscoverer:Maximum Peptides Output: Maximum number of peptide matches reported per spectrum.
    MS_ProteomeDiscoverer_Maximum_Peptides_Output = 1001675,

    /// ProteomeDiscoverer:Maximum Protein References Per Peptide: Maximum number of proteins that a single identified peptide can be associated with during protein assembly.
    MS_ProteomeDiscoverer_Maximum_Protein_References_Per_Peptide = 1001676,

    /// ProteomeDiscoverer:SEQUEST:NTerminal Modification: Dynamic N-terminal modification that is used during the search.
    MS_ProteomeDiscoverer_SEQUEST_NTerminal_Modification = 1001677,

    /// ProteomeDiscoverer:Peptide CTerminus: Static modification for the C terminal of the peptide used during the search.
    MS_ProteomeDiscoverer_Peptide_CTerminus = 1001678,

    /// ProteomeDiscoverer:Peptide NTerminus: Static modification for the N terminal of the peptide used during the search.
    MS_ProteomeDiscoverer_Peptide_NTerminus = 1001679,

    /// ProteomeDiscoverer:SEQUEST:Peptide Relevance Factor: Specifies a factor to apply to the protein score.
    MS_ProteomeDiscoverer_SEQUEST_Peptide_Relevance_Factor = 1001680,

    /// ProteomeDiscoverer:Protein Relevance Threshold: Specifies a peptide threshold that determines whether the protein that it is a part of is scored and retained in the report.
    MS_ProteomeDiscoverer_Protein_Relevance_Threshold = 1001681,

    /// ProteomeDiscoverer:Search Against Decoy Database: Determines whether the Proteome Discoverer application searches against a decoy database.
    MS_ProteomeDiscoverer_Search_Against_Decoy_Database_OBSOLETE = 1001682,

    /// ProteomeDiscoverer:SEQUEST:Use Average Fragment Masses: Use average masses for the fragments.
    MS_ProteomeDiscoverer_SEQUEST_Use_Average_Fragment_Masses = 1001683,

    /// ProteomeDiscoverer:Use Neutral Loss a Ions: Determines whether a ions with neutral loss are used for spectrum matching.
    MS_ProteomeDiscoverer_Use_Neutral_Loss_a_Ions = 1001684,

    /// ProteomeDiscoverer:Use Neutral Loss b Ions: Determines whether b ions with neutral loss are used for spectrum matching.
    MS_ProteomeDiscoverer_Use_Neutral_Loss_b_Ions = 1001685,

    /// ProteomeDiscoverer:Use Neutral Loss y Ions: Determines whether y ions with neutral loss are used for spectrum matching.
    MS_ProteomeDiscoverer_Use_Neutral_Loss_y_Ions = 1001686,

    /// ProteomeDiscoverer:Use Neutral Loss z Ions: Determines whether z ions with neutral loss are used for spectrum matching.
    MS_ProteomeDiscoverer_Use_Neutral_Loss_z_Ions = 1001687,

    /// ProteomeDiscoverer:SEQUEST:Weight of a Ions: Uses a ions for spectrum matching with this relative factor.
    MS_ProteomeDiscoverer_SEQUEST_Weight_of_a_Ions = 1001688,

    /// ProteomeDiscoverer:SEQUEST:Weight of b Ions: Uses b ions for spectrum matching with this relative factor.
    MS_ProteomeDiscoverer_SEQUEST_Weight_of_b_Ions = 1001689,

    /// ProteomeDiscoverer:SEQUEST:Weight of c Ions: Uses c ions for spectrum matching with this relative factor.
    MS_ProteomeDiscoverer_SEQUEST_Weight_of_c_Ions = 1001690,

    /// ProteomeDiscoverer:SEQUEST:Weight of d Ions: Uses c ions for spectrum matching with this relative factor.
    MS_ProteomeDiscoverer_SEQUEST_Weight_of_d_Ions = 1001691,

    /// ProteomeDiscoverer:SEQUEST:Weight of v Ions: Uses c ions for spectrum matching with this relative factor.
    MS_ProteomeDiscoverer_SEQUEST_Weight_of_v_Ions = 1001692,

    /// ProteomeDiscoverer:SEQUEST:Weight of w Ions: Uses c ions for spectrum matching with this relative factor.
    MS_ProteomeDiscoverer_SEQUEST_Weight_of_w_Ions = 1001693,

    /// ProteomeDiscoverer:SEQUEST:Weight of x Ions: Uses x ions for spectrum matching with this relative factor.
    MS_ProteomeDiscoverer_SEQUEST_Weight_of_x_Ions = 1001694,

    /// ProteomeDiscoverer:SEQUEST:Weight of y Ions: Uses y ions for spectrum matching with this relative factor.
    MS_ProteomeDiscoverer_SEQUEST_Weight_of_y_Ions = 1001695,

    /// ProteomeDiscoverer:SEQUEST:Weight of z Ions: Uses z ions for spectrum matching with this relative factor.
    MS_ProteomeDiscoverer_SEQUEST_Weight_of_z_Ions = 1001696,

    /// ProteomeDiscoverer:ZCore:Protein Score Cutoff: Sets a minimum protein score that each protein must exceed in order to be reported.
    MS_ProteomeDiscoverer_ZCore_Protein_Score_Cutoff = 1001697,

    /// ProteomeDiscoverer:Reporter Ions Quantizer:Integration Method: Specifies which peak to select if more than one peak is found inside the integration window.
    MS_ProteomeDiscoverer_Reporter_Ions_Quantizer_Integration_Method = 1001698,

    /// ProteomeDiscoverer:Reporter Ions Quantizer:Integration Window Tolerance: Specifies the mass-to-charge window that enables one to look for the reporter peaks.
    MS_ProteomeDiscoverer_Reporter_Ions_Quantizer_Integration_Window_Tolerance = 1001699,

    /// ProteomeDiscoverer:Reporter Ions Quantizer:Quantitation Method: Quantitation method for isobarically labeled quantitation.
    MS_ProteomeDiscoverer_Reporter_Ions_Quantizer_Quantitation_Method = 1001700,

    /// ProteomeDiscoverer:Spectrum Exporter:Export Format: Format of the exported spectra (dta, mgf or mzData).
    MS_ProteomeDiscoverer_Spectrum_Exporter_Export_Format_OBSOLETE = 1001701,

    /// ProteomeDiscoverer:Spectrum Exporter:File name: Name of the output file that contains the exported data.
    MS_ProteomeDiscoverer_Spectrum_Exporter_File_name = 1001702,

    /// ProteomeDiscoverer:Search Modifications Only For Identified Proteins: Influences the modifications search.
    MS_ProteomeDiscoverer_Search_Modifications_Only_For_Identified_Proteins = 1001703,

    /// ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge1: Standard high confidence XCorr parameter for charge = 1.
    MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge1 = 1001704,

    /// ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge2: Standard high confidence XCorr parameter for charge = 2.
    MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge2 = 1001705,

    /// ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge3: Standard high confidence XCorr parameter for charge = 3.
    MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge3 = 1001706,

    /// ProteomeDiscoverer:SEQUEST:Std High Confidence XCorr Charge4: Standard high confidence XCorr parameter for charge >= 4.
    MS_ProteomeDiscoverer_SEQUEST_Std_High_Confidence_XCorr_Charge4 = 1001707,

    /// ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge1: Standard medium confidence XCorr parameter for charge = 1.
    MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge1 = 1001708,

    /// ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge2: Standard medium confidence XCorr parameter for charge = 2.
    MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge2 = 1001709,

    /// ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge3: Standard medium confidence XCorr parameter for charge = 3.
    MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge3 = 1001710,

    /// ProteomeDiscoverer:SEQUEST:Std Medium Confidence XCorr Charge4: Standard medium confidence XCorr parameter for charge >= 4.
    MS_ProteomeDiscoverer_SEQUEST_Std_Medium_Confidence_XCorr_Charge4 = 1001711,

    /// ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge1: FT high confidence XCorr parameter for charge = 1.
    MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge1 = 1001712,

    /// ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge2: FT high confidence XCorr parameter for charge = 2.
    MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge2 = 1001713,

    /// ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge3: FT high confidence XCorr parameter for charge = 3.
    MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge3 = 1001714,

    /// ProteomeDiscoverer:SEQUEST:FT High Confidence XCorr Charge4: FT high confidence XCorr parameter for charge >= 4.
    MS_ProteomeDiscoverer_SEQUEST_FT_High_Confidence_XCorr_Charge4 = 1001715,

    /// ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge1: FT medium confidence XCorr parameter for charge = 1.
    MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge1 = 1001716,

    /// ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge2: FT medium confidence XCorr parameter for charge = 2.
    MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge2 = 1001717,

    /// ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge3: FT medium confidence XCorr parameter for charge = 3.
    MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge3 = 1001718,

    /// ProteomeDiscoverer:SEQUEST:FT Medium Confidence XCorr Charge4: FT medium confidence XCorr parameter for charge >= 4.
    MS_ProteomeDiscoverer_SEQUEST_FT_Medium_Confidence_XCorr_Charge4 = 1001719,

    /// ProteomeDiscoverer:1. Dynamic Modification: Determine 1st dynamic post-translational modifications (PTMs).
    MS_ProteomeDiscoverer_1__Dynamic_Modification = 1001720,

    /// ProteomeDiscoverer:2. Dynamic Modification: Determine 2nd dynamic post-translational modifications (PTMs).
    MS_ProteomeDiscoverer_2__Dynamic_Modification = 1001721,

    /// ProteomeDiscoverer:3. Dynamic Modification: Determine 3rd dynamic post-translational modifications (PTMs).
    MS_ProteomeDiscoverer_3__Dynamic_Modification = 1001722,

    /// ProteomeDiscoverer:4. Dynamic Modification: Determine 4th dynamic post-translational modifications (PTMs).
    MS_ProteomeDiscoverer_4__Dynamic_Modification = 1001723,

    /// ProteomeDiscoverer:Static Modification for X: Static Modification for X.
    MS_ProteomeDiscoverer_Static_Modification_for_X = 1001724,

    /// ProteomeDiscoverer:Initial minimal peptide probability: Minimal initial peptide probability to contribute to analysis.
    MS_ProteomeDiscoverer_Initial_minimal_peptide_probability = 1001725,

    /// ProteomeDiscoverer:Minimal peptide probability: Minimum adjusted peptide probability contributing to protein probability.
    MS_ProteomeDiscoverer_Minimal_peptide_probability = 1001726,

    /// ProteomeDiscoverer:Minimal peptide weight: Minimum peptide weight contributing to protein probability.
    MS_ProteomeDiscoverer_Minimal_peptide_weight = 1001727,

    /// ProteomeDiscoverer:Number of input1 spectra: Number of spectra from 1+ precursor ions.
    MS_ProteomeDiscoverer_Number_of_input1_spectra = 1001728,

    /// ProteomeDiscoverer:Number of input2 spectra: Number of spectra from 2+ precursor ions.
    MS_ProteomeDiscoverer_Number_of_input2_spectra = 1001729,

    /// ProteomeDiscoverer:Number of input3 spectra: Number of spectra from 3+ precursor ions.
    MS_ProteomeDiscoverer_Number_of_input3_spectra = 1001730,

    /// ProteomeDiscoverer:Number of input4 spectra: Number of spectra from 4+ precursor ions.
    MS_ProteomeDiscoverer_Number_of_input4_spectra = 1001731,

    /// ProteomeDiscoverer:Number of input5 spectra: Number of spectra from 5+ precursor ions.
    MS_ProteomeDiscoverer_Number_of_input5_spectra = 1001732,

    /// ProteomeDiscoverer:Number of predicted correct proteins: Total number of predicted correct protein ids (sum of probabilities).
    MS_ProteomeDiscoverer_Number_of_predicted_correct_proteins = 1001733,

    /// ProteomeDiscoverer:Organism: Sample organism (used for annotation purposes).
    MS_ProteomeDiscoverer_Organism_OBSOLETE = 1001734,

    /// ProteomeDiscoverer:Reference Database: Full path database name.
    MS_ProteomeDiscoverer_Reference_Database_OBSOLETE = 1001735,

    /// ProteomeDiscoverer:Residue substitution list: Residues considered equivalent when comparing peptides.
    MS_ProteomeDiscoverer_Residue_substitution_list = 1001736,

    /// ProteomeDiscoverer:Source file extension: File type (if not pepXML).
    MS_ProteomeDiscoverer_Source_file_extension_OBSOLETE = 1001737,

    /// ProteomeDiscoverer:Source Files: Input pepXML files.
    MS_ProteomeDiscoverer_Source_Files_OBSOLETE = 1001738,

    /// ProteomeDiscoverer:Source Files old: Input pepXML files (old).
    MS_ProteomeDiscoverer_Source_Files_old_OBSOLETE = 1001739,

    /// ProteomeDiscoverer:WinCyg reference database: Windows full path for database.
    MS_ProteomeDiscoverer_WinCyg_reference_database = 1001740,

    /// ProteomeDiscoverer:WinCyg source files: Windows pepXML file names.
    MS_ProteomeDiscoverer_WinCyg_source_files = 1001741,

    /// LTQ Orbitrap Velos: Finnigan LTQ Orbitrap Velos MS.
    MS_LTQ_Orbitrap_Velos = 1001742,

    /// ProteomeDiscoverer:Mascot:Weight of A Ions: Determines if to use A ions for spectrum matching.
    MS_ProteomeDiscoverer_Mascot_Weight_of_A_Ions = 1001743,

    /// ProteomeDiscoverer:Mascot:Weight of B Ions: Determines if to use B ions for spectrum matching.
    MS_ProteomeDiscoverer_Mascot_Weight_of_B_Ions = 1001744,

    /// ProteomeDiscoverer:Mascot:Weight of C Ions: Determines if to use C ions for spectrum matching.
    MS_ProteomeDiscoverer_Mascot_Weight_of_C_Ions = 1001745,

    /// ProteomeDiscoverer:Mascot:Weight of D Ions: Determines if to use D ions for spectrum matching.
    MS_ProteomeDiscoverer_Mascot_Weight_of_D_Ions = 1001746,

    /// ProteomeDiscoverer:Mascot:Weight of V Ions: Determines if to use V ions for spectrum matching.
    MS_ProteomeDiscoverer_Mascot_Weight_of_V_Ions = 1001747,

    /// ProteomeDiscoverer:Mascot:Weight of W Ions: Determines if to use W ions for spectrum matching.
    MS_ProteomeDiscoverer_Mascot_Weight_of_W_Ions = 1001748,

    /// ProteomeDiscoverer:Mascot:Weight of X Ions: Determines if to use X ions for spectrum matching.
    MS_ProteomeDiscoverer_Mascot_Weight_of_X_Ions = 1001749,

    /// ProteomeDiscoverer:Mascot:Weight of Y Ions: Determines if to use Y ions for spectrum matching.
    MS_ProteomeDiscoverer_Mascot_Weight_of_Y_Ions = 1001750,

    /// ProteomeDiscoverer:Mascot:Weight of Z Ions: Determines if to use z ions for spectrum matching.
    MS_ProteomeDiscoverer_Mascot_Weight_of_Z_Ions = 1001751,

    /// ProteomeDiscoverer:Spectrum Selector:Use New Precursor Reevaluation: Determines if to use precursor reevaluation.
    MS_ProteomeDiscoverer_Spectrum_Selector_Use_New_Precursor_Reevaluation = 1001752,

    /// ProteomeDiscoverer:Spectrum Selector:SN Threshold FTonly: Signal-to-Noise ratio below which peaks are removed (in FT mode only).
    MS_ProteomeDiscoverer_Spectrum_Selector_SN_Threshold_FTonly = 1001753,

    /// ProteomeDiscoverer:Mascot:Please Do not Touch this: Unknown Mascot parameter which ProteomeDiscoverer uses for mascot searches.
    MS_ProteomeDiscoverer_Mascot_Please_Do_not_Touch_this = 1001754,

    /// contact phone number: Phone number of the contact person or organization.
    MS_contact_phone_number = 1001755,

    /// contact fax number: Fax number for the contact person or organization.
    MS_contact_fax_number = 1001756,

    /// contact toll-free phone number: Toll-free phone number of the contact person or organization.
    MS_contact_toll_free_phone_number = 1001757,

    /// Mascot:SigThresholdType: Significance threshold type used in Mascot reporting (either 'identity' or 'homology').
    MS_Mascot_SigThresholdType = 1001758,

    /// Mascot:ProteinGrouping: Strategy used by Mascot to group proteins with same peptide matches (one of 'none', 'Occam's razor' or 'family clustering').
    MS_Mascot_ProteinGrouping = 1001759,

    /// Percolator:features: List of Percolator features that were used in processing the peptide matches. Typical Percolator features are 'retentionTime', 'dM', 'mScore', 'lgDScore', 'mrCalc', 'charge' and 'dMppm'.
    MS_Percolator_features = 1001760,

    /// ACQUITY UPLC: Waters LC-system ACQUITY UPLC.
    MS_ACQUITY_UPLC = 1001761,

    /// ACQUITY UPLC H-Class: Waters LC-system ACQUITY UPLC H-Class.
    MS_ACQUITY_UPLC_H_Class = 1001762,

    /// ACQUITY UPLC H-Class Bio: Waters LC-system ACQUITY UPLC H-Class Bio.
    MS_ACQUITY_UPLC_H_Class_Bio = 1001763,

    /// ACQUITY UPLC I-Class: Waters LC-system ACQUITY UPLC I-Class.
    MS_ACQUITY_UPLC_I_Class = 1001764,

    /// ACQUITY UPLC Systems with 2D Technology: Waters LC-system ACQUITY UPLC Systems with 2D Technology.
    MS_ACQUITY_UPLC_Systems_with_2D_Technology = 1001765,

    /// nanoACQUITY UPLC: Waters LC-system nanoACQUITY UPLC.
    MS_nanoACQUITY_UPLC = 1001766,

    /// nanoACQUITY UPLC System with Technology: Waters LC-system nanoACQUITY UPLC System with Technology.
    MS_nanoACQUITY_UPLC_System_with_Technology = 1001767,

    /// nanoACQUITY UPLC with HDX Technology: Waters LC-system nanoACQUITY UPLC with HDX Technology.
    MS_nanoACQUITY_UPLC_with_HDX_Technology = 1001768,

    /// TRIZAIC UPLC nanoTile: Waters LC-system TRIZAIC UPLC nanoTile.
    MS_TRIZAIC_UPLC_nanoTile = 1001769,

    /// GCT Premier: Waters oa-ToF based GCT Premier.
    MS_GCT_Premier = 1001770,

    /// MALDI Synapt G2 HDMS: Waters oa-ToF based MALDI Synapt G2 HDMS.
    MS_MALDI_Synapt_G2_HDMS = 1001771,

    /// MALDI Synapt G2 MS: Waters oa-ToF based MALDI Synapt G2 MS.
    MS_MALDI_Synapt_G2_MS = 1001772,

    /// MALDI Synapt G2-S HDMS: Waters oa-ToF based MALDI Synapt G2 MS.
    MS_MALDI_Synapt_G2_S_HDMS = 1001773,

    /// MALDI Synapt G2-S MS: Waters oa-ToF based MALDI Synapt G2-S MS.
    MS_MALDI_Synapt_G2_S_MS = 1001774,

    /// MALDI Synapt HDMS: Waters oa-ToF based MALDI Synapt HDMS.
    MS_MALDI_Synapt_HDMS = 1001775,

    /// MALDI Synapt MS: Waters oa-ToF based MALDI Synapt MS.
    MS_MALDI_Synapt_MS = 1001776,

    /// Synapt G2 HDMS: Waters oa-ToF based Synapt G2 HDMS.
    MS_Synapt_G2_HDMS = 1001777,

    /// Synapt G2 MS: Waters oa-ToF based Synapt G2 MS.
    MS_Synapt_G2_MS = 1001778,

    /// Synapt G2-S HDMS: Waters oa-ToF based Synapt G2-S HDMS.
    MS_Synapt_G2_S_HDMS = 1001779,

    /// Synapt G2-S MS: Waters oa-ToF based Synapt G2-S MS.
    MS_Synapt_G2_S_MS = 1001780,

    /// Synapt HDMS: Waters oa-ToF based Synapt HDMS.
    MS_Synapt_HDMS = 1001781,

    /// Synapt MS: Waters oa-ToF based Synapt MS.
    MS_Synapt_MS = 1001782,

    /// Xevo G2 Q-Tof: Waters oa-ToF based Xevo G2 Q-Tof.
    MS_Xevo_G2_Q_Tof = 1001783,

    /// Xevo G2 Tof: Waters oa-ToF based Xevo G2 Tof.
    MS_Xevo_G2_Tof = 1001784,

    /// Xevo Q-Tof: Waters oa-ToF based Xevo Q-Tof.
    MS_Xevo_Q_Tof = 1001785,

    /// 3100: Waters quadrupole based 3100.
    MS_3100 = 1001786,

    /// Acquity SQD: Waters quadrupole based Acquity SQD.
    MS_Acquity_SQD = 1001787,

    /// Acquity TQD: Waters quadrupole based Acquity TQD.
    MS_Acquity_TQD = 1001788,

    /// Quattro micro GC: Waters quadrupole based Quattro micro GC.
    MS_Quattro_micro_GC = 1001789,

    /// Xevo TQ MS: Waters quadrupole based Xevo TQ MS.
    MS_Xevo_TQ_MS = 1001790,

    /// Xevo TQD: Waters quadrupole based Xevo TQD.
    MS_Xevo_TQD = 1001791,

    /// Xevo TQ-S: Waters quadrupole based Xevo TQ-S.
    MS_Xevo_TQ_S = 1001792,

    /// Mascot:PreferredTaxonomy: NCBI TaxID taxonomy ID to prefer when two or more proteins match the same set of peptides or when protein entry in database represents multiple sequences.
    MS_Mascot_PreferredTaxonomy = 1001793,

    /// Empower: Waters Empower software for liquid chromatography and mass spectrometry acquisition.
    MS_Empower = 1001795,

    /// Unify: Waters Unify software for liquid chromatography and mass spectrometry acquisition.
    MS_Unify = 1001796,

    /// travelling wave ion mobility mass spectrometer: An ion mobility mass spectrometry technique based on the superimposition of travelling voltage waves on a radially-confining RF voltage in a gas-filled, stacked-ring ion guide.
    MS_travelling_wave_ion_mobility_mass_spectrometer = 1001797,

    /// TWIMS (travelling wave ion mobility mass spectrometer): An ion mobility mass spectrometry technique based on the superimposition of travelling voltage waves on a radially-confining RF voltage in a gas-filled, stacked-ring ion guide.
    MS_TWIMS = MS_travelling_wave_ion_mobility_mass_spectrometer,

    /// LECO software: LECO software for data acquisition and analysis.
    MS_LECO_software = 1001798,

    /// ChromaTOF software: Software for acquisition, processing and analysis of data for LECO instruments.
    MS_ChromaTOF_software = 1001799,

    /// LECO instrument model: LECO instrument model.
    MS_LECO_instrument_model = 1001800,

    /// Pegasus HRT: LECO high resolution time-of-flight GC mass spectrometer.
    MS_Pegasus_HRT = 1001801,

    /// Citius HRT: LECO high resolution time-of-flight LC mass spectrometer.
    MS_Citius_HRT = 1001802,

    /// Pegasus: LECO GC time-of-flight mass spectrometer.
    MS_Pegasus = 1001803,

    /// TruTOF: LECO bench-top GC time-of-flight mass spectrometer.
    MS_TruTOF = 1001804,

    /// quantification datatype: The data type of the value reported in a QuantLayer for a feature, peptide, protein, protein group.
    MS_quantification_datatype = 1001805,

    /// quantification object attribute: Attributes describing the details of an object relevant for reporting quantification workflows or values.
    MS_quantification_object_attribute = 1001806,

    /// study variable attribute: Attribute describing a study variable.
    MS_study_variable_attribute = 1001807,

    /// technical replicate: The study variable is 'technical replicate'. The string value denotes the category of technical replicate, e.g. 'run generated from same sample'.
    MS_technical_replicate = 1001808,

    /// biological replicate: The study variable is 'biological replicate'. This means, the run was generated from another individual or sample.
    MS_biological_replicate = 1001809,

    /// experimental condition 'case': The experimental condition is 'case' in contrast to 'control'.
    MS_experimental_condition__case_ = 1001810,

    /// experimental condition 'control': The experimental condition is 'control' in contrast to 'case'.
    MS_experimental_condition__control_ = 1001811,

    /// experimental condition 'disease': The experimental condition is 'disease' in contrast to 'healthy'.
    MS_experimental_condition__disease_ = 1001812,

    /// experimental condition 'healthy': The experimental condition is 'healthy' in contrast to 'disease'.
    MS_experimental_condition__healthy_ = 1001813,

    /// generic experimental condition: The experimental condition is given in the value of this term.
    MS_generic_experimental_condition = 1001814,

    /// time series, time point X: The experimental design followed a time series design. The time point of this run is given in the value of this term.
    MS_time_series__time_point_X = 1001815,

    /// dilution series, concentration X: The experimental design followed a dilution series design. The concentration of this run is given in the value of this term.
    MS_dilution_series__concentration_X = 1001816,

    /// raw file attribute: Attribute describing a raw file.
    MS_raw_file_attribute = 1001817,

    /// one sample run: The raw file contains the run of one sample (e.g. spectral counting, LC-MS label-free).
    MS_one_sample_run = 1001818,

    /// two sample run: The raw file contains the run of two samples (e.g. SILAC, metabolic labelling).
    MS_two_sample_run = 1001819,

    /// three sample run: The raw file contains the run of three samples (e.g. 3-plex SILAC).
    MS_three_sample_run = 1001820,

    /// four sample run: The raw file contains the run of four samples (e.g. 4-plex iTraq).
    MS_four_sample_run = 1001821,

    /// eight sample run: The raw file contains the run of eight samples (e.g. 8-plex iTraq).
    MS_eight_sample_run = 1001822,

    /// raw files group attribute: Attribute describing, how raw files build a raw file group.
    MS_raw_files_group_attribute = 1001823,

    /// merge of runs of 1D gel bands: Attribute describing, how raw files build a raw file group.
    MS_merge_of_runs_of_1D_gel_bands = 1001824,

    /// feature list attribute: Attribute describing a feature list.
    MS_feature_list_attribute = 1001825,

    /// mass trace reporting: rectangles: The mass trace of the features of this feature list specifies rectangles. Each mass trace has the syntax (RT_start,MZ_start,RT_end,MZ_end), i.e. opposite corners are given.
    MS_mass_trace_reporting__rectangles = 1001826,

    /// mass trace reporting: polygons: The mass trace of the features of this feature list specifies polygons. Each mass trace has the syntax (RT_1, MZ_1, RT_2, MZ_2, ... , RT_i, MZ_i, ... , RT_n, MZ_n), where the line (RT_n, MZ_n)->(RT_1, MZ_1) is implicit.
    MS_mass_trace_reporting__polygons = 1001827,

    /// feature attribute: Attribute describing a feature.
    MS_feature_attribute = 1001828,

    /// SRM transition ID: Identifier for an SRM transition in an external document describing additional information about the transition.
    MS_SRM_transition_ID = 1001829,

    /// Progenesis LC-MS: Software from Nonlinear Dynamics for LC-MS label-free workflow.
    MS_Progenesis_LC_MS = 1001830,

    /// SILACAnalyzer: Software for SILAC workflow.
    MS_SILACAnalyzer = 1001831,

    /// quantitation software comment or customizations: Quantitation software comment or any customizations to the default setup of the software.
    MS_quantitation_software_comment_or_customizations = 1001832,

    /// quantitation analysis summary: The overall workflow of this quantitation report.
    MS_quantitation_analysis_summary = 1001833,

    /// LC-MS label-free quantitation analysis: LC-MS label-free workflow (RT m/z map).
    MS_LC_MS_label_free_quantitation_analysis = 1001834,

    /// SILAC quantitation analysis: SILAC workflow (heavy, light, and sometimes medium peak).
    MS_SILAC_quantitation_analysis = 1001835,

    /// spectral counting quantitation analysis: Spectral counting workflow (number of identified MS/MS spectra as approximation of peptide / protein quant).
    MS_spectral_counting_quantitation_analysis = 1001836,

    /// iTRAQ quantitation analysis: Quantification analysis using the AB SCIEX iTRAQ isobaric labelling workflow, wherein 2-8 reporter ions are measured in MS/MS spectra near 114 m/z.
    MS_iTRAQ_quantitation_analysis = 1001837,

    /// SRM quantitation analysis: Selected Reaction Monitoring workflow (XIC quantitation of precursor / fragment mass pair).
    MS_SRM_quantitation_analysis = 1001838,

    /// metabolic labeling 14N / 15N quantitation analysis: Metabolic labeling workflow (heavy and light versions of peptides, depending on number of nitrogens).
    MS_metabolic_labeling_14N___15N_quantitation_analysis = 1001839,

    /// LC-MS feature intensity: Maximum peak intensity of the LC-MS feature.
    MS_LC_MS_feature_intensity = 1001840,

    /// LC-MS feature volume: Real (intensity times area) volume of the LC-MS feature.
    MS_LC_MS_feature_volume = 1001841,

    /// peptide PSM count: The number of MS/MS spectra identified for this peptide in spectral counting.
    MS_peptide_PSM_count = 1001842,

    /// MS1 feature maximum intensity: Maximum intensity of MS1 feature.
    MS_MS1_feature_maximum_intensity = 1001843,

    /// MS1 feature area: Area of MS1 feature.
    MS_MS1_feature_area = 1001844,

    /// peak area: Area of MS1 peak (e.g. SILAC, 15N).
    MS_peak_area_OBSOLETE = 1001845,

    /// isotopic pattern area: Area of all peaks belonging to the isotopic pattern of light or heavy peak (e.g. 15N).
    MS_isotopic_pattern_area = 1001846,

    /// reporter ion intensity: Intensity of MS/MS reporter ion (e.g. iTraq).
    MS_reporter_ion_intensity = 1001847,

    /// simple ratio of two values: Simple ratio of two values (enumerator and denominator).
    MS_simple_ratio_of_two_values = 1001848,

    /// sum of MatchedFeature values: Peptide quantification value calculated as sum of MatchedFeature quantification values.
    MS_sum_of_MatchedFeature_values_OBSOLETE = 1001849,

    /// normalized peptide value: Normalized peptide value.
    MS_normalized_peptide_value = 1001850,

    /// protein value: sum of peptide values: Protein quantification value calculated as sum of peptide values.
    MS_protein_value__sum_of_peptide_values = 1001851,

    /// normalized protein value: Normalized protein value.
    MS_normalized_protein_value = 1001852,

    /// max fold change: Global datatype: Maximum of all pair-wise fold changes of group means (e.g. Progenesis).
    MS_max_fold_change = 1001853,

    /// ANOVA p-value: Global datatype: p-value of ANOVA of group means (e.g. Progenesis).
    MS_ANOVA_p_value = 1001854,

    /// t-test p-value: P-value of t-Test of two groups.
    MS_t_test_p_value = 1001855,

    /// reporter ion raw value: Intensity (or area) of MS/MS reporter ion (e.g. iTraq).
    MS_reporter_ion_raw_value = 1001856,

    /// reporter ion normalized value: Normalized value of MS/MS reporter ion (e.g. iTraq).
    MS_reporter_ion_normalized_value = 1001857,

    /// XIC area: Area of the extracted ion chromatogram (e.g. of a transition in SRM).
    MS_XIC_area = 1001858,

    /// normalized XIC area: Normalized area of the extracted ion chromatogram (e.g. of a transition in SRM).
    MS_normalized_XIC_area = 1001859,

    /// protein value: mean of peptide ratios: Protein quantification value calculated as mean of peptide ratios.
    MS_protein_value__mean_of_peptide_ratios = 1001860,

    /// quantification data processing: Terms used to describe types of quantification data processing.
    MS_quantification_data_processing = 1001861,

    /// normalization to mean of sum of all proteins: Normalization of protein values to the mean of the sum of all protein PSM counts (e.g. spectral counting).
    MS_normalization_to_mean_of_sum_of_all_proteins = 1001862,

    /// quantile normalization, proteins: Normalization of protein values to approach the same distribution.
    MS_quantile_normalization__proteins = 1001863,

    /// quantile normalization, peptides: Normalization of peptide values to approach the same distribution.
    MS_quantile_normalization__peptides = 1001864,

    /// Progenesis automatic alignment: Automatic RT alignment of Progenesis software.
    MS_Progenesis_automatic_alignment = 1001865,

    /// Progenesis manual alignment: RT alignment of Progenesis software using automatic and manual vectors.
    MS_Progenesis_manual_alignment = 1001866,

    /// Progenesis normalization: Normalization as performed by Progenesis LC-MS.
    MS_Progenesis_normalization = 1001867,

    /// distinct peptide-level q-value: Estimation of the q-value for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).
    MS_distinct_peptide_level_q_value = 1001868,

    /// protein-level q-value: Estimation of the q-value for proteins.
    MS_protein_level_q_value = 1001869,

    /// distinct peptide-level p-value: Estimation of the p-value for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).
    MS_distinct_peptide_level_p_value = 1001870,

    /// protein-level p-value: Estimation of the p-value for proteins.
    MS_protein_level_p_value = 1001871,

    /// distinct peptide-level e-value: Estimation of the e-value for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).
    MS_distinct_peptide_level_e_value = 1001872,

    /// protein-level e-value: Estimation of the e-value for proteins.
    MS_protein_level_e_value = 1001873,

    /// FDRScore: A smoothing of the distribution of q-values calculated for PSMs from individual search engines, such that ordering of result quality is maintained and all FDRScore values are guaranteed to have a value > 0.
    MS_FDRScore_OBSOLETE = 1001874,

    /// modification motif: The regular expression describing the sequence motif for a modification.
    MS_modification_motif = 1001875,

    /// modification probability: The a priori probability of a modification.
    MS_modification_probability = 1001876,

    /// ChromaTOF HRT software: Software for acquisition, processing and analysis of data for LECO instruments.
    MS_ChromaTOF_HRT_software = 1001877,

    /// MALDI Solutions Microbial Identification: Shimadzu Biotech software for data acquisition, processing, and analysis.
    MS_MALDI_Solutions_Microbial_Identification = 1001878,

    /// offset voltage: The potential difference between two adjacent interface voltages affecting in-source collision induced dissociation.
    MS_offset_voltage = 1001879,

    /// in-source collision-induced dissociation: The dissociation of an ion as a result of collisional excitation during ion transfer from an atmospheric pressure ion source and the mass spectrometer vacuum.
    MS_in_source_collision_induced_dissociation = 1001880,

    /// mz5 format: mz5 file format, modelled after mzML.
    MS_mz5_format = 1001881,

    /// transition validation attribute: Attributes of the quality of a transition that affect its selection as appropriate.
    MS_transition_validation_attribute = 1001882,

    /// coefficient of variation: Variation of a set of signal measurements calculated as the standard deviation relative to the mean.
    MS_coefficient_of_variation = 1001883,

    /// signal-to-noise ratio: Unitless number providing the ratio of the total measured intensity of a signal relative to the estimated noise level for that signal.
    MS_signal_to_noise_ratio = 1001884,

    /// command-line parameters: Parameters string passed to a command-line interface software application, omitting the executable name.
    MS_command_line_parameters = 1001885,

    /// SQID: Software for data analysis of peptides and proteins.
    MS_SQID = 1001886,

    /// SQID:score: The SQID result 'Score'.
    MS_SQID_score = 1001887,

    /// SQID:deltaScore: The SQID result 'deltaScore'.
    MS_SQID_deltaScore = 1001888,

    /// SQID:protein score: The SQID result 'protein score'.
    MS_SQID_protein_score = 1001889,

    /// Progenesis:protein normalised abundance: The data type normalised abundance for proteins produced by Progenesis LC-MS.
    MS_Progenesis_protein_normalised_abundance = 1001890,

    /// Progenesis:peptide normalised abundance: The data type normalised abundance for peptides produced by Progenesis LC-MS.
    MS_Progenesis_peptide_normalised_abundance = 1001891,

    /// Progenesis:protein raw abundance: The data type raw abundance for proteins produced by Progenesis LC-MS.
    MS_Progenesis_protein_raw_abundance = 1001892,

    /// Progenesis:peptide raw abundance: The data type raw abundance for peptide produced by Progenesis LC-MS.
    MS_Progenesis_peptide_raw_abundance = 1001893,

    /// Progenesis:confidence score: The data type confidence score produced by Progenesis LC-MS.
    MS_Progenesis_confidence_score = 1001894,

    /// Progenesis:peptide count: The data type peptide count produced by Progenesis LC-MS.
    MS_Progenesis_peptide_count = 1001895,

    /// Progenesis:feature intensity: The data type feature intensity produced by Progenesis LC-MS.
    MS_Progenesis_feature_intensity = 1001896,

    /// MaxQuant:peptide counts (unique): The data type peptide counts (unique) produced by MaxQuant.
    MS_MaxQuant_peptide_counts__unique_ = 1001897,

    /// MaxQuant:peptide counts (all): The data type peptide counts (all) produced by MaxQuant.
    MS_MaxQuant_peptide_counts__all_ = 1001898,

    /// MaxQuant:peptide counts (razor+unique): The data type peptide counts (razor+unique) produced by MaxQuant.
    MS_MaxQuant_peptide_counts__razor_unique_ = 1001899,

    /// MaxQuant:sequence length: The data type sequence length produced by MaxQuant.
    MS_MaxQuant_sequence_length = 1001900,

    /// MaxQuant:PEP: The data type PEP (posterior error probability) produced by MaxQuant.
    MS_MaxQuant_PEP = 1001901,

    /// MaxQuant:LFQ intensity: The data type LFQ intensity produced by MaxQuant.
    MS_MaxQuant_LFQ_intensity = 1001902,

    /// MaxQuant:feature intensity: The data type feature intensity produced by MaxQuant.
    MS_MaxQuant_feature_intensity = 1001903,

    /// MaxQuant:MS/MS count: The data type MS/MS count produced by MaxQuant.
    MS_MaxQuant_MS_MS_count = 1001904,

    /// emPAI value: The emPAI value of protein abundance, produced from the emPAI algorithm.
    MS_emPAI_value = 1001905,

    /// APEX value: The APEX value of protein abundance, produced from the APEX software.
    MS_APEX_value = 1001906,

    /// retention time window width: The full width of a retention time window for a chromatographic peak.
    MS_retention_time_window_width = 1001907,

    /// ISQ: Thermo Scientific ISQ single quadrupole MS with the ExtractraBrite source.
    MS_ISQ = 1001908,

    /// Velos Plus: Thermo Scientific second generation Velos.
    MS_Velos_Plus = 1001909,

    /// LTQ Orbitrap Elite: Thermo Scientific second generation Velos and Orbitrap.
    MS_LTQ_Orbitrap_Elite = 1001910,

    /// Q Exactive: Thermo Scientific Q Exactive.
    MS_Q_Exactive = 1001911,

    /// PinPoint: Thermo Scientific PinPoint SRM analysis software.
    MS_PinPoint = 1001912,

    /// S-lens voltage: Potential difference setting of the Thermo Scientific S-lens stacked-ring ion guide in volts.
    MS_S_lens_voltage = 1001913,

    /// pymzML: Python module to interface mzML Data.
    MS_pymzML = 1001914,

    /// leukocyte elastase: Enzyme leukocyte elastase (EC 3.4.21.37).
    MS_leukocyte_elastase = 1001915,

    /// proline endopeptidase: Enzyme proline endopeptidase (EC 3.4.21.26).
    MS_proline_endopeptidase = 1001916,

    /// glutamyl endopeptidase: Enzyme glutamyl endopeptidase (EC 3.4.21.19).
    MS_glutamyl_endopeptidase = 1001917,

    /// staphylococcal protease (glutamyl endopeptidase): Enzyme glutamyl endopeptidase (EC 3.4.21.19).
    MS_staphylococcal_protease = MS_glutamyl_endopeptidase,

    /// Glu-C (glutamyl endopeptidase): Enzyme glutamyl endopeptidase (EC 3.4.21.19).
    MS_Glu_C = MS_glutamyl_endopeptidase,

    /// 2-iodobenzoate: Chemical iodobenzoate. Cleaves after W.
    MS_2_iodobenzoate = 1001918,

    /// ProteomeXchange accession number: Main identifier of a ProteomeXchange dataset.
    MS_ProteomeXchange_accession_number = 1001919,

    /// ProteomeXchange accession number version number: Version number of a ProteomeXchange accession number.
    MS_ProteomeXchange_accession_number_version_number = 1001921,

    /// Digital Object Identifier (DOI): DOI unique identifier of a publication.
    MS_Digital_Object_Identifier__DOI_ = 1001922,

    /// doi (Digital Object Identifier (DOI)): DOI unique identifier of a publication.
    MS_doi = MS_Digital_Object_Identifier__DOI_,

    /// external reference keyword: Free text attribute that can enrich the information about an entity.
    MS_external_reference_keyword = 1001923,

    /// journal article keyword: Keyword present in a scientific publication.
    MS_journal_article_keyword = 1001924,

    /// submitter keyword: Keyword assigned by the data submitter.
    MS_submitter_keyword = 1001925,

    /// curator keyword: Keyword assigned by a data curator.
    MS_curator_keyword = 1001926,

    /// Tranche file hash: Hash assigned by the Tranche resource to an individual file.
    MS_Tranche_file_hash = 1001927,

    /// Tranche project hash: Hash assigned by the Tranche resource to a whole project.
    MS_Tranche_project_hash = 1001928,

    /// PRIDE experiment URI: URI that allows the access to one experiment in the PRIDE database.
    MS_PRIDE_experiment_URI = 1001929,

    /// PRIDE project URI: URI that allows the access to one project in the PRIDE database.
    MS_PRIDE_project_URI = 1001930,

    /// source interface: The source interface.
    MS_source_interface = 1001931,

    /// source interface model: The source interface model.
    MS_source_interface_model = 1001932,

    /// source sprayer: The source sprayer.
    MS_source_sprayer = 1001933,

    /// source sprayer type: The source sprayer type.
    MS_source_sprayer_type = 1001934,

    /// source sprayer manufacturer: The source sprayer manufacturer.
    MS_source_sprayer_manufacturer = 1001935,

    /// source sprayer model: The source sprayer model.
    MS_source_sprayer_model = 1001936,

    /// sample plate: Plate where the sample solution is spotted in a MALDI or similar instrument.
    MS_sample_plate = 1001937,

    /// sample plate type: The sample plate type.
    MS_sample_plate_type = 1001938,

    /// stainless steel plate: Stainless steel plate.
    MS_stainless_steel_plate = 1001939,

    /// coated glass plate: Coated glass plate.
    MS_coated_glass_plate = 1001940,

    /// electrospray supply type: Whether the sprayer is fed or is loaded with sample once.
    MS_electrospray_supply_type = 1001941,

    /// static supply electrospray: The sprayer is loaded with sample once.
    MS_static_supply_electrospray = 1001942,

    /// fed supply electrospray: The sprayer is continuously fed with sample.
    MS_fed_supply_electrospray = 1001943,

    /// Collision cell exit potential: Potential difference between Q2 and Q3 in a triple quadrupole instrument in volts.
    MS_Collision_cell_exit_potential = 1001944,

    /// CXP (Collision cell exit potential): Potential difference between Q2 and Q3 in a triple quadrupole instrument in volts.
    MS_CXP = MS_Collision_cell_exit_potential,

    /// Pegasus 4D: LECO nominal mass resolution time-of-flight GCxGC mass spectrometer.
    MS_Pegasus_4D = 1001945,

    /// PEAKS Studio: PEAKS Studio software for data analysis.
    MS_PEAKS_Studio = 1001946,

    /// PEAKS Online: PEAKS Online software for high throughput data analysis.
    MS_PEAKS_Online = 1001947,

    /// PEAKS Node: PEAKS Node software for high throughput data analysis.
    MS_PEAKS_Node = 1001948,

    /// BSI software: Bioinformatics Solutions Inc. Software for data processing and analysis.
    MS_BSI_software = 1001949,

    /// PEAKS:peptideScore: The PEAKS peptide '-10lgP Score'.
    MS_PEAKS_peptideScore = 1001950,

    /// PEAKS:proteinScore: The PEAKS protein '-10lgP Score'.
    MS_PEAKS_proteinScore = 1001951,

    /// ZCore:probScore: The ZCore probability score.
    MS_ZCore_probScore = 1001952,

    /// source interface manufacturer: The source interface manufacturer.
    MS_source_interface_manufacturer = 1001953,

    /// acquisition parameter: Parameters used in the mass spectrometry acquisition.
    MS_acquisition_parameter = 1001954,

    /// no cleavage: No cleavage.
    MS_no_cleavage = 1001955,

    /// unspecific cleavage: Unspecific cleavage.
    MS_unspecific_cleavage = 1001956,

    /// (?<=[ALIV])(?!P): Regular expression for leukocyte elastase.
    MS______ALIV_____P_ = 1001957,

    /// (?<=[HKR]P)(?!P): Regular expression for proline endopeptidase.
    MS______HKR_P____P_ = 1001958,

    /// (?<=[^E]E): Regular expression for glutamyl endopeptidase.
    MS_______E_E_ = 1001959,

    /// (?<=W): Regular expression for 2-iodobenzoate.
    MS_____W_ = 1001960,

    /// peptide spectrum match scoring algorithm: Algorithm used to score the match between a spectrum and a peptide ion.
    MS_peptide_spectrum_match_scoring_algorithm = 1001961,

    /// Mascot:C13 counts: C13 peaks to use in peak detection.
    MS_Mascot_C13_counts = 1001962,

    /// ProteinExtractor:Weighting: Weighting factor for protein list compilation by ProteinExtractor.
    MS_ProteinExtractor_Weighting = 1001963,

    /// ProteinScape:second round Mascot: Flag indicating a second round search with Mascot.
    MS_ProteinScape_second_round_Mascot = 1001964,

    /// ProteinScape:second round Phenyx: Flag indicating a second round search with Phenyx.
    MS_ProteinScape_second_round_Phenyx = 1001965,

    /// product ion mobility: The mobility of an MS2 product ion, as measured by ion mobility mass spectrometry.
    MS_product_ion_mobility = 1001966,

    /// product ion drift time: The ion drift time of an MS2 product ion.
    MS_product_ion_drift_time_OBSOLETE = 1001967,

    /// PTM localization score: A score that assign confidence to the localization of an amino acid modification on a peptide sequence.
    MS_PTM_localization_score = 1001968,

    /// ProteomeDiscoverer:phosphoRS score: Peptide score based on the cumulative binomial probability that the observed match is a random event.
    MS_ProteomeDiscoverer_phosphoRS_score = 1001969,

    /// ProteomeDiscoverer:phosphoRS sequence probability: Probability that the respective isoform is correct.
    MS_ProteomeDiscoverer_phosphoRS_sequence_probability = 1001970,

    /// ProteomeDiscoverer:phosphoRS site probability: Estimate of the probability that the respective site is truly phosphorylated.
    MS_ProteomeDiscoverer_phosphoRS_site_probability = 1001971,

    /// PTM scoring algorithm version: Version of the post-translational modification scoring algorithm.
    MS_PTM_scoring_algorithm_version = 1001972,

    /// DeBunker: DeBunker software.
    MS_DeBunker = 1001973,

    /// DeBunker:score: Score specific to DeBunker.
    MS_DeBunker_score = 1001974,

    /// delta m/z: The difference between a theoretically calculated m/z and the corresponding experimentally measured m/z. It can be expressed as absolute or relative value.
    MS_delta_m_z = 1001975,

    /// m/z difference (delta m/z): The difference between a theoretically calculated m/z and the corresponding experimentally measured m/z. It can be expressed as absolute or relative value.
    MS_m_z_difference = MS_delta_m_z,

    /// delta M: The difference between a theoretically calculated molecular mass M and the corresponding experimentally measured M. It can be expressed as absolute or relative value.
    MS_delta_M = 1001976,

    /// mass difference (delta M): The difference between a theoretically calculated molecular mass M and the corresponding experimentally measured M. It can be expressed as absolute or relative value.
    MS_mass_difference = MS_delta_M,

    /// MSQuant: MSQuant software.
    MS_MSQuant = 1001977,

    /// MSQuant:PTM-score: The PTM score from MSQuant software.
    MS_MSQuant_PTM_score = 1001978,

    /// MaxQuant:PTM Score: The PTM score from MaxQuant software.
    MS_MaxQuant_PTM_Score = 1001979,

    /// MaxQuant:Phospho (STY) Probabilities: The Phospho (STY) Probabilities from MaxQuant software.
    MS_MaxQuant_Phospho__STY__Probabilities = 1001980,

    /// MaxQuant:Phospho (STY) Score Diffs: The Phospho (STY) Score Diffs from MaxQuant software.
    MS_MaxQuant_Phospho__STY__Score_Diffs = 1001981,

    /// MaxQuant:P-site localization probability: The P-site localization probability value from MaxQuant software.
    MS_MaxQuant_P_site_localization_probability = 1001982,

    /// MaxQuant:PTM Delta Score: The PTM Delta Score value from MaxQuant software (Difference between highest scoring site and second highest).
    MS_MaxQuant_PTM_Delta_Score = 1001983,

    /// Ascore: Ascore software.
    MS_Ascore = 1001984,

    /// Ascore:Ascore: The Ascore score value from Ascore software.
    MS_Ascore_Ascore = 1001985,

    /// H-Score: H-Score for peptide phosphorylation site location.
    MS_H_Score = 1001986,

    /// vacuum drying MALDI sample preparation: Vacuum-drying MALDI sample preparation crystallization method.
    MS_vacuum_drying_MALDI_sample_preparation = 1001987,

    /// crushed crystal MALDI sample preparation: Crushed-crystal MALDI sample preparation method.
    MS_crushed_crystal_MALDI_sample_preparation = 1001988,

    /// fast evaporation MALDI sample preparation: Fast-evaporation MALDI sample preparation method.
    MS_fast_evaporation_MALDI_sample_preparation = 1001989,

    /// overlayer MALDI sample preparation: Overlayer method combining features of the crushed-crystal method and the fast-evaporation method.
    MS_overlayer_MALDI_sample_preparation = 1001990,

    /// sandwich MALDI sample preparation: Sandwich MALDI sample preparation method.
    MS_sandwich_MALDI_sample_preparation = 1001991,

    /// spin coating MALDI sample preparation: Spin coating MALDI sample preparation method.
    MS_spin_coating_MALDI_sample_preparation = 1001992,

    /// quick and dirty MALDI sample preparation: Quick & dirty (Q&D) sample preparation separating matrix handling from sample handling.
    MS_quick_and_dirty_MALDI_sample_preparation = 1001993,

    /// top hat baseline reduction: Top-hat morphological filter based on the basic morphological operations 'erosion' and 'dilatation'.
    MS_top_hat_baseline_reduction = 1001994,

    /// convex hull baseline reduction: Constructs the baseline by fitting multiple parabolas to the spectrum starting with the large scale structures.
    MS_convex_hull_baseline_reduction = 1001995,

    /// median baseline reduction: The spectrum that will be baseline subtracted is divided into a number of segments.
    MS_median_baseline_reduction = 1001996,

    /// wavelet transformation smoothing: The random noise is removed by using the undecimated wavelet transform.
    MS_wavelet_transformation_smoothing = 1001997,

    /// sophisticated numerical annotation procedure: It searches for known patterns in the measured spectrum.
    MS_sophisticated_numerical_annotation_procedure = 1001998,

    /// SNAP (sophisticated numerical annotation procedure): It searches for known patterns in the measured spectrum.
    MS_SNAP = MS_sophisticated_numerical_annotation_procedure,

    /// area normalization: Normalization of areas below the curves.
    MS_area_normalization = 1001999,

    /// LIFT: A Bruker's proprietary technique where molecular ions are initially accelerated at lower energy, then collide with inert gas in a collision cell that is then 'lifted' to high potential. The use of inert gas is optional, as it could lift also fragments provided by LID.
    MS_LIFT = 1002000,

    /// MS1 label-based raw feature quantitation: MS1 label-based raw feature quantitation.
    MS_MS1_label_based_raw_feature_quantitation = 1002001,

    /// MS1 label-based peptide level quantitation: MS1 label-based peptide level quantitation.
    MS_MS1_label_based_peptide_level_quantitation = 1002002,

    /// MS1 label-based protein level quantitation: MS1 label-based protein level quantitation.
    MS_MS1_label_based_protein_level_quantitation = 1002003,

    /// MS1 label-based proteingroup level quantitation: MS1 label-based proteingroup level quantitation.
    MS_MS1_label_based_proteingroup_level_quantitation = 1002004,

    /// iRT retention time normalization standard: A de facto standard providing the retention times at which a specific set of 10 reference peptides exit the reference chromatographic column. The kit may be obtain from Biognosys.
    MS_iRT_retention_time_normalization_standard = 1002005,

    /// SRM transition type: The type of the transitions, e.g. target or decoy.
    MS_SRM_transition_type = 1002006,

    /// MRM transition type (SRM transition type): The type of the transitions, e.g. target or decoy.
    MS_MRM_transition_type = MS_SRM_transition_type,

    /// target SRM transition: A transition used to target a specific compound that may be in the sample.
    MS_target_SRM_transition = 1002007,

    /// target MRM transition (target SRM transition): A transition used to target a specific compound that may be in the sample.
    MS_target_MRM_transition = MS_target_SRM_transition,

    /// decoy SRM transition: A transition not expected to be present in the sample and used to calculate statistical confidence of target transition detections in some workflows.
    MS_decoy_SRM_transition = 1002008,

    /// decoy MRM transition (decoy SRM transition): A transition not expected to be present in the sample and used to calculate statistical confidence of target transition detections in some workflows.
    MS_decoy_MRM_transition = MS_decoy_SRM_transition,

    /// isobaric label quantitation analysis: Quantitation analysis using an isobaric labelling workflow.
    MS_isobaric_label_quantitation_analysis = 1002009,

    /// TMT quantitation analysis: Quantitation analysis using the Thermo Fisher tandem mass tag (TMT) labelling workflow.
    MS_TMT_quantitation_analysis = 1002010,

    /// desorption electrospray ionization: Combination of electrospray and desorption ionization method that ionizes gases, liquids and solids in open air under atmospheric pressure.
    MS_desorption_electrospray_ionization = 1002011,

    /// DESI (desorption electrospray ionization): Combination of electrospray and desorption ionization method that ionizes gases, liquids and solids in open air under atmospheric pressure.
    MS_DESI = MS_desorption_electrospray_ionization,

    /// Mascot:PTM site assignment confidence: Relative probability that PTM site assignment is correct, derived from the Mascot score difference between matches to the same spectrum (Mascot Delta Score).
    MS_Mascot_PTM_site_assignment_confidence = 1002012,

    /// collision energy ramp start: Collision energy at the start of the collision energy ramp.
    MS_collision_energy_ramp_start = 1002013,

    /// collision energy ramp end: Collision energy at the end of the collision energy ramp.
    MS_collision_energy_ramp_end = 1002014,

    /// spectral count peptide level quantitation: Spectral count peptide level quantitation.
    MS_spectral_count_peptide_level_quantitation = 1002015,

    /// spectral count protein level quantitation: Spectral count protein level quantitation.
    MS_spectral_count_protein_level_quantitation = 1002016,

    /// spectral count proteingroup level quantitation: Spectral count proteingroup level quantitation.
    MS_spectral_count_proteingroup_level_quantitation = 1002017,

    /// MS1 label-based analysis: MS1 label-based analysis.
    MS_MS1_label_based_analysis = 1002018,

    /// label-free raw feature quantitation: Label-free raw feature quantitation.
    MS_label_free_raw_feature_quantitation = 1002019,

    /// label-free peptide level quantitation: Label-free peptide level quantitation.
    MS_label_free_peptide_level_quantitation = 1002020,

    /// label-free protein level quantitation: Label-free protein level quantitation.
    MS_label_free_protein_level_quantitation = 1002021,

    /// label-free proteingroup level quantitation: Label-free proteingroup level quantitation.
    MS_label_free_proteingroup_level_quantitation = 1002022,

    /// MS2 tag-based analysis: MS2 tag-based analysis.
    MS_MS2_tag_based_analysis = 1002023,

    /// MS2 tag-based feature level quantitation: MS2 tag-based feature level quantitation.
    MS_MS2_tag_based_feature_level_quantitation = 1002024,

    /// MS2 tag-based peptide level quantitation: MS2 tag-based peptide level quantitation.
    MS_MS2_tag_based_peptide_level_quantitation = 1002025,

    /// MS2 tag-based protein level quantitation: MS2 tag-based protein level quantitation.
    MS_MS2_tag_based_protein_level_quantitation = 1002026,

    /// MS2 tag-based proteingroup level quantitation: MS2 tag-based proteingroup level quantitation.
    MS_MS2_tag_based_proteingroup_level_quantitation = 1002027,

    /// nucleic acid base modification: Nucleic acid base modification (substitution, insertion or deletion).
    MS_nucleic_acid_base_modification = 1002028,

    /// original nucleic acid sequence: Specification of the original nucleic acid sequence, prior to a modification. The value slot should hold the DNA or RNA sequence.
    MS_original_nucleic_acid_sequence = 1002029,

    /// modified nucleic acid sequence: Specification of the modified nucleic acid sequence. The value slot should hold the DNA or RNA sequence.
    MS_modified_nucleic_acid_sequence = 1002030,

    /// PASSEL transition group browser URI: URI to retrieve transition group data for a PASSEL (PeptideAtlas SRM Experiment Library) experiment.
    MS_PASSEL_transition_group_browser_URI = 1002031,

    /// PeptideAtlas dataset URI: URI that allows access to a PeptideAtlas dataset.
    MS_PeptideAtlas_dataset_URI = 1002032,

    /// contact role: Role of the contact person.
    MS_contact_role = 1002033,

    /// first author: The first of a set of authors associated with a publication or release. There may be more than one first author in cases where several authors share primary attribution.
    MS_first_author = 1002034,

    /// senior author: The last of a set of authors associated with a publication or release. There may be more than one senior author in cases where several authors share senior attribution.
    MS_senior_author = 1002035,

    /// co-author: One of a set of authors associated with a publication or release.
    MS_co_author = 1002036,

    /// dataset submitter: A person who submits a dataset to a repository.
    MS_dataset_submitter = 1002037,

    /// unlabeled sample: A sample that has not been labelled or modified. This is often referred to as \"light\" to distinguish from \"heavy\".
    MS_unlabeled_sample = 1002038,

    /// light labeled sample (unlabeled sample): A sample that has not been labelled or modified. This is often referred to as \"light\" to distinguish from \"heavy\".
    MS_light_labeled_sample = MS_unlabeled_sample,

    /// inlet attribute: Inlet properties that are associated with a value.
    MS_inlet_attribute = 1002039,

    /// inlet temperature: The temperature of the inlet of a mass spectrometer.
    MS_inlet_temperature = 1002040,

    /// source temperature: The temperature of the source of a mass spectrometer.
    MS_source_temperature = 1002041,

    /// modulation time: The duration of a complete cycle of modulation in a comprehensive two-dimensional separation system, equals the length of a second dimension chromatogram, i.e., the time between two successive injections into the second column.
    MS_modulation_time = 1002042,

    /// ProteinProspector: ProteinProspector software for data acquisition and analysis.
    MS_ProteinProspector = 1002043,

    /// ProteinProspector:score: The ProteinProspector result 'Score'.
    MS_ProteinProspector_score = 1002044,

    /// ProteinProspector:expectation value: The ProteinProspector result 'Expectation value'.
    MS_ProteinProspector_expectation_value = 1002045,

    /// native source path: The original source path used for directory-based sources.
    MS_native_source_path = 1002046,

    /// MS-GF: MS-GF software used to re-score the peptide-spectrum matches.
    MS_MS_GF = 1002047,

    /// MS-GF+: MS-GF+ software used to analyze the spectra.
    MS_MS_GF_ = 1002048,

    /// MS-GFDB (MS-GF+): MS-GF+ software used to analyze the spectra.
    MS_MS_GFDB = MS_MS_GF_,

    /// MS-GF:RawScore: MS-GF raw score.
    MS_MS_GF_RawScore = 1002049,

    /// MS-GF:DeNovoScore: MS-GF de novo score.
    MS_MS_GF_DeNovoScore = 1002050,

    /// MS-GF:Energy: MS-GF energy score.
    MS_MS_GF_Energy = 1002051,

    /// MS-GF:SpecEValue: MS-GF spectral E-value.
    MS_MS_GF_SpecEValue = 1002052,

    /// MS-GF:EValue: MS-GF E-value.
    MS_MS_GF_EValue = 1002053,

    /// MS-GF:QValue: MS-GF Q-value.
    MS_MS_GF_QValue = 1002054,

    /// MS-GF:PepQValue: MS-GF peptide-level Q-value.
    MS_MS_GF_PepQValue = 1002055,

    /// MS-GF:PEP: MS-GF posterior error probability.
    MS_MS_GF_PEP = 1002056,

    /// modification specificity protein N-term: As parameter for search engine: apply the modification only at the N-terminus of a protein.
    MS_modification_specificity_protein_N_term = 1002057,

    /// modification specificity protein C-term: As parameter for search engine: apply the modification only at the C-terminus of a protein.
    MS_modification_specificity_protein_C_term = 1002058,

    /// Microsoft Excel: Microsoft Excel (can be used for spectral counting).
    MS_Microsoft_Excel = 1002059,

    /// database UniProtKB/TrEMBL: The name of the UniProtKB/TrEMBL database.
    MS_database_UniProtKB_TrEMBL = 1002060,

    /// decoy DB from UniProtKB/TrEMBL: Decoy database from a TrEMBL protein sequence database.
    MS_decoy_DB_from_UniProtKB_TrEMBL_OBSOLETE = 1002061,

    /// metabolic labelling: natural N (mainly 14N): Metabolic labelling: natural N (mainly 14N).
    MS_metabolic_labelling__natural_N__mainly_14N_ = 1002062,

    /// FindPairs: Software e.g. for SILAC and 14N/15N workflow, part of the PeakQuant suite.
    MS_FindPairs = 1002063,

    /// peptide consensus RT: Peptide consensus retention time.
    MS_peptide_consensus_RT = 1002064,

    /// peptide consensus m/z: Peptide consensus mass/charge ratio.
    MS_peptide_consensus_m_z = 1002065,

    /// ratio calculation method: Method used to calculate the ratio.
    MS_ratio_calculation_method = 1002066,

    /// protein value: median of peptide ratios: Protein quantification value calculated as median of peptide ratios.
    MS_protein_value__median_of_peptide_ratios = 1002067,

    /// metabolic labelling: heavy N (mainly 15N): Metabolic labelling: heavy N (mainly 15N).
    MS_metabolic_labelling__heavy_N__mainly_15N_ = 1002068,

    /// metabolic labelling: labelling purity: Metabolic labelling: Description of labelling purity. Usually the purity of feeding material (e.g. 95%), or the inclusion rate derived from isotopic peak pattern shape.
    MS_metabolic_labelling__labelling_purity = 1002069,

    /// t-test: Perform a t-test (two groups). Specify in string value, whether paired / unpaired, variance equal / different, one- / two-sided version is performed.
    MS_t_test = 1002070,

    /// ANOVA-test: Perform an ANOVA-test (more than two groups). Specify in string value, which version is performed.
    MS_ANOVA_test = 1002071,

    /// p-value: P-value as result of one of the processing steps described. Specify in the description, which processing step it was.
    MS_p_value = 1002072,

    /// mzIdentML format: The mzIdentML format for peptide and protein identification data from the PSI. File extension '.mzid'.
    MS_mzIdentML_format = 1002073,

    /// quantification file format: File format containing quantification results.
    MS_quantification_file_format = 1002074,

    /// mzQuantML format: The mzQuantML format for quantification data from the PSI. File extension '.mzq'.
    MS_mzQuantML_format = 1002075,

    /// PAnalyzer: PAnalyzer software for getting protein evidence categories.
    MS_PAnalyzer = 1002076,

    /// impact: Bruker Daltonics' impact: ESI Q-TOF, Nanospray, APCI, APPI, GC-APCI, CaptiveSpray.
    MS_impact = 1002077,

    /// ProteomeDiscoverer:1. Static Modification: Determine 1st static post-translational modifications (PTMs).
    MS_ProteomeDiscoverer_1__Static_Modification = 1002078,

    /// ProteomeDiscoverer:2. Static Modification: Determine 2nd static post-translational modifications (PTMs).
    MS_ProteomeDiscoverer_2__Static_Modification = 1002079,

    /// ProteomeDiscoverer:Spectrum Selector:Precursor Clipping Range Before: Precursor clipping range before.
    MS_ProteomeDiscoverer_Spectrum_Selector_Precursor_Clipping_Range_Before = 1002080,

    /// ProteomeDiscoverer:Spectrum Selector:Precursor Clipping Range After: Precursor clipping range after.
    MS_ProteomeDiscoverer_Spectrum_Selector_Precursor_Clipping_Range_After = 1002081,

    /// first column elution time: The time of elution from the first chromatographic column in the chromatographic separation step, relative to the start of chromatography on the first column.
    MS_first_column_elution_time = 1002082,

    /// second column elution time: The time of elution from the second chromatographic column in the chromatographic separation step, relative to the start of the chromatography on the second column.
    MS_second_column_elution_time = 1002083,

    /// multidimensional chromatography modulation description: Multidimensional chromatography modulation description.
    MS_multidimensional_chromatography_modulation_description = 1002084,

    /// two-dimensional gas chromatography with fixed modulation time: Two-dimensional gas chromatography where a single modulation time is used throughout the acquisition.
    MS_two_dimensional_gas_chromatography_with_fixed_modulation_time = 1002085,

    /// two-dimensional gas chromatography with discrete modulation time steps: Two-dimensional gas chromatography where the acquisition is divided into steps, each with a different modulation time.
    MS_two_dimensional_gas_chromatography_with_discrete_modulation_time_steps = 1002086,

    /// two-dimensional liquid chromatography with fixed modulation time: Two-dimensional liquid chromatography where a single modulation time is used throughout the acquisition.
    MS_two_dimensional_liquid_chromatography_with_fixed_modulation_time = 1002087,

    /// two-dimensional liquid chromatography with discrete modulation time steps: Two-dimensional liquid chromatography where the acquisition is divided into steps, each with a different modulation time.
    MS_two_dimensional_liquid_chromatography_with_discrete_modulation_time_steps = 1002088,

    /// ProteomeDiscoverer:Peptide Without Protein XCorr Threshold: XCorr threshold for storing peptides that do not belong to a protein.
    MS_ProteomeDiscoverer_Peptide_Without_Protein_XCorr_Threshold = 1002089,

    /// Calculate Probability Scores: Flag indicating that a probability score for the assessment that a reported peptide match is a random occurence is calculated.
    MS_Calculate_Probability_Scores = 1002090,

    /// ProteomeDiscoverer:Maximum Delta Cn: Delta Cn threshold for filtering out PSM's.
    MS_ProteomeDiscoverer_Maximum_Delta_Cn = 1002091,

    /// Percolator:Validation based on: Algorithm (e.g. q-value or PEP) used for calculation of the validation score using Percolator.
    MS_Percolator_Validation_based_on = 1002092,

    /// search engine input parameter: Search engine input parameter.
    MS_search_engine_input_parameter = 1002093,

    /// common search engine input parameter: Search engine input parameter that is shared by more than one search engine.
    MS_common_search_engine_input_parameter = 1002094,

    /// Mascot input parameter: Search engine input parameters specific to Mascot.
    MS_Mascot_input_parameter = 1002095,

    /// SEQUEST input parameter: Search engine input parameters specific to SEQUEST.
    MS_SEQUEST_input_parameter = 1002096,

    /// Phenyx input parameter: Search engine input parameters specific to Phenyx.
    MS_Phenyx_input_parameter = 1002097,

    /// ProteinExtractor input parameter: Search engine input parameters specific to ProteinExtractor.
    MS_ProteinExtractor_input_parameter = 1002098,

    /// OMSSA input parameter: Search engine input parameters specific to OMSSA.
    MS_OMSSA_input_parameter = 1002099,

    /// ProteinScape input parameter: Search engine input parameters specific to ProteinScape.
    MS_ProteinScape_input_parameter = 1002100,

    /// ProteomeDiscoverer input parameter: Search engine input parameters specific to ProteomeDiscoverer.
    MS_ProteomeDiscoverer_input_parameter = 1002101,

    /// software input parameter: Software input parameters.
    MS_software_input_parameter = 1002103,

    /// common software input parameter: Software input parameter that is shared by more than one software.
    MS_common_software_input_parameter = 1002104,

    /// software specific input parameter: Software specific input parameter.
    MS_software_specific_input_parameter = 1002105,

    /// Scaffold input parameter: Search engine input parameters specific to Scaffold.
    MS_Scaffold_input_parameter = 1002106,

    /// Percolator input parameter: Search engine input parameters specific to Percolator.
    MS_Percolator_input_parameter = 1002107,

    /// higher score better: Indicates that a higher score is better.
    MS_higher_score_better = 1002108,

    /// lower score better: Indicates that a lower score is better.
    MS_lower_score_better = 1002109,

    /// assay attribute: Attribute describing an assay.
    MS_assay_attribute = 1002110,

    /// assay label attribute: Attribute describing an assay label.
    MS_assay_label_attribute = 1002111,

    /// protein group list attribute: Attribute describing a protein group list.
    MS_protein_group_list_attribute = 1002112,

    /// protein group attribute: Attribute describing a protein group.
    MS_protein_group_attribute = 1002113,

    /// protein list attribute: Attribute describing a protein list.
    MS_protein_list_attribute = 1002114,

    /// peptide consensus list attribute: Attribute describing a peptide consensus list.
    MS_peptide_consensus_list_attribute = 1002115,

    /// peptide consensus attribute: Attribute describing a peptide consensus.
    MS_peptide_consensus_attribute = 1002116,

    /// small molecule list attribute: Attribute describing a small molecule list.
    MS_small_molecule_list_attribute = 1002117,

    /// small molecule attribute: Attribute describing a small molecule.
    MS_small_molecule_attribute = 1002118,

    /// small molecule modification attribute: Attribute describing a small molecule modification.
    MS_small_molecule_modification_attribute = 1002119,

    /// experiment name: The name for identifying an experiment.
    MS_experiment_name = 1002120,

    /// spectral count feature: Dummy decribing a spectral count feature.
    MS_spectral_count_feature = 1002121,

    /// counts reporting: FeatureList of spectral counts.
    MS_counts_reporting = 1002122,

    /// x-Tracker: x-Tracker generic tool for quantitative proteomics.
    MS_x_Tracker = 1002123,

    /// ProteoSuite: ProteoSuite software for the analysis of quantitative proteomics data.
    MS_ProteoSuite = 1002124,

    /// combined FDRScore: FDRScore values specifically obtained for distinct combinations of single, pairs or triplets of search engines making a given PSM, used for integrating results from these distinct pools.
    MS_combined_FDRScore_OBSOLETE = 1002125,

    /// database UniProtKB: The name of the UniProtKB knowledgebase.
    MS_database_UniProtKB = 1002126,

    /// identification file attribute: Attribute describing an identification file.
    MS_identification_file_attribute = 1002127,

    /// method file format: Attribute describing a method file format.
    MS_method_file_format = 1002128,

    /// ITRAQAnalyzer: Software for iTRAQ workflow. Extracts and normalizes iTRAQ information from an MS experiment.
    MS_ITRAQAnalyzer = 1002129,

    /// identification file format: Attribute describing an identification file format.
    MS_identification_file_format = 1002130,

    /// TOPP noise filter: Noise filter component of the TOPP software.
    MS_TOPP_noise_filter = 1002131,

    /// TOPP NoiseFilterGaussian: Removes noise from profile spectra by using a gaussian smoothing.
    MS_TOPP_NoiseFilterGaussian = 1002132,

    /// TOPP NoiseFilterSGolay: Removes noise from profile spectra by using a Savitzky-Golay smoothing.
    MS_TOPP_NoiseFilterSGolay = 1002133,

    /// TOPP peak picker: Peak picker component of the TOPP software.
    MS_TOPP_peak_picker = 1002134,

    /// TOPP PeakPickerHiRes: Finds mass spectrometric peaks in high-resoluted profile mass spectra.
    MS_TOPP_PeakPickerHiRes = 1002135,

    /// TOPP PeakPickerWavelet: Finds mass spectrometric peaks with a wavelet algorithm in low-resoluted profile mass spectra.
    MS_TOPP_PeakPickerWavelet = 1002136,

    /// TOPP spectra filter: Spectra filter component of the TOPP software.
    MS_TOPP_spectra_filter = 1002137,

    /// TOPP SpectraFilterBernNorm: Applies a Bern et al normalization to peak spectra.
    MS_TOPP_SpectraFilterBernNorm = 1002138,

    /// TOPP SpectraFilterMarkerMower: Applies a filter to peak spectra for marked peaks.
    MS_TOPP_SpectraFilterMarkerMower = 1002139,

    /// TOPP SpectraFilterNLargest: Retains the n largest peaks of a peak spectra.
    MS_TOPP_SpectraFilterNLargest = 1002140,

    /// TOPP SpectraFilterNormalizer: Applies a TIC/maximal intensity normalization to peak spectra.
    MS_TOPP_SpectraFilterNormalizer = 1002141,

    /// TOPP SpectraFilterParentPeakMower: Filters putative unfragmented precursor ions from tandem spectra.
    MS_TOPP_SpectraFilterParentPeakMower = 1002142,

    /// TOPP SpectraFilterScaler: Applies a filter to peak spectra after intensity scaling according to rank.
    MS_TOPP_SpectraFilterScaler = 1002143,

    /// TOPP SpectraFilterSqrtMower: Applies a filter to peak spectra after intensity scaling to the square root.
    MS_TOPP_SpectraFilterSqrtMower = 1002144,

    /// TOPP SpectraFilterThresholdMower: Applies a filter of peaks below a given threshold to peak spectra.
    MS_TOPP_SpectraFilterThresholdMower = 1002145,

    /// TOPP SpectraFilterWindowMower: Applies a filter of the largest peaks in a sliding window over a peak spectrum.
    MS_TOPP_SpectraFilterWindowMower = 1002146,

    /// TOPP map aligner: Map aligner component of the TOPP software.
    MS_TOPP_map_aligner = 1002147,

    /// TOPP MapAlignerIdentification: Corrects retention time distortions between maps based on common peptide identifications.
    MS_TOPP_MapAlignerIdentification = 1002148,

    /// TOPP MapAlignerPoseClustering: Corrects retention time distortions between maps using a pose clustering approach.
    MS_TOPP_MapAlignerPoseClustering = 1002149,

    /// TOPP MapAlignerSpectrum: Corrects retention time distortions between maps by spectrum alignment.
    MS_TOPP_MapAlignerSpectrum = 1002150,

    /// numerator data type attribute: Attribute describing the data type of the numerator of a ratio.
    MS_numerator_data_type_attribute = 1002151,

    /// denominator data type attribute: Attribute describing the data type of the denominator of a ratio.
    MS_denominator_data_type_attribute = 1002152,

    /// protein level PSM counts: The number of spectra identified for this protein in spectral counting.
    MS_protein_level_PSM_counts = 1002153,

    /// TOPP DTAExtractor: Extracts spectra of an MS run file to several files in DTA format.
    MS_TOPP_DTAExtractor = 1002154,

    /// TOPP IDMerger: Merges several protein/peptide identification files into one file.
    MS_TOPP_IDMerger = 1002155,

    /// TOPP IDFileConverter: Converts identification engine file formats.
    MS_TOPP_IDFileConverter = 1002156,

    /// TOPP SpectraMerger: Merges spectra from an LC/MS map, either by precursor or by RT blocks.
    MS_TOPP_SpectraMerger = 1002157,

    /// TOPP MzTabExporter: Exports various XML formats to an mzTab file.
    MS_TOPP_MzTabExporter = 1002158,

    /// TOPP MassTraceExtractor: Annotates mass traces in centroided LC/MS maps.
    MS_TOPP_MassTraceExtractor = 1002159,

    /// TOPP PrecursorMassCorrector: Correct the precursor entries of tandem MS scans.
    MS_TOPP_PrecursorMassCorrector = 1002160,

    /// TOPP HighResPrecursorMassCorrector: Performs precursor mz correction on centroided high resolution data.
    MS_TOPP_HighResPrecursorMassCorrector = 1002161,

    /// TOPP AdditiveSeries: Computes an additive series to quantify a peptide in a set of samples.
    MS_TOPP_AdditiveSeries = 1002162,

    /// TOPP Decharger: Decharges and merges different feature charge variants of the same chemical entity.
    MS_TOPP_Decharger = 1002163,

    /// TOPP EICExtractor: Quantifies signals at given positions in (raw or picked) LC/MS maps.
    MS_TOPP_EICExtractor = 1002164,

    /// TOPP feature finder: Feature finder component of the TOPP software.
    MS_TOPP_feature_finder = 1002165,

    /// TOPP FeatureFinderCentroided: Detects two-dimensional features in centroided LC-MS data.
    MS_TOPP_FeatureFinderCentroided = 1002166,

    /// TOPP FeatureFinderRaw: Detects two-dimensional features in uncentroided LC-MS data.
    MS_TOPP_FeatureFinderRaw = 1002167,

    /// TOPP FeatureFinderIsotopeWavelet: Detects two-dimensional features in uncentroided LC-MS data with a wavelet algorithm.
    MS_TOPP_FeatureFinderIsotopeWavelet = 1002168,

    /// TOPP FeatureFinderMetabo: Detects two-dimensional features in centroided LC-MS data of metabolites.
    MS_TOPP_FeatureFinderMetabo = 1002169,

    /// TOPP FeatureFinderMRM: Quantifies features LC-MS/MS MRM data.
    MS_TOPP_FeatureFinderMRM = 1002170,

    /// TOPP ProteinQuantifier: Computes protein abundances from annotated feature/consensus maps.
    MS_TOPP_ProteinQuantifier = 1002171,

    /// TOPP ConsensusMapNormalizer: Normalizes maps of one consensus XML file (after linking).
    MS_TOPP_ConsensusMapNormalizer = 1002172,

    /// TOPP MapRTTransformer: Applies retention time transformations to maps.
    MS_TOPP_MapRTTransformer = 1002173,

    /// TOPP feature linker: Feature linker component of the TOPP software.
    MS_TOPP_feature_linker = 1002174,

    /// TOPP FeatureLinkerLabeled: Groups corresponding isotope-labeled features in a feature map.
    MS_TOPP_FeatureLinkerLabeled = 1002175,

    /// TOPP FeatureLinkerUnlabeled: Groups corresponding features from multiple maps.
    MS_TOPP_FeatureLinkerUnlabeled = 1002176,

    /// TOPP FeatureLinkerUnlabeledQT: Groups corresponding features from multiple maps using a quality threshold clustering approach.
    MS_TOPP_FeatureLinkerUnlabeledQT = 1002177,

    /// TOPP CompNovo: Performs a peptide/protein identification with the CompNovo engine.
    MS_TOPP_CompNovo = 1002178,

    /// TOPP CompNovoCID: Performs a peptide/protein identification with the CompNovo engine in collision-induced dissociation (CID) mode.
    MS_TOPP_CompNovoCID = 1002179,

    /// TOPP software adaptor: Software adaptor to an external program in the TOPP software.
    MS_TOPP_software_adaptor = 1002180,

    /// TOPP InspectAdapter: Identifies MS/MS spectra using the external program Inspect.
    MS_TOPP_InspectAdapter = 1002181,

    /// TOPP MascotAdapter: Identifies MS/MS spectra using the external program Mascot.
    MS_TOPP_MascotAdapter = 1002182,

    /// TOPP MascotAdapterOnline: Identifies MS/MS spectra using the online version of the external program Mascot.
    MS_TOPP_MascotAdapterOnline = 1002183,

    /// TOPP OMSSAAdapter: Identifies MS/MS spectra using the external program OMSSA.
    MS_TOPP_OMSSAAdapter = 1002184,

    /// TOPP PepNovoAdapter: Identifies MS/MS spectra using the external program PepNovo.
    MS_TOPP_PepNovoAdapter = 1002185,

    /// TOPP XTandemAdapter: Identifies MS/MS spectra using the external program XTandem.
    MS_TOPP_XTandemAdapter = 1002186,

    /// TOPP SpecLibSearcher: Identifies peptide MS/MS spectra by spectral matching with a searchable spectral library.
    MS_TOPP_SpecLibSearcher = 1002187,

    /// TOPP ConsensusID: Computes a consensus identification from peptide identifications of several identification engines.
    MS_TOPP_ConsensusID = 1002188,

    /// TOPP IDConflictResolver: Resolves ambiguous annotations of features with peptide identifications.
    MS_TOPP_IDConflictResolver = 1002189,

    /// TOPP IDFilter: Filters results from protein or peptide identification engines based on different criteria.
    MS_TOPP_IDFilter = 1002190,

    /// TOPP IDMapper: Assigns protein/peptide identifications to feature or consensus features.
    MS_TOPP_IDMapper = 1002191,

    /// TOPP IDPosteriorErrorProbability: Estimates posterior error probabilities using a mixture model.
    MS_TOPP_IDPosteriorErrorProbability = 1002192,

    /// TOPP IDRTCalibration: Calibrate Retention times of peptide hits to standards.
    MS_TOPP_IDRTCalibration = 1002193,

    /// TOPP PeptideIndexer: Refreshes the protein references for all peptide hits.
    MS_TOPP_PeptideIndexer = 1002194,

    /// TOPP PrecursorIonSelector: A tool for precursor ion selection based on identification results.
    MS_TOPP_PrecursorIonSelector = 1002195,

    /// TOPP MRMMapper: MRMMapper maps measured chromatograms (mzML) and the transitions used (TraML).
    MS_TOPP_MRMMapper = 1002196,

    /// TOPP OpenSwath component: OpenSwath component of the TOPP software.
    MS_TOPP_OpenSwath_component = 1002197,

    /// TOPP OpenSwathAnalyzer: Picks peaks and finds features in an SRM experiment.
    MS_TOPP_OpenSwathAnalyzer = 1002198,

    /// TOPP OpenSwathChromatogramExtractor: Extract chromatograms (XIC) from a MS2 map file.
    MS_TOPP_OpenSwathChromatogramExtractor = 1002199,

    /// TOPP OpenSwathDecoyGenerator: Generates decoys according to different models for a specific TraML.
    MS_TOPP_OpenSwathDecoyGenerator = 1002200,

    /// TOPP OpenSwathFeatureXMLToTSV: Converts a featureXML to a mProphet tsv (tab separated values).
    MS_TOPP_OpenSwathFeatureXMLToTSV = 1002201,

    /// TOPP OpenSwathRTNormalizer: Generates a transformation file for retention time space into normalized space.
    MS_TOPP_OpenSwathRTNormalizer = 1002202,

    /// TOPP ProteinInference: Infer proteins from a list of (high-confidence) peptides.
    MS_TOPP_ProteinInference = 1002203,

    /// TOPP FalseDiscoveryRate: Estimates the false discovery rate on peptide and protein level using decoy searches.
    MS_TOPP_FalseDiscoveryRate = 1002204,

    /// ProteoWizard msconvert: Converts, filters, and processes mass spectrometry data in variety of formats.
    MS_ProteoWizard_msconvert = 1002205,

    /// ProteoWizard idconvert: Converts, filters, and processes identifications from shotgun proteomics experiments.
    MS_ProteoWizard_idconvert = 1002206,

    /// ProteoWizard chainsaw: Filters and processes protein sequence databases.
    MS_ProteoWizard_chainsaw = 1002207,

    /// ProteoWizard msaccess: Filters, processes, and displays mass spectrometry data in a variety of ways.
    MS_ProteoWizard_msaccess = 1002208,

    /// ProteoWizard SeeMS: An interactive GUI application to view and filter mass spectrometry data in a variety of formats.
    MS_ProteoWizard_SeeMS = 1002209,

    /// IsobariQ: A quantitative software package designed for analysis of IPTL, TMT and iTRAQ data.
    MS_IsobariQ = 1002210,

    /// Variance stabilizing normalization: The model incorporates data calibration (normalization), a model for the dependence of the variance on the mean intensity, and a variance stabilizing data transformation.
    MS_Variance_stabilizing_normalization = 1002211,

    /// IPTL quantitation analysis: Quantification analysis using a labelling strategy where both peptide termini are labelled so that the peptides from different labelling schema are isobaric.
    MS_IPTL_quantitation_analysis = 1002212,

    /// PAnalyzer:conclusive protein: A protein identified by at least one unique (distinct, discrete) peptide (peptides are considered different only if they can be distinguished by evidence in mass spectrum).
    MS_PAnalyzer_conclusive_protein = 1002213,

    /// PAnalyzer:indistinguishable protein: A member of a group of proteins sharing all peptides that are exclusive to the group (peptides are considered different only if they can be distinguished by evidence in mass spectrum).
    MS_PAnalyzer_indistinguishable_protein = 1002214,

    /// PAnalyzer:non-conclusive protein: A protein sharing all its matched peptides with either conclusive or indistinguishable proteins (peptides are considered different only if they can be distinguished by evidence in mass spectrum).
    MS_PAnalyzer_non_conclusive_protein = 1002215,

    /// PAnalyzer:ambiguous group member: A protein sharing at least one peptide not matched to either conclusive or indistinguishable proteins (peptides are considered different only if they can be distinguished by evidence in mass spectrum).
    MS_PAnalyzer_ambiguous_group_member = 1002216,

    /// decoy peptide: A putative identified peptide issued from a decoy sequence database.
    MS_decoy_peptide = 1002217,

    /// percent collision energy ramp start: Collision energy at the start of the collision energy ramp in percent, normalized to the mass of the ion.
    MS_percent_collision_energy_ramp_start = 1002218,

    /// percent collision energy ramp end: Collision energy at the end of the collision energy ramp in percent, normalized to the mass of the ion.
    MS_percent_collision_energy_ramp_end = 1002219,

    /// MRMaid: A web-based SRM assay design tool whose transitions are generated by mining the millions of identified peptide spectra held in the EBI's PRIDE database.
    MS_MRMaid = 1002220,

    /// MRMaid:peptide score: Score in MRMaid to indicate the expected performance of the peptide in SRM.
    MS_MRMaid_peptide_score = 1002221,

    /// SRM transition attribute: Attribute associated with a SRM transition.
    MS_SRM_transition_attribute = 1002222,

    /// precursor ion detection probability: Probability of detecting precursor when parent protein is present.
    MS_precursor_ion_detection_probability = 1002223,

    /// product ion detection probability: Probability of detecting product ion when precursor ion is present.
    MS_product_ion_detection_probability = 1002224,

    /// average product ion intensity: Average value of product ion intensity in a collection of identified spectra.
    MS_average_product_ion_intensity = 1002225,

    /// product ion intensity standard deviation: Standard deviation of product ion intensity in a collection of identified spectra.
    MS_product_ion_intensity_standard_deviation = 1002226,

    /// number of product ion observations: The number of times the specific product ion has been observed in a series of SRM experiments.
    MS_number_of_product_ion_observations = 1002227,

    /// number of precursor ion observations: The number of times the specific precursor ion has been observed in a series of SRM experiments.
    MS_number_of_precursor_ion_observations = 1002228,

    /// ProteomeDiscoverer:Mascot:Significance Middle: Calculated relaxed significance when performing a decoy search for high-confidence peptides.
    MS_ProteomeDiscoverer_Mascot_Significance_Middle = 1002229,

    /// ProteomeDiscoverer:Mascot:Significance High: Calculated relaxed significance when performing a decoy search for medium-confidence peptides.
    MS_ProteomeDiscoverer_Mascot_Significance_High = 1002230,

    /// regular expressions for a GUID: ([A-Fa-f0-9]\{8\}-([A-Fa-f0-9]\{4\}-)\{3\}[A-Fa-f0-9]\{12\}).
    MS_regular_expressions_for_a_GUID = 1002231,

    /// ProteomeDiscoverer:Default FDR calculator: The default FDR calculator as globally unique identifier (GUID).
    MS_ProteomeDiscoverer_Default_FDR_calculator = 1002232,

    /// ProteomeDiscoverer:SEQUEST:Low resolution spectra contained: Flag indicating if low-resolution spectra are taken into consideration.
    MS_ProteomeDiscoverer_SEQUEST_Low_resolution_spectra_contained = 1002233,

    /// selected precursor m/z: Mass-to-charge ratio of a precursor ion selected for fragmentation.
    MS_selected_precursor_m_z = 1002234,

    /// ProteoGrouper:PDH score: A score assigned to a single protein accession (modelled as ProteinDetectionHypothesis in mzIdentML), based on summed peptide level scores.
    MS_ProteoGrouper_PDH_score = 1002235,

    /// ProteoGrouper:PAG score: A score assigned to a protein group (modelled as ProteinAmbiguityGroup in mzIdentML), based on all summed peptide level scores that have been assigned to the group as unique or razor peptides.
    MS_ProteoGrouper_PAG_score = 1002236,

    /// mzidLib: A library of Java routines for manipulating mzIdentML files.
    MS_mzidLib = 1002237,

    /// mzidLib:Omssa2Mzid: A converter for OMSSA OMX to mzIdentML.
    MS_mzidLib_Omssa2Mzid = 1002238,

    /// mzidLib:Tandem2Mzid: A converter for Tandem XML to mzIdentML.
    MS_mzidLib_Tandem2Mzid = 1002239,

    /// mzidLib:Csv2Mzid: A converter for CSV files (following OMSSA CSV style) to mzIdentML.
    MS_mzidLib_Csv2Mzid = 1002240,

    /// mzidLib:ProteoGrouper: A generic and parameterizable protein inference algorithm for mzIdentML files.
    MS_mzidLib_ProteoGrouper = 1002241,

    /// mzidLib:Thresholder: A routine for keeping only identifications passing a given threshold or setting passThreshold to true or false for SpectrumIdentificationItem or ProteinDetectionHypothesis in mzIdentML files.
    MS_mzidLib_Thresholder = 1002242,

    /// mzidLib:Perform emPAI on mzid: A routine for adding emPAI quantitative values to an mzIdentML file.
    MS_mzidLib_Perform_emPAI_on_mzid = 1002243,

    /// mzidLib:FalseDiscoveryRate: A routine for calculating local FDR, q-value and FDRScore for mzIdentML files, based on a decoy search.
    MS_mzidLib_FalseDiscoveryRate = 1002244,

    /// mzidLib:Mzidentml2Csv: A tool for converting mzIdentML files to CSV format.
    MS_mzidLib_Mzidentml2Csv = 1002245,

    /// mzidLib:CombineSearchEngines: A tool for combining results analysed in parallel in two or three search engines into a single mzIdentML file.
    MS_mzidLib_CombineSearchEngines = 1002246,

    /// mzidLib:InsertMetaDataFromFasta: A tool for adding additional meta data from a FASTA file to DBSequence entries (sequence and description) in mzIdentML files.
    MS_mzidLib_InsertMetaDataFromFasta = 1002247,

    /// SEQUEST:spscore: The SEQUEST result 'SpScore'.
    MS_SEQUEST_spscore = 1002248,

    /// SEQUEST:sprank: The SEQUEST result 'SpRank'.
    MS_SEQUEST_sprank = 1002249,

    /// SEQUEST:deltacnstar: The SEQUEST result 'DeltaCnStar'.
    MS_SEQUEST_deltacnstar = 1002250,

    /// Comet: Comet open-source sequence search engine developed at the University of Washington.
    MS_Comet = 1002251,

    /// Comet:xcorr: The Comet result 'XCorr'.
    MS_Comet_xcorr = 1002252,

    /// Comet:deltacn: The Comet result 'DeltaCn'.
    MS_Comet_deltacn = 1002253,

    /// Comet:deltacnstar: The Comet result 'DeltaCnStar'.
    MS_Comet_deltacnstar = 1002254,

    /// Comet:spscore: The Comet result 'SpScore'.
    MS_Comet_spscore = 1002255,

    /// Comet:sprank: The Comet result 'SpRank'.
    MS_Comet_sprank = 1002256,

    /// Comet:expectation value: The Comet result 'Expectation value'.
    MS_Comet_expectation_value = 1002257,

    /// Comet:matched ions: The Comet result 'Matched Ions'.
    MS_Comet_matched_ions = 1002258,

    /// Comet:total ions: The Comet result 'Total Ions'.
    MS_Comet_total_ions = 1002259,

    /// PSM:FDR threshold: False-discovery rate threshold for peptide-spectrum matches.
    MS_PSM_FDR_threshold = 1002260,

    /// Byonic: Byonic search engine from Protein Metrics.
    MS_Byonic = 1002261,

    /// Byonic:Score: The Byonic score is the primary indicator of PSM correctness. The Byonic score reflects the absolute quality of the peptide-spectrum match, not the relative quality compared to other candidate peptides. Byonic scores range from 0 to about 1000, with 300 a good score, 400 a very good score, and PSMs with scores over 500 almost sure to be correct.
    MS_Byonic_Score = 1002262,

    /// Byonic:Delta Score: The drop in Byonic score from the top-scoring peptide to the next peptide with distinct sequence. In this computation, the same peptide with different modifications is not considered distinct.
    MS_Byonic_Delta_Score = 1002263,

    /// Byonic:DeltaMod Score: The drop in Byonic score from the top-scoring peptide to the next peptide different in any way, including placement of modifications. DeltaMod gives an indication of whether modifications are confidently localized; DeltaMod over 10.0 means that there is high likelihood that all modification placements are correct.
    MS_Byonic_DeltaMod_Score = 1002264,

    /// Byonic:PEP: Byonic posterior error probability.
    MS_Byonic_PEP = 1002265,

    /// Byonic:Peptide LogProb: The log p-value of the PSM. This is the log of the probability that the PSM with such a score and delta would arise by chance in a search of this size (size of the protein database, as expanded by the modification rules). A log p-value of -3.0 should happen by chance on only one of a thousand spectra. Caveat: it is very hard to compute a p-value that works for all searches and all spectra, so read Byonic p-values with a certain amount of skepticism.
    MS_Byonic_Peptide_LogProb = 1002266,

    /// Byonic:Protein LogProb: The log p-value of the protein.
    MS_Byonic_Protein_LogProb = 1002267,

    /// Byonic:Best LogProb: Best (most negative) log p-value of an individual PSM.
    MS_Byonic_Best_LogProb = 1002268,

    /// Byonic:Best Score: Best (largest) Byonic score of a PSM.
    MS_Byonic_Best_Score = 1002269,

    /// chromatography separation: A technique by which molecules are separated by chemical and physical properties such as hydrophobicity or vapour pressure.
    MS_chromatography_separation = 1002270,

    /// liquid chromatography separation: Liquid chromatography (LC) is a separation technique in which the mobile phase is a liquid.
    MS_liquid_chromatography_separation = 1002271,

    /// gas chromatography separation: Gas chromatography (GC) is a separation technique in which the mobile phase is a gas.
    MS_gas_chromatography_separation = 1002272,

    /// detector potential: Detector potential difference in volts.
    MS_detector_potential = 1002273,

    /// SQ Detector 2: Waters quadrupole based SQ Detector 2.
    MS_SQ_Detector_2 = 1002274,

    /// Xevo G2-S Tof: Waters oa-ToF based Xevo G2-S Tof.
    MS_Xevo_G2_S_Tof = 1002275,

    /// Xevo G2-S QTof: Waters oa-ToF based Xevo G2-S QTof.
    MS_Xevo_G2_S_QTof = 1002276,

    /// AutoSpec Premier: Waters AutoSpec Premier.
    MS_AutoSpec_Premier = 1002277,

    /// Pegasus III: LECO nominal mass resolution time-of-flight GC mass spectrometer.
    MS_Pegasus_III = 1002278,

    /// maXis 4G: Bruker Daltonics' maXis 4G: ESI Q-TOF, Nanospray, APCI, APPI, GC-APCI, CaptiveSpray.
    MS_maXis_4G = 1002279,

    /// compact: Bruker Daltonics' compact: ESI Q-TOF, Nanospray, APCI, APPI, GC-APCI, CaptiveSpray.
    MS_compact = 1002280,

    /// SRM feature level quantitation: Selected Reaction Monitoring feature level quantitation.
    MS_SRM_feature_level_quantitation = 1002281,

    /// SRM peptide level quantitation: Selected Reaction Monitoring peptide level quantitation.
    MS_SRM_peptide_level_quantitation = 1002282,

    /// SRM protein level quantitation: Selected Reaction Monitoring protein level quantitation.
    MS_SRM_protein_level_quantitation = 1002283,

    /// SRM proteingroup level quantitation: Selected Reaction Monitoring proteingroup level quantitation.
    MS_SRM_proteingroup_level_quantitation = 1002284,

    /// Trans-Proteomic Pipeline: A suite of open source tools for the processing of MS/MS proteomics data developed by the Seattle Proteome Center at the Institute for Systems Biology.
    MS_Trans_Proteomic_Pipeline = 1002285,

    /// TPP (Trans-Proteomic Pipeline): A suite of open source tools for the processing of MS/MS proteomics data developed by the Seattle Proteome Center at the Institute for Systems Biology.
    MS_TPP = MS_Trans_Proteomic_Pipeline,

    /// Trans-Proteomic Pipeline software: A software program that is a component of the Trans-Proteomic Pipeline.
    MS_Trans_Proteomic_Pipeline_software = 1002286,

    /// PeptideProphet: A program in the TPP that calculates PSM probabilities for MS/MS proteomics data searched with any of the supported sequence or spectral library search engines via the pepXML format.
    MS_PeptideProphet = 1002287,

    /// iProphet: A program in the TPP that calculates distinct peptide probabilities based on several lines of corroborating evidence including search results from multiple search engines via the pepXML format.
    MS_iProphet = 1002288,

    /// ProteinProphet: A program in the TPP that calculates protein-level probabilities based on input PSM or peptide-level probabilities from PeptideProphet or iProphet. The output is written in the protXML format.
    MS_ProteinProphet = 1002289,

    /// XPRESS: A program in the TPP that calculates PSM-level abundances based on 2-channel isotope-labelled data such as ICAT, SILAC, etc.
    MS_XPRESS = 1002290,

    /// Libra: A program in the TPP that calculates PSM, peptide, and protein-level abundances based on N-channel isobaric label peptide data such as iTRAQ, TMT, etc.
    MS_Libra = 1002291,

    /// PTMProphet: A program in the TPP that calculates PTM localization probabilities by re-analyzing the peaks that are available to distinguish between possible modification sites.
    MS_PTMProphet = 1002292,

    /// Bruker Daltonics SCION series: Bruker Daltonics' SCION series.
    MS_Bruker_Daltonics_SCION_series = 1002293,

    /// Bruker Daltonics EVOQ series: Bruker Daltonics' EVOQ series.
    MS_Bruker_Daltonics_EVOQ_series = 1002294,

    /// SCION SQ: Bruker Daltonics' SCION SQ: GC-single quadrupole.
    MS_SCION_SQ = 1002295,

    /// SCION TQ: Bruker Daltonics' SCION TQ: GC-triple quadrupole.
    MS_SCION_TQ = 1002296,

    /// EVOQ Elite: Bruker Daltonics' EVOQ Elite: LC-triple quadrupole.
    MS_EVOQ_Elite = 1002297,

    /// EVOQ Qube: Bruker Daltonics' EVOQ Qube: LC-triple quadrupole.
    MS_EVOQ_Qube = 1002298,

    /// micrOTOF-Q III: Bruker Daltonics' micrOTOF-Q III: ESI Q-TOF, Nanospray, APCI, APPI, GC-APCI, CaptiveSpray.
    MS_micrOTOF_Q_III = 1002299,

    /// amaZon Speed ETD: Bruker Daltonics' amaZon Speed ETD: ESI quadrupole ion trap, Nanospray, APCI, APPI, ETD, PTR, GC-APCI, CaptiveSpray.
    MS_amaZon_Speed_ETD = 1002300,

    /// amaZon Speed: Bruker Daltonics' amaZon ETD: ESI quadrupole ion trap, Nanospray, APCI, APPI, GC-APCI, CaptiveSpray.
    MS_amaZon_Speed = 1002301,

    /// Bruker Container format: Bruker Container raw file format.
    MS_Bruker_Container_format = 1002302,

    /// Bruker Container nativeID format: Native identifier (UUID).
    MS_Bruker_Container_nativeID_format = 1002303,

    /// domain range: Domain range of a numerical value.
    MS_domain_range = 1002304,

    /// value between 0 and 1 inclusive: Value range for probabilities.
    MS_value_between_0_and_1_inclusive = 1002305,

    /// value greater than zero: Positive value range.
    MS_value_greater_than_zero = 1002306,

    /// fragmentation ion type: Type of fragment ion based on where the backbone breaks, such as a y ion or a c ion.
    MS_fragmentation_ion_type = 1002307,

    /// fluorescence detector: A detector using a fluorescent signal after excitation with light.
    MS_fluorescence_detector = 1002308,

    /// Byonic: Peptide AbsLogProb: The absolute value of the log-base10 of the Byonic posterior error probability (PEP) of the PSM.
    MS_Byonic__Peptide_AbsLogProb = 1002309,

    /// Byonic: Protein AbsLogProb: The absolute value of the log-base10 of the Byonic posterior error probability (PEP) of the protein.
    MS_Byonic__Protein_AbsLogProb = 1002310,

    /// Byonic: Peptide AbsLogProb2D: The absolute value of the log-base10 Byonic two-dimensional posterior error probability (PEP) of the PSM. The two-dimensional PEP takes into account protein ranking information as well as PSM information.
    MS_Byonic__Peptide_AbsLogProb2D = 1002311,

    /// MS-Numpress linear prediction compression: Compression using MS-Numpress linear prediction compression.
    MS_MS_Numpress_linear_prediction_compression = 1002312,

    /// MS-Numpress positive integer compression: Compression using MS-Numpress positive integer compression.
    MS_MS_Numpress_positive_integer_compression = 1002313,

    /// MS-Numpress short logged float compression: Compression using MS-Numpress short logged float compression.
    MS_MS_Numpress_short_logged_float_compression = 1002314,

    /// consensus result: Indicates a consensus result from several search engine runs.
    MS_consensus_result = 1002315,

    /// ProteomeDiscoverer:Amanda:high confidence threshold: Strict confidence probability score.
    MS_ProteomeDiscoverer_Amanda_high_confidence_threshold = 1002316,

    /// ProteomeDiscoverer:Amanda:middle confidence threshold: Relaxed confidence probability score.
    MS_ProteomeDiscoverer_Amanda_middle_confidence_threshold = 1002317,

    /// ProteomeDiscoverer:automatic workload: Flag indicating automatic estimation of the workload level.
    MS_ProteomeDiscoverer_automatic_workload = 1002318,

    /// Amanda:AmandaScore: The Amanda score of the scoring function for a PSM.
    MS_Amanda_AmandaScore = 1002319,

    /// ProteomeDiscoverer:max differential modifications: Maximum dynamic modifications per PSM.
    MS_ProteomeDiscoverer_max_differential_modifications = 1002320,

    /// ProteomeDiscoverer:max equal modifications: Maximum equal modifications per PSM.
    MS_ProteomeDiscoverer_max_equal_modifications = 1002321,

    /// ProteomeDiscoverer:min peptide length: Minimum peptide length.
    MS_ProteomeDiscoverer_min_peptide_length = 1002322,

    /// ProteomeDiscoverer:max peptide length: Maximum peptide length.
    MS_ProteomeDiscoverer_max_peptide_length = 1002323,

    /// ProteomeDiscoverer:max number neutral loss: Maximum number of same neutral losses.
    MS_ProteomeDiscoverer_max_number_neutral_loss = 1002324,

    /// ProteomeDiscoverer:max number neutral loss modifications: Max number of same neutral losses of modifications.
    MS_ProteomeDiscoverer_max_number_neutral_loss_modifications = 1002325,

    /// ProteomeDiscoverer:use flanking ions: Flag for usage of flanking ions.
    MS_ProteomeDiscoverer_use_flanking_ions = 1002326,

    /// ProteomeDiscoverer:max number of same modifs: The maximum number of possible equal modifications per PSM.
    MS_ProteomeDiscoverer_max_number_of_same_modifs = 1002327,

    /// ProteomeDiscoverer:perform deisotoping: Defines whether a simple deisotoping shall be performed.
    MS_ProteomeDiscoverer_perform_deisotoping = 1002328,

    /// ProteomeDiscoverer:ion settings: Specifies the fragment ions and neutral losses that are calculated.
    MS_ProteomeDiscoverer_ion_settings = 1002329,

    /// ProteomeDiscoverer:3. Static Modification: Determine 3rd static (fixed) post-translational modifications (PTMs).
    MS_ProteomeDiscoverer_3__Static_Modification = 1002330,

    /// ProteomeDiscoverer:5. Dynamic Modification: Determine 5th dynamic (variable) post-translational modifications (PTMs).
    MS_ProteomeDiscoverer_5__Dynamic_Modification = 1002331,

    /// lab head: The scientist responsible for personnel, grants, and instrumentation in a functional laboratory group.
    MS_lab_head = 1002332,

    /// conversion software: Computer software primarily designed to convert data represented in one format to another format, sometimes with minor data alterations in the process.
    MS_conversion_software = 1002333,

    /// ProCon: Java software designed to convert one of several proteomics identification results formats into mzIdentML or PRIDE XML.
    MS_ProCon = 1002334,

    /// PRIDE Converter2: Java software designed to convert one of several proteomics identification results formats into PRIDE XML.
    MS_PRIDE_Converter2 = 1002335,

    /// Amanda: Amanda scoring system for PSM identification.
    MS_Amanda = 1002336,

    /// Andromeda: Andromeda is a peptide search engine.
    MS_Andromeda = 1002337,

    /// Andromeda:score: The probability based score of the Andromeda search engine.
    MS_Andromeda_score = 1002338,

    /// site:global FDR: Estimation of global false discovery rate of peptides with a post-translational modification.
    MS_site_global_FDR = 1002339,

    /// ProteomeXchange project tag: Tag that can be added to a ProteomeXchange dataset, to enable the grouping of datasets. One tag can be used for indicating that a given dataset is part of a bigger project, like e.g. the Human Proteome Project.
    MS_ProteomeXchange_project_tag = 1002340,

    /// second-pass peptide identification: A putative identified peptide found in a second-pass search of protein sequences selected from a first-pass search.
    MS_second_pass_peptide_identification = 1002341,

    /// MZmine: A framework for differential analysis of mass spectrometry data.
    MS_MZmine = 1002342,

    /// ion stability type: Stability type of the ion.
    MS_ion_stability_type = 1002343,

    /// Maltcms: Modular Application Toolkit for Chromatography Mass-Spectrometry is an application framework mainly for developers.
    MS_Maltcms = 1002344,

    /// PSM-level result details: Peptide spectrum match level information.
    MS_PSM_level_result_details = 1002345,

    /// protein group-level result details: Protein group level information.
    MS_protein_group_level_result_details = 1002346,

    /// PSM-level identification confidence metric: Identification confidence metric for a peptide spectrum match.
    MS_PSM_level_identification_confidence_metric = 1002347,

    /// protein group-level identification confidence metric: Identification confidence metric for a protein group.
    MS_protein_group_level_identification_confidence_metric = 1002348,

    /// value greater than zero but less than or equal to one: Positive value range less than or equal to 1.
    MS_value_greater_than_zero_but_less_than_or_equal_to_one = 1002349,

    /// PSM-level global FDR: Estimation of the global false discovery rate of peptide spectrum matches.
    MS_PSM_level_global_FDR = 1002350,

    /// PSM-level local FDR: Estimation of the local false discovery rate of peptide spectrum matches.
    MS_PSM_level_local_FDR = 1002351,

    /// PSM-level p-value: Estimation of the p-value for peptide spectrum matches.
    MS_PSM_level_p_value = 1002352,

    /// PSM-level e-value: Estimation of the e-value for peptide spectrum matches.
    MS_PSM_level_e_value = 1002353,

    /// PSM-level q-value: Estimation of the q-value for peptide spectrum matches.
    MS_PSM_level_q_value = 1002354,

    /// PSM-level FDRScore: FDRScore for peptide spectrum matches.
    MS_PSM_level_FDRScore = 1002355,

    /// PSM-level combined FDRScore: Combined FDRScore for peptide spectrum matches specifically obtained for distinct combinations of single, pairs or triplets of search engines making a given PSM, used for integrating results from these distinct pools.
    MS_PSM_level_combined_FDRScore = 1002356,

    /// PSM-level probability: Probability that the reported peptide ion is truly responsible for some or all of the components of the specified mass spectrum.
    MS_PSM_level_probability = 1002357,

    /// search engine specific score for distinct peptides: Search engine specific distinct peptide score.
    MS_search_engine_specific_score_for_distinct_peptides = 1002358,

    /// distinct peptide-level local FDR: Estimation of the local false discovery rate for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).
    MS_distinct_peptide_level_local_FDR = 1002359,

    /// distinct peptide-level FDRScore: FDRScore for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).
    MS_distinct_peptide_level_FDRScore = 1002360,

    /// distinct peptide-level combined FDRScore: Combined FDRScore for peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry) specifically obtained for distinct combinations of single, pairs or triplets of search engines making a given peptide, used for integrating results from these distinct pools.
    MS_distinct_peptide_level_combined_FDRScore = 1002361,

    /// distinct peptide-level probability: Probability that the reported distinct peptide sequence (irrespective of mass modifications) has been correctly identified via the referenced PSMs.
    MS_distinct_peptide_level_probability = 1002362,

    /// search engine specific score for proteins: Search engine specific protein scores.
    MS_search_engine_specific_score_for_proteins = 1002363,

    /// protein-level local FDR: Estimation of the local false discovery rate of proteins.
    MS_protein_level_local_FDR = 1002364,

    /// FDRScore for proteins: FDRScore for proteins specifically obtained for distinct combinations of single, pairs or triplets of search engines making a given PSM, used for integrating results from these distinct pools.
    MS_FDRScore_for_proteins = 1002365,

    /// combined FDRScore for proteins: Combined FDRScore for proteins.
    MS_combined_FDRScore_for_proteins = 1002366,

    /// probability for proteins: Probability that a specific protein sequence has been correctly identified from the PSM and distinct peptide evidence, and based on the available protein sequences presented to the analysis software.
    MS_probability_for_proteins = 1002367,

    /// search engine specific score for protein groups: Search engine specific protein group scores.
    MS_search_engine_specific_score_for_protein_groups = 1002368,

    /// protein group-level global FDR: Estimation of the global false discovery rate of protein groups.
    MS_protein_group_level_global_FDR = 1002369,

    /// protein group-level local FDR: Estimation of the local false discovery rate of protein groups.
    MS_protein_group_level_local_FDR = 1002370,

    /// protein group-level p-value: Estimation of the p-value for protein groups.
    MS_protein_group_level_p_value = 1002371,

    /// protein group-level e-value: Estimation of the e-value for protein groups.
    MS_protein_group_level_e_value = 1002372,

    /// protein group-level q-value: Estimation of the q-value for protein groups.
    MS_protein_group_level_q_value = 1002373,

    /// protein group-level FDRScore: FDRScore for protein groups.
    MS_protein_group_level_FDRScore = 1002374,

    /// protein group-level combined FDRScore: Combined FDRScore for proteins specifically obtained for distinct combinations of single, pairs or triplets of search engines making a given PSM, used for integrating results from these distinct pools.
    MS_protein_group_level_combined_FDRScore = 1002375,

    /// protein group-level probability: Probability that at least one of the members of a group of protein sequences has been correctly identified from the PSM and distinct peptide evidence, and based on the available protein sequences presented to the analysis software.
    MS_protein_group_level_probability = 1002376,

    /// ProteomeDiscoverer:Relaxed Score Threshold: Specifies the threshold value for relaxed scoring.
    MS_ProteomeDiscoverer_Relaxed_Score_Threshold = 1002377,

    /// ProteomeDiscoverer:Strict Score Threshold: Specifies the threshold value for strict scoring.
    MS_ProteomeDiscoverer_Strict_Score_Threshold = 1002378,

    /// ProteomeDiscoverer:Peptide Without Protein Cut Off Score: Cut off score for storing peptides that do not belong to a protein.
    MS_ProteomeDiscoverer_Peptide_Without_Protein_Cut_Off_Score = 1002379,

    /// false localization rate: Estimation of the false localization rate for modification site assignment.
    MS_false_localization_rate = 1002380,

    /// MALDI Solutions LC-MALDI: Software for automated LC-MALDI analysis and reporting.
    MS_MALDI_Solutions_LC_MALDI = 1002381,

    /// Shimadzu MALDI-7090: Shimadzu MALDI-7090: MALDI-TOF-TOF.
    MS_Shimadzu_MALDI_7090 = 1002382,

    /// SCiLS software: SCiLS software for data acquisition and analysis.
    MS_SCiLS_software = 1002383,

    /// SCiLS Lab: SCiLS Lab software.
    MS_SCiLS_Lab = 1002384,

    /// SCiLS Lab format: SCiLS Lab file format.
    MS_SCiLS_Lab_format = 1002385,

    /// preprocessing software: Preprocessing software.
    MS_preprocessing_software = 1002386,

    /// PIA: PIA - Protein Inference Algorithms, a toolbox for protein inference and identification analysis.
    MS_PIA = 1002387,

    /// PIA XML format: A compilation of search engine results in the PIA XML format.
    MS_PIA_XML_format = 1002388,

    /// PIA workflow parameter: A parameter set for a single PIA analysis.
    MS_PIA_workflow_parameter = 1002389,

    /// PIA:FDRScore calculated: Indicates whether the FDR score was calculated for the input file.
    MS_PIA_FDRScore_calculated = 1002390,

    /// PIA:Combined FDRScore calculated: Indicates whether the combined FDR score was calculated for the PIA compilation.
    MS_PIA_Combined_FDRScore_calculated = 1002391,

    /// PIA:PSM sets created: Indicates whether PSM sets were created.
    MS_PIA_PSM_sets_created = 1002392,

    /// PIA:used top identifications for FDR: The number of top identifications per spectrum used for the FDR calculation, 0 means all.
    MS_PIA_used_top_identifications_for_FDR = 1002393,

    /// PIA:protein score: The score given to a protein by any protein inference.
    MS_PIA_protein_score = 1002394,

    /// PIA:protein inference: The used algorithm for the protein inference using PIA.
    MS_PIA_protein_inference = 1002395,

    /// PIA:protein inference filter: A filter used by PIA for the protein inference.
    MS_PIA_protein_inference_filter = 1002396,

    /// PIA:protein inference scoring: The used scoring method for the protein inference using PIA.
    MS_PIA_protein_inference_scoring = 1002397,

    /// PIA:protein inference used score: The used base score for the protein inference using PIA.
    MS_PIA_protein_inference_used_score = 1002398,

    /// PIA:protein inference used PSMs: The method to determine the PSMs used for scoring by the protein inference.
    MS_PIA_protein_inference_used_PSMs = 1002399,

    /// PIA:filter: A filter used for the report generation.
    MS_PIA_filter = 1002400,

    /// leading protein: At least one protein within each group should be annotated as a leading protein to indicate it has the strongest evidence, or approximately equal evidence as other group members.
    MS_leading_protein = 1002401,

    /// non-leading protein: Zero to many proteins within each group should be annotated as non-leading to indicate that other proteins have stronger evidence.
    MS_non_leading_protein = 1002402,

    /// group representative: An arbitrary and optional flag applied to exactly one protein per group to indicate it can serve as the representative of the group, amongst leading proteins, in effect serving as a tiebreaker for approaches that require exactly one group representative.
    MS_group_representative = 1002403,

    /// count of identified proteins: The number of proteins that have been identified, which must match the number of groups that pass the threshold in the file.
    MS_count_of_identified_proteins = 1002404,

    /// protein cluster details: Details describing a protein cluster.
    MS_protein_cluster_details = 1002405,

    /// count of identified clusters: The number of protein clusters that have been identified, which must match the number of clusters that pass the threshold in the file.
    MS_count_of_identified_clusters = 1002406,

    /// cluster identifier: An identifier applied to protein groups to indicate that they are linked by shared peptides.
    MS_cluster_identifier = 1002407,

    /// number of distinct protein sequences: The number of protein clusters that have been identified, which must match the number of clusters that pass the threshold in the file.
    MS_number_of_distinct_protein_sequences = 1002408,

    /// marginally distinguished protein: Assigned to a non-leading protein that has some independent evidence to support its presence relative to the leading protein(s), e.g. the protein may have a unique peptide but not sufficient to be promoted as a leading protein of another group.
    MS_marginally_distinguished_protein = 1002409,

    /// Anubis: Anubis software for selected reaction monitoring data.
    MS_Anubis = 1002410,

    /// TraML format: The TraML format for transitions in SRM from the PSI. File extension '.TraML'.
    MS_TraML_format = 1002411,

    /// total XIC area: Summed area of all the extracted ion chromatogram for the peptide (e.g. of all the transitions in SRM).
    MS_total_XIC_area = 1002412,

    /// product background: The background area for the quantified transition.
    MS_product_background = 1002413,

    /// postprocessing software: Postprocessing software.
    MS_postprocessing_software = 1002414,

    /// protein group passes threshold: A Boolean attribute to determine whether the protein group has passed the threshold indicated in the file.
    MS_protein_group_passes_threshold = 1002415,

    /// Orbitrap Fusion: Thermo Scientific Orbitrap Fusion.
    MS_Orbitrap_Fusion = 1002416,

    /// Orbitrap Fusion ETD: Thermo Scientific Orbitrap Fusion with ETD.
    MS_Orbitrap_Fusion_ETD = 1002417,

    /// TSQ Quantiva: Thermo Scientific TSQ Quantiva MS.
    MS_TSQ_Quantiva = 1002418,

    /// TSQ Endura: Thermo Scientific TSQ Endura MS.
    MS_TSQ_Endura = 1002419,

    /// PASSEL experiment URI: URI that allows access to a PASSEL experiment.
    MS_PASSEL_experiment_URI = 1002420,

    /// Paragon input parameter: Search engine input parameters specific to Paragon.
    MS_Paragon_input_parameter = 1002421,

    /// Paragon: sample type: The Paragon method setting indicating the type of sample at the high level, generally meaning the type of quantitation labelling or lack thereof. 'Identification' is indicated for samples without any labels for quantitation.
    MS_Paragon__sample_type = 1002422,

    /// Paragon: cysteine alkylation: The Paragon method setting indicating the actual cysteine alkylation agent; 'None' is indicated if there was no cysteine alkylation.
    MS_Paragon__cysteine_alkylation = 1002423,

    /// Paragon: instrument setting: The Paragon method setting (translating to a large number of lower level settings) indicating the instrument used or a category of instrument.
    MS_Paragon__instrument_setting = 1002424,

    /// Paragon: search effort: The Paragon method setting that controls the two major modes of search effort of the Paragon algorithm: the Rapid mode uses a conventional database search, while the Thorough mode uses a hybrid search, starting with the same approach as the Rapid mode but then follows it with a separate tag-based approach enabling a more extensive search.
    MS_Paragon__search_effort = 1002425,

    /// Paragon: ID focus: A Paragon method setting that allows the inclusion of large sets of features such as biological modification or substitutions.
    MS_Paragon__ID_focus = 1002426,

    /// Paragon: FDR analysis: The Paragon method setting that controls whether FDR analysis is conducted.
    MS_Paragon__FDR_analysis = 1002427,

    /// Paragon: quantitation: The Paragon method setting that controls whether quantitation analysis is conducted.
    MS_Paragon__quantitation = 1002428,

    /// Paragon: background correction: The Paragon method setting that controls whether the 'Background Correction' analysis is conducted; this processing estimates a correction to the attenuation in extremity ratios that can occur in isobaric quantatitation workflows on complex samples.
    MS_Paragon__background_correction = 1002429,

    /// Paragon: bias correction: The Paragon method setting that controls whether 'Bias Correction' is invoked in quantitation analysis; this correction is a normalization to set the central tendency of protein ratios to unity.
    MS_Paragon__bias_correction = 1002430,

    /// Paragon: channel to use as denominator in ratios: The Paragon method setting that controls which label channel is used as the denominator in calculating relative expression ratios.
    MS_Paragon__channel_to_use_as_denominator_in_ratios = 1002431,

    /// search engine specific input metadata: Search engine specific metadata that are not user-controlled settings.
    MS_search_engine_specific_input_metadata = 1002432,

    /// Paragon: modified data dictionary or parameter translation: This metric detects if any changes have been made to the originally installed key control files for the software; if no changes have been made, then the software version and settings are sufficient to enable exact reproduction; if changes have been made, then the modified ParameterTranslation- and ProteinPilot DataDictionary-XML files much also be provided in order to exactly reproduce a result.
    MS_Paragon__modified_data_dictionary_or_parameter_translation = 1002433,

    /// number of spectra searched: Number of spectra in a search.
    MS_number_of_spectra_searched = 1002434,

    /// data processing start time: The time that a data processing action was started.
    MS_data_processing_start_time = 1002435,

    /// Paragon: digestion: The Paragon method setting indicating the actual digestion agent - unlike other search tools, this setting does not include options that control partial specificity like 'semitrypsin'; if trypsin is used, trypsin is set, and partially conforming peptides are found in the Thorough mode of search; 'None' should be indicated only if there was really no digestion done.
    MS_Paragon__digestion = 1002436,

    /// number of decoy sequences: The number of decoy sequences, if the concatenated target-decoy approach is used.
    MS_number_of_decoy_sequences = 1002437,

    /// spectrum identification list result details: Information about the list of PSMs (SpectrumIdentificationList).
    MS_spectrum_identification_list_result_details = 1002438,

    /// final PSM list UNDER DISCUSSION: A flag on a list of PSMs (SpectrumIdentificationList) to indicate that this is the final set of identifications to be interpreted by consuming software. Amongst the set of SpectrumIdentificationList(s) that are flagged with the term, each spectrum must not be referenced from more than one SpectrumIdentificationResult.
    MS_final_PSM_list_UNDER_DISCUSSION = 1002439,

    /// intermediate PSM list UNDER DISCUSSION: A flag on a list of PSMs (SpectrumIdentificationList) to indicate that this is not the final set of identifications to be interpreted by consuming software. This term should be used when results are provided from multiple search engines for the results from each search engine before they are combined to give consensus identifications. Amongst the set of SpectrumIdentificationList(s) that are flagged with the term, each spectrum may be referenced from more than one SpectrumIdentificationResult.
    MS_intermediate_PSM_list_UNDER_DISCUSSION = 1002440,

    /// Andi-MS format: AIA Analytical Data Interchange file format for mass spectrometry data.
    MS_Andi_MS_format = 1002441,

    /// chromatograph file format: The format of the chromatography file being used. This could be a instrument or vendor specific proprietary file format or a converted open file format.
    MS_chromatograph_file_format = 1002442,

    /// Andi-CHROM format: AIA Analytical Data Interchange file format for chromatography data.
    MS_Andi_CHROM_format = 1002443,

    /// 6420 Triple Quadrupole LC/MS: The 6420 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer.
    MS_6420_Triple_Quadrupole_LC_MS = 1002444,

    /// 6460 Triple Quadrupole LC/MS: The 6460 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer. It is similar to the 6420 but adds Agilent Jet Stream (AJS) technology to increase sensitivity.
    MS_6460_Triple_Quadrupole_LC_MS = 1002445,

    /// 6490 Triple Quadrupole LC/MS: The 6490 Quadrupole LC/MS system is a Agilent liquid chromatography instrument combined with a Agilent triple quadrupole mass spectrometer. It is similar to the 6420 but adds the Agilent iFunnel technology to increase sensitivity.
    MS_6490_Triple_Quadrupole_LC_MS = 1002446,

    /// Paragon:special factor: The Paragon method setting indicating a list of one or more 'special factors', which generally capture secondary effects (relative to other settings) as a set of probabilities of modification features that override the assumed levels. For example the 'gel-based ID' special factor causes an increase probability of oxidation on several resides because of the air exposure impact on a gel, in addition to other effects.
    MS_Paragon_special_factor = 1002447,

    /// PEAKS:inChorusPeptideScore: The PEAKS inChorus peptide score.
    MS_PEAKS_inChorusPeptideScore = 1002448,

    /// PEAKS:inChorusProteinScore: The PEAKS inChorus protein score.
    MS_PEAKS_inChorusProteinScore = 1002449,

    /// param: b ion-H3PO4 DEPRECATED: Ion b-H3PO4: b ion with lost phosphoric acid.
    MS_param__b_ion_H3PO4_DEPRECATED = 1002450,

    /// param: y ion-H3PO4 DEPRECATED: Ion y-H3PO4: y ion with lost phosphoric acid.
    MS_param__y_ion_H3PO4_DEPRECATED = 1002451,

    /// Maui: The Maltcms Graphical User Interface.
    MS_Maui = 1002452,

    /// No fixed modifications searched: No fixed modifications are included as a parameter for the search, and therefore they are not reported.
    MS_No_fixed_modifications_searched = 1002453,

    /// No variable modifications searched: No variable modifications are included as a parameter for the search, and therefore they are not reported.
    MS_No_variable_modifications_searched = 1002454,

    /// H2O neutral loss: Neutral loss of water.
    MS_H2O_neutral_loss = 1002455,

    /// NH3 neutral loss: Neutral loss of ammonia.
    MS_NH3_neutral_loss = 1002456,

    /// H3PO4 neutral loss: Neutral loss of phosphoric acid.
    MS_H3PO4_neutral_loss = 1002457,

    /// PeptideShaker: PeptideShaker is a software for the interpretation of proteomics identification results.
    MS_PeptideShaker = 1002458,

    /// MS Amanda csv format: MS Amanda csv output format.
    MS_MS_Amanda_csv_format = 1002459,

    /// protein group-level global FNR: Estimation of the global false negative rate of protein groups.
    MS_protein_group_level_global_FNR = 1002460,

    /// protein group-level confidence: Estimation of the global confidence of protein groups.
    MS_protein_group_level_confidence = 1002461,

    /// distinct peptide-level global FNR: Estimation of the global false negative rate for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).
    MS_distinct_peptide_level_global_FNR = 1002462,

    /// distinct peptide-level global confidence: Estimation of the global confidence for distinct peptides once redundant identifications of the same peptide have been removed (id est multiple PSMs have been collapsed to one entry).
    MS_distinct_peptide_level_global_confidence = 1002463,

    /// PSM-level global FNR: Estimation of the global false negative rate of peptide spectrum matches.
    MS_PSM_level_global_FNR = 1002464,

    /// PSM-level global confidence: Estimation of the global confidence of peptide spectrum matches.
    MS_PSM_level_global_confidence = 1002465,

    /// PeptideShaker PSM score: The probability based PeptideShaker PSM score.
    MS_PeptideShaker_PSM_score = 1002466,

    /// PeptideShaker PSM confidence: The probability based PeptideShaker PSM confidence.
    MS_PeptideShaker_PSM_confidence = 1002467,

    /// PeptideShaker peptide score: The probability based PeptideShaker peptide score.
    MS_PeptideShaker_peptide_score = 1002468,

    /// PeptideShaker peptide confidence: The probability based PeptideShaker peptide confidence.
    MS_PeptideShaker_peptide_confidence = 1002469,

    /// PeptideShaker protein group score: The probability based PeptideShaker protein group score.
    MS_PeptideShaker_protein_group_score = 1002470,

    /// PeptideShaker protein group confidence: The probability based PeptideShaker protein group confidence.
    MS_PeptideShaker_protein_group_confidence = 1002471,

    /// trap-type collision-induced dissociation: A collision-induced dissociation process that occurs in a trap-type collision cell.
    MS_trap_type_collision_induced_dissociation = 1002472,

    /// ion series considered in search: The description of the ion fragment series (including charges and neutral losses) that are considered by the search engine.
    MS_ion_series_considered_in_search = 1002473,

    /// ProteoAnnotator:non-canonical gene model score: The sum of peptide-level scores for peptides mapped only to non-canonical gene models within the group.
    MS_ProteoAnnotator_non_canonical_gene_model_score = 1002474,

    /// ProteoAnnotator:count alternative peptides: The count of the number of peptide sequences mapped to non-canonical gene models only within the group.
    MS_ProteoAnnotator_count_alternative_peptides = 1002475,

    /// ion mobility drift time: Drift time of an ion or spectrum of ions as measured in an ion mobility mass spectrometer. This time might refer to the central value of a bin into which all ions within a narrow range of drift time have been aggregated.
    MS_ion_mobility_drift_time = 1002476,

    /// mean drift time array: Array of drift times, averaged from a matrix of binned m/z and drift time values, corresponding to spectrum of individual peaks encoded with an m/z array.
    MS_mean_drift_time_array = 1002477,

    /// mean charge array: Array of mean charge values where the mean charge is calculated as a weighted mean of the charges of individual peaks that are aggregated into a processed spectrum.
    MS_mean_charge_array = 1002478,

    /// regular expression: Regular expression.
    MS_regular_expression = 1002479,

    /// regular expression for a digital object identifier (DOI): (10[.][0-9]\{4,\}(?:[.][0-9]+)*/(?:(?!["&\'<>])\S)+).
    MS_regular_expression_for_a_digital_object_identifier__DOI_ = 1002480,

    /// higher energy beam-type collision-induced dissociation: A collision-induced dissociation process wherein the projectile ion has the translational energy higher than approximately 1000 eV.
    MS_higher_energy_beam_type_collision_induced_dissociation = 1002481,

    /// statistical threshold: Estimated statistical threshold.
    MS_statistical_threshold = 1002482,

    /// PSM-level statistical threshold: Estimated statistical threshold at PSM-level.
    MS_PSM_level_statistical_threshold = 1002483,

    /// peptide-level statistical threshold: Estimated statistical threshold at peptide-level.
    MS_peptide_level_statistical_threshold = 1002484,

    /// protein-level statistical threshold: Estimated statistical threshold at protein-level.
    MS_protein_level_statistical_threshold = 1002485,

    /// protein group-level statistical threshold: Estimated statistical threshold at protein group-level.
    MS_protein_group_level_statistical_threshold = 1002486,

    /// MassIVE dataset identifier: Dataset identifier issued by the MassIVE repository. A dataset can refer to either a single sample as part of a study, or all samples that are part of the study corresponding to a publication.
    MS_MassIVE_dataset_identifier = 1002487,

    /// MassIVE dataset URI: URI that allows the access to one dataset in the MassIVE repository. A dataset can refer to either a single sample as part of a study, or all samples that are part of the study corresponding to a publication.
    MS_MassIVE_dataset_URI = 1002488,

    /// special processing: Details describing a special processing.
    MS_special_processing = 1002489,

    /// peptide-level scoring: Peptide-level scoring performed.
    MS_peptide_level_scoring = 1002490,

    /// modification localization scoring: Modification localization scoring performed.
    MS_modification_localization_scoring = 1002491,

    /// consensus scoring: Consensus multiple search engine approach performed.
    MS_consensus_scoring = 1002492,

    /// sample pre-fractionation: Sample pre-fractionation performed.
    MS_sample_pre_fractionation = 1002493,

    /// cross-linking search: Cross-linking search performed.
    MS_cross_linking_search = 1002494,

    /// no special processing: No special processing performed.
    MS_no_special_processing = 1002495,

    /// group PSMs by sequence: Group PSMs by distinct peptide sequence ignoring modifications.
    MS_group_PSMs_by_sequence = 1002496,

    /// group PSMs by sequence with modifications: Group PSMs by distinct peptide sequence with taking modifications into account.
    MS_group_PSMs_by_sequence_with_modifications = 1002497,

    /// group PSMs by sequence with modifications and charge: Group PSMs by distinct peptide sequence with taking modifications and charge into account.
    MS_group_PSMs_by_sequence_with_modifications_and_charge = 1002498,

    /// peptide level score: Peptide level score.
    MS_peptide_level_score = 1002499,

    /// peptide passes threshold: A Boolean attribute to determine whether the peptide has passed the threshold indicated in the file.
    MS_peptide_passes_threshold = 1002500,

    /// no PSM threshold: Indicating that no PSM threshold was used.
    MS_no_PSM_threshold = 1002501,

    /// no peptide-level threshold: Indicating that no peptide-level threshold was used.
    MS_no_peptide_level_threshold = 1002502,

    /// PSM is used for peptide-level scoring: Flags a PSM that it is used for peptide-level scoring.
    MS_PSM_is_used_for_peptide_level_scoring = 1002503,

    /// order: The order of modifications to be referenced elsewhere in the document.
    MS_order = 1002504,

    /// regular expression for modification localization scoring: ([:digit:]+:[0|1]\{1\}.[:digit:]+:[:digit:]+[|:digit:]*:(true|false)\{1\}).
    MS_regular_expression_for_modification_localization_scoring = 1002505,

    /// modification position score: Modification position score.
    MS_modification_position_score = 1002506,

    /// modification rescoring:false localization rate: Mod position score: false localization rate.
    MS_modification_rescoring_false_localization_rate = 1002507,

    /// cross-linking attribute: Cross-linking attribute.
    MS_cross_linking_attribute = 1002508,

    /// cross-link donor: The Cross-linking donor, assigned according to the following rules: the export software SHOULD use the following rules to choose the cross-link donor as the: longer peptide, then higher peptide neutral mass, then alphabetical order.
    MS_cross_link_donor = 1002509,

    /// cross-link receiver: Cross-linking receiver, assigned according to the following rules: the export software SHOULD use the following rules to choose the cross-link donor as the: longer peptide, then higher peptide neutral mass, then alphabetical order.
    MS_cross_link_receiver = 1002510,

    /// cross-link spectrum identification item: Cross-linked spectrum identification item.
    MS_cross_link_spectrum_identification_item = 1002511,

    /// cross-linking score: Cross-linking scoring value.
    MS_cross_linking_score = 1002512,

    /// molecules per cell: The absolute abundance of protein in a cell.
    MS_molecules_per_cell = 1002513,

    /// absolute quantitation analysis: Absolute quantitation analysis.
    MS_absolute_quantitation_analysis = 1002514,

    /// internal peptide reference used: States whether an internal peptide reference is used or not in absolute quantitation analysis.
    MS_internal_peptide_reference_used = 1002515,

    /// internal protein reference used: States whether an internal protein reference is used or not in absolute quantitation analysis.
    MS_internal_protein_reference_used = 1002516,

    /// internal reference abundance: The absolute abundance of the spiked in reference peptide or protein used for absolute quantitation analysis.
    MS_internal_reference_abundance = 1002517,

    /// Progenesis:protein group normalised abundance: The data type normalised abundance for protein groups produced by Progenesis LC-MS.
    MS_Progenesis_protein_group_normalised_abundance = 1002518,

    /// Progenesis:protein group raw abundance: The data type raw abundance for protein groups produced by Progenesis LC-MS.
    MS_Progenesis_protein_group_raw_abundance = 1002519,

    /// unimod root node: The root node of the unimod modifications ontology.
    UNIMOD_unimod_root_node = 100000000,

    /// Acetyl: Acetylation.
    UNIMOD_Acetyl = 100000001,

    /// Amidated: Amidation.
    UNIMOD_Amidated = 100000002,

    /// Biotin: Biotinylation.
    UNIMOD_Biotin = 100000003,

    /// Carbamidomethyl: Iodoacetamide derivative.
    UNIMOD_Carbamidomethyl = 100000004,

    /// Carbamyl: Carbamylation.
    UNIMOD_Carbamyl = 100000005,

    /// Carboxymethyl: Iodoacetic acid derivative.
    UNIMOD_Carboxymethyl = 100000006,

    /// Deamidated: Deamidation.
    UNIMOD_Deamidated = 100000007,

    /// ICAT-G: Gygi ICAT(TM) d0.
    UNIMOD_ICAT_G = 100000008,

    /// ICAT-G:2H(8): Gygi ICAT(TM) d8.
    UNIMOD_ICAT_G_2H_8_ = 100000009,

    /// Met->Hse: Homoserine.
    UNIMOD_Met__Hse = 100000010,

    /// Met->Hsl: Homoserine lactone.
    UNIMOD_Met__Hsl = 100000011,

    /// ICAT-D:2H(8): Applied Biosystems original ICAT(TM) d8.
    UNIMOD_ICAT_D_2H_8_ = 100000012,

    /// ICAT-D: Applied Biosystems original ICAT(TM) d0.
    UNIMOD_ICAT_D = 100000013,

    /// NIPCAM: N-isopropylcarboxamidomethyl.
    UNIMOD_NIPCAM = 100000017,

    /// PEO-Iodoacetyl-LC-Biotin: Biotinyl-iodoacetamidyl-3,6-dioxaoctanediamine.
    UNIMOD_PEO_Iodoacetyl_LC_Biotin = 100000020,

    /// Phospho: Phosphorylation.
    UNIMOD_Phospho = 100000021,

    /// Dehydrated: Dehydration.
    UNIMOD_Dehydrated = 100000023,

    /// Propionamide: Acrylamide adduct.
    UNIMOD_Propionamide = 100000024,

    /// Pyridylacetyl: Pyridylacetyl.
    UNIMOD_Pyridylacetyl = 100000025,

    /// Pyro-carbamidomethyl: S-carbamoylmethylcysteine cyclization (N-terminus).
    UNIMOD_Pyro_carbamidomethyl = 100000026,

    /// Glu->pyro-Glu: Pyro-glu from E.
    UNIMOD_Glu__pyro_Glu = 100000027,

    /// Gln->pyro-Glu: Pyro-glu from Q.
    UNIMOD_Gln__pyro_Glu = 100000028,

    /// SMA: N-Succinimidyl-2-morpholine acetate.
    UNIMOD_SMA = 100000029,

    /// Cation:Na: Sodium adduct.
    UNIMOD_Cation_Na = 100000030,

    /// Pyridylethyl: S-pyridylethylation.
    UNIMOD_Pyridylethyl = 100000031,

    /// Methyl: Methylation.
    UNIMOD_Methyl = 100000034,

    /// Oxidation: Oxidation or Hydroxylation.
    UNIMOD_Oxidation = 100000035,

    /// Dimethyl: Di-Methylation.
    UNIMOD_Dimethyl = 100000036,

    /// Trimethyl: Tri-Methylation.
    UNIMOD_Trimethyl = 100000037,

    /// Methylthio: Beta-methylthiolation.
    UNIMOD_Methylthio = 100000039,

    /// Sulfo: O-Sulfonation.
    UNIMOD_Sulfo = 100000040,

    /// Hex: Hexose.
    UNIMOD_Hex = 100000041,

    /// Lipoyl: Lipoyl.
    UNIMOD_Lipoyl = 100000042,

    /// HexNAc: N-Acetylhexosamine.
    UNIMOD_HexNAc = 100000043,

    /// Farnesyl: Farnesylation.
    UNIMOD_Farnesyl = 100000044,

    /// Myristoyl: Myristoylation.
    UNIMOD_Myristoyl = 100000045,

    /// PyridoxalPhosphate: Pyridoxal phosphate.
    UNIMOD_PyridoxalPhosphate = 100000046,

    /// Palmitoyl: Palmitoylation.
    UNIMOD_Palmitoyl = 100000047,

    /// GeranylGeranyl: Geranyl-geranyl.
    UNIMOD_GeranylGeranyl = 100000048,

    /// Phosphopantetheine: Phosphopantetheine.
    UNIMOD_Phosphopantetheine = 100000049,

    /// FAD: Flavin adenine dinucleotide.
    UNIMOD_FAD = 100000050,

    /// Tripalmitate: N-acyl diglyceride cysteine.
    UNIMOD_Tripalmitate = 100000051,

    /// Guanidinyl: Guanidination.
    UNIMOD_Guanidinyl = 100000052,

    /// HNE: 4-hydroxynonenal (HNE).
    UNIMOD_HNE = 100000053,

    /// Glucuronyl: N-glucuronylation.
    UNIMOD_Glucuronyl = 100000054,

    /// Glutathione: Glutathione disulfide.
    UNIMOD_Glutathione = 100000055,

    /// Acetyl:2H(3): Acetate labeling reagent (N-term & K) (heavy form, +3amu).
    UNIMOD_Acetyl_2H_3_ = 100000056,

    /// Propionyl: Propionate labeling reagent light form (N-term & K).
    UNIMOD_Propionyl = 100000058,

    /// Propionyl:13C(3): Propionate labeling reagent heavy form (+3amu), N-term & K.
    UNIMOD_Propionyl_13C_3_ = 100000059,

    /// GIST-Quat: Quaternary amine labeling reagent light form (N-term & K).
    UNIMOD_GIST_Quat = 100000060,

    /// GIST-Quat:2H(3): Quaternary amine labeling reagent heavy (+3amu) form, N-term & K.
    UNIMOD_GIST_Quat_2H_3_ = 100000061,

    /// GIST-Quat:2H(6): Quaternary amine labeling reagent heavy form (+6amu), N-term & K.
    UNIMOD_GIST_Quat_2H_6_ = 100000062,

    /// GIST-Quat:2H(9): Quaternary amine labeling reagent heavy form (+9amu), N-term & K.
    UNIMOD_GIST_Quat_2H_9_ = 100000063,

    /// Succinyl: Succinic anhydride labeling reagent light form (N-term & K).
    UNIMOD_Succinyl = 100000064,

    /// Succinyl:2H(4): Succinic anhydride labeling reagent, heavy form (+4amu, 4H2), N-term & K.
    UNIMOD_Succinyl_2H_4_ = 100000065,

    /// Succinyl:13C(4): Succinic anhydride labeling reagent, heavy form (+4amu, 4C13), N-term & K.
    UNIMOD_Succinyl_13C_4_ = 100000066,

    /// Iminobiotin: Iminobiotinylation.
    UNIMOD_Iminobiotin = 100000089,

    /// ESP: ESP-Tag light d0.
    UNIMOD_ESP = 100000090,

    /// ESP:2H(10): ESP-Tag heavy d10.
    UNIMOD_ESP_2H_10_ = 100000091,

    /// NHS-LC-Biotin: NHS-LC-Biotin.
    UNIMOD_NHS_LC_Biotin = 100000092,

    /// EDT-maleimide-PEO-biotin: EDT-maleimide-PEO-biotin.
    UNIMOD_EDT_maleimide_PEO_biotin = 100000093,

    /// IMID: IMID d0.
    UNIMOD_IMID = 100000094,

    /// IMID:2H(4): IMID d4.
    UNIMOD_IMID_2H_4_ = 100000095,

    /// Propionamide:2H(3): Acrylamide d3.
    UNIMOD_Propionamide_2H_3_ = 100000097,

    /// ICAT-C: Applied Biosystems cleavable ICAT(TM) light.
    UNIMOD_ICAT_C = 100000105,

    /// ICAT-C:13C(9): Applied Biosystems cleavable ICAT(TM) heavy.
    UNIMOD_ICAT_C_13C_9_ = 100000106,

    /// FormylMet: Addition of N-formyl met.
    UNIMOD_FormylMet = 100000107,

    /// Nethylmaleimide: N-ethylmaleimide on cysteines.
    UNIMOD_Nethylmaleimide = 100000108,

    /// OxLysBiotinRed: Oxidized lysine biotinylated with biotin-LC-hydrazide, reduced.
    UNIMOD_OxLysBiotinRed = 100000112,

    /// OxLysBiotin: Oxidized lysine biotinylated with biotin-LC-hydrazide.
    UNIMOD_OxLysBiotin = 100000113,

    /// OxProBiotinRed: Oxidized proline biotinylated with biotin-LC-hydrazide, reduced.
    UNIMOD_OxProBiotinRed = 100000114,

    /// OxProBiotin: Oxidized Proline biotinylated with biotin-LC-hydrazide.
    UNIMOD_OxProBiotin = 100000115,

    /// OxArgBiotin: Oxidized arginine biotinylated with biotin-LC-hydrazide.
    UNIMOD_OxArgBiotin = 100000116,

    /// OxArgBiotinRed: Oxidized arginine biotinylated with biotin-LC-hydrazide, reduced.
    UNIMOD_OxArgBiotinRed = 100000117,

    /// EDT-iodoacetyl-PEO-biotin: EDT-iodo-PEO-biotin.
    UNIMOD_EDT_iodoacetyl_PEO_biotin = 100000118,

    /// IBTP: Thio Ether Formation - BTP Adduct.
    UNIMOD_IBTP = 100000119,

    /// GlyGly: Ubiquitinylation residue.
    UNIMOD_GlyGly = 100000121,

    /// Formyl: Formylation.
    UNIMOD_Formyl = 100000122,

    /// ICAT-H: N-iodoacetyl, p-chlorobenzyl-12C6-glucamine.
    UNIMOD_ICAT_H = 100000123,

    /// ICAT-H:13C(6): N-iodoacetyl, p-chlorobenzyl-13C6-glucamine.
    UNIMOD_ICAT_H_13C_6_ = 100000124,

    /// Thioacyl: 3-sulfanylpropanoyl.
    UNIMOD_Thioacyl = 100000126,

    /// Fluoro: Fluorination.
    UNIMOD_Fluoro = 100000127,

    /// Fluorescein: 5-Iodoacetamidofluorescein (Molecular Probe, Eugene, OR).
    UNIMOD_Fluorescein = 100000128,

    /// Iodo: Iodination.
    UNIMOD_Iodo = 100000129,

    /// Diiodo: Di-Iodination.
    UNIMOD_Diiodo = 100000130,

    /// Triiodo: Tri-Iodination.
    UNIMOD_Triiodo = 100000131,

    /// Myristoleyl: (cis-delta 5)-tetradecaenoyl.
    UNIMOD_Myristoleyl = 100000134,

    /// Myristoyl+Delta:H(-4): (cis,cis-delta 5, delta 8)-tetradecadienoyl.
    UNIMOD_Myristoyl_Delta_H__4_ = 100000135,

    /// Benzoyl: Labeling reagent light form (N-term & K).
    UNIMOD_Benzoyl = 100000136,

    /// Hex(5)HexNAc(2): N-linked glycan core.
    UNIMOD_Hex_5_HexNAc_2_ = 100000137,

    /// Dansyl: 5-dimethylaminonaphthalene-1-sulfonyl.
    UNIMOD_Dansyl = 100000139,

    /// a-type-ion: ISD a-series (C-Term).
    UNIMOD_a_type_ion = 100000140,

    /// Amidine: Amidination of lysines or N-terminal amines with methyl acetimidate.
    UNIMOD_Amidine = 100000141,

    /// HexNAc(1)dHex(1): HexNAc1dHex1.
    UNIMOD_HexNAc_1_dHex_1_ = 100000142,

    /// HexNAc(2): HexNAc2.
    UNIMOD_HexNAc_2_ = 100000143,

    /// Hex(3): Hex3.
    UNIMOD_Hex_3_ = 100000144,

    /// HexNAc(1)dHex(2): HexNAc1dHex2.
    UNIMOD_HexNAc_1_dHex_2_ = 100000145,

    /// Hex(1)HexNAc(1)dHex(1): Hex1HexNAc1dHex1.
    UNIMOD_Hex_1_HexNAc_1_dHex_1_ = 100000146,

    /// HexNAc(2)dHex(1): HexNAc2dHex1.
    UNIMOD_HexNAc_2_dHex_1_ = 100000147,

    /// Hex(1)HexNAc(2): Hex1HexNAc2.
    UNIMOD_Hex_1_HexNAc_2_ = 100000148,

    /// Hex(1)HexNAc(1)NeuAc(1): Hex1HexNAc1NeuAc1.
    UNIMOD_Hex_1_HexNAc_1_NeuAc_1_ = 100000149,

    /// HexNAc(2)dHex(2): HexNAc2dHex2.
    UNIMOD_HexNAc_2_dHex_2_ = 100000150,

    /// Hex(1)HexNAc(2)Pent(1): Hex1HexNAc2Pent1.
    UNIMOD_Hex_1_HexNAc_2_Pent_1_ = 100000151,

    /// Hex(1)HexNAc(2)dHex(1): Hex1HexNAc2dHex1.
    UNIMOD_Hex_1_HexNAc_2_dHex_1_ = 100000152,

    /// Hex(2)HexNAc(2): Hex2HexNAc2.
    UNIMOD_Hex_2_HexNAc_2_ = 100000153,

    /// Hex(3)HexNAc(1)Pent(1): Hex3HexNAc1Pent1.
    UNIMOD_Hex_3_HexNAc_1_Pent_1_ = 100000154,

    /// Hex(1)HexNAc(2)dHex(1)Pent(1): Hex1HexNAc2dHex1Pent1.
    UNIMOD_Hex_1_HexNAc_2_dHex_1_Pent_1_ = 100000155,

    /// Hex(1)HexNAc(2)dHex(2): Hex1HexNAc2dHex2.
    UNIMOD_Hex_1_HexNAc_2_dHex_2_ = 100000156,

    /// Hex(2)HexNAc(2)Pent(1): Hex2HexNAc2Pent1.
    UNIMOD_Hex_2_HexNAc_2_Pent_1_ = 100000157,

    /// Hex(2)HexNAc(2)dHex(1): Hex2HexNAc2dHex1.
    UNIMOD_Hex_2_HexNAc_2_dHex_1_ = 100000158,

    /// Hex(3)HexNAc(2): Hex3HexNAc2.
    UNIMOD_Hex_3_HexNAc_2_ = 100000159,

    /// Hex(1)HexNAc(1)NeuAc(2): Hex1HexNAc1NeuAc2.
    UNIMOD_Hex_1_HexNAc_1_NeuAc_2_ = 100000160,

    /// Hex(3)HexNAc(2)P(1): Hex3HexNAc2P1.
    UNIMOD_Hex_3_HexNAc_2_P_1_ = 100000161,

    /// Delta:S(-1)Se(1): Selenium replaces sulfur.
    UNIMOD_Delta_S__1_Se_1_ = 100000162,

    /// Delta:H(1)N(-1)18O(1): Glycosylated asparagine 18O labeling.
    UNIMOD_Delta_H_1_N__1_18O_1_ = 100000170,

    /// NBS:13C(6): Shimadzu NBS-13C.
    UNIMOD_NBS_13C_6_ = 100000171,

    /// NBS: Shimadzu NBS-12C.
    UNIMOD_NBS = 100000172,

    /// BHT: Michael addition of BHT quinone methide to Cysteine and Lysine.
    UNIMOD_BHT = 100000176,

    /// DAET: Phosphorylation to amine thiol.
    UNIMOD_DAET = 100000178,

    /// Label:13C(9): 13C(9) Silac label.
    UNIMOD_Label_13C_9_ = 100000184,

    /// Label:13C(9)+Phospho: C13 label (Phosphotyrosine).
    UNIMOD_Label_13C_9__Phospho = 100000185,

    /// HPG: Hydroxyphenylglyoxal arginine.
    UNIMOD_HPG = 100000186,

    /// 2HPG: Bis(hydroxphenylglyoxal) arginine.
    UNIMOD_2HPG = 100000187,

    /// Label:13C(6): 13C(6) Silac label.
    UNIMOD_Label_13C_6_ = 100000188,

    /// Label:18O(2): O18 label at both C-terminal oxygens.
    UNIMOD_Label_18O_2_ = 100000193,

    /// AccQTag: 6-aminoquinolyl-N-hydroxysuccinimidyl carbamate.
    UNIMOD_AccQTag = 100000194,

    /// QAT: APTA-d0.
    UNIMOD_QAT = 100000195,

    /// QAT:2H(3): APTA d3.
    UNIMOD_QAT_2H_3_ = 100000196,

    /// EQAT: EAPTA d0.
    UNIMOD_EQAT = 100000197,

    /// EQAT:2H(5): EAPTA d5.
    UNIMOD_EQAT_2H_5_ = 100000198,

    /// Dimethyl:2H(4): DiMethyl-CHD2.
    UNIMOD_Dimethyl_2H_4_ = 100000199,

    /// Ethanedithiol: EDT.
    UNIMOD_Ethanedithiol = 100000200,

    /// Delta:H(6)C(6)O(1): Acrolein addition +94.
    UNIMOD_Delta_H_6_C_6_O_1_ = 100000205,

    /// Delta:H(4)C(3)O(1): Acrolein addition +56.
    UNIMOD_Delta_H_4_C_3_O_1_ = 100000206,

    /// Delta:H(2)C(3): Acrolein addition +38.
    UNIMOD_Delta_H_2_C_3_ = 100000207,

    /// Delta:H(4)C(6): Acrolein addition +76.
    UNIMOD_Delta_H_4_C_6_ = 100000208,

    /// Delta:H(8)C(6)O(2): Acrolein addition +112.
    UNIMOD_Delta_H_8_C_6_O_2_ = 100000209,

    /// NEIAA: N-ethyl iodoacetamide-d0.
    UNIMOD_NEIAA = 100000211,

    /// NEIAA:2H(5): N-ethyl iodoacetamide-d5.
    UNIMOD_NEIAA_2H_5_ = 100000212,

    /// ADP-Ribosyl: ADP Ribose addition.
    UNIMOD_ADP_Ribosyl = 100000213,

    /// iTRAQ4plex: Representative mass and accurate mass for 116 & 117.
    UNIMOD_iTRAQ4plex = 100000214,

    /// IGBP: Light IDBEST tag for quantitation.
    UNIMOD_IGBP = 100000243,

    /// Crotonaldehyde: Crotonaldehyde.
    UNIMOD_Crotonaldehyde = 100000253,

    /// Delta:H(2)C(2): Acetaldehyde +26.
    UNIMOD_Delta_H_2_C_2_ = 100000254,

    /// Delta:H(4)C(2): Acetaldehyde +28.
    UNIMOD_Delta_H_4_C_2_ = 100000255,

    /// Delta:H(4)C(3): Propionaldehyde +40.
    UNIMOD_Delta_H_4_C_3_ = 100000256,

    /// Label:18O(1): O18 Labeling.
    UNIMOD_Label_18O_1_ = 100000258,

    /// Label:13C(6)15N(2): 13C(6) 15N(2) Silac label.
    UNIMOD_Label_13C_6_15N_2_ = 100000259,

    /// Thiophospho: Thiophosphorylation.
    UNIMOD_Thiophospho = 100000260,

    /// SPITC: 4-sulfophenyl isothiocyanate.
    UNIMOD_SPITC = 100000261,

    /// Label:2H(3): Trideuteration.
    UNIMOD_Label_2H_3_ = 100000262,

    /// PET: Phosphorylation to pyridyl thiol.
    UNIMOD_PET = 100000264,

    /// Label:13C(6)15N(4): 13C(6) 15N(4) Silac label.
    UNIMOD_Label_13C_6_15N_4_ = 100000267,

    /// Label:13C(5)15N(1): 13C(5) 15N(1) Silac label.
    UNIMOD_Label_13C_5_15N_1_ = 100000268,

    /// Label:13C(9)15N(1): 13C(9) 15N(1) Silac label.
    UNIMOD_Label_13C_9_15N_1_ = 100000269,

    /// Cytopiloyne: Nucleophilic addtion to cytopiloyne.
    UNIMOD_Cytopiloyne = 100000270,

    /// Cytopiloyne+water: Nucleophilic addition to cytopiloyne+H2O.
    UNIMOD_Cytopiloyne_water = 100000271,

    /// CAF: Sulfonation of N-terminus.
    UNIMOD_CAF = 100000272,

    /// Xlink:SSD: Covalent modification of lysine by cross-linking reagent.
    UNIMOD_Xlink_SSD = 100000273,

    /// Nitrosyl: S-nitrosylation.
    UNIMOD_Nitrosyl = 100000275,

    /// AEBS: Aminoethylbenzenesulfonylation.
    UNIMOD_AEBS = 100000276,

    /// Ethanolyl: Ethanolation.
    UNIMOD_Ethanolyl = 100000278,

    /// Ethyl: Ethylation.
    UNIMOD_Ethyl = 100000280,

    /// CoenzymeA: Cysteine modified Coenzyme A.
    UNIMOD_CoenzymeA = 100000281,

    /// Methyl:2H(2): Deuterium Methylation of Lysine.
    UNIMOD_Methyl_2H_2_ = 100000284,

    /// SulfanilicAcid: Light Sulfanilic Acid (SA) C12.
    UNIMOD_SulfanilicAcid = 100000285,

    /// SulfanilicAcid:13C(6): Heavy Sulfanilic Acid (SA) C13.
    UNIMOD_SulfanilicAcid_13C_6_ = 100000286,

    /// Trp->Oxolactone: Tryptophan oxidation to oxolactone.
    UNIMOD_Trp__Oxolactone = 100000288,

    /// Biotin-PEO-Amine: Biotin polyethyleneoxide amine.
    UNIMOD_Biotin_PEO_Amine = 100000289,

    /// Biotin-HPDP: Pierce EZ-Link Biotin-HPDP.
    UNIMOD_Biotin_HPDP = 100000290,

    /// Delta:Hg(1): Mercury Mercaptan.
    UNIMOD_Delta_Hg_1_ = 100000291,

    /// IodoU-AMP: Cross-link of (Iodo)-uracil MP with W,F,Y.
    UNIMOD_IodoU_AMP = 100000292,

    /// CAMthiopropanoyl: 3-(carbamidomethylthio)propanoyl.
    UNIMOD_CAMthiopropanoyl = 100000293,

    /// IED-Biotin: Biotinoyl-iodoacetyl-ethylenediamine.
    UNIMOD_IED_Biotin = 100000294,

    /// dHex: Fucose.
    UNIMOD_dHex = 100000295,

    /// Methyl:2H(3): Deuterated methyl ester.
    UNIMOD_Methyl_2H_3_ = 100000298,

    /// Carboxy: Carboxylation.
    UNIMOD_Carboxy = 100000299,

    /// Bromobimane: Monobromobimane derivative.
    UNIMOD_Bromobimane = 100000301,

    /// Menadione: Menadione quinone derivative.
    UNIMOD_Menadione = 100000302,

    /// DeStreak: Cysteine mercaptoethanol.
    UNIMOD_DeStreak = 100000303,

    /// dHex(1)Hex(3)HexNAc(4): Fucosylated biantennary (-2 galactose).
    UNIMOD_dHex_1_Hex_3_HexNAc_4_ = 100000305,

    /// dHex(1)Hex(4)HexNAc(4): Fucosylated biantennary (-1 galactose).
    UNIMOD_dHex_1_Hex_4_HexNAc_4_ = 100000307,

    /// dHex(1)Hex(5)HexNAc(4): Fucosylated biantennary.
    UNIMOD_dHex_1_Hex_5_HexNAc_4_ = 100000308,

    /// Hex(3)HexNAc(4): Biantennary (-2 galactose).
    UNIMOD_Hex_3_HexNAc_4_ = 100000309,

    /// Hex(4)HexNAc(4): Biantennary (-1 galactose).
    UNIMOD_Hex_4_HexNAc_4_ = 100000310,

    /// Hex(5)HexNAc(4): Biantennary.
    UNIMOD_Hex_5_HexNAc_4_ = 100000311,

    /// Cysteinyl: Cysteinylation.
    UNIMOD_Cysteinyl = 100000312,

    /// Lys-loss: Loss of C-terminal K from Heavy Chain of MAb.
    UNIMOD_Lys_loss = 100000313,

    /// Nmethylmaleimide: Nmethylmaleimide.
    UNIMOD_Nmethylmaleimide = 100000314,

    /// DimethylpyrroleAdduct: 2,5-dimethypyrrole.
    UNIMOD_DimethylpyrroleAdduct = 100000316,

    /// Delta:H(2)C(5): MDA adduct +62.
    UNIMOD_Delta_H_2_C_5_ = 100000318,

    /// Delta:H(2)C(3)O(1): MDA adduct +54.
    UNIMOD_Delta_H_2_C_3_O_1_ = 100000319,

    /// Nethylmaleimide+water: Nethylmaleimidehydrolysis.
    UNIMOD_Nethylmaleimide_water = 100000320,

    /// Xlink:B10621: Bis-N-I-sulfonerahodamine.
    UNIMOD_Xlink_B10621 = 100000323,

    /// DTBP: Dimethyl 3,3\'-dithiobispropionimidate.
    UNIMOD_DTBP = 100000324,

    /// FP-Biotin: 10-ethoxyphosphinyl-N-(biotinamidopentyl)decanamide.
    UNIMOD_FP_Biotin = 100000325,

    /// Delta:H(4)C(2)O(-1)S(1): S-Ethylcystine from Serine.
    UNIMOD_Delta_H_4_C_2_O__1_S_1_ = 100000327,

    /// Methyl:2H(3)13C(1): Monomethylated arginine.
    UNIMOD_Methyl_2H_3_13C_1_ = 100000329,

    /// Dimethyl:2H(6)13C(2): Dimethylated arginine.
    UNIMOD_Dimethyl_2H_6_13C_2_ = 100000330,

    /// Thiophos-S-S-biotin: Thiophosphate labeled with biotin-HPDP.
    UNIMOD_Thiophos_S_S_biotin = 100000332,

    /// Can-FP-biotin: 6-N-biotinylaminohexyl isopropyl phosphate.
    UNIMOD_Can_FP_biotin = 100000333,

    /// HNE+Delta:H(2): Reduced 4-Hydroxynonenal.
    UNIMOD_HNE_Delta_H_2_ = 100000335,

    /// Methylamine: Michael addition with methylamine.
    UNIMOD_Methylamine = 100000337,

    /// Bromo: Bromination.
    UNIMOD_Bromo = 100000340,

    /// Amino: Tyrosine oxidation to 2-aminotyrosine.
    UNIMOD_Amino = 100000342,

    /// Argbiotinhydrazide: Oxidized Arginine biotinylated with biotin hydrazide.
    UNIMOD_Argbiotinhydrazide = 100000343,

    /// Arg->GluSA: Arginine oxidation to glutamic semialdehyde.
    UNIMOD_Arg__GluSA = 100000344,

    /// Trioxidation: Cysteine oxidation to cysteic acid.
    UNIMOD_Trioxidation = 100000345,

    /// His->Asn: His->Asn substitution.
    UNIMOD_His__Asn = 100000348,

    /// His->Asp: His->Asp substitution.
    UNIMOD_His__Asp = 100000349,

    /// Trp->Hydroxykynurenin: Tryptophan oxidation to hydroxykynurenin.
    UNIMOD_Trp__Hydroxykynurenin = 100000350,

    /// Trp->Kynurenin: Tryptophan oxidation to kynurenin.
    UNIMOD_Trp__Kynurenin = 100000351,

    /// Lys->Allysine: Lysine oxidation to aminoadipic semialdehyde.
    UNIMOD_Lys__Allysine = 100000352,

    /// Lysbiotinhydrazide: Oxidized Lysine biotinylated with biotin hydrazide.
    UNIMOD_Lysbiotinhydrazide = 100000353,

    /// Nitro: Oxidation to nitro.
    UNIMOD_Nitro = 100000354,

    /// probiotinhydrazide: Oxidized proline biotinylated with biotin hydrazide.
    UNIMOD_probiotinhydrazide = 100000357,

    /// Pro->pyro-Glu: Proline oxidation to pyroglutamic acid.
    UNIMOD_Pro__pyro_Glu = 100000359,

    /// Pro->Pyrrolidinone: Proline oxidation to pyrrolidinone.
    UNIMOD_Pro__Pyrrolidinone = 100000360,

    /// Thrbiotinhydrazide: Oxidized Threonine biotinylated with biotin hydrazide.
    UNIMOD_Thrbiotinhydrazide = 100000361,

    /// Diisopropylphosphate: O-Diisopropylphosphorylation.
    UNIMOD_Diisopropylphosphate = 100000362,

    /// Isopropylphospho: O-Isopropylphosphorylation.
    UNIMOD_Isopropylphospho = 100000363,

    /// ICPL:13C(6): Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, heavy form.
    UNIMOD_ICPL_13C_6_ = 100000364,

    /// ICPL: Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, light form.
    UNIMOD_ICPL = 100000365,

    /// Deamidated:18O(1): Deamidation in presence of O18.
    UNIMOD_Deamidated_18O_1_ = 100000366,

    /// Cys->Dha: Dehydroalanine (from Cysteine).
    UNIMOD_Cys__Dha = 100000368,

    /// Pro->Pyrrolidone: Pyrrolidone from Proline.
    UNIMOD_Pro__Pyrrolidone = 100000369,

    /// HMVK: Michael addition of hydroxymethylvinyl ketone to cysteine.
    UNIMOD_HMVK = 100000371,

    /// Arg->Orn: Ornithine from Arginine.
    UNIMOD_Arg__Orn = 100000372,

    /// Dehydro: Half of a disulfide bridge.
    UNIMOD_Dehydro = 100000374,

    /// Diphthamide: Diphthamide.
    UNIMOD_Diphthamide = 100000375,

    /// Hydroxyfarnesyl: Hydroxyfarnesyl.
    UNIMOD_Hydroxyfarnesyl = 100000376,

    /// Diacylglycerol: Diacylglycerol.
    UNIMOD_Diacylglycerol = 100000377,

    /// Carboxyethyl: Carboxyethyl.
    UNIMOD_Carboxyethyl = 100000378,

    /// Hypusine: Hypusine.
    UNIMOD_Hypusine = 100000379,

    /// Retinylidene: Retinal.
    UNIMOD_Retinylidene = 100000380,

    /// Lys->AminoadipicAcid: Alpha-amino adipic acid.
    UNIMOD_Lys__AminoadipicAcid = 100000381,

    /// Cys->PyruvicAcid: Pyruvic acid from N-term cys.
    UNIMOD_Cys__PyruvicAcid = 100000382,

    /// Ammonia-loss: Loss of ammonia.
    UNIMOD_Ammonia_loss = 100000385,

    /// Phycocyanobilin: Phycocyanobilin.
    UNIMOD_Phycocyanobilin = 100000387,

    /// Phycoerythrobilin: Phycoerythrobilin.
    UNIMOD_Phycoerythrobilin = 100000388,

    /// Phytochromobilin: Phytochromobilin.
    UNIMOD_Phytochromobilin = 100000389,

    /// Heme: Heme.
    UNIMOD_Heme = 100000390,

    /// Molybdopterin: Molybdopterin.
    UNIMOD_Molybdopterin = 100000391,

    /// Quinone: Quinone.
    UNIMOD_Quinone = 100000392,

    /// Glucosylgalactosyl: Glucosylgalactosyl hydroxylysine.
    UNIMOD_Glucosylgalactosyl = 100000393,

    /// GPIanchor: Glycosylphosphatidylinositol.
    UNIMOD_GPIanchor = 100000394,

    /// PhosphoribosyldephosphoCoA: Phosphoribosyl dephospho-coenzyme A.
    UNIMOD_PhosphoribosyldephosphoCoA = 100000395,

    /// GlycerylPE: Glycerylphosphorylethanolamine.
    UNIMOD_GlycerylPE = 100000396,

    /// Triiodothyronine: Triiodo.
    UNIMOD_Triiodothyronine = 100000397,

    /// Thyroxine: Tetraiodo.
    UNIMOD_Thyroxine = 100000398,

    /// Tyr->Dha: Dehydroalanine (from Tyrosine).
    UNIMOD_Tyr__Dha = 100000400,

    /// Didehydro: 2-amino-3-oxo-butanoic_acid.
    UNIMOD_Didehydro = 100000401,

    /// Cys->Oxoalanine: Oxoalanine.
    UNIMOD_Cys__Oxoalanine = 100000402,

    /// Ser->LacticAcid: Lactic acid from N-term Ser.
    UNIMOD_Ser__LacticAcid = 100000403,

    /// Phosphoadenosine: AMP binding site.
    UNIMOD_Phosphoadenosine = 100000405,

    /// Hydroxycinnamyl: Hydroxycinnamyl.
    UNIMOD_Hydroxycinnamyl = 100000407,

    /// Glycosyl: Glycosyl-L-hydroxyproline.
    UNIMOD_Glycosyl = 100000408,

    /// FMNH: Flavin mononucleotide.
    UNIMOD_FMNH = 100000409,

    /// Archaeol: S-diphytanylglycerol diether.
    UNIMOD_Archaeol = 100000410,

    /// Phenylisocyanate: Phenyl isocyanate.
    UNIMOD_Phenylisocyanate = 100000411,

    /// Phenylisocyanate:2H(5): D5-phenyl isocyanate.
    UNIMOD_Phenylisocyanate_2H_5_ = 100000412,

    /// Phosphoguanosine: Phospho-guanosine.
    UNIMOD_Phosphoguanosine = 100000413,

    /// Hydroxymethyl: Hydroxymethyl.
    UNIMOD_Hydroxymethyl = 100000414,

    /// MolybdopterinGD+Delta:S(-1)Se(1): L-selenocysteinyl molybdenum bis(molybdopterin guanine dinucleotide).
    UNIMOD_MolybdopterinGD_Delta_S__1_Se_1_ = 100000415,

    /// Dipyrrolylmethanemethyl: Dipyrrolylmethanemethyl.
    UNIMOD_Dipyrrolylmethanemethyl = 100000416,

    /// PhosphoUridine: Uridine phosphodiester.
    UNIMOD_PhosphoUridine = 100000417,

    /// Glycerophospho: Glycerophospho.
    UNIMOD_Glycerophospho = 100000419,

    /// Carboxy->Thiocarboxy: Thiocarboxylic acid.
    UNIMOD_Carboxy__Thiocarboxy = 100000420,

    /// Sulfide: Persulfide.
    UNIMOD_Sulfide = 100000421,

    /// PyruvicAcidIminyl: N-pyruvic acid 2-iminyl.
    UNIMOD_PyruvicAcidIminyl = 100000422,

    /// Delta:Se(1): Selenyl.
    UNIMOD_Delta_Se_1_ = 100000423,

    /// MolybdopterinGD: Molybdenum bis(molybdopterin guanine dinucleotide).
    UNIMOD_MolybdopterinGD = 100000424,

    /// Dioxidation: Dihydroxy.
    UNIMOD_Dioxidation = 100000425,

    /// Octanoyl: Octanoyl.
    UNIMOD_Octanoyl = 100000426,

    /// PhosphoHexNAc: N-acetylglucosamine-1-phosphoryl.
    UNIMOD_PhosphoHexNAc = 100000428,

    /// PhosphoHex: Phosphoglycosyl-D-mannose-1-phosphoryl.
    UNIMOD_PhosphoHex = 100000429,

    /// Palmitoleyl: Palmitoleyl.
    UNIMOD_Palmitoleyl = 100000431,

    /// Cholesterol: Cholesterol ester.
    UNIMOD_Cholesterol = 100000432,

    /// Didehydroretinylidene: 3,4-didehydroretinylidene.
    UNIMOD_Didehydroretinylidene = 100000433,

    /// CHDH: Cis-14-hydroxy-10,13-dioxo-7-heptadecenoic ester.
    UNIMOD_CHDH = 100000434,

    /// Methylpyrroline: 4-methyl-delta-1-pyrroline-5-carboxyl.
    UNIMOD_Methylpyrroline = 100000435,

    /// Hydroxyheme: Hydroxyheme.
    UNIMOD_Hydroxyheme = 100000436,

    /// MicrocinC7: (3-aminopropyl)(L-aspartyl-1-amino)phosphoryl-5-adenosine.
    UNIMOD_MicrocinC7 = 100000437,

    /// Cyano: Cyano.
    UNIMOD_Cyano = 100000438,

    /// Diironsubcluster: Hydrogenase diiron subcluster.
    UNIMOD_Diironsubcluster = 100000439,

    /// Amidino: Amidino.
    UNIMOD_Amidino = 100000440,

    /// FMN: O3-(riboflavin phosphoryl).
    UNIMOD_FMN = 100000442,

    /// FMNC: S-(4a-FMN).
    UNIMOD_FMNC = 100000443,

    /// CuSMo: Copper sulfido molybdopterin cytosine dinuncleotide.
    UNIMOD_CuSMo = 100000444,

    /// Hydroxytrimethyl: 5-hydroxy-N6,N6,N6-trimethyl.
    UNIMOD_Hydroxytrimethyl = 100000445,

    /// Deoxy: Reduction.
    UNIMOD_Deoxy = 100000447,

    /// Microcin: Microcin E492 siderophore ester from serine.
    UNIMOD_Microcin = 100000448,

    /// Decanoyl: Lipid.
    UNIMOD_Decanoyl = 100000449,

    /// Glu: Monoglutamyl.
    UNIMOD_Glu = 100000450,

    /// GluGlu: Diglutamyl.
    UNIMOD_GluGlu = 100000451,

    /// GluGluGlu: Triglutamyl.
    UNIMOD_GluGluGlu = 100000452,

    /// GluGluGluGlu: Tetraglutamyl.
    UNIMOD_GluGluGluGlu = 100000453,

    /// HexN: Hexosamine.
    UNIMOD_HexN = 100000454,

    /// Xlink:DMP-s: One end of crosslink attached, one end free.
    UNIMOD_Xlink_DMP_s = 100000455,

    /// Xlink:DMP: Both ends of crosslink attached to same peptide.
    UNIMOD_Xlink_DMP = 100000456,

    /// NDA: Naphthalene-2,3-dicarboxaldehyde.
    UNIMOD_NDA = 100000457,

    /// SPITC:13C(6): 4-sulfophenyl isothiocyanate (Heavy C13).
    UNIMOD_SPITC_13C_6_ = 100000464,

    /// AEC-MAEC: Aminoethylcysteine.
    UNIMOD_AEC_MAEC = 100000472,

    /// TMAB: 4-trimethyllammoniumbutyryl-.
    UNIMOD_TMAB = 100000476,

    /// TMAB:2H(9): D9-4-trimethyllammoniumbutyryl-.
    UNIMOD_TMAB_2H_9_ = 100000477,

    /// FTC: Fluorescein-5-thiosemicarbazide.
    UNIMOD_FTC = 100000478,

    /// Label:2H(4): 4,4,5,5-D4 Lysine.
    UNIMOD_Label_2H_4_ = 100000481,

    /// DHP: Dehydropyrrolizidine alkaloid (dehydroretronecine) on cysteines.
    UNIMOD_DHP = 100000488,

    /// Hep: Heptose.
    UNIMOD_Hep = 100000490,

    /// BADGE: Bisphenol A diglycidyl ether derivative.
    UNIMOD_BADGE = 100000493,

    /// CyDye-Cy3: Cy3 CyDye DIGE Fluor saturation dye.
    UNIMOD_CyDye_Cy3 = 100000494,

    /// CyDye-Cy5: Cy5 CyDye DIGE Fluor saturation dye.
    UNIMOD_CyDye_Cy5 = 100000495,

    /// BHTOH: Michael addition of t-butyl hydroxylated BHT (BHTOH) to C, H or K.
    UNIMOD_BHTOH = 100000498,

    /// IGBP:13C(2): Heavy IDBEST tag for quantitation.
    UNIMOD_IGBP_13C_2_ = 100000499,

    /// Nmethylmaleimide+water: Nmethylmaleimidehydrolysis.
    UNIMOD_Nmethylmaleimide_water = 100000500,

    /// PyMIC: 3-methyl-2-pyridyl isocyanate.
    UNIMOD_PyMIC = 100000501,

    /// LG-lactam-K: Levuglandinyl - lysine lactam adduct.
    UNIMOD_LG_lactam_K = 100000503,

    /// LG-Hlactam-K: Levuglandinyl - lysine hydroxylactam adduct.
    UNIMOD_LG_Hlactam_K = 100000504,

    /// LG-lactam-R: Levuglandinyl - arginine lactam adduct.
    UNIMOD_LG_lactam_R = 100000505,

    /// LG-Hlactam-R: Levuglandinyl - arginine hydroxylactam adduct.
    UNIMOD_LG_Hlactam_R = 100000506,

    /// Dimethyl:2H(4)13C(2): DiMethyl-C13HD2.
    UNIMOD_Dimethyl_2H_4_13C_2_ = 100000510,

    /// Hex(2): Lactosylation.
    UNIMOD_Hex_2_ = 100000512,

    /// C8-QAT: [3-(2,5)-Dioxopyrrolidin-1-yloxycarbonyl)-propyl]dimethyloctylammonium.
    UNIMOD_C8_QAT = 100000513,

    /// PropylNAGthiazoline: Propyl-1,2-dideoxy-2\'-methyl-alpha-D-glucopyranoso-[2,1-d]-Delta2\'-thiazoline.
    UNIMOD_PropylNAGthiazoline = 100000514,

    /// FNEM: Fluorescein-5-maleimide.
    UNIMOD_FNEM = 100000515,

    /// Diethyl: Diethylation, analogous to Dimethylation.
    UNIMOD_Diethyl = 100000518,

    /// BisANS: 4,4\'-dianilino-1,1\'-binaphthyl-5,5\'-disulfonic acid.
    UNIMOD_BisANS = 100000519,

    /// Piperidine: Piperidination.
    UNIMOD_Piperidine = 100000520,

    /// Maleimide-PEO2-Biotin: Maleimide-Biotin.
    UNIMOD_Maleimide_PEO2_Biotin = 100000522,

    /// Sulfo-NHS-LC-LC-Biotin: Biot_LC_LC.
    UNIMOD_Sulfo_NHS_LC_LC_Biotin = 100000523,

    /// CLIP_TRAQ_2: CLIP_TRAQ_2.
    UNIMOD_CLIP_TRAQ_2 = 100000525,

    /// Dethiomethyl: Prompt loss of side chain from oxidised Met.
    UNIMOD_Dethiomethyl = 100000526,

    /// Methyl+Deamidated: Deamidation followed by a methylation.
    UNIMOD_Methyl_Deamidated = 100000528,

    /// Delta:H(5)C(2): Dimethylation of proline residue.
    UNIMOD_Delta_H_5_C_2_ = 100000529,

    /// Cation:K: Replacement of proton by potassium.
    UNIMOD_Cation_K = 100000530,

    /// Cation:Cu[I]: Replacement of proton by copper.
    UNIMOD_Cation_Cu_I_ = 100000531,

    /// iTRAQ4plex114: Accurate mass for 114.
    UNIMOD_iTRAQ4plex114 = 100000532,

    /// iTRAQ4plex115: Accurate mass for 115.
    UNIMOD_iTRAQ4plex115 = 100000533,

    /// Dibromo: Dibromo.
    UNIMOD_Dibromo = 100000534,

    /// LeuArgGlyGly: Ubiquitination.
    UNIMOD_LeuArgGlyGly = 100000535,

    /// CLIP_TRAQ_3: CLIP_TRAQ_3.
    UNIMOD_CLIP_TRAQ_3 = 100000536,

    /// CLIP_TRAQ_4: CLIP_TRAQ_4.
    UNIMOD_CLIP_TRAQ_4 = 100000537,

    /// Biotin:Cayman-10141: Was 15dB-biotin.
    UNIMOD_Biotin_Cayman_10141 = 100000538,

    /// Biotin:Cayman-10013: Was PGA1-biotin.
    UNIMOD_Biotin_Cayman_10013 = 100000539,

    /// Ala->Ser: Ala->Ser substitution.
    UNIMOD_Ala__Ser = 100000540,

    /// Ala->Thr: Ala->Thr substitution.
    UNIMOD_Ala__Thr = 100000541,

    /// Ala->Asp: Ala->Asp substitution.
    UNIMOD_Ala__Asp = 100000542,

    /// Ala->Pro: Ala->Pro substitution.
    UNIMOD_Ala__Pro = 100000543,

    /// Ala->Gly: Ala->Gly substitution.
    UNIMOD_Ala__Gly = 100000544,

    /// Ala->Glu: Ala->Glu substitution.
    UNIMOD_Ala__Glu = 100000545,

    /// Ala->Val: Ala->Val substitution.
    UNIMOD_Ala__Val = 100000546,

    /// Cys->Phe: Cys->Phe substitution.
    UNIMOD_Cys__Phe = 100000547,

    /// Cys->Ser: Cys->Ser substitution.
    UNIMOD_Cys__Ser = 100000548,

    /// Cys->Trp: Cys->Trp substitution.
    UNIMOD_Cys__Trp = 100000549,

    /// Cys->Tyr: Cys->Tyr substitution.
    UNIMOD_Cys__Tyr = 100000550,

    /// Cys->Arg: Cys->Arg substitution.
    UNIMOD_Cys__Arg = 100000551,

    /// Cys->Gly: Cys->Gly substitution.
    UNIMOD_Cys__Gly = 100000552,

    /// Asp->Ala: Asp->Ala substitution.
    UNIMOD_Asp__Ala = 100000553,

    /// Asp->His: Asp->His substitution.
    UNIMOD_Asp__His = 100000554,

    /// Asp->Asn: Asp->Asn substitution.
    UNIMOD_Asp__Asn = 100000555,

    /// Asp->Gly: Asp->Gly substitution.
    UNIMOD_Asp__Gly = 100000556,

    /// Asp->Tyr: Asp->Tyr substitution.
    UNIMOD_Asp__Tyr = 100000557,

    /// Asp->Glu: Asp->Glu substitution.
    UNIMOD_Asp__Glu = 100000558,

    /// Asp->Val: Asp->Val substitution.
    UNIMOD_Asp__Val = 100000559,

    /// Glu->Ala: Glu->Ala substitution.
    UNIMOD_Glu__Ala = 100000560,

    /// Glu->Gln: Glu->Gln substitution.
    UNIMOD_Glu__Gln = 100000561,

    /// Glu->Asp: Glu->Asp substitution.
    UNIMOD_Glu__Asp = 100000562,

    /// Glu->Lys: Glu->Lys substitution.
    UNIMOD_Glu__Lys = 100000563,

    /// Glu->Gly: Glu->Gly substitution.
    UNIMOD_Glu__Gly = 100000564,

    /// Glu->Val: Glu->Val substitution.
    UNIMOD_Glu__Val = 100000565,

    /// Phe->Ser: Phe->Ser substitution.
    UNIMOD_Phe__Ser = 100000566,

    /// Phe->Cys: Phe->Cys substitution.
    UNIMOD_Phe__Cys = 100000567,

    /// Phe->Xle: Phe->Leu/Ile substitution.
    UNIMOD_Phe__Xle = 100000568,

    /// Phe->Tyr: Phe->Tyr substitution.
    UNIMOD_Phe__Tyr = 100000569,

    /// Phe->Val: Phe->Val substitution.
    UNIMOD_Phe__Val = 100000570,

    /// Gly->Ala: Gly->Ala substitution.
    UNIMOD_Gly__Ala = 100000571,

    /// Gly->Ser: Gly->Ser substitution.
    UNIMOD_Gly__Ser = 100000572,

    /// Gly->Trp: Gly->Trp substitution.
    UNIMOD_Gly__Trp = 100000573,

    /// Gly->Glu: Gly->Glu substitution.
    UNIMOD_Gly__Glu = 100000574,

    /// Gly->Val: Gly->Val substitution.
    UNIMOD_Gly__Val = 100000575,

    /// Gly->Asp: Gly->Asp substitution.
    UNIMOD_Gly__Asp = 100000576,

    /// Gly->Cys: Gly->Cys substitution.
    UNIMOD_Gly__Cys = 100000577,

    /// Gly->Arg: Gly->Arg substitution.
    UNIMOD_Gly__Arg = 100000578,

    /// His->Pro: His->Pro substitution.
    UNIMOD_His__Pro = 100000580,

    /// His->Tyr: His->Tyr substitution.
    UNIMOD_His__Tyr = 100000581,

    /// His->Gln: His->Gln substitution.
    UNIMOD_His__Gln = 100000582,

    /// His->Arg: His->Arg substitution.
    UNIMOD_His__Arg = 100000584,

    /// His->Xle: His->Leu/Ile substitution.
    UNIMOD_His__Xle = 100000585,

    /// Xle->Thr: Leu/Ile->Thr substitution.
    UNIMOD_Xle__Thr = 100000588,

    /// Xle->Asn: Leu/Ile->Asn substitution.
    UNIMOD_Xle__Asn = 100000589,

    /// Xle->Lys: Leu/Ile->Lys substitution.
    UNIMOD_Xle__Lys = 100000590,

    /// Lys->Thr: Lys->Thr substitution.
    UNIMOD_Lys__Thr = 100000594,

    /// Lys->Asn: Lys->Asn substitution.
    UNIMOD_Lys__Asn = 100000595,

    /// Lys->Glu: Lys->Glu substitution.
    UNIMOD_Lys__Glu = 100000596,

    /// Lys->Gln: Lys->Gln substitution.
    UNIMOD_Lys__Gln = 100000597,

    /// Lys->Met: Lys->Met substitution.
    UNIMOD_Lys__Met = 100000598,

    /// Lys->Arg: Lys->Arg substitution.
    UNIMOD_Lys__Arg = 100000599,

    /// Lys->Xle: Lys->Leu/Ile substitution.
    UNIMOD_Lys__Xle = 100000600,

    /// Xle->Ser: Leu/Ile->Ser substitution.
    UNIMOD_Xle__Ser = 100000601,

    /// Xle->Phe: Leu/Ile->Phe substitution.
    UNIMOD_Xle__Phe = 100000602,

    /// Xle->Trp: Leu/Ile->Trp substitution.
    UNIMOD_Xle__Trp = 100000603,

    /// Xle->Pro: Leu/Ile->Pro substitution.
    UNIMOD_Xle__Pro = 100000604,

    /// Xle->Val: Leu/Ile->Val substitution.
    UNIMOD_Xle__Val = 100000605,

    /// Xle->His: Leu/Ile->His substitution.
    UNIMOD_Xle__His = 100000606,

    /// Xle->Gln: Leu/Ile->Gln substitution.
    UNIMOD_Xle__Gln = 100000607,

    /// Xle->Met: Leu/Ile->Met substitution.
    UNIMOD_Xle__Met = 100000608,

    /// Xle->Arg: Leu/Ile->Arg substitution.
    UNIMOD_Xle__Arg = 100000609,

    /// Met->Thr: Met->Thr substitution.
    UNIMOD_Met__Thr = 100000610,

    /// Met->Arg: Met->Arg substitution.
    UNIMOD_Met__Arg = 100000611,

    /// Met->Lys: Met->Lys substitution.
    UNIMOD_Met__Lys = 100000613,

    /// Met->Xle: Met->Leu/Ile substitution.
    UNIMOD_Met__Xle = 100000614,

    /// Met->Val: Met->Val substitution.
    UNIMOD_Met__Val = 100000615,

    /// Asn->Ser: Asn->Ser substitution.
    UNIMOD_Asn__Ser = 100000616,

    /// Asn->Thr: Asn->Thr substitution.
    UNIMOD_Asn__Thr = 100000617,

    /// Asn->Lys: Asn->Lys substitution.
    UNIMOD_Asn__Lys = 100000618,

    /// Asn->Tyr: Asn->Tyr substitution.
    UNIMOD_Asn__Tyr = 100000619,

    /// Asn->His: Asn->His substitution.
    UNIMOD_Asn__His = 100000620,

    /// Asn->Asp: Asn->Asp substitution.
    UNIMOD_Asn__Asp = 100000621,

    /// Asn->Xle: Asn->Leu/Ile substitution.
    UNIMOD_Asn__Xle = 100000622,

    /// Pro->Ser: Pro->Ser substitution.
    UNIMOD_Pro__Ser = 100000623,

    /// Pro->Ala: Pro->Ala substitution.
    UNIMOD_Pro__Ala = 100000624,

    /// Pro->His: Pro->His substitution.
    UNIMOD_Pro__His = 100000625,

    /// Pro->Gln: Pro->Gln substitution.
    UNIMOD_Pro__Gln = 100000626,

    /// Pro->Thr: Pro->Thr substitution.
    UNIMOD_Pro__Thr = 100000627,

    /// Pro->Arg: Pro->Arg substitution.
    UNIMOD_Pro__Arg = 100000628,

    /// Pro->Xle: Pro->Leu/Ile substitution.
    UNIMOD_Pro__Xle = 100000629,

    /// Gln->Pro: Gln->Pro substitution.
    UNIMOD_Gln__Pro = 100000630,

    /// Gln->Lys: Gln->Lys substitution.
    UNIMOD_Gln__Lys = 100000631,

    /// Gln->Glu: Gln->Glu substitution.
    UNIMOD_Gln__Glu = 100000632,

    /// Gln->His: Gln->His substitution.
    UNIMOD_Gln__His = 100000633,

    /// Gln->Arg: Gln->Arg substitution.
    UNIMOD_Gln__Arg = 100000634,

    /// Gln->Xle: Gln->Leu/Ile substitution.
    UNIMOD_Gln__Xle = 100000635,

    /// Arg->Ser: Arg->Ser substitution.
    UNIMOD_Arg__Ser = 100000636,

    /// Arg->Trp: Arg->Trp substitution.
    UNIMOD_Arg__Trp = 100000637,

    /// Arg->Thr: Arg->Thr substitution.
    UNIMOD_Arg__Thr = 100000638,

    /// Arg->Pro: Arg->Pro substitution.
    UNIMOD_Arg__Pro = 100000639,

    /// Arg->Lys: Arg->Lys substitution.
    UNIMOD_Arg__Lys = 100000640,

    /// Arg->His: Arg->His substitution.
    UNIMOD_Arg__His = 100000641,

    /// Arg->Gln: Arg->Gln substitution.
    UNIMOD_Arg__Gln = 100000642,

    /// Arg->Met: Arg->Met substitution.
    UNIMOD_Arg__Met = 100000643,

    /// Arg->Cys: Arg->Cys substitution.
    UNIMOD_Arg__Cys = 100000644,

    /// Arg->Xle: Arg->Leu/Ile substitution.
    UNIMOD_Arg__Xle = 100000645,

    /// Arg->Gly: Arg->Gly substitution.
    UNIMOD_Arg__Gly = 100000646,

    /// Ser->Phe: Ser->Phe substitution.
    UNIMOD_Ser__Phe = 100000647,

    /// Ser->Ala: Ser->Ala substitution.
    UNIMOD_Ser__Ala = 100000648,

    /// Ser->Trp: Ser->Trp substitution.
    UNIMOD_Ser__Trp = 100000649,

    /// Ser->Thr: Ser->Thr substitution.
    UNIMOD_Ser__Thr = 100000650,

    /// Ser->Asn: Ser->Asn substitution.
    UNIMOD_Ser__Asn = 100000651,

    /// Ser->Pro: Ser->Pro substitution.
    UNIMOD_Ser__Pro = 100000652,

    /// Ser->Tyr: Ser->Tyr substitution.
    UNIMOD_Ser__Tyr = 100000653,

    /// Ser->Cys: Ser->Cys substitution.
    UNIMOD_Ser__Cys = 100000654,

    /// Ser->Arg: Ser->Arg substitution.
    UNIMOD_Ser__Arg = 100000655,

    /// Ser->Xle: Ser->Leu/Ile substitution.
    UNIMOD_Ser__Xle = 100000656,

    /// Ser->Gly: Ser->Gly substitution.
    UNIMOD_Ser__Gly = 100000657,

    /// Thr->Ser: Thr->Ser substitution.
    UNIMOD_Thr__Ser = 100000658,

    /// Thr->Ala: Thr->Ala substitution.
    UNIMOD_Thr__Ala = 100000659,

    /// Thr->Asn: Thr->Asn substitution.
    UNIMOD_Thr__Asn = 100000660,

    /// Thr->Lys: Thr->Lys substitution.
    UNIMOD_Thr__Lys = 100000661,

    /// Thr->Pro: Thr->Pro substitution.
    UNIMOD_Thr__Pro = 100000662,

    /// Thr->Met: Thr->Met substitution.
    UNIMOD_Thr__Met = 100000663,

    /// Thr->Xle: Thr->Leu/Ile substitution.
    UNIMOD_Thr__Xle = 100000664,

    /// Thr->Arg: Thr->Arg substitution.
    UNIMOD_Thr__Arg = 100000665,

    /// Val->Phe: Val->Phe substitution.
    UNIMOD_Val__Phe = 100000666,

    /// Val->Ala: Val->Ala substitution.
    UNIMOD_Val__Ala = 100000667,

    /// Val->Glu: Val->Glu substitution.
    UNIMOD_Val__Glu = 100000668,

    /// Val->Met: Val->Met substitution.
    UNIMOD_Val__Met = 100000669,

    /// Val->Asp: Val->Asp substitution.
    UNIMOD_Val__Asp = 100000670,

    /// Val->Xle: Val->Leu/Ile substitution.
    UNIMOD_Val__Xle = 100000671,

    /// Val->Gly: Val->Gly substitution.
    UNIMOD_Val__Gly = 100000672,

    /// Trp->Ser: Trp->Ser substitution.
    UNIMOD_Trp__Ser = 100000673,

    /// Trp->Cys: Trp->Cys substitution.
    UNIMOD_Trp__Cys = 100000674,

    /// Trp->Arg: Trp->Arg substitution.
    UNIMOD_Trp__Arg = 100000675,

    /// Trp->Gly: Trp->Gly substitution.
    UNIMOD_Trp__Gly = 100000676,

    /// Trp->Xle: Trp->Leu/Ile substitution.
    UNIMOD_Trp__Xle = 100000677,

    /// Tyr->Phe: Tyr->Phe substitution.
    UNIMOD_Tyr__Phe = 100000678,

    /// Tyr->Ser: Tyr->Ser substitution.
    UNIMOD_Tyr__Ser = 100000679,

    /// Tyr->Asn: Tyr->Asn substitution.
    UNIMOD_Tyr__Asn = 100000680,

    /// Tyr->His: Tyr->His substitution.
    UNIMOD_Tyr__His = 100000681,

    /// Tyr->Asp: Tyr->Asp substitution.
    UNIMOD_Tyr__Asp = 100000682,

    /// Tyr->Cys: Tyr->Cys substitution.
    UNIMOD_Tyr__Cys = 100000683,

    /// BDMAPP: Mass Defect Tag on lysine e-amino.
    UNIMOD_BDMAPP = 100000684,

    /// NA-LNO2: Nitroalkylation by Nitro Linoleic Acid.
    UNIMOD_NA_LNO2 = 100000685,

    /// NA-OA-NO2: Nitroalkylation by Nitro Oleic Acid.
    UNIMOD_NA_OA_NO2 = 100000686,

    /// ICPL:2H(4): Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, medium form.
    UNIMOD_ICPL_2H_4_ = 100000687,

    /// Label:13C(6)15N(1): 13C(6) 15N(1) Silac label.
    UNIMOD_Label_13C_6_15N_1_ = 100000695,

    /// Label:2H(9)13C(6)15N(2): 13C(6) 15N(2) (D)9 SILAC label.
    UNIMOD_Label_2H_9_13C_6_15N_2_ = 100000696,

    /// NIC: Nicotinic Acid.
    UNIMOD_NIC = 100000697,

    /// dNIC: Deuterated Nicotinic Acid.
    UNIMOD_dNIC = 100000698,

    /// HNE-Delta:H(2)O: Dehydrated 4-hydroxynonenal.
    UNIMOD_HNE_Delta_H_2_O = 100000720,

    /// 4-ONE: 4-Oxononenal (ONE).
    UNIMOD_4_ONE = 100000721,

    /// O-Dimethylphosphate: O-Dimethylphosphorylation.
    UNIMOD_O_Dimethylphosphate = 100000723,

    /// O-Methylphosphate: O-Methylphosphorylation.
    UNIMOD_O_Methylphosphate = 100000724,

    /// Diethylphosphate: O-Diethylphosphorylation.
    UNIMOD_Diethylphosphate = 100000725,

    /// Ethylphosphate: O-Ethylphosphorylation.
    UNIMOD_Ethylphosphate = 100000726,

    /// O-pinacolylmethylphosphonate: O-pinacolylmethylphosphonylation.
    UNIMOD_O_pinacolylmethylphosphonate = 100000727,

    /// Methylphosphonate: Methylphosphonylation.
    UNIMOD_Methylphosphonate = 100000728,

    /// O-Isopropylmethylphosphonate: O-Isopropylmethylphosphonylation.
    UNIMOD_O_Isopropylmethylphosphonate = 100000729,

    /// iTRAQ8plex: Representative mass and accurate mass for 113, 114, 116 & 117.
    UNIMOD_iTRAQ8plex = 100000730,

    /// iTRAQ8plex:13C(6)15N(2): Accurate mass for 115, 118, 119 & 121.
    UNIMOD_iTRAQ8plex_13C_6_15N_2_ = 100000731,

    /// Ethanolamine: Carboxyl modification with ethanolamine.
    UNIMOD_Ethanolamine = 100000734,

    /// DTT_ST: Dithiothreitol (DTT).
    UNIMOD_DTT_ST = 100000735,

    /// DTT_C: Dithiothreitol (DTT) on Cys.
    UNIMOD_DTT_C = 100000736,

    /// TMT6plex: Sixplex Tandem Mass Tag®.
    UNIMOD_TMT6plex = 100000737,

    /// TMT2plex: Duplex Tandem Mass Tag®.
    UNIMOD_TMT2plex = 100000738,

    /// TMT: Native Tandem Mass Tag®.
    UNIMOD_TMT = 100000739,

    /// ExacTagThiol: ExacTag Thiol label mass for 2-4-7-10 plex.
    UNIMOD_ExacTagThiol = 100000740,

    /// ExacTagAmine: ExacTag Amine label mass for 2-4-7-10 plex.
    UNIMOD_ExacTagAmine = 100000741,

    /// 4-ONE+Delta:H(-2)O(-1): Dehydrated 4-Oxononenal Michael adduct.
    UNIMOD_4_ONE_Delta_H__2_O__1_ = 100000743,

    /// NO_SMX_SEMD: Nitroso Sulfamethoxazole Sulphenamide thiol adduct.
    UNIMOD_NO_SMX_SEMD = 100000744,

    /// NO_SMX_SMCT: Nitroso Sulfamethoxazole semimercaptal thiol adduct.
    UNIMOD_NO_SMX_SMCT = 100000745,

    /// NO_SMX_SIMD: Nitroso Sulfamethoxazole Sulfinamide thiol adduct.
    UNIMOD_NO_SMX_SIMD = 100000746,

    /// Malonyl: Malonylation of C and S residues.
    UNIMOD_Malonyl = 100000747,

    /// 3sulfo: Derivatization by N-term modification using 3-Sulfobenzoic succinimidyl ester.
    UNIMOD_3sulfo = 100000748,

    /// trifluoro: Trifluoroleucine replacement of leucine.
    UNIMOD_trifluoro = 100000750,

    /// TNBS: Tri nitro benzene.
    UNIMOD_TNBS = 100000751,

    /// IDEnT: Isotope Distribution Encoded Tag.
    UNIMOD_IDEnT = 100000762,

    /// DTT_ST:2H(6): Isotopically labeled Dithiothreitol (DTT) modification of serines or threonines.
    UNIMOD_DTT_ST_2H_6_ = 100000763,

    /// DTT_C:2H(6): Isotopically labeled Dithiothreitol (DTT) modification of cysteines.
    UNIMOD_DTT_C_2H_6_ = 100000764,

    /// Met-loss: Removal of initiator methionine from protein N-terminus.
    UNIMOD_Met_loss = 100000765,

    /// Met-loss+Acetyl: Removal of initiator methionine from protein N-terminus, then acetylation of the new N-terminus.
    UNIMOD_Met_loss_Acetyl = 100000766,

    /// Menadione-HQ: Menadione hydroquinone derivative.
    UNIMOD_Menadione_HQ = 100000767,

    /// Methyl+Acetyl:2H(3): Mono-methylated lysine labelled with Acetyl_heavy.
    UNIMOD_Methyl_Acetyl_2H_3_ = 100000768,

    /// lapachenole: Lapachenole photochemically added to cysteine.
    UNIMOD_lapachenole = 100000771,

    /// Label:13C(5): 13C(5) Silac label.
    UNIMOD_Label_13C_5_ = 100000772,

    /// maleimide: Maleimide.
    UNIMOD_maleimide = 100000773,

    /// Biotin-phenacyl: Alkylation by biotinylated form of phenacyl bromide.
    UNIMOD_Biotin_phenacyl = 100000774,

    /// Carboxymethyl:13C(2): Iodoacetic acid derivative w/ 13C label.
    UNIMOD_Carboxymethyl_13C_2_ = 100000775,

    /// NEM:2H(5): D5 N-ethylmaleimide on cysteines.
    UNIMOD_NEM_2H_5_ = 100000776,

    /// AEC-MAEC:2H(4): Deuterium cysteamine modification to S or T.
    UNIMOD_AEC_MAEC_2H_4_ = 100000792,

    /// Hex1HexNAc1: Hex1HexNAc1.
    UNIMOD_Hex1HexNAc1 = 100000793,

    /// Label:13C(6)+GlyGly: 13C6 labeled ubiquitinylation residue.
    UNIMOD_Label_13C_6__GlyGly = 100000799,

    /// Biotin:Thermo-21345: Was PentylamineBiotin.
    UNIMOD_Biotin_Thermo_21345 = 100000800,

    /// Pentylamine: Labeling transglutaminase substrate on glutamine side chain.
    UNIMOD_Pentylamine = 100000801,

    /// Biotin:Thermo-21360: Was Biotin-PEO4-hydrazide.
    UNIMOD_Biotin_Thermo_21360 = 100000811,

    /// Cy3b-maleimide: Fluorescent dye that labels cysteines.
    UNIMOD_Cy3b_maleimide = 100000821,

    /// Gly-loss+Amide: Enzymatic glycine removal leaving an amidated C-terminus.
    UNIMOD_Gly_loss_Amide = 100000822,

    /// BMOE: Addition of BMOE crosslinker.
    UNIMOD_BMOE = 100000824,

    /// DFDNB: Addition of DFDNB crosslinker.
    UNIMOD_DFDNB = 100000825,

    /// TMPP-Ac: Tris(2,4,6-trimethoxyphenyl)phosphonium acetic acid N-hydroxysuccinimide ester derivative.
    UNIMOD_TMPP_Ac = 100000827,

    /// Dihydroxyimidazolidine: Dihydroxy methylglyoxal adduct.
    UNIMOD_Dihydroxyimidazolidine = 100000830,

    /// Label:2H(4)+Acetyl: Acetyl 4,4,5,5-D4 Lysine.
    UNIMOD_Label_2H_4__Acetyl = 100000834,

    /// Label:13C(6)+Acetyl: Acetyl 13C(6) Silac label.
    UNIMOD_Label_13C_6__Acetyl = 100000835,

    /// Label:13C(6)15N(2)+Acetyl: Acetyl_13C(6) 15N(2) Silac label.
    UNIMOD_Label_13C_6_15N_2__Acetyl = 100000836,

    /// Arg->Npo: Arginine replacement by Nitropyrimidyl ornithine.
    UNIMOD_Arg__Npo = 100000837,

    /// EQIGG: Sumo mutant Smt3-WT tail following trypsin digestion.
    UNIMOD_EQIGG = 100000846,

    /// Arg2PG: Adduct of phenylglyoxal with Arg.
    UNIMOD_Arg2PG = 100000848,

    /// cGMP: S-guanylation.
    UNIMOD_cGMP = 100000849,

    /// cGMP+RMP-loss: S-guanylation-2.
    UNIMOD_cGMP_RMP_loss = 100000851,

    /// Label:2H(4)+GlyGly: Ubiquitination 2H4 lysine.
    UNIMOD_Label_2H_4__GlyGly = 100000853,

    /// Label:13C(8)15N(2): 13C(8) 15N(2) Silac label.
    UNIMOD_Label_13C_8_15N_2_ = 100000854,

    /// MG-H1: Methylglyoxal-derived hydroimidazolone.
    UNIMOD_MG_H1 = 100000859,

    /// G-H1: Glyoxal-derived hydroimiadazolone.
    UNIMOD_G_H1 = 100000860,

    /// ZGB: NHS ester linked Green Fluorescent Bodipy Dye.
    UNIMOD_ZGB = 100000861,

    /// Label:13C(1)2H(3): SILAC.
    UNIMOD_Label_13C_1_2H_3_ = 100000862,

    /// Label:13C(6)15N(2)+GlyGly: 13C(6) 15N(2) Lysine glygly.
    UNIMOD_Label_13C_6_15N_2__GlyGly = 100000864,

    /// ICPL:13C(6)2H(4): Bruker Daltonics SERVA-ICPL(TM) quantification chemistry, +10 Da form.
    UNIMOD_ICPL_13C_6_2H_4_ = 100000866,

    /// QEQTGG: SUMOylation by SUMO-1.
    UNIMOD_QEQTGG = 100000876,

    /// QQQTGG: SUMOylation by SUMO-2/3.
    UNIMOD_QQQTGG = 100000877,

    /// Bodipy: Bodipy modifications onto cysteine.
    UNIMOD_Bodipy = 100000878,

    /// Biotin:Thermo-21325: Was ChromoBiotin.
    UNIMOD_Biotin_Thermo_21325 = 100000884,

    /// Label:13C(1)2H(3)+Oxidation: Oxidised methionine 13C(1)2H(3) SILAC label.
    UNIMOD_Label_13C_1_2H_3__Oxidation = 100000885,

    /// HydroxymethylOP: 2-ammonio-6-[4-(hydroxymethyl)-3-oxidopyridinium-1-yl]- hexanoate.
    UNIMOD_HydroxymethylOP = 100000886,

    /// MDCC: Covalent linkage of maleimidyl coumarin probe (Molecular Probes D-10253).
    UNIMOD_MDCC = 100000887,

    /// mTRAQ: MTRAQ light.
    UNIMOD_mTRAQ = 100000888,

    /// mTRAQ:13C(3)15N(1): MTRAQ medium.
    UNIMOD_mTRAQ_13C_3_15N_1_ = 100000889,

    /// DyLight-maleimide: Thiol-reactive dye for fluorescence labelling of proteins.
    UNIMOD_DyLight_maleimide = 100000890,

    /// Methyl-PEO12-Maleimide: Methyl-PEO12-Maleimide.
    UNIMOD_Methyl_PEO12_Maleimide = 100000891,

    /// CarbamidomethylDTT: Carbamidomethylated DTT modification of cysteine.
    UNIMOD_CarbamidomethylDTT = 100000893,

    /// CarboxymethylDTT: Carboxymethylated DTT modification of cysteine.
    UNIMOD_CarboxymethylDTT = 100000894,

    /// Biotin-PEG-PRA: Biotin polyethyleneoxide (n=3) alkyne.
    UNIMOD_Biotin_PEG_PRA = 100000895,

    /// Met->Aha: Methionine replacement by azido homoalanine.
    UNIMOD_Met__Aha = 100000896,

    /// Label:15N(4): SILAC 15N(4).
    UNIMOD_Label_15N_4_ = 100000897,

    /// pyrophospho: Pyrophosphorylation of Ser/Thr.
    UNIMOD_pyrophospho = 100000898,

    /// Met->Hpg: Methionine replacement by homopropargylglycine.
    UNIMOD_Met__Hpg = 100000899,

    /// 4AcAllylGal: 2,3,4,6-tetra-O-Acetyl-1-allyl-alpha-D-galactopyranoside modification of cysteine.
    UNIMOD_4AcAllylGal = 100000901,

    /// DimethylArsino: Reaction with dimethylarsinous (AsIII) acid.
    UNIMOD_DimethylArsino = 100000902,

    /// Lys->CamCys: Lys->Cys substitution and carbamidomethylation.
    UNIMOD_Lys__CamCys = 100000903,

    /// Phe->CamCys: Phe->Cys substitution and carbamidomethylation.
    UNIMOD_Phe__CamCys = 100000904,

    /// Leu->MetOx: Leu->Met substitution and sulfoxidation.
    UNIMOD_Leu__MetOx = 100000905,

    /// Lys->MetOx: Lys->Met substitution and sulfoxidation.
    UNIMOD_Lys__MetOx = 100000906,

    /// Galactosyl: Galactosyl hydroxylysine.
    UNIMOD_Galactosyl = 100000907,

    /// SMCC-maleimide: Modified SMCC maleimide with 3-(dimethylamino)-1-propylamine.
    UNIMOD_SMCC_maleimide = 100000908,

    /// Bacillosamine: 2,4-diacetamido-2,4,6-trideoxyglucopyranose.
    UNIMOD_Bacillosamine = 100000910,

    /// MTSL: Cys modification by (1-oxyl-2,2,5,5-tetramethyl-3-pyrroline-3-methyl)methanesulfonate (MTSL).
    UNIMOD_MTSL = 100000911,

    /// HNE-BAHAH: 4-hydroxy-2-nonenal and biotinamidohexanoic acid hydrazide, reduced.
    UNIMOD_HNE_BAHAH = 100000912,

    /// Methylmalonylation: Methylmalonylation on Serine.
    UNIMOD_Methylmalonylation = 100000914,

    /// Ethoxyformyl: Ethoxyformylation.
    UNIMOD_Ethoxyformyl = 100000915,

    /// Label:13C(4)15N(2)+GlyGly: 13C(4) 15N(2) Lysine glygly.
    UNIMOD_Label_13C_4_15N_2__GlyGly = 100000923,

    /// ethylamino: Ethyl amino.
    UNIMOD_ethylamino = 100000926,

    /// MercaptoEthanol: 2-OH-ethyl thio-Ser.
    UNIMOD_MercaptoEthanol = 100000928,

    /// Ethyl+Deamidated: Deamidation followed by esterification with ethanol.
    UNIMOD_Ethyl_Deamidated = 100000931,

    /// VFQQQTGG: SUMOylation by SUMO-2/3 (formic acid cleavage).
    UNIMOD_VFQQQTGG = 100000932,

    /// VIEVYQEQTGG: SUMOylation by SUMO-1 (formic acid cleavage).
    UNIMOD_VIEVYQEQTGG = 100000933,

    /// AMTzHexNAc2: Photocleavable Biotin + GalNAz on O-GlcNAc.
    UNIMOD_AMTzHexNAc2 = 100000934,

    /// Atto495Maleimide: High molecular absorption maleimide label for proteins.
    UNIMOD_Atto495Maleimide = 100000935,

    /// Chlorination: Chlorination of tyrosine residues.
    UNIMOD_Chlorination = 100000936,

    /// dichlorination: Dichlorination.
    UNIMOD_dichlorination = 100000937,

    /// AROD: Cysteine modifier.
    UNIMOD_AROD = 100000938,

    /// Cys->methylaminoAla: Carbamidomethylated Cys that undergoes beta-elimination and Michael addition of methylamine.
    UNIMOD_Cys__methylaminoAla = 100000939,

    /// Cys->ethylaminoAla: Carbamidomethylated Cys that undergoes beta-elimination and Michael addition of ethylamine.
    UNIMOD_Cys__ethylaminoAla = 100000940,

    /// DNPS: 2,4-Dinitrobenzenesulfenyl.
    UNIMOD_DNPS = 100000941,

    /// SulfoGMBS: High molecular absorption label for proteins.
    UNIMOD_SulfoGMBS = 100000942,

    /// DimethylamineGMBS: Modified GMBS X linker for proteins.
    UNIMOD_DimethylamineGMBS = 100000943,

    /// Label:15N(2)2H(9): SILAC label.
    UNIMOD_Label_15N_2_2H_9_ = 100000944,

    /// LG-anhydrolactam: Levuglandinyl-lysine anhydrolactam adduct.
    UNIMOD_LG_anhydrolactam = 100000946,

    /// LG-pyrrole: Levuglandinyl-lysine pyrrole adduct.
    UNIMOD_LG_pyrrole = 100000947,

    /// LG-anhyropyrrole: Levuglandinyl-lysine anhyropyrrole adduct.
    UNIMOD_LG_anhyropyrrole = 100000948,

    /// 3-deoxyglucosone: Condensation product of 3-deoxyglucosone.
    UNIMOD_3_deoxyglucosone = 100000949,

    /// Cation:Li: Replacement of proton by lithium.
    UNIMOD_Cation_Li = 100000950,

    /// Cation:Ca[II]: Replacement of 2 protons by calcium.
    UNIMOD_Cation_Ca_II_ = 100000951,

    /// Cation:Fe[II]: Replacement of 2 protons by iron.
    UNIMOD_Cation_Fe_II_ = 100000952,

    /// Cation:Ni[II]: Replacement of 2 protons by nickel.
    UNIMOD_Cation_Ni_II_ = 100000953,

    /// Cation:Zn[II]: Replacement of 2 protons by zinc.
    UNIMOD_Cation_Zn_II_ = 100000954,

    /// Cation:Ag: Replacement of proton by silver.
    UNIMOD_Cation_Ag = 100000955,

    /// Cation:Mg[II]: Replacement of 2 protons by magnesium.
    UNIMOD_Cation_Mg_II_ = 100000956,

    /// 2-succinyl: S-(2-succinyl) cysteine.
    UNIMOD_2_succinyl = 100000957,

    /// Propargylamine: Propargylamine.
    UNIMOD_Propargylamine = 100000958,

    /// Phosphopropargyl: Phospho-propargylamine.
    UNIMOD_Phosphopropargyl = 100000959,

    /// SUMO2135: SUMOylation by SUMO-1 after tryptic cleavage.
    UNIMOD_SUMO2135 = 100000960,

    /// SUMO3549: SUMOylation by SUMO-2/3 after tryptic cleavage.
    UNIMOD_SUMO3549 = 100000961,

    /// thioacylPA: Membrane protein extraction.
    UNIMOD_thioacylPA = 100000967,

    /// maleimide3: Maleimide-3-saccharide.
    UNIMOD_maleimide3 = 100000971,

    /// maleimide5: Maleimide-5-saccharide.
    UNIMOD_maleimide5 = 100000972,

    /// Puromycin: Puromycin.
    UNIMOD_Puromycin = 100000973,

    /// Chlorpyrifos: O,O-diethyl o-3,5,6-trichloro-2-pyridyl phosphorothioate.
    UNIMOD_Chlorpyrifos = 100000975,

    /// Carbofuran: 2,3-dihydro-2,2-dimethyl-7-benzofuranol N-methyl carbamate.
    UNIMOD_Carbofuran = 100000977,

    /// BITC: Benzyl isothiocyanate.
    UNIMOD_BITC = 100000978,

    /// PEITC: Phenethyl isothiocyanate.
    UNIMOD_PEITC = 100000979,

    /// glucosone: Condensation product of glucosone.
    UNIMOD_glucosone = 100000981,

    /// cysTMT: Native cysteine-reactive Tandem Mass Tag®.
    UNIMOD_cysTMT = 100000984,

    /// cysTMT6plex: Cysteine-reactive Sixplex Tandem Mass Tag®.
    UNIMOD_cysTMT6plex = 100000985,

    /// Label:13C(6)+Dimethyl: Dimethyl 13C(6) Silac label.
    UNIMOD_Label_13C_6__Dimethyl = 100000986,

    /// Label:13C(6)15N(2)+Dimethyl: Dimethyl 13C(6)15N(2) Silac label.
    UNIMOD_Label_13C_6_15N_2__Dimethyl = 100000987,

    /// Ammonium: Replacement of proton with ammonium ion.
    UNIMOD_Ammonium = 100000989,

    /// ISD_z+2_ion: ISD (z+2)-series.
    UNIMOD_ISD_z_2_ion = 100000991,

    /// Biotin:Sigma-B1267: Was Biotin-maleimide.
    UNIMOD_Biotin_Sigma_B1267 = 100000993,

    /// Label:15N(1): 15N(1).
    UNIMOD_Label_15N_1_ = 100000994,

    /// Label:15N(2): 15N(2).
    UNIMOD_Label_15N_2_ = 100000995,

    /// Label:15N(3): 15N(3).
    UNIMOD_Label_15N_3_ = 100000996,

    /// sulfo+amino: Aminotyrosine with sulfation.
    UNIMOD_sulfo_amino = 100000997,

    /// BHAc: N-biotinyl-6-aminohexanoyl.
    UNIMOD_BHAc = 100000998,

    /// AHA-Alkyne: Azidohomoalanine (AHA) bound to propargylglycine-NH2 (alkyne).
    UNIMOD_AHA_Alkyne = 100001000,

    /// AHA-Alkyne-KDDDD: Azidohomoalanine (AHA) bound to DDDDK-propargylglycine-NH2 (alkyne).
    UNIMOD_AHA_Alkyne_KDDDD = 100001001,

    /// EGCG1: (-)-epigallocatechin-3-gallate.
    UNIMOD_EGCG1 = 100001002,

    /// EGCG2: (-)-dehydroepigallocatechin.
    UNIMOD_EGCG2 = 100001003,

    /// Label:13C(6)15N(4)+Methyl: Monomethylated Arg13C(6) 15N(4).
    UNIMOD_Label_13C_6_15N_4__Methyl = 100001004,

    /// Label:13C(6)15N(4)+Dimethyl: Dimethylated Arg13C(6) 15N(4).
    UNIMOD_Label_13C_6_15N_4__Dimethyl = 100001005,

    /// Label:13C(6)15N(4)+Methyl:2H(3)13C(1): 2H(3) 13C(1) monomethylated Arg13C(6) 15N(4).
    UNIMOD_Label_13C_6_15N_4__Methyl_2H_3_13C_1_ = 100001006,

    /// Label:13C(6)15N(4)+Dimethyl:2H(6)13C(2): 2H(6) 13C(2) Dimethylated Arg13C(6) 15N(4).
    UNIMOD_Label_13C_6_15N_4__Dimethyl_2H_6_13C_2_ = 100001007,

    /// SecCarbamidomethyl: Sec Iodoacetamide derivative.
    UNIMOD_SecCarbamidomethyl = 100001008,

    /// Thiazolidine: Addition of Carbon to cysteine.
    UNIMOD_Thiazolidine = 100001009,

    /// DEDGFLYMVYASQETFG: Addition of DEDGFLYMVYASQETFG.
    UNIMOD_DEDGFLYMVYASQETFG = 100001010,

    /// Biotin:Invitrogen-M1602: Nalpha-(3-maleimidylpropionyl)biocytin.
    UNIMOD_Biotin_Invitrogen_M1602 = 100001012,

    /// glycidamide: Glycidamide adduct.
    UNIMOD_glycidamide = 100001014,

    /// Ahx2+Hsl: C-terminal homoserine lactone and two aminohexanoic acids.
    UNIMOD_Ahx2_Hsl = 100001015,

    /// DMPO: DMPO spin-trap nitrone adduct.
    UNIMOD_DMPO = 100001017,

    /// ICDID: Isotope-Coded Dimedone light form.
    UNIMOD_ICDID = 100001018,

    /// ICDID:2H(6): Isotope-Coded Dimedone heavy form.
    UNIMOD_ICDID_2H_6_ = 100001019,

    /// Xlink:DSS: Monolink of DSS/BS3 crosslinker to Lys or N-terminus.
    UNIMOD_Xlink_DSS = 100001020,

    /// Xlink:EGS: Monolink of EGS crosslinker to Lys or N-terminus.
    UNIMOD_Xlink_EGS = 100001021,

    /// Xlink:DST: Monolink of DST crosslinker to Lys or N-terminus.
    UNIMOD_Xlink_DST = 100001022,

    /// Xlink:DTSSP: Monolink of DSP/DTSSP crosslinker to Lys or N-terminus.
    UNIMOD_Xlink_DTSSP = 100001023,

    /// Xlink:SMCC: Monolink of sulfoSMCC/SMCC crosslinker to Cys.
    UNIMOD_Xlink_SMCC = 100001024,

    /// Xlink:DMP-de: Monolink of DMP crosslinker to Lys or N-terminus.
    UNIMOD_Xlink_DMP_de = 100001027,

    /// Xlink:EGScleaved: EGS crosslinker to Lys or N-terminus following hydroxylamine cleavage.
    UNIMOD_Xlink_EGScleaved = 100001028,

    /// Biotin:Thermo-88310: Desthiobiotin modification of lysine.
    UNIMOD_Biotin_Thermo_88310 = 100001031,

    /// 2-nitrobenzyl: Tyrosine caged with 2-nitrobenzyl (ONB).
    UNIMOD_2_nitrobenzyl = 100001032,

    /// SecNEM: N-ethylmaleimide on selenocysteines.
    UNIMOD_SecNEM = 100001033,

    /// SecNEM:2H(5): D5 N-ethylmaleimide on selenocysteines.
    UNIMOD_SecNEM_2H_5_ = 100001034,

    /// Thiadiazole: Thiadiazolydation of Cys.
    UNIMOD_Thiadiazole = 100001035,

    /// Withaferin: Modification of cystein by withaferin.
    UNIMOD_Withaferin = 100001036,

    /// Biotin:Thermo-88317: Desthiobiotin fluorophosphonate.
    UNIMOD_Biotin_Thermo_88317 = 100001037,

    /// TAMRA-FP: TAMRA fluorophosphonate modification of serine.
    UNIMOD_TAMRA_FP = 100001038,

    /// Biotin:Thermo-21901+H2O: Maleimide-Biotin + Water.
    UNIMOD_Biotin_Thermo_21901_H2O = 100001039,

    /// Deoxyhypusine: Deoxyhypusine.
    UNIMOD_Deoxyhypusine = 100001041,

    /// Acetyldeoxyhypusine: Acetyldeoxyhypusine.
    UNIMOD_Acetyldeoxyhypusine = 100001042,

    /// Acetylhypusine: Acetylhypusine.
    UNIMOD_Acetylhypusine = 100001043,

    /// Ala->Cys: Ala->Cys substitution.
    UNIMOD_Ala__Cys = 100001044,

    /// Ala->Phe: Ala->Phe substitution.
    UNIMOD_Ala__Phe = 100001045,

    /// Ala->His: Ala->His substitution.
    UNIMOD_Ala__His = 100001046,

    /// Ala->Xle: Ala->Leu/Ile substitution.
    UNIMOD_Ala__Xle = 100001047,

    /// Ala->Lys: Ala->Lys substitution.
    UNIMOD_Ala__Lys = 100001048,

    /// Ala->Met: Ala->Met substitution.
    UNIMOD_Ala__Met = 100001049,

    /// Ala->Asn: Ala->Asn substitution.
    UNIMOD_Ala__Asn = 100001050,

    /// Ala->Gln: Ala->Gln substitution.
    UNIMOD_Ala__Gln = 100001051,

    /// Ala->Arg: Ala->Arg substitution.
    UNIMOD_Ala__Arg = 100001052,

    /// Ala->Trp: Ala->Trp substitution.
    UNIMOD_Ala__Trp = 100001053,

    /// Ala->Tyr: Ala->Tyr substitution.
    UNIMOD_Ala__Tyr = 100001054,

    /// Cys->Ala: Cys->Ala substitution.
    UNIMOD_Cys__Ala = 100001055,

    /// Cys->Asp: Cys->Asp substitution.
    UNIMOD_Cys__Asp = 100001056,

    /// Cys->Glu: Cys->Glu substitution.
    UNIMOD_Cys__Glu = 100001057,

    /// Cys->His: Cys->His substitution.
    UNIMOD_Cys__His = 100001058,

    /// Cys->Xle: Cys->Leu/Ile substitution.
    UNIMOD_Cys__Xle = 100001059,

    /// Cys->Lys: Cys->Lys substitution.
    UNIMOD_Cys__Lys = 100001060,

    /// Cys->Met: Cys->Met substitution.
    UNIMOD_Cys__Met = 100001061,

    /// Cys->Asn: Cys->Asn substitution.
    UNIMOD_Cys__Asn = 100001062,

    /// Cys->Pro: Cys->Pro substitution.
    UNIMOD_Cys__Pro = 100001063,

    /// Cys->Gln: Cys->Gln substitution.
    UNIMOD_Cys__Gln = 100001064,

    /// Cys->Thr: Cys->Thr substitution.
    UNIMOD_Cys__Thr = 100001065,

    /// Cys->Val: Cys->Val substitution.
    UNIMOD_Cys__Val = 100001066,

    /// Asp->Cys: Asp->Cys substitution.
    UNIMOD_Asp__Cys = 100001067,

    /// Asp->Phe: Asp->Phe substitution.
    UNIMOD_Asp__Phe = 100001068,

    /// Asp->Xle: Asp->Leu/Ile substitution.
    UNIMOD_Asp__Xle = 100001069,

    /// Asp->Lys: Asp->Lys substitution.
    UNIMOD_Asp__Lys = 100001070,

    /// Asp->Met: Asp->Met substitution.
    UNIMOD_Asp__Met = 100001071,

    /// Asp->Pro: Asp->Pro substitution.
    UNIMOD_Asp__Pro = 100001072,

    /// Asp->Gln: Asp->Gln substitution.
    UNIMOD_Asp__Gln = 100001073,

    /// Asp->Arg: Asp->Arg substitution.
    UNIMOD_Asp__Arg = 100001074,

    /// Asp->Ser: Asp->Ser substitution.
    UNIMOD_Asp__Ser = 100001075,

    /// Asp->Thr: Asp->Thr substitution.
    UNIMOD_Asp__Thr = 100001076,

    /// Asp->Trp: Asp->Trp substitution.
    UNIMOD_Asp__Trp = 100001077,

    /// Glu->Cys: Glu->Cys substitution.
    UNIMOD_Glu__Cys = 100001078,

    /// Glu->Phe: Glu->Phe substitution.
    UNIMOD_Glu__Phe = 100001079,

    /// Glu->His: Glu->His substitution.
    UNIMOD_Glu__His = 100001080,

    /// Glu->Xle: Glu->Leu/Ile substitution.
    UNIMOD_Glu__Xle = 100001081,

    /// Glu->Met: Glu->Met substitution.
    UNIMOD_Glu__Met = 100001082,

    /// Glu->Asn: Glu->Asn substitution.
    UNIMOD_Glu__Asn = 100001083,

    /// Glu->Pro: Glu->Pro substitution.
    UNIMOD_Glu__Pro = 100001084,

    /// Glu->Arg: Glu->Arg substitution.
    UNIMOD_Glu__Arg = 100001085,

    /// Glu->Ser: Glu->Ser substitution.
    UNIMOD_Glu__Ser = 100001086,

    /// Glu->Thr: Glu->Thr substitution.
    UNIMOD_Glu__Thr = 100001087,

    /// Glu->Trp: Glu->Trp substitution.
    UNIMOD_Glu__Trp = 100001088,

    /// Glu->Tyr: Glu->Tyr substitution.
    UNIMOD_Glu__Tyr = 100001089,

    /// Phe->Ala: Phe->Ala substitution.
    UNIMOD_Phe__Ala = 100001090,

    /// Phe->Asp: Phe->Asp substitution.
    UNIMOD_Phe__Asp = 100001091,

    /// Phe->Glu: Phe->Glu substitution.
    UNIMOD_Phe__Glu = 100001092,

    /// Phe->Gly: Phe->Gly substitution.
    UNIMOD_Phe__Gly = 100001093,

    /// Phe->His: Phe->His substitution.
    UNIMOD_Phe__His = 100001094,

    /// Phe->Lys: Phe->Lys substitution.
    UNIMOD_Phe__Lys = 100001095,

    /// Phe->Met: Phe->Met substitution.
    UNIMOD_Phe__Met = 100001096,

    /// Phe->Asn: Phe->Asn substitution.
    UNIMOD_Phe__Asn = 100001097,

    /// Phe->Pro: Phe->Pro substitution.
    UNIMOD_Phe__Pro = 100001098,

    /// Phe->Gln: Phe->Gln substitution.
    UNIMOD_Phe__Gln = 100001099,

    /// Phe->Arg: Phe->Arg substitution.
    UNIMOD_Phe__Arg = 100001100,

    /// Phe->Thr: Phe->Thr substitution.
    UNIMOD_Phe__Thr = 100001101,

    /// Phe->Trp: Phe->Trp substitution.
    UNIMOD_Phe__Trp = 100001102,

    /// Gly->Phe: Gly->Phe substitution.
    UNIMOD_Gly__Phe = 100001103,

    /// Gly->His: Gly->His substitution.
    UNIMOD_Gly__His = 100001104,

    /// Gly->Xle: Gly->Leu/Ile substitution.
    UNIMOD_Gly__Xle = 100001105,

    /// Gly->Lys: Gly->Lys substitution.
    UNIMOD_Gly__Lys = 100001106,

    /// Gly->Met: Gly->Met substitution.
    UNIMOD_Gly__Met = 100001107,

    /// Gly->Asn: Gly->Asn substitution.
    UNIMOD_Gly__Asn = 100001108,

    /// Gly->Pro: Gly->Pro substitution.
    UNIMOD_Gly__Pro = 100001109,

    /// Gly->Gln: Gly->Gln substitution.
    UNIMOD_Gly__Gln = 100001110,

    /// Gly->Thr: Gly->Thr substitution.
    UNIMOD_Gly__Thr = 100001111,

    /// Gly->Tyr: Gly->Tyr substitution.
    UNIMOD_Gly__Tyr = 100001112,

    /// His->Ala: His->Ala substitution.
    UNIMOD_His__Ala = 100001113,

    /// His->Cys: His->Cys substitution.
    UNIMOD_His__Cys = 100001114,

    /// His->Glu: His->Glu substitution.
    UNIMOD_His__Glu = 100001115,

    /// His->Phe: His->Phe substitution.
    UNIMOD_His__Phe = 100001116,

    /// His->Gly: His->Gly substitution.
    UNIMOD_His__Gly = 100001117,

    /// His->Lys: His->Lys substitution.
    UNIMOD_His__Lys = 100001119,

    /// His->Met: His->Met substitution.
    UNIMOD_His__Met = 100001120,

    /// His->Ser: His->Ser substitution.
    UNIMOD_His__Ser = 100001121,

    /// His->Thr: His->Thr substitution.
    UNIMOD_His__Thr = 100001122,

    /// His->Val: His->Val substitution.
    UNIMOD_His__Val = 100001123,

    /// His->Trp: His->Trp substitution.
    UNIMOD_His__Trp = 100001124,

    /// Xle->Ala: Leu/Ile->Ala substitution.
    UNIMOD_Xle__Ala = 100001125,

    /// Xle->Cys: Leu/Ile->Cys substitution.
    UNIMOD_Xle__Cys = 100001126,

    /// Xle->Asp: Leu/Ile->Asp substitution.
    UNIMOD_Xle__Asp = 100001127,

    /// Xle->Glu: Leu/Ile->Glu substitution.
    UNIMOD_Xle__Glu = 100001128,

    /// Xle->Gly: Leu/Ile->Gly substitution.
    UNIMOD_Xle__Gly = 100001129,

    /// Xle->Tyr: Leu/Ile->Tyr substitution.
    UNIMOD_Xle__Tyr = 100001130,

    /// Lys->Ala: Lys->Ala substitution.
    UNIMOD_Lys__Ala = 100001131,

    /// Lys->Cys: Lys->Cys substitution.
    UNIMOD_Lys__Cys = 100001132,

    /// Lys->Asp: Lys->Asp substitution.
    UNIMOD_Lys__Asp = 100001133,

    /// Lys->Phe: Lys->Phe substitution.
    UNIMOD_Lys__Phe = 100001134,

    /// Lys->Gly: Lys->Gly substitution.
    UNIMOD_Lys__Gly = 100001135,

    /// Lys->His: Lys->His substitution.
    UNIMOD_Lys__His = 100001136,

    /// Lys->Pro: Lys->Pro substitution.
    UNIMOD_Lys__Pro = 100001137,

    /// Lys->Ser: Lys->Ser substitution.
    UNIMOD_Lys__Ser = 100001138,

    /// Lys->Val: Lys->Val substitution.
    UNIMOD_Lys__Val = 100001139,

    /// Lys->Trp: Lys->Trp substitution.
    UNIMOD_Lys__Trp = 100001140,

    /// Lys->Tyr: Lys->Tyr substitution.
    UNIMOD_Lys__Tyr = 100001141,

    /// Met->Ala: Met->Ala substitution.
    UNIMOD_Met__Ala = 100001142,

    /// Met->Cys: Met->Cys substitution.
    UNIMOD_Met__Cys = 100001143,

    /// Met->Asp: Met->Asp substitution.
    UNIMOD_Met__Asp = 100001144,

    /// Met->Glu: Met->Glu substitution.
    UNIMOD_Met__Glu = 100001145,

    /// Met->Phe: Met->Phe substitution.
    UNIMOD_Met__Phe = 100001146,

    /// Met->Gly: Met->Gly substitution.
    UNIMOD_Met__Gly = 100001147,

    /// Met->His: Met->His substitution.
    UNIMOD_Met__His = 100001148,

    /// Met->Asn: Met->Asn substitution.
    UNIMOD_Met__Asn = 100001149,

    /// Met->Pro: Met->Pro substitution.
    UNIMOD_Met__Pro = 100001150,

    /// Met->Gln: Met->Gln substitution.
    UNIMOD_Met__Gln = 100001151,

    /// Met->Ser: Met->Ser substitution.
    UNIMOD_Met__Ser = 100001152,

    /// Met->Trp: Met->Trp substitution.
    UNIMOD_Met__Trp = 100001153,

    /// Met->Tyr: Met->Tyr substitution.
    UNIMOD_Met__Tyr = 100001154,

    /// Asn->Ala: Asn->Ala substitution.
    UNIMOD_Asn__Ala = 100001155,

    /// Asn->Cys: Asn->Cys substitution.
    UNIMOD_Asn__Cys = 100001156,

    /// Asn->Glu: Asn->Glu substitution.
    UNIMOD_Asn__Glu = 100001157,

    /// Asn->Phe: Asn->Phe substitution.
    UNIMOD_Asn__Phe = 100001158,

    /// Asn->Gly: Asn->Gly substitution.
    UNIMOD_Asn__Gly = 100001159,

    /// Asn->Met: Asn->Met substitution.
    UNIMOD_Asn__Met = 100001160,

    /// Asn->Pro: Asn->Pro substitution.
    UNIMOD_Asn__Pro = 100001161,

    /// Asn->Gln: Asn->Gln substitution.
    UNIMOD_Asn__Gln = 100001162,

    /// Asn->Arg: Asn->Arg substitution.
    UNIMOD_Asn__Arg = 100001163,

    /// Asn->Val: Asn->Val substitution.
    UNIMOD_Asn__Val = 100001164,

    /// Asn->Trp: Asn->Trp substitution.
    UNIMOD_Asn__Trp = 100001165,

    /// Pro->Cys: Pro->Cys substitution.
    UNIMOD_Pro__Cys = 100001166,

    /// Pro->Asp: Pro->Asp substitution.
    UNIMOD_Pro__Asp = 100001167,

    /// Pro->Glu: Pro->Glu substitution.
    UNIMOD_Pro__Glu = 100001168,

    /// Pro->Phe: Pro->Phe substitution.
    UNIMOD_Pro__Phe = 100001169,

    /// Pro->Gly: Pro->Gly substitution.
    UNIMOD_Pro__Gly = 100001170,

    /// Pro->Lys: Pro->Lys substitution.
    UNIMOD_Pro__Lys = 100001171,

    /// Pro->Met: Pro->Met substitution.
    UNIMOD_Pro__Met = 100001172,

    /// Pro->Asn: Pro->Asn substitution.
    UNIMOD_Pro__Asn = 100001173,

    /// Pro->Val: Pro->Val substitution.
    UNIMOD_Pro__Val = 100001174,

    /// Pro->Trp: Pro->Trp substitution.
    UNIMOD_Pro__Trp = 100001175,

    /// Pro->Tyr: Pro->Tyr substitution.
    UNIMOD_Pro__Tyr = 100001176,

    /// Gln->Ala: Gln->Ala substitution.
    UNIMOD_Gln__Ala = 100001177,

    /// Gln->Cys: Gln->Cys substitution.
    UNIMOD_Gln__Cys = 100001178,

    /// Gln->Asp: Gln->Asp substitution.
    UNIMOD_Gln__Asp = 100001179,

    /// Gln->Phe: Gln->Phe substitution.
    UNIMOD_Gln__Phe = 100001180,

    /// Gln->Gly: Gln->Gly substitution.
    UNIMOD_Gln__Gly = 100001181,

    /// Gln->Met: Gln->Met substitution.
    UNIMOD_Gln__Met = 100001182,

    /// Gln->Asn: Gln->Asn substitution.
    UNIMOD_Gln__Asn = 100001183,

    /// Gln->Ser: Gln->Ser substitution.
    UNIMOD_Gln__Ser = 100001184,

    /// Gln->Thr: Gln->Thr substitution.
    UNIMOD_Gln__Thr = 100001185,

    /// Gln->Val: Gln->Val substitution.
    UNIMOD_Gln__Val = 100001186,

    /// Gln->Trp: Gln->Trp substitution.
    UNIMOD_Gln__Trp = 100001187,

    /// Gln->Tyr: Gln->Tyr substitution.
    UNIMOD_Gln__Tyr = 100001188,

    /// Arg->Ala: Arg->Ala substitution.
    UNIMOD_Arg__Ala = 100001189,

    /// Arg->Asp: Arg->Asp substitution.
    UNIMOD_Arg__Asp = 100001190,

    /// Arg->Glu: Arg->Glu substitution.
    UNIMOD_Arg__Glu = 100001191,

    /// Arg->Asn: Arg->Asn substitution.
    UNIMOD_Arg__Asn = 100001192,

    /// Arg->Val: Arg->Val substitution.
    UNIMOD_Arg__Val = 100001193,

    /// Arg->Tyr: Arg->Tyr substitution.
    UNIMOD_Arg__Tyr = 100001194,

    /// Arg->Phe: Arg->Phe substitution.
    UNIMOD_Arg__Phe = 100001195,

    /// Ser->Asp: Ser->Asp substitution.
    UNIMOD_Ser__Asp = 100001196,

    /// Ser->Glu: Ser->Glu substitution.
    UNIMOD_Ser__Glu = 100001197,

    /// Ser->His: Ser->His substitution.
    UNIMOD_Ser__His = 100001198,

    /// Ser->Lys: Ser->Lys substitution.
    UNIMOD_Ser__Lys = 100001199,

    /// Ser->Met: Ser->Met substitution.
    UNIMOD_Ser__Met = 100001200,

    /// Ser->Gln: Ser->Gln substitution.
    UNIMOD_Ser__Gln = 100001201,

    /// Ser->Val: Ser->Val substitution.
    UNIMOD_Ser__Val = 100001202,

    /// Thr->Cys: Thr->Cys substitution.
    UNIMOD_Thr__Cys = 100001203,

    /// Thr->Asp: Thr->Asp substitution.
    UNIMOD_Thr__Asp = 100001204,

    /// Thr->Glu: Thr->Glu substitution.
    UNIMOD_Thr__Glu = 100001205,

    /// Thr->Phe: Thr->Phe substitution.
    UNIMOD_Thr__Phe = 100001206,

    /// Thr->Gly: Thr->Gly substitution.
    UNIMOD_Thr__Gly = 100001207,

    /// Thr->His: Thr->His substitution.
    UNIMOD_Thr__His = 100001208,

    /// Thr->Gln: Thr->Gln substitution.
    UNIMOD_Thr__Gln = 100001209,

    /// Thr->Val: Thr->Val substitution.
    UNIMOD_Thr__Val = 100001210,

    /// Thr->Trp: Thr->Trp substitution.
    UNIMOD_Thr__Trp = 100001211,

    /// Thr->Tyr: Thr->Tyr substitution.
    UNIMOD_Thr__Tyr = 100001212,

    /// Val->Cys: Val->Cys substitution.
    UNIMOD_Val__Cys = 100001213,

    /// Val->His: Val->His substitution.
    UNIMOD_Val__His = 100001214,

    /// Val->Lys: Val->Lys substitution.
    UNIMOD_Val__Lys = 100001215,

    /// Val->Asn: Val->Asn substitution.
    UNIMOD_Val__Asn = 100001216,

    /// Val->Pro: Val->Pro substitution.
    UNIMOD_Val__Pro = 100001217,

    /// Val->Gln: Val->Gln substitution.
    UNIMOD_Val__Gln = 100001218,

    /// Val->Arg: Val->Arg substitution.
    UNIMOD_Val__Arg = 100001219,

    /// Val->Ser: Val->Ser substitution.
    UNIMOD_Val__Ser = 100001220,

    /// Val->Thr: Val->Thr substitution.
    UNIMOD_Val__Thr = 100001221,

    /// Val->Trp: Val->Trp substitution.
    UNIMOD_Val__Trp = 100001222,

    /// Val->Tyr: Val->Tyr substitution.
    UNIMOD_Val__Tyr = 100001223,

    /// Trp->Ala: Trp->Ala substitution.
    UNIMOD_Trp__Ala = 100001224,

    /// Trp->Asp: Trp->Asp substitution.
    UNIMOD_Trp__Asp = 100001225,

    /// Trp->Glu: Trp->Glu substitution.
    UNIMOD_Trp__Glu = 100001226,

    /// Trp->Phe: Trp->Phe substitution.
    UNIMOD_Trp__Phe = 100001227,

    /// Trp->His: Trp->His substitution.
    UNIMOD_Trp__His = 100001228,

    /// Trp->Lys: Trp->Lys substitution.
    UNIMOD_Trp__Lys = 100001229,

    /// Trp->Met: Trp->Met substitution.
    UNIMOD_Trp__Met = 100001230,

    /// Trp->Asn: Trp->Asn substitution.
    UNIMOD_Trp__Asn = 100001231,

    /// Trp->Pro: Trp->Pro substitution.
    UNIMOD_Trp__Pro = 100001232,

    /// Trp->Gln: Trp->Gln substitution.
    UNIMOD_Trp__Gln = 100001233,

    /// Trp->Thr: Trp->Thr substitution.
    UNIMOD_Trp__Thr = 100001234,

    /// Trp->Val: Trp->Val substitution.
    UNIMOD_Trp__Val = 100001235,

    /// Trp->Tyr: Trp->Tyr substitution.
    UNIMOD_Trp__Tyr = 100001236,

    /// Tyr->Ala: Tyr->Ala substitution.
    UNIMOD_Tyr__Ala = 100001237,

    /// Tyr->Glu: Tyr->Glu substitution.
    UNIMOD_Tyr__Glu = 100001238,

    /// Tyr->Gly: Tyr->Gly substitution.
    UNIMOD_Tyr__Gly = 100001239,

    /// Tyr->Lys: Tyr->Lys substitution.
    UNIMOD_Tyr__Lys = 100001240,

    /// Tyr->Met: Tyr->Met substitution.
    UNIMOD_Tyr__Met = 100001241,

    /// Tyr->Pro: Tyr->Pro substitution.
    UNIMOD_Tyr__Pro = 100001242,

    /// Tyr->Gln: Tyr->Gln substitution.
    UNIMOD_Tyr__Gln = 100001243,

    /// Tyr->Arg: Tyr->Arg substitution.
    UNIMOD_Tyr__Arg = 100001244,

    /// Tyr->Thr: Tyr->Thr substitution.
    UNIMOD_Tyr__Thr = 100001245,

    /// Tyr->Val: Tyr->Val substitution.
    UNIMOD_Tyr__Val = 100001246,

    /// Tyr->Trp: Tyr->Trp substitution.
    UNIMOD_Tyr__Trp = 100001247,

    /// Tyr->Xle: Tyr->Leu/Ile substitution.
    UNIMOD_Tyr__Xle = 100001248,

    /// AHA-SS: Azidohomoalanine coupled to reductively cleaved tag.
    UNIMOD_AHA_SS = 100001249,

    /// AHA-SS_CAM: Carbamidomethylated form of reductively cleaved tag coupled to azidohomoalanine.
    UNIMOD_AHA_SS_CAM = 100001250,

    /// Biotin:Thermo-33033: Sulfo-SBED Label Photoreactive Biotin Crosslinker.
    UNIMOD_Biotin_Thermo_33033 = 100001251,

    /// Biotin:Thermo-33033-H: Sulfo-SBED Label Photoreactive Biotin Crosslinker minus Hydrogen.
    UNIMOD_Biotin_Thermo_33033_H = 100001252,

    /// 2-monomethylsuccinyl: S-(2-monomethylsuccinyl) cysteine.
    UNIMOD_2_monomethylsuccinyl = 100001253,

    /// Saligenin: O-toluene.
    UNIMOD_Saligenin = 100001254,

    /// Cresylphosphate: O-toluyl-phosphorylation.
    UNIMOD_Cresylphosphate = 100001255,

    /// CresylSaligeninPhosphate: Cresyl-Saligenin-phosphorylation.
    UNIMOD_CresylSaligeninPhosphate = 100001256,

    /// Ub-Br2: Ub Bromide probe addition.
    UNIMOD_Ub_Br2 = 100001257,

    /// Ub-VME: Ubiquitin vinylmethylester.
    UNIMOD_Ub_VME = 100001258,

    /// Ub-amide: Ub amide probe addition.
    UNIMOD_Ub_amide = 100001260,

    /// Ub-fluorescein: Ub Fluorescein probe addition.
    UNIMOD_Ub_fluorescein = 100001261,

    /// 2-dimethylsuccinyl: S-(2-dimethylsuccinyl) cysteine.
    UNIMOD_2_dimethylsuccinyl = 100001262,

    /// Gly: Addition of Glycine.
    UNIMOD_Gly = 100001263,

    /// pupylation: Addition of GGE.
    UNIMOD_pupylation = 100001264,

    /// Label:13C(4): 13C4 Methionine label.
    UNIMOD_Label_13C_4_ = 100001266,

    /// Label:13C(4)+Oxidation: Oxidised 13C4 labelled Methionine.
    UNIMOD_Label_13C_4__Oxidation = 100001267,

    /// HCysThiolactone: N-Homocysteine thiolactone.
    UNIMOD_HCysThiolactone = 100001270,

    /// HCysteinyl: S-homocysteinylation.
    UNIMOD_HCysteinyl = 100001271,

    /// UgiJoullie: Side reaction of HisTag.
    UNIMOD_UgiJoullie = 100001276,

    /// Dipyridyl: Cys modified with dipy ligand.
    UNIMOD_Dipyridyl = 100001277,

    /// Furan: Chemical modification of the iodinated sites of thyroglobulin by Suzuki reaction.
    UNIMOD_Furan = 100001278,

    /// Difuran: Chemical modification of the diiodinated sites of thyroglobulin by Suzuki reaction.
    UNIMOD_Difuran = 100001279,

    /// BMP-piperidinol: 1-methyl-3-benzoyl-4-hydroxy-4-phenylpiperidine.
    UNIMOD_BMP_piperidinol = 100001281,

    /// UgiJoullieProGly: Side reaction of PG with Side chain of aspartic or glutamic acid.
    UNIMOD_UgiJoullieProGly = 100001282,

    /// UgiJoullieProGlyProGly: Side reaction of PGPG with Side chain of aspartic or glutamic acid.
    UNIMOD_UgiJoullieProGlyProGly = 100001283,

    /// IMEHex(2)NeuAc: Glycosylation with IME linked Hex(2) NeuAc.
    UNIMOD_IMEHex_2_NeuAc = 100001286,

    /// Arg-loss: Loss of arginine due to transpeptidation.
    UNIMOD_Arg_loss = 100001287,

    /// Arg: Addition of arginine due to transpeptidation.
    UNIMOD_Arg = 100001288,

    /// Butyryl: Butyryl.
    UNIMOD_Butyryl = 100001289,

    /// Dicarbamidomethyl: Double Carbamidomethylation.
    UNIMOD_Dicarbamidomethyl = 100001290,

    /// Dimethyl:2H(6): Dimethyl-Medium.
    UNIMOD_Dimethyl_2H_6_ = 100001291,

    /// GGQ: SUMOylation leaving GlyGlyGln.
    UNIMOD_GGQ = 100001292,

    /// QTGG: SUMOylation leaving GlnThrGlyGly.
    UNIMOD_QTGG = 100001293,

    /// Label:13C(3): 13C3 label for SILAC.
    UNIMOD_Label_13C_3_ = 100001296,

    /// Label:13C(3)15N(1): 13C3 15N1 label for SILAC.
    UNIMOD_Label_13C_3_15N_1_ = 100001297,

    /// Label:13C(4)15N(1): 13C4 15N1 label for SILAC.
    UNIMOD_Label_13C_4_15N_1_ = 100001298,

    /// Label:2H(10): 2H(10) label.
    UNIMOD_Label_2H_10_ = 100001299,

    /// Label:2H(4)13C(1): Label:2H(4)13C(1).
    UNIMOD_Label_2H_4_13C_1_ = 100001300,

    /// Lys: Addition of lysine due to transpeptidation.
    UNIMOD_Lys = 100001301,

    /// mTRAQ:13C(6)15N(2): MTRAQ heavy.
    UNIMOD_mTRAQ_13C_6_15N_2_ = 100001302,

    /// NeuAc: N-acetyl neuraminic acid.
    UNIMOD_NeuAc = 100001303,

    /// NeuGc: N-glycoyl neuraminic acid.
    UNIMOD_NeuGc = 100001304,

    /// Propyl: Propyl.
    UNIMOD_Propyl = 100001305,

    /// Propyl:2H(6): Propyl:2H(6).
    UNIMOD_Propyl_2H_6_ = 100001306,

    /// Propiophenone: Propiophenone.
    UNIMOD_Propiophenone = 100001310,

    /// Delta:H(6)C(3)O(1): Reduced acrolein addition +58.
    UNIMOD_Delta_H_6_C_3_O_1_ = 100001312,

    /// Delta:H(8)C(6)O(1): Reduced acrolein addition +96.
    UNIMOD_Delta_H_8_C_6_O_1_ = 100001313,

    /// biotinAcrolein298: Biotin hydrazide labeled acrolein addition +298.
    UNIMOD_biotinAcrolein298 = 100001314,

    /// MM-diphenylpentanone: 3-methyl-5-(methylamino)-1,3-diphenylpentan-1-one.
    UNIMOD_MM_diphenylpentanone = 100001315,

    /// EHD-diphenylpentanone: 2-ethyl-3-hydroxy-1,3-diphenylpentan-1-one.
    UNIMOD_EHD_diphenylpentanone = 100001317,

    /// Biotin:Thermo-21901+2H2O: Maleimide-Biotin + 2Water.
    UNIMOD_Biotin_Thermo_21901_2H2O = 100001320,

    /// DiLeu4plex115: Accurate mass for DiLeu 115 isobaric tag.
    UNIMOD_DiLeu4plex115 = 100001321,

    /// DiLeu4plex: Accurate mass for DiLeu 116 isobaric tag.
    UNIMOD_DiLeu4plex = 100001322,

    /// DiLeu4plex117: Accurate mass for DiLeu 117 isobaric tag.
    UNIMOD_DiLeu4plex117 = 100001323,

    /// DiLeu4plex118: Accurate mass for DiLeu 118 isobaric tag.
    UNIMOD_DiLeu4plex118 = 100001324,

    /// NEMsulfur: N-ethylmaleimideSulfur.
    UNIMOD_NEMsulfur = 100001326,

    /// SulfurDioxide: SulfurDioxide.
    UNIMOD_SulfurDioxide = 100001327,

    /// NEMsulfurWater: N-ethylmaleimideSulfurWater.
    UNIMOD_NEMsulfurWater = 100001328,

    /// bisANS-sulfonates: BisANS with loss of both sulfonates.
    UNIMOD_bisANS_sulfonates = 100001330,

    /// DNCB_hapten: Chemical reaction with 2,4-dinitro-1-chloro benzene (DNCB).
    UNIMOD_DNCB_hapten = 100001331,

    /// Biotin:Thermo-21911: Biotin-PEG11-maleimide.
    UNIMOD_Biotin_Thermo_21911 = 100001340,

    /// iodoTMT: Native iodoacetyl Tandem Mass Tag®.
    UNIMOD_iodoTMT = 100001341,

    /// iodoTMT6plex: Sixplex iodoacetyl Tandem Mass Tag®.
    UNIMOD_iodoTMT6plex = 100001342,

    /// Gluconoylation: Gluconoylation.
    UNIMOD_Gluconoylation = 100001343,

    /// Phosphogluconoylation: Phosphogluconoylation.
    UNIMOD_Phosphogluconoylation = 100001344,

    /// PS_Hapten: Reaction with phenyl salicylate (PS).
    UNIMOD_PS_Hapten = 100001345,

    /// Cy3-maleimide: Cy3 Maleimide mono-Reactive dye.
    UNIMOD_Cy3_maleimide = 100001348,

    /// benzylguanidine: Modification of the lysine side chain from NH2 to guanidine with a H removed in favor of a benzyl group.
    UNIMOD_benzylguanidine = 100001349,

    /// CarboxymethylDMAP: A fixed +1 charge tag attached to the N-terminus of peptides.
    UNIMOD_CarboxymethylDMAP = 100001350,

    /// azole: Formation of five membered aromatic heterocycle.
    UNIMOD_azole = 100001355,

    /// phosphoRibosyl: Phosphate-ribosylation.
    UNIMOD_phosphoRibosyl = 100001356,

    /// NEM:2H(5)+H2O: D5 N-ethylmaleimide+water on cysteines.
    UNIMOD_NEM_2H_5__H2O = 100001358,

    /// Crotonyl: Crotonylation.
    UNIMOD_Crotonyl = 100001363,

    /// O-Et-N-diMePhospho: O-ethyl, N-dimethyl phosphate.
    UNIMOD_O_Et_N_diMePhospho = 100001364,

    /// N-dimethylphosphate: N-dimethylphosphate.
    UNIMOD_N_dimethylphosphate = 100001365,

    /// dHex(1)Hex(1): Hex1dHex1.
    UNIMOD_dHex_1_Hex_1_ = 100001367,

    /// Methyl:2H(3)+Acetyl:2H(3): 3-fold methylated lysine labelled with Acetyl_heavy.
    UNIMOD_Methyl_2H_3__Acetyl_2H_3_ = 100001368,

    /// Label:2H(3)+Oxidation: Oxidised 2H(3) labelled Methionine.
    UNIMOD_Label_2H_3__Oxidation = 100001370,

    /// Trimethyl:2H(9): 3-fold methylation with deuterated methyl groups.
    UNIMOD_Trimethyl_2H_9_ = 100001371,

    /// Acetyl:13C(2): Heavy acetylation.
    UNIMOD_Acetyl_13C_2_ = 100001372,

    /// dHex(1)Hex(2): Hex2dHex1.
    UNIMOD_dHex_1_Hex_2_ = 100001375,

    /// dHex(1)Hex(3): Hex3dHex1.
    UNIMOD_dHex_1_Hex_3_ = 100001376,

    /// dHex(1)Hex(4): Hex4dHex1.
    UNIMOD_dHex_1_Hex_4_ = 100001377,

    /// dHex(1)Hex(5): Hex5dHex1.
    UNIMOD_dHex_1_Hex_5_ = 100001378,

    /// dHex(1)Hex(6): Hex6dHex1.
    UNIMOD_dHex_1_Hex_6_ = 100001379,

    /// methylsulfonylethyl: Reaction with methyl vinyl sulfone.
    UNIMOD_methylsulfonylethyl = 100001380,

    /// ethylsulfonylethyl: Reaction with ethyl vinyl sulfone.
    UNIMOD_ethylsulfonylethyl = 100001381,

    /// phenylsulfonylethyl: Reaction with phenyl vinyl sulfone.
    UNIMOD_phenylsulfonylethyl = 100001382,

    /// PyridoxalPhosphateH2: PLP bound to lysine reduced by sodium borohydride (NaBH4) to create amine linkage.
    UNIMOD_PyridoxalPhosphateH2 = 100001383,

    /// Homocysteic_acid: Methionine oxidation to homocysteic acid.
    UNIMOD_Homocysteic_acid = 100001384,

    /// Hydroxamic_acid: Conversion of carboxylic acid to hydroxamic acid.
    UNIMOD_Hydroxamic_acid = 100001385,

    /// 3-phosphoglyceryl: 3-phosphoglyceryl.
    UNIMOD_3_phosphoglyceryl = 100001387,

    /// HN2_mustard: Modification by hydroxylated mechloroethamine (HN-2).
    UNIMOD_HN2_mustard = 100001388,

    /// HN3_mustard: Modification by hydroxylated tris-(2-chloroethyl)amine (HN-3).
    UNIMOD_HN3_mustard = 100001389,

    /// Oxidation+NEM: N-ethylmaleimide on cysteine sulfenic acid.
    UNIMOD_Oxidation_NEM = 100001390,

    /// NHS-fluorescein: Fluorescein-hexanoate-NHS hydrolysis.
    UNIMOD_NHS_fluorescein = 100001391,

    /// DiART6plex: Representative mass and accurate mass for 114.
    UNIMOD_DiART6plex = 100001392,

    /// DiART6plex115: Accurate mass for DiART6plex 115.
    UNIMOD_DiART6plex115 = 100001393,

    /// DiART6plex116/119: Accurate mass for DiART6plex 116 and 119.
    UNIMOD_DiART6plex116_119 = 100001394,

    /// DiART6plex117: Accurate mass for DiART6plex 117.
    UNIMOD_DiART6plex117 = 100001395,

    /// DiART6plex118: Accurate mass for DiART6plex 118.
    UNIMOD_DiART6plex118 = 100001396,

    /// Iodoacetanilide: Iodoacetanilide derivative.
    UNIMOD_Iodoacetanilide = 100001397,

    /// Iodoacetanilide:13C(6): 13C labelled iodoacetanilide derivative.
    UNIMOD_Iodoacetanilide_13C_6_ = 100001398,

    /// Dap-DSP: Diaminopimelic acid-DSP monolinked.
    UNIMOD_Dap_DSP = 100001399,

    /// MurNAc: N-Acetylmuramic acid.
    UNIMOD_MurNAc = 100001400,

    /// TransN-biotin: Transaminated Protein N-terminus biotinylated with biotin-hydrazide.
    UNIMOD_TransN_biotin = 100001401,

    /// Label:2H(7)15N(4): Label:2H(7)15N(4).
    UNIMOD_Label_2H_7_15N_4_ = 100001402,

    /// Label:2H(6)15N(1): Label:2H(6)15N(1).
    UNIMOD_Label_2H_6_15N_1_ = 100001403,

    /// unit: A unit of measurement is a standardized quantity of a physical quality.
    UO_unit = 200000000,

    /// length unit: A unit which is a standard measure of the distance between two points.
    UO_length_unit = 200000001,

    /// mass unit: A unit which is a standard measure of the amount of matter/energy of a physical object.
    UO_mass_unit = 200000002,

    /// time unit: A unit which is a standard measure of the dimension in which events occur in sequence.
    UO_time_unit = 200000003,

    /// electric current unit: A unit which is a standard measure of the flow of electric charge.
    UO_electric_current_unit = 200000004,

    /// temperature unit: A unit which is a standard measure of the average kinetic energy of the particles in a sample of matter.
    UO_temperature_unit = 200000005,

    /// substance unit: A unit which is a standardised quantity of an element or compound with uniform composition.
    UO_substance_unit = 200000006,

    /// luminous intensity unit: A unit which is a standard measure of the wavelength-weighted power emitted by a light source in a particular direction.
    UO_luminous_intensity_unit = 200000007,

    /// meter: A length unit which is equal to the length of the path traveled by light in vacuum during a time interval of 1/299 792 458 of a second.
    UO_meter = 200000008,

    /// kilogram: A mass unit which is equal to the mass of the International Prototype Kilogram kept by the BIPM at Svres, France.
    UO_kilogram = 200000009,

    /// second: A time unit which is equal to the duration of 9 192 631 770 periods of the radiation corresponding to the transition between the two hyperfine levels of the ground state of the caesium 133 atom.
    UO_second = 200000010,

    /// ampere: An electric current unit which is equal to the constant current which, if maintained in two straight parallel conductors of infinite length, of negligible circular cross-section, and placed 1 m apart in vacuum, would produce between these conductors a force equal to 2 x 10^[-7] newton per meter of length.
    UO_ampere = 200000011,

    /// kelvin: A thermodynamic temperature unit which is equal to the fraction 1/273.16 of the thermodynamic temperature of the triple point of water.
    UO_kelvin = 200000012,

    /// mole: A substance unit which is equal to the amount of substance of a molecular system which contains as many elementary entities as there are atoms in 0.012 kilogram of carbon 12.
    UO_mole = 200000013,

    /// candela: A luminous intensity unit which equal to the luminous intensity, in a given direction, of a source that emits monochromatic radiation of frequency 540 x 1012 hertz and that has a radiant intensity in that direction of 1/683 watt per steradian.
    UO_candela = 200000014,

    /// centimeter: A length unit which is equal to one hundredth of a meter or 10^[-2] m.
    UO_centimeter = 200000015,

    /// millimeter: A length unit which is equal to one thousandth of a meter or 10^[-3] m.
    UO_millimeter = 200000016,

    /// micrometer: A length unit which is equal to one millionth of a meter or 10^[-6] m.
    UO_micrometer = 200000017,

    /// nanometer: A length unit which is equal to one thousandth of one millionth of a meter or 10^[-9] m.
    UO_nanometer = 200000018,

    /// angstrom: A length unit which is equal to 10 [-10] m.
    UO_angstrom = 200000019,

    /// picometer: A length unit which is equal to 10^[-12] m.
    UO_picometer = 200000020,

    /// gram: A mass unit which is equal to one thousandth of a kilogram or 10^[-3] kg.
    UO_gram = 200000021,

    /// milligram: A mass unit which is equal to one thousandth of a gram or 10^[-3] g.
    UO_milligram = 200000022,

    /// microgram: A mass unit which is equal to one millionth of a gram or 10^[-6] g.
    UO_microgram = 200000023,

    /// nanogram: A mass unit which is equal to one thousandth of one millionth of a gram or 10^[-9] g.
    UO_nanogram = 200000024,

    /// picogram: A mass unit which is equal to 10^[-12] g.
    UO_picogram = 200000025,

    /// femtogram: A mass unit which is equal to 10^[-15] g.
    UO_femtogram = 200000026,

    /// degree celsius: A temperature unit which is equal to one Kelvin degree. However, they have their zeros at different points. The Centigrade scale has its zero at 273.15 K.
    UO_degree_celsius = 200000027,

    /// millisecond: A time unit which is equal to one thousandth of a second or 10^[-3] s.
    UO_millisecond = 200000028,

    /// microsecond: A time unit which is equal to one millionth of a second or 10^[-6] s.
    UO_microsecond = 200000029,

    /// picosecond: A time unit which is equal to 10^[-12] s.
    UO_picosecond = 200000030,

    /// minute: A time unit which is equal to 60 seconds.
    UO_minute = 200000031,

    /// hour: A time unit which is equal to 3600 seconds or 60 minutes.
    UO_hour = 200000032,

    /// day: A time unit which is equal to 24 hours.
    UO_day = 200000033,

    /// week: A time unit which is equal to 7 days.
    UO_week = 200000034,

    /// month: A time unit which is approximately equal to the length of time of one of cycle of the moon's phases which in science is taken to be equal to 30 days.
    UO_month = 200000035,

    /// year: A time unit which is equal to 12 months which is science is taken to be equal to 365.25 days.
    UO_year = 200000036,

    /// milliampere: An electric current unit current which is equal to one thousandth of an ampere or 10^[-3] A.
    UO_milliampere = 200000037,

    /// microampere: An electric current unit current which is equal to one millionth of an ampere or 10^[-6] A.
    UO_microampere = 200000038,

    /// micromole: A substance unit equal to a millionth of a mol or 10^[-6] mol.
    UO_micromole = 200000039,

    /// millimole: A substance unit equal to a thousandth of a mol or 10^[-3] mol.
    UO_millimole = 200000040,

    /// nanomole: A substance unit equal to one thousandth of one millionth of a mole or 10^[-9] mol.
    UO_nanomole = 200000041,

    /// picomole: A substance unit equal to 10^[-12] mol.
    UO_picomole = 200000042,

    /// femtomole: A substance unit equal to 10^[-15] mol.
    UO_femtomole = 200000043,

    /// attomole: A substance unit equal to 10^[-18] mol.
    UO_attomole = 200000044,

    /// base unit: A unit which is one of a particular measure to which all measures of that type can be related.
    UO_base_unit = 200000045,

    /// derived unit: A unit which is derived from base units.
    UO_derived_unit_OBSOLETE = 200000046,

    /// area unit: A unit which is a standard measure of the amount of a 2-dimensional flat surface.
    UO_area_unit = 200000047,

    /// acceleration unit: A unit which is a standard measure of the rate of change of velocity in either speed or direction.
    UO_acceleration_unit = 200000048,

    /// angular velocity unit: A unit which is a standard measure of the rate of angular movement about an axis; the angle rotated in a given time.
    UO_angular_velocity_unit = 200000049,

    /// angular acceleration unit: A unit which is a standard measure of the rate of change of angular velocity.
    UO_angular_acceleration_unit = 200000050,

    /// concentration unit: A unit which represents a standard measurement of how much of a given substance there is mixed with another substance.
    UO_concentration_unit = 200000051,

    /// mass density unit: A density unit which is a standard measure of the mass of a substance in a given volume.
    UO_mass_density_unit = 200000052,

    /// luminance unit: A unit which is a standard measure of the luminous intensity impinging on a given area.
    UO_luminance_unit = 200000053,

    /// area density unit: A density unit which is a standard measure of the mass exerting an influence on a given area.
    UO_area_density_unit = 200000054,

    /// molar mass unit: A unit which is a standard measure of the mass of a homogeneous substance containing 6.02 x 1023 atoms or molecules.
    UO_molar_mass_unit = 200000055,

    /// molar volume unit: A unit which is a standard measure of the volume of a homogeneous substance containing 6.02 x 1023 atoms or molecules.
    UO_molar_volume_unit = 200000056,

    /// momentum unit: A unit which is a standard measure of the quantity of motion measured by the product of mass and velocity.
    UO_momentum_unit = 200000057,

    /// rotational frequency unit: A unit which is a standard measure of the number of rotations in a given time.
    UO_rotational_frequency_unit = 200000058,

    /// specific volume unit: A unit which is a standard measure of the volume of a given mass of substance (the reciprocal of density).
    UO_specific_volume_unit = 200000059,

    /// speed/velocity unit: A unit which is a standard measure of the rate of movement. Speed is measured in the same physical units of measurement as velocity, but does not contain the element of direction that velocity has. Speed is thus the magnitude component of velocity.
    UO_speed_velocity_unit = 200000060,

    /// unit of molarity: A concentration unit which is a standard measure of the number of moles of a given substance per liter of solution.
    UO_unit_of_molarity = 200000061,

    /// molar: A unit of concentration which expresses a concentration of 1 mole of solute per liter of solution (mol/L).
    UO_molar = 200000062,

    /// millimolar: A unit of molarity which is equal to one thousandth of a molar or 10^[-3] M.
    UO_millimolar = 200000063,

    /// micromolar: A unit of molarity which is equal to one millionth of a molar or 10^[-6] M.
    UO_micromolar = 200000064,

    /// nanomolar: A unit of molarity which is equal to one thousandth of one millionth of a molar or 10^[-9] M.
    UO_nanomolar = 200000065,

    /// picomolar: A unit of molarity which is equal to 10^[-12] M.
    UO_picomolar = 200000066,

    /// unit of molality: A concentration unit which is a standard measure of the number of moles of a given substance per kilogram of solvent.
    UO_unit_of_molality = 200000067,

    /// molal: A unit of concentration which expresses a concentration of a solution of 1 mole per kilogram of solvent (mol/kg).
    UO_molal = 200000068,

    /// millimolal: A molality unit which is equal to one thousandth of a molal or 10^[-3] m.
    UO_millimolal = 200000069,

    /// micromolal: A molality unit which is equal to one millionth of a molal or 10^[-6] m.
    UO_micromolal = 200000070,

    /// nanomolal: A molality unit which is equal to one thousandth of one millionth of a molal or 10^[-9] m.
    UO_nanomolal = 200000071,

    /// picomolal: A molality unit which is equal to 10^[-12] m.
    UO_picomolal = 200000072,

    /// femtomolar: A unit of molarity which is equal to 10^[-15] M.
    UO_femtomolar = 200000073,

    /// unit of normality: A unit of concentration which highlights the chemical nature of salts.
    UO_unit_of_normality = 200000074,

    /// normal: A unit of concentration which is one gram equivalent of a solute per liter of solution. A gram equivalent weight or equivalent is a measure of the reactive capacity of a given molecule.
    UO_normal = 200000075,

    /// mole fraction: A concentration unit which denotes the number of moles of solute as a proportion of the total number of moles in a solution.
    UO_mole_fraction = 200000076,

    /// meter per second per second: An acceleration unit which is equal to the acceleration an object changing its velocity by 1meter/s over a time period that equals one second.
    UO_meter_per_second_per_second = 200000077,

    /// radian per second per second: An angular unit acceleration which is equal to the angular acceleration of an object changing its angular velocity by 1rad/s over a time period that equals one second.
    UO_radian_per_second_per_second = 200000078,

    /// radian per second: An angular unit velocity which is equal to about 9.54930 rpm (revolutions per minute).
    UO_radian_per_second = 200000079,

    /// square meter: An area unit which is equal to an area enclosed by a square with sides each 1 meter long.
    UO_square_meter = 200000080,

    /// square centimeter: An area unit which is equal to one thousand of square meter or 10^[-3] m^[2].
    UO_square_centimeter = 200000081,

    /// square millimeter: An area unit which is equal to one millionth of a square meter or 10^[-6] m^[2].
    UO_square_millimeter = 200000082,

    /// kilogram per cubic meter: A mass unit density which is equal to mass of an object in kilograms divided by the volume in cubic meters.
    UO_kilogram_per_cubic_meter = 200000083,

    /// gram per cubic centimeter: A mass unit density which is equal to mass of an object in grams divided by the volume in cubic centimeters.
    UO_gram_per_cubic_centimeter = 200000084,

    /// candela per square meter: A luminance unit which is equal to a luminous intensity of one candela radiating from a surface whose area is one square meter.
    UO_candela_per_square_meter = 200000085,

    /// kilogram per square meter: An area density unit which is equal to the mass of an object in kilograms divided by the surface area in meters squared.
    UO_kilogram_per_square_meter = 200000086,

    /// kilogram per mole: A molar mass unit which is equal to one kilogram of mass of one mole of chemical element or chemical compound.
    UO_kilogram_per_mole = 200000087,

    /// gram per mole: A molar mass unit which is equal to one gram of mass of one mole of chemical element or chemical compound.
    UO_gram_per_mole = 200000088,

    /// cubic meter per mole: A molar volume unit which is equal to 1 cubic meter occupied by one mole of a substance in the form of a solid, liquid, or gas.
    UO_cubic_meter_per_mole = 200000089,

    /// cubic centimeter per mole: A molar volume unit which is equal to 1 cubic centimeter occupied by one mole of a substance in the form of a solid, liquid, or gas.
    UO_cubic_centimeter_per_mole = 200000090,

    /// kilogram meter per second: A momentum unit which is equal to the momentum of a one kilogram mass object with a speed of one meter per second.
    UO_kilogram_meter_per_second = 200000091,

    /// turns per second: A rotational frequency unit which is equal to the number complete turn in a period of time that equals to 1 second.
    UO_turns_per_second = 200000092,

    /// cubic meter per kilogram: A specific volume unit which is equal to one cubic meter volume occupied by one kilogram of a particular substance.
    UO_cubic_meter_per_kilogram = 200000093,

    /// meter per second: A speed/velocity unit which is equal to the speed of an object traveling 1 meter distance in one second.
    UO_meter_per_second = 200000094,

    /// volume unit: A unit which is a standard measure of the amount of space occupied by any substance, whether solid, liquid, or gas.
    UO_volume_unit = 200000095,

    /// cubic meter: A volume unit which is equal to the volume of a cube with edges one meter in length. One cubic meter equals to 1000 liters.
    UO_cubic_meter = 200000096,

    /// cubic centimeter: A volume unit which is equal to one millionth of a cubic meter or 10^[-9] m^[3], or to 1 ml.
    UO_cubic_centimeter = 200000097,

    /// milliliter: A volume unit which is equal to one thousandth of a liter or 10^[-3] L, or to 1 cubic centimeter.
    UO_milliliter = 200000098,

    /// liter: A volume unit which is equal to one thousandth of a cubic meter or 10^[-3] m^[3], or to 1 decimeter.
    UO_liter = 200000099,

    /// cubic decimeter: A volume unit which is equal to one thousand of a cubic meter or 10^[-3] m^[3], or to 1 L.
    UO_cubic_decimeter = 200000100,

    /// microliter: A volume unit which is equal to one millionth of a liter or 10^[-6] L.
    UO_microliter = 200000101,

    /// nanoliter: A volume unit which is equal to one thousandth of one millionth of a liter or 10^[-9] L.
    UO_nanoliter = 200000102,

    /// picoliter: A volume unit which is equal to 10^[-12] L.
    UO_picoliter = 200000103,

    /// femtoliter: A volume unit which is equal to 10^[-15] L.
    UO_femtoliter = 200000104,

    /// frequency unit: A unit which is a standard measure of the number of repetitive actions in a particular time.
    UO_frequency_unit = 200000105,

    /// hertz: A frequency unit which is equal to 1 complete cycle of a recurring phenomenon in 1 second.
    UO_hertz = 200000106,

    /// force unit: A unit which is a standard measure of the force is applied when a mass is accelerated.
    UO_force_unit = 200000107,

    /// newton: A force unit which is equal to the force required to cause an acceleration of 1m/s2 of a mass of 1 Kg in the direction of the force.
    UO_newton = 200000108,

    /// pressure unit: A unit which is a standard measure of the force applied to a given area.
    UO_pressure_unit = 200000109,

    /// pascal: A pressure unit which is equal to the pressure or stress on a surface caused by a force of 1 newton spread over a surface of 1 m^[2].
    UO_pascal = 200000110,

    /// energy unit: A unit which is a standard measure of the work done by a certain force (gravitational, electric, magnetic, force of inertia, etc).
    UO_energy_unit = 200000111,

    /// joule: An energy unit which is equal to the energy required when a force of 1 newton moves an object 1 meter in the direction of the force.
    UO_joule = 200000112,

    /// power unit: A unit which is a standard measure power or the rate of doing work.
    UO_power_unit = 200000113,

    /// watt: A power unit which is equal to the power used when work is done at the rate of 1 joule per second.
    UO_watt = 200000114,

    /// illuminance unit: A unit which is a standard measure of the luminous flux incident on a unit area.
    UO_illuminance_unit = 200000115,

    /// lux: An illuminance unit which is equal to the illuminance produced by 1 lumen evenly spread over an area 1 m^[2].
    UO_lux = 200000116,

    /// luminous flux unit: A unit which is a standard measure of the flow of radiant energy.
    UO_luminous_flux_unit = 200000117,

    /// lumen: A luminous flux unit which is equal to the luminous flux emitted into 1 steradian by a point source of 1 candela.
    UO_lumen = 200000118,

    /// catalytic activity unit: A unit which is a standard measure of the amount of the action of a catalyst.
    UO_catalytic_activity_unit = 200000119,

    /// katal: A catalytic unit activity which is equal to the activity of a catalyst in moles per second, such as the amount of an enzyme needed to transform one mole of substrate per second.
    UO_katal = 200000120,

    /// angle unit: A unit which is a standard measure of the figure or space formed by the junction of two lines or planes.
    UO_angle_unit = 200000121,

    /// plane angle unit: A unit which is a standard measure of the angle formed by two straight lines in the same plane.
    UO_plane_angle_unit = 200000122,

    /// radian: A plane angle unit which is equal to the angle subtended at the center of a circle by an arc equal in length to the radius of the circle, approximately 57 degrees 17 minutes and 44.6 seconds.
    UO_radian = 200000123,

    /// solid angle unit: A unit which is a standard measure of the angle formed by three or more planes intersecting at a common point.
    UO_solid_angle_unit = 200000124,

    /// steradian: A solid angle unit which is equal to the solid angle subtended at the center of a sphere by an area on the surface of the sphere that is equal to the radius squared.
    UO_steradian = 200000125,

    /// radiation unit: A unit which is a standard measure of the amount of radiation emitted by a given radiation source as well as the amount of radiation absorbed or deposited in a specific material by a radiation source.
    UO_radiation_unit = 200000127,

    /// activity (of a radionuclide) unit: A unit which is a standard measure of the transformation (disintegration) rate of a radioactive substance.
    UO_activity__of_a_radionuclide__unit = 200000128,

    /// absorbed dose unit: A unit which is a standard measure of the energy imparted by ionizing radiation to unit mass of matter such as tissue.
    UO_absorbed_dose_unit = 200000129,

    /// dose equivalent unit: A unit which is a standard measure of the expression of dose in terms of its biological effect.
    UO_dose_equivalent_unit = 200000130,

    /// exposure unit: A unit which is a standard measure of the quantity that expresses the ability of radiation to ionize air and thereby create electric charges which can be collected and measured.
    UO_exposure_unit = 200000131,

    /// becquerel: An activity (of a radionuclide) unit which is equal to the activity of a quantity of radioactive material in which one nucleus decays per second or there is one atom disintegration per second (dps).
    UO_becquerel = 200000132,

    /// curie: An activity (of a radionuclide) unit which is equal to the activity of a quantity of radioactive material in which there are 3.7 x 10^[10] atom disintegration per second (dps).
    UO_curie = 200000133,

    /// gray: An absorbed dose unit which is equal to the absorption of one joule of radiation energy by one kilogram of matter.
    UO_gray = 200000134,

    /// rad: An absorbed dose unit which is equal to 0.01 gray (Gy).
    UO_rad = 200000135,

    /// roentgen: An exposure unit which is equal to the amount of radiation required to liberate positive and negative charges of one electrostatic unit of charge in 1 cm^[3] of air at standard temperature and pressure (STP). This corresponds to the generation of approximately 2.0810^[9] ion pairs.
    UO_roentgen = 200000136,

    /// sievert: A dose equivalent unit which is equal to the absorption of one joule of radiation energy by one kilogram of matter.
    UO_sievert = 200000137,

    /// millisievert: A dose equivalent unit which is equal to one thousandth of a sievert or 10^[-3] Sv.
    UO_millisievert = 200000138,

    /// microsievert: A dose equivalent unit which is equal to one millionth of a sievert or 10^[-6] Sv.
    UO_microsievert = 200000139,

    /// Roentgen equivalent man: A dose equivalent unit which when multiplied by hundred is equal to one sievert or 1 Sv. 1 Sv is equal to 100 rem.
    UO_Roentgen_equivalent_man = 200000140,

    /// microgray: An absorbed dose unit which is equal to one millionth of a gray or 10^[-6] Gy.
    UO_microgray = 200000141,

    /// milligray: An absorbed dose unit which is equal to one thousandth of a gray or 10^[-3] Gy.
    UO_milligray = 200000142,

    /// nanogray: An absorbed dose unit which is equal to one thousandth of a millionth of a gray or 10^[-9] Gy.
    UO_nanogray = 200000143,

    /// nanosievert: A dose equivalent unit which is equal to one thousandth of a millionth of a sievert or 10^[-9] Sv.
    UO_nanosievert = 200000144,

    /// millicurie: An activity (of a radionuclide) unit which is equal to one thousandth of a curie or 10^[-3] Ci.
    UO_millicurie = 200000145,

    /// microcurie: An activity (of a radionuclide) unit which is equal to one millionth of a curie or 10^[-6] Ci.
    UO_microcurie = 200000146,

    /// disintegrations per minute: An activity (of a radionuclide) unit which is equal to the activity of a quantity of radioactive material in which one nucleus decays per minute or there is one atom disintegration per minute.
    UO_disintegrations_per_minute = 200000147,

    /// counts per minute: An activity (of a radionuclide) unit which is equal to the number of light emissions produced by ionizing radiation in one minute.
    UO_counts_per_minute = 200000148,

    /// nanosecond: A time unit which is equal to one thousandth of one millionth of a second or 10^[-9] s.
    UO_nanosecond = 200000150,

    /// century: A time unit which is equal to 100 years.
    UO_century = 200000151,

    /// half life: A time unit which represents the period over which the activity or concentration of a specified chemical or element falls to half its original activity or concentration.
    UO_half_life = 200000152,

    /// foot candle: An illuminance unit which is equal to the illuminance produced by 1 lumen evenly spread over an area 1 foot^[2]. One footcandle is equal to 10.76 lux.
    UO_foot_candle = 200000153,

    /// irradiance unit: A unit which is a standard measure of the power of electromagnetic radiation at a surface, per unit area.
    UO_irradiance_unit = 200000154,

    /// watt per square meter: An irradiance unit which is equal to 1 watt of radiant power incident per one square meter surface area.
    UO_watt_per_square_meter = 200000155,

    /// einstein per square meter per second: An irradiance unit which is equal to one einstein per square meter per second. One einstein is one mole of photons, regardless of their frequency. Therefore, the number of photons in an einstein is Avogadro's number.
    UO_einstein_per_square_meter_per_second = 200000156,

    /// light unit: A unit which is a standard measure of the intensity of light.
    UO_light_unit = 200000157,

    /// watt per steradian per square meter: A radiance unit which is equal to one watt of radiant power incident per steradian solid angle per one square meter projected area of the source, as viewed from the given direction.
    UO_watt_per_steradian_per_square_meter = 200000158,

    /// radiant intensity unit: A unit which is a standard measure of the intensity of electromagnetic radiation.
    UO_radiant_intensity_unit = 200000159,

    /// microeinstein per square meter per second: An irradiance unit which is equal to one microeinstein per square meter per second or 10^[-6] microeinstein/sm^[2].
    UO_microeinstein_per_square_meter_per_second = 200000160,

    /// radiance unit: A unit which is a standard measure of the power of electromagnetic radiation through space or through a material medium in the form of electromagnetic waves.
    UO_radiance_unit = 200000161,

    /// watt per steradian: A radiant intensity unit which is equal to one kilogram meter squared per second cubed per steradian.
    UO_watt_per_steradian = 200000162,

    /// mass percentage: A dimensionless concentration unit which denotes the mass of a substance in a mixture as a percentage of the mass of the entire mixture.
    UO_mass_percentage = 200000163,

    /// mass volume percentage: A dimensionless concentration unit which denotes the mass of the substance in a mixture as a percentage of the volume of the entire mixture.
    UO_mass_volume_percentage = 200000164,

    /// volume percentage: A dimensionless concentration unit which denotes the volume of the solute in mL per 100 mL of the resulting solution.
    UO_volume_percentage = 200000165,

    /// parts per notation unit: A dimensionless concentration notation which describes the amount of one substance in another. It is the ratio of the amount of the substance of interest to the amount of that substance plus the amount of the substance.
    UO_parts_per_notation_unit = 200000166,

    /// parts per hundred: A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 100 regardless of the units of measure as long as they are the same.
    UO_parts_per_hundred = 200000167,

    /// parts per thousand: A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 1000 regardless of the units of measure as long as they are the same.
    UO_parts_per_thousand = 200000168,

    /// parts per million: A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 1,000,000 regardless of the units of measure used as long as they are the same or 1 part in 10^[6].
    UO_parts_per_million = 200000169,

    /// parts per billion: A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 1,000,000,000 regardless of the units of measure as long as they are the same or 1 part in 10^[9].
    UO_parts_per_billion = 200000170,

    /// parts per trillion: A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 1,000,000,000 regardless of the units of measure used as long as they are the same or 1 part in 10^[12].
    UO_parts_per_trillion = 200000171,

    /// parts per quadrillion: A dimensionless concentration notation which denotes the amount of a given substance in a total amount of 1,000,000,000,000 regardless of the units of measure used as long as they are the same or 1 part in 10^[15].
    UO_parts_per_quadrillion = 200000172,

    /// gram per milliliter: A mass unit density which is equal to mass of an object in grams divided by the volume in milliliter.
    UO_gram_per_milliliter = 200000173,

    /// kilogram per liter: A mass unit density which is equal to mass of an object in kilograms divided by the volume in liters.
    UO_kilogram_per_liter = 200000174,

    /// gram per liter: A mass unit density which is equal to mass of an object in grams divided by the volume in liters.
    UO_gram_per_liter = 200000175,

    /// milligram per milliliter: A mass unit density which is equal to mass of an object in milligrams divided by the volume in milliliters.
    UO_milligram_per_milliliter = 200000176,

    /// unit per volume unit: A concentration unit which is a standard measure of the number of units, as an agreed arbitrary amount, of a given substance per a specific volume of solution.
    UO_unit_per_volume_unit = 200000177,

    /// unit per milliliter: A unit per milliliter unit which is equal to one unit of an agreed arbitrary amount per one milliliter.
    UO_unit_per_milliliter = 200000178,

    /// unit per liter: A unit per milliliter unit which is equal to one unit of an agreed arbitrary amount per one liter.
    UO_unit_per_liter = 200000179,

    /// mass per unit volume: A concentration unit which is a standard measure of the mass of a substance in a given volume (density).
    UO_mass_per_unit_volume = 200000180,

    /// enzyme unit: A catalytic unit activity which is equal to the amount of the enzyme that catalyzes the conversion of 1 micro mole of substrate per minute.
    UO_enzyme_unit = 200000181,

    /// density unit: A unit which is a standard measure of the influence exerted by some mass.
    UO_density_unit = 200000182,

    /// linear density unit: A density unit which is a standard measure of the mass exerting an influence on a one-dimensional object.
    UO_linear_density_unit = 200000183,

    /// kilogram per meter: An area density unit which is equal to the mass of an object in kilograms divided by one meter.
    UO_kilogram_per_meter = 200000184,

    /// degree: A plane angle unit which is equal to 1/360 of a full rotation or 1.7453310^[-2] rad.
    UO_degree = 200000185,

    /// dimensionless unit: A unit which is a standard measure of physical quantity consisting of only a numerical number without any units.
    UO_dimensionless_unit = 200000186,

    /// percent: A dimensionless ratio unit which denotes numbers as fractions of 100.
    UO_percent = 200000187,

    /// pi: A dimensionless unit which denoted an irrational real number, approximately equal to 3.14159 which is the ratio of a circle's circumference to its diameter in Euclidean geometry.
    UO_pi = 200000188,

    /// count unit: A dimensionless unit which denotes a simple count of things.
    UO_count_unit = 200000189,

    /// ratio: A dimensionless unit which denotes an amount or magnitude of one quantity relative to another.
    UO_ratio = 200000190,

    /// fraction: A dimensionless ratio unit which relates the part (the numerator) to the whole (the denominator).
    UO_fraction = 200000191,

    /// molecule count: A dimensionless count unit which denotes the number of molecules.
    UO_molecule_count = 200000192,

    /// purity percentage: A dimensionless percent unit which denotes the homogeneity of a biomaterial.
    UO_purity_percentage = 200000193,

    /// confluence percentage: A dimensionless percent unit which denotes the density of an attached or monolayer culture (e.g., cell culture).
    UO_confluence_percentage = 200000194,

    /// degree fahrenheit: A temperature unit which is equal to 5/9ths of a kelvin. Negative 40 degrees Fahrenheit is equal to negative 40 degrees Celsius.
    UO_degree_fahrenheit = 200000195,

    /// pH: A dimensionless concentration notation which denotes the acidity of a solution in terms of activity of hydrogen ions (H+).
    UO_pH = 200000196,

    /// liter per kilogram: A specific volume unit which is equal to one liter volume occupied by one kilogram of a particular substance.
    UO_liter_per_kilogram = 200000197,

    /// milliliter per kilogram: A specific volume unit which is equal to a thousandth of a liter per kilogram or 10^[-3] l/kg.
    UO_milliliter_per_kilogram = 200000198,

    /// microliter per kilogram: A specific volume unit which is equal to one millionth of a liter per kilogram or 10^[-6] l/kg.
    UO_microliter_per_kilogram = 200000199,

    /// cell concentration unit: A concentration unit which denotes the average cell number in a given volume.
    UO_cell_concentration_unit = 200000200,

    /// cells per milliliter: A unit of cell concentration which is equal to one cell in a volume of 1 milliliter.
    UO_cells_per_milliliter = 200000201,

    /// catalytic (activity) concentration unit: A concentration unit which is a standard measure of the amount of the action of a catalyst in a given volume.
    UO_catalytic__activity__concentration_unit = 200000202,

    /// katal per cubic meter: A catalytic (activity) concentration unit which is equal to 1 katal activity of a catalyst in a given volume of one cubic meter.
    UO_katal_per_cubic_meter = 200000203,

    /// katal per liter: A catalytic (activity) concentration unit which is equal to 1 katal activity of a catalyst in a given volume of one thousandth of a cubic meter.
    UO_katal_per_liter = 200000204,

    /// volume per unit volume: A dimensionless concentration unit which denotes the given volume of the solute in the total volume of the resulting solution.
    UO_volume_per_unit_volume = 200000205,

    /// milliliter per cubic meter: A volume per unit volume unit which is equal to one millionth of a liter of solute in one cubic meter of solution.
    UO_milliliter_per_cubic_meter = 200000206,

    /// milliliter per liter: A volume per unit volume unit which is equal to one millionth of a liter of solute in one liter of solution.
    UO_milliliter_per_liter = 200000207,

    /// gram per deciliter: A mass density unit which is equal to mass of an object in grams divided by the volume in deciliters.
    UO_gram_per_deciliter = 200000208,

    /// deciliter: A volume unit which is equal to one tenth of a liter or 10^[-1] L.
    UO_deciliter = 200000209,

    /// colony forming unit: A dimensionless count unit which a measure of viable bacterial numbers.
    UO_colony_forming_unit = 200000210,

    /// plaque forming unit: A dimensionless count unit which a measure of plague forming units in a given volume.
    UO_plaque_forming_unit = 200000211,

    /// colony forming unit per volume: A concentration unit which a measure of viable bacterial numbers in a given volume.
    UO_colony_forming_unit_per_volume = 200000212,

    /// colony forming unit per milliliter: A colony forming unit which a measure of viable bacterial numbers in one milliliter.
    UO_colony_forming_unit_per_milliliter = 200000213,

    /// plaque forming unit per volume: A concentration unit which a measure of plague forming units in a given volume.
    UO_plaque_forming_unit_per_volume = 200000214,

    /// plaque forming unit per milliliter: A concentration unit which a measure of plague forming units in one milliliter.
    UO_plaque_forming_unit_per_milliliter = 200000215,

    /// disintegrations per second: An activity (of a radionuclide) unit which is equal to the activity of a quantity of radioactive material in which one nucleus decays per second or there is one atom disintegration per second.
    UO_disintegrations_per_second = 200000216,

    /// electric potential difference unit: A unit which is a standard measure of the work done per unit charge as a charge is moved between two points in an electric field.
    UO_electric_potential_difference_unit = 200000217,

    /// volt: An electric potential difference unit which is equal to the work per unit charge. One volt is the potential difference required to move one coulomb of charge between two points in a circuit while using one joule of energy.
    UO_volt = 200000218,

    /// electric charge: A unit which is a standard measure of the quantity of unbalanced electricity in a body (either positive or negative) and construed as an excess or deficiency of electrons.
    UO_electric_charge = 200000219,

    /// coulomb: An electrical charge unit which is equal to the amount of charge transferred by a current of 1 ampere in 1 second.
    UO_coulomb = 200000220,

    /// dalton: An independently to the base SI units defined mass unit which is equal to one twelfth of the mass of an unbound atom of the carbon-12 nuclide, at rest and in its ground state.
    UO_dalton = 200000221,

    /// kilodalton: A mass unit which is equal to one thousand daltons.
    UO_kilodalton = 200000222,

    /// watt-hour: An energy unit which is equal to the amount of electrical energy equivalent to a one-watt load drawing power for one hour.
    UO_watt_hour = 200000223,

    /// kilowatt-hour: An energy unit which is equal to 1,000 watt-hours.
    UO_kilowatt_hour = 200000224,

    /// magnetic flux unit: A unit which is a standard measure of quantity of magnetism, taking account of the strength and the extent of a magnetic field.
    UO_magnetic_flux_unit = 200000225,

    /// weber: A magnetic flux unit which is equal to the amount of flux that when linked with a single turn of wire for an interval of one second will induce an electromotive force of one volt.
    UO_weber = 200000226,

    /// magnetic flux density unit: A unit which is a standard measure of the strength of a magnetic field.
    UO_magnetic_flux_density_unit = 200000227,

    /// tesla: A magnetic flux density unit which is equal to one weber per square meter.
    UO_tesla = 200000228,

    /// volt-hour: A magnetic flux unit which is equal to 3600 Wb.
    UO_volt_hour = 200000229,

    /// kilovolt-hour: A magnetic flux unit which is equal to one thousand volt-hours.
    UO_kilovolt_hour = 200000230,

    /// information unit: A unit which is a standard measure of the amount of information.
    UO_information_unit = 200000231,

    /// bit: An information unit which refers to a digit in the binary numeral system, which consists of base 2 digits (ie there are only 2 possible values: 0 or 1).
    UO_bit = 200000232,

    /// byte: An information unit which is equal to 8 bits.
    UO_byte = 200000233,

    /// kilobyte: An information unit which is equal to 1000 bytes.
    UO_kilobyte = 200000234,

    /// megabyte: An information unit which is equal to 1000 kB.
    UO_megabyte = 200000235,

    /// image resolution unit: An information unit which is a standard measure of the detail an image holds.
    UO_image_resolution_unit = 200000236,

    /// chroma sampling unit: An image resolution unit which is a standard measure of the amount of spatial detail in an image.
    UO_chroma_sampling_unit = 200000237,

    /// dynamic range unit: An image resolution unit which is a standard measure of the amount of contrast available in a pixel.
    UO_dynamic_range_unit = 200000238,

    /// spatial resolution unit: An image resolution unit which is a standard measure of the way luminance and chrominance may be sampled at different levels.
    UO_spatial_resolution_unit = 200000239,

    /// dots per inch: A spatial resolution unit which is a standard measure of the printing resolution, in particular the number of individual dots of ink a printer or toner can produce within a linear one-inch space.
    UO_dots_per_inch = 200000240,

    /// micron pixel: A spatial resolution unit which is equal to a pixel size of one micrometer.
    UO_micron_pixel = 200000241,

    /// pixels per inch: A spatial resolution unit which is a standard measure of the resolution of a computer display, related to the size of the display in inches and the total number of pixels in the horizontal and vertical directions.
    UO_pixels_per_inch = 200000242,

    /// pixels per millimeter: A spatial resolution unit which is a standard measure of the number of pixels in one millimeter length or width of a digital image divided by the physical length or width of a printed image.
    UO_pixels_per_millimeter = 200000243,

    /// base pair: A count unit which contains one nucleotide.
    UO_base_pair = 200000244,

    /// kibibyte: An information unit which is equal to 1024 B.
    UO_kibibyte = 200000245,

    /// mebibyte: An information unit which is equal to 1024 KiB.
    UO_mebibyte = 200000246,

    /// millivolt: An electric potential difference unit which is equal to one thousandth of a volt or 10^[-3] V.
    UO_millivolt = 200000247,

    /// kilovolt: An electric potential difference unit which is equal to one thousand volts or 10^[3] V.
    UO_kilovolt = 200000248,

    /// microvolt: An electric potential difference unit which is equal to one millionth of a volt or 10^[-6] V.
    UO_microvolt = 200000249,

    /// nanovolt: An electric potential difference unit which is equal to one billionth of a volt or 10^[-12] V.
    UO_nanovolt = 200000250,

    /// picovolt: An electric potential difference unit which is equal to one trillionth of a volt or 10^[-12] V.
    UO_picovolt = 200000251,

    /// megavolt: An electric potential difference unit which is equal to one million volts or 10^[6] V.
    UO_megavolt = 200000252,

    /// surface tension unit: A unit which is a standard measure of the ability of a liguid to attraction of molecules at its surface as a result of unbalanced molecular cohesive forces.
    UO_surface_tension_unit = 200000253,

    /// newton per meter: A surface tension unit which is equal to one newton per meter.
    UO_newton_per_meter = 200000254,

    /// dyne per cm: A surface tension unit which is equal to one dyne per centimeter.
    UO_dyne_per_cm = 200000255,

    /// viscosity unit: A unit which is a standard measure of the internal resistance of fluids to flow.
    UO_viscosity_unit = 200000256,

    /// pascal second: A viscosity unit which is equal to one pascale per second.
    UO_pascal_second = 200000257,

    /// poise: A viscosity unit which is equal to one dyne second per square centimeter.
    UO_poise = 200000258,

    /// decibel: An ratio unit which is an indicator of sound power per unit area.
    UO_decibel = 200000259,

    /// effective dose unit: A unit which is a standard measure of the estimate of the stochastic effect that a non-uniform radiation dose has on a human.
    UO_effective_dose_unit = 200000260,

    /// conduction unit: A unit which represents a standard measurement of the transmission of an entity through a medium.
    UO_conduction_unit = 200000261,

    /// electrical conduction unit: A unit which represents a standard measurement of the movement of electrically charged particles through a transmission medium (electrical conductor).
    UO_electrical_conduction_unit = 200000262,

    /// heat conduction unit: A unit which represents a standard measurement of the spontaneous transfer of thermal energy through matter, from a region of higher temperature to a region of lower temperature.
    UO_heat_conduction_unit = 200000263,

    /// siemens: An electrical conduction unit which is equal to A/V.
    UO_siemens = 200000264,

    /// watt per meter kelvin: An heat conduction unit which is equal to one watt divided by meter kelvin.
    UO_watt_per_meter_kelvin = 200000265,

    /// electronvolt: A non-SI unit of energy (eV) defined as the energy acquired by a single unbound electron when it passes through an electrostatic potential difference of one volt. An electronvolt is equal to 1.602 176 53(14) x 10^-19 J.
    UO_electronvolt = 200000266,

    /// electric field strength unit: The electric field strength is a unit which is a measure of the potential difference between two points some distance apart.
    UO_electric_field_strength_unit = 200000267,

    /// volt per meter: The volt per meter is a unit of electric field strength equal to the a potential difference of 1 volt existing between two points that are 1 meter apart.
    UO_volt_per_meter = 200000268,

    /// absorbance unit: A dimensionless logarithmic unit assigned to a measure of absorbance of light through a partially absorbing substance, defined as -log10(I/I_0) where I = transmitted light and I_0 = incident light.
    UO_absorbance_unit = 200000269,

    /// volumetric flow rate unit: A unit which is a standard measure of the volume of fluid which passes through a given surface per unit time .
    UO_volumetric_flow_rate_unit = 200000270,

    /// microliters per minute: A volumetric flow rate unit which is equal to one microliter volume through a given surface in one minute.
    UO_microliters_per_minute = 200000271,

    /// millimetres of mercury: A unit of pressure equal to the amount of fluid pressure one millimeter deep in mercury at zero degrees centigrade on Earth.
    UO_millimetres_of_mercury = 200000272,

    /// milligram per liter: A mass unit density which is equal to mass of an object in milligrams divided by the volume in liters.
    UO_milligram_per_liter = 200000273,

    /// microgram per milliliter: A mass unit density which is equal to mass of an object in micrograms divided by the volume in millliters.
    UO_microgram_per_milliliter = 200000274,

    /// nanogram per milliliter: A mass unit density which is equal to mass of an object in nanograms divided by the volume in milliliters.
    UO_nanogram_per_milliliter = 200000275,

    /// amount per container: A concentration unit which is a standard measure of the amount of a substance in a given container.
    UO_amount_per_container = 200000276,

    /// ug/disk: A unit which is equal to one microgram per disk, where a disk is some physical surface/container upon which the substance is deposited.
    UO_ug_disk = 200000277,

    /// nmole/disk: A unit which is equal to one nanomole per disk, where a disk is some physical surface/container upon which the substance is deposited.
    UO_nmole_disk = 200000278,

    /// milliunits per milliliter: A unit per milliliter unit which is equal to one thousandth of a unit of an agreed arbitrary amount per one milliliter.
    UO_milliunits_per_milliliter = 200000279,

    /// rate unit: A unit which represents a standard measurement occurrence of a process per unit time.
    UO_rate_unit = 200000280,

    /// count per nanomolar second: A rate unit which is equal to one over one nanomolar second.
    UO_count_per_nanomolar_second = 200000281,

    /// count per molar second: A rate unit which is equal to one over one molar second.
    UO_count_per_molar_second = 200000282,

    /// kilogram per hectare: An area density unit which is equal to the mass of an object in kilograms divided by the surface area in hectares..
    UO_kilogram_per_hectare = 200000283,

    /// count per nanomolar: A rate unit which is equal to one over one nanomolar.
    UO_count_per_nanomolar = 200000284,

    /// count per molar: A rate unit which is equal to one over one molar.
    UO_count_per_molar = 200000285,

    /// microgram per liter: A mass unit density which is equal to mass of an object in micrograms divided by the volume in liters.
    UO_microgram_per_liter = 200000301
}; // enum CVID


/// Information about an ontology or CV source and a short 'lookup' tag to refer to.
struct PWIZ_API_DECL CV
{
    /// the short label to be used as a reference tag with which to refer to this particular Controlled Vocabulary source description (e.g., from the cvLabel attribute, in CVParamType elements).
    std::string id;

    /// the URI for the resource.
    std::string URI;

    /// the usual name for the resource (e.g. The PSI-MS Controlled Vocabulary).
    std::string fullName;

    /// the version of the CV from which the referred-to terms are drawn.
    std::string version;

    /// returns true iff id, URI, fullName, and version are all pairwise equal
    bool operator==(const CV& that) const;

    /// returns ture iff id, URI, fullName, and version are all empty
    bool empty() const;
};


/// returns a CV object for the specified namespace (prefix);
/// currently supported namespaces are: MS UO
PWIZ_API_DECL const CV& cv(const std::string& prefix);


/// structure for holding CV term info
struct PWIZ_API_DECL CVTermInfo
{
    CVID cvid;
    std::string id;
    std::string name;
    std::string def;
    bool isObsolete;

    typedef std::vector<CVID> id_list;
    id_list parentsIsA;
    id_list parentsPartOf;
    std::multimap<std::string, CVID> otherRelations;
    std::vector<std::string> exactSynonyms;
    std::multimap<std::string, std::string> propertyValues;

    CVTermInfo() : cvid((CVID)-1) {}
    const std::string& shortName() const;
    std::string prefix() const;
};


/// returns CV term info for the specified CVID
PWIZ_API_DECL const CVTermInfo& cvTermInfo(CVID cvid);


/// returns CV term info for the specified id (accession number)
PWIZ_API_DECL const CVTermInfo& cvTermInfo(const char* id);
PWIZ_API_DECL const CVTermInfo& cvTermInfo(const std::string& id);


/// returns true iff child IsA parent in the CV
PWIZ_API_DECL bool cvIsA(CVID child, CVID parent);


/// returns vector of all valid CVIDs
PWIZ_API_DECL const std::vector<CVID>& cvids();


} // namespace cv
} // namespace pwiz


#endif // _CV_HPP_


