/* http://delegate.uec.ac.jp:8081/club/mma/~shimiz98/misc/sendfile.html */
#define _FILE_OFFSET_BITS 64
#include "io_internal.h"
#include "havebsdsf.h"
#include "havesendfile.h"

#if defined(HAVE_BSDSENDFILE)
#define SENDFILE 1
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>

int64 io_sendfile(int64 s,int64 fd,uint64 off,uint64 n) {
  off_t sbytes;
  int r=sendfile(fd,s,off,n,0,&sbytes,0);
  if (r==-1)
    return (errno==EAGAIN?(sbytes?sbytes:-1):-3);
  return n;
}

#elif defined(HAVE_SENDFILE)

#ifdef __hpux__

#define _LARGEFILE64_SOURCE
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/socket.h>

int64 io_sendfile(int64 out,int64 in,uint64 off,uint64 bytes) {
  long long r=sendfile64(out,in,off,bytes,0,0);
  if (r==-1 && errno!=EAGAIN) r=-3;
  return r;
}

#elif defined (__sun__) && defined(__svr4__)

#define _LARGEFILE64_SOURCE
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/sendfile.h>

int64 io_sendfile(int64 out,int64 in,uint64 off,uint64 bytes) {
  off64_t o=off;
  long long r=sendfile64(out,in,&o,bytes);
  if (r==-1 && errno!=EAGAIN) r=-3;
  return r;
}

#elif defined(_AIX)

#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <errno.h>

int64 io_sendfile(int64 out,int64 in,uint64 off,uint64 bytes) {
  struct sf_parms p;
  int destfd=out;
  p.header_data=0;
  p.header_length=0;
  p.file_descriptor=in;
  p.file_offset=off;
  p.file_bytes=bytes;
  p.trailer_data=0;
  p.trailer_length=0;
  if (send_file(&destfd,&p,0)>=0)
    return p.bytes_sent;
  if (errno==EAGAIN)
    return -1;
  else
    return -3;
}

#elif defined(__linux__)

#if defined(__GLIBC__)
#include <sys/sendfile.h>
#elif defined(__dietlibc__)
#include <sys/sendfile.h>
#else
#include <linux/unistd.h>
_syscall4(int,sendfile,int,out,int,in,long *,offset,unsigned long,count)
#endif

int64 io_sendfile(int64 s,int64 fd,uint64 off,uint64 n) {
  off_t o=off;
  io_entry* e=array_get(&io_fds,sizeof(io_entry),s);
  off_t i;
  uint64 done=0;
  /* What a spectacularly broken design for sendfile64.
   * The offset is 64-bit for sendfile64, but the count is not. */
  while (n) {
    off_t todo=n>0x7fffffff?0x7fffffff:n;
    i=sendfile(s,fd,&o,todo);
    if (i==todo) {
      done+=todo;
      n-=todo;
      if (n==0) return done;
      continue;
    } else if (i==-1) {
      if (e) {
	e->canwrite=0;
	e->next_write=-1;
      }
      return (errno==EAGAIN?-1:-3);
    } else
      return done+i;
  }
  return 0;
}
#endif

#else

#include <iob.h>
#include <unistd.h>

static int64 writecb(int64 s,const void* buf,uint64 n) {
  return write(s,buf,n);
}

int64 io_sendfile(int64 out,int64 in,uint64 off,uint64 bytes) {
  return io_mmapwritefile(out,in,off,bytes,writecb);
}

#endif
