/* createuser.c

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#include "createuser.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <openhbci/customer.h>
#include <openhbci/bank.h>

/* Does the openhbci.h include work in C? */
/*#include "../openhbci/openhbci.h" */


HBCI_Error* createUser(HBCI_API* hbciif,
		       HBCI_CmdLineOptions* opt){
  int country;
  char* userid;
  char* bank_id;
  char* mediumfile;
  char* server, *cust_id, *custName;
  char* secmode_string;
  int ro;
  char *mtype;
  HBCI_Error* err = 0;
  /*HBCI_Customer* customer;*/
  const HBCI_User *user;
  HBCI_User *nonconst_user;
  HBCI_Medium *medium;
  HBCI_Bank *bank;
  HBCI_Customer *cust;


  /* get the variables from the command line */
  country = HBCI_CmdLineOptions_getIntVariable(opt, "country", 280);
  ro = HBCI_CmdLineOptions_getIntVariable(opt, "readonly", 0);
  bank_id = HBCI_CmdLineOptions_getStringVariable(opt, "instid", "");
  userid = HBCI_CmdLineOptions_getStringVariable(opt, "user", "");
  mediumfile = HBCI_CmdLineOptions_getStringVariable(opt, "medium", "");
  server = HBCI_CmdLineOptions_getStringVariable(opt, "server", "");
  secmode_string = HBCI_CmdLineOptions_getStringVariable(opt, "secmode", "");
  cust_id = HBCI_CmdLineOptions_getStringVariable(opt, "customer", "");
  custName = HBCI_CmdLineOptions_getStringVariable(opt, "custName", "");
  mtype = HBCI_CmdLineOptions_getStringVariable(opt, "mediumtype", "");

  if (strlen(mtype)==0)
    return HBCI_Error_new("createUser()",
			  ERROR_LEVEL_NORMAL,
			  0,
			  ERROR_ADVISE_DONTKNOW,
			  "No medium type given.",
			  "");
  if (country == 0 ||
      strlen(bank_id) == 0 ||
      strlen(userid) == 0 ||
      strlen(server) == 0)
    return HBCI_Error_new("createUser()",
			  ERROR_LEVEL_NORMAL,
			  0,
			  ERROR_ADVISE_DONTKNOW,
			  "You need to specify country, institute, user, medium, and server.",
			  "");

  /* check if the bank exists */
  bank = HBCI_API_findBank(hbciif, country, bank_id);
  if (!bank) {
    printf("Creating bank with BLZ %s. \n", bank_id);
    /* need to create it */
    bank = HBCI_API_bankFactory(hbciif,
				country,
				bank_id,
				server);
    HBCI_API_addBank(hbciif, bank, 1);
  }
  printf("Now having bank with BLZ %s.\n", HBCI_Bank_bankCode(bank));

  /* check if user exists */
  user = HBCI_Bank_findUser(bank, userid);
  if (!user) {
      /* need to create him */
    printf("Creating user with userid %s. \n", userid);

    /* check if medium exists */
    medium = HBCI_API_findMedium(hbciif, mediumfile);
    if (!medium) {
      HBCI_Error *err;
      printf("Creating medium with mediumfile %s. \n", mediumfile);
      /* need to create the medium */
      medium = HBCI_API_createNewMedium(hbciif,
					mtype,
					ro,
					country,
					bank_id,
					userid,
					mediumfile,
					&err);
      if (!medium)
	return err;
    }
    printf("Now having medium.\n");

    /* then the user himself */
    nonconst_user = HBCI_API_userFactory(bank,
					 medium,
					 1,
					 userid);
    /* add user to the system */
    HBCI_Bank_addUser(bank, nonconst_user, 1);
    user = nonconst_user;
    printf("Now having user with userid %s, name %s.\n",
	   HBCI_User_userId(user), HBCI_User_userName(user));


    /* done with user creation */
  }
  /* create customer, if given */
  if (strlen(cust_id)!=0) {
    cust = HBCI_API_customerFactory((HBCI_User *)user,
				    cust_id,
				    custName);
    HBCI_User_addCustomer((HBCI_User *)user, cust, 1);
    printf("Now created customer with custid %s.\n",
	   HBCI_Customer_custId(cust));
  }

  return err;
}





