MODULE VO:ButtonRowPrefs;

(*
    Copyright (C) 1999  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT Z   := VO:Base:Size,

       V   := VO:Model:Value,

       PP  := VO:Prefs:Parser,

       BR  := VO:ButtonRow,
       F   := VO:FrameGroup,
       G   := VO:Object,
       GP  := VO:ObjectPrefs,
       L   := VO:Label,
       R   := VO:Radio,
       T   := VO:Text,
       TA  := VO:Tab;

TYPE
  Item*     = POINTER TO ItemDesc;
  ItemDesc* = RECORD (GP.PrefsItemDesc)
                model : V.IntModel;
              END;

VAR
  prefs : Item;

  PROCEDURE (d : Item) Init*;

  BEGIN
    d.Init^;
    d.name:="ButtonRow";

    d.SetPrefs(BR.prefs);

    NEW(d.model);
    d.model.Init;
  END Init;

  PROCEDURE (d : Item) GetObject*():G.Object;

  VAR
    frame  : F.FrameGroup;
    label  : L.Label;
    radio  : R.Radio;
    object : G.Object;
    tab    : TA.Tab;

  BEGIN
    object:=d.GetObject^();
    tab:=object(TA.Tab);

    frame:=F.CreateFrameGroup();
    frame.SetTextLabel("Button alignment");

      label:=L.CreateLabel();
      label.Set(TRUE);

        radio:=R.CreateRadio();
        radio.SetIndex(G.alignLeft);
        radio.SetModel(d.model);
        d.window.AddFocusObject(radio);
      label.AddTextLabel("left",radio);

        radio:=R.CreateRadio();
        radio.SetIndex(G.alignCenter);
        radio.SetModel(d.model);
        d.window.AddFocusObject(radio);
      label.AddTextLabel("center",radio);

        radio:=R.CreateRadio();
        radio.SetIndex(G.alignRight);
        radio.SetModel(d.model);
        d.window.AddFocusObject(radio);
      label.AddTextLabel("right",radio);

        radio:=R.CreateRadio();
        radio.SetIndex(G.alignBound);
        radio.SetModel(d.model);
        d.window.AddFocusObject(radio);
      label.AddTextLabel("bound",radio);

    frame.SetObject(label);

    tab.AddTab(T.MakeCenterText(d.name),frame);

    RETURN tab;
  END GetObject;

  PROCEDURE (d : Item) Refresh*;

  BEGIN
    d.Refresh^;

    d.model.SetLongint(BR.prefs.alignment);
  END Refresh;

  PROCEDURE (p : Item) Apply*;

  BEGIN
    p.Apply^;

    BR.prefs.alignment:=p.model.GetLongint();
  END Apply;

  PROCEDURE (p : Item) LoadPrefs*(top : PP.Item);

  VAR
    buffer : ARRAY 256 OF CHAR;
    pos    : LONGINT;

  BEGIN
    p.LoadPrefs^(top);

    Z.LoadSize("space",top,BR.prefs.space);

    IF top.GetStringEntry("alignment",buffer) THEN
      pos:=G.GetAlignment(buffer);
      IF pos>=0 THEN
        BR.prefs.alignment:=pos;
      ELSE
        p.ErrorWrongData("alignment",buffer);
      END;
    END;
  END LoadPrefs;

  PROCEDURE (p : Item) SavePrefs*(block : PP.BlockItem);

  BEGIN
    p.SavePrefs^(block);

    Z.SaveSize("space",block,BR.prefs.space);

    block.AddItemValue("alignment",G.alignments[BR.prefs.alignment]);
  END SavePrefs;

BEGIN
  NEW(prefs);
  prefs.Init;
END VO:ButtonRowPrefs.