package ru.novosoft.uml.gen;

import java.util.*;
import java.io.*;

import ru.novosoft.uml.gen.mmm.*;

public class GenMMXMIReaderDOM extends GenMMWriter
{
  public static String CLASSNAME = "XMIReaderDOM";
  public static String PACKAGE= GenMM.ROOT_PACKAGE+".xmi";

  protected MPackage root = null;
  
  GenMMXMIReaderDOM(GenMM g, HashMap hmTypes) throws IOException
  {
    super(g, PACKAGE, CLASSNAME+".java");
    try
    {
      root = g.getRootPackage();

      prolog();

      sline("package "); print(PACKAGE); println(";");
      println();

      imports();

      println();
      sline("public class "); print(CLASSNAME); println(" implements ErrorHandler, EntityResolver");
      sblock();

      appendResource(PACKAGE, CLASSNAME+".user");

      Iterator i = hmTypes.values().iterator();
      while (i.hasNext())
      {
        MClass c = (MClass)i.next();
        if (c instanceof MElement || c instanceof MDataType)
        {
          genClass(c);
        }
      }
      println();

      line("public Object process(Node arg)");
      sblock();
      line("boolean ref = false;");
      line("if (null != arg.getAttributes())");
      sblock();
      line("ref = (null != arg.getAttributes().getNamedItem(\"xmi.idref\")) ||"); ident();
      line("(null != arg.getAttributes().getNamedItem(\"xmi.uuidref\"));"); unident();
      eblock();
      println();
  
      int j=1;
  
      i = hmTypes.values().iterator();
      while (i.hasNext())
      {
        MClass c = (MClass)i.next();
        //leafClassifiers.put(c, c);
      }
  
      line("String lastName = null;");
      line("String nodeName = arg.getNodeName();");
      println();
  
      i = root.getElements().iterator();
      while(i.hasNext())
      {
        Object o = i.next();
        if (o instanceof MPackage)
        {
          genSelectorPackage((MPackage)o, 0);
        }
      }
      println();

      line("return null;");
  
      eblock();

      eblock();
    }
    finally
    {
      close();
    }
  }

  protected void imports()
  {
    importCollections();
    sline("import "); print(getGenerator().getCollectionsPackage()); println(".HashMap;");
    sline("import "); print(getGenerator().getCollectionsPackage()); println(".Map;");
    println();

    line("import java.util.StringTokenizer;");
    println();
    
    line("import java.io.*;");
    println();    

    line("import ru.novosoft.uml.*;");
    line("import ru.novosoft.uml.foundation.core.*;");
    line("import ru.novosoft.uml.foundation.data_types.*;");
    line("import ru.novosoft.uml.foundation.extension_mechanisms.*;");
    line("import ru.novosoft.uml.behavior.*;");
    line("import ru.novosoft.uml.behavior.use_cases.*;");
    line("import ru.novosoft.uml.behavior.common_behavior.*;");
    line("import ru.novosoft.uml.behavior.state_machines.*;");
    line("import ru.novosoft.uml.behavior.collaborations.*;");
    line("import ru.novosoft.uml.behavior.activity_graphs.*;");
    line("import ru.novosoft.uml.model_management.*;");
    println();
    
    line("import org.w3c.dom.*;");
    println();
    
    line("import org.xml.sax.*;");
  }

  protected void genClass(MClass p_cls)
  {
    if (!p_cls.isAbstract())
    {
      sline("public Object "); printProcessMainName(p_cls); println("(Node arg)");
      sblock();
      line("if (null == arg)");
      sblock();
      line("return null;");
      eblock();
      println();
  
      if (p_cls instanceof MDataType)
      {
        if (p_cls.getName().equals("Multiplicity"))
        {
          sline(); printUMLMName(p_cls); println(" o = null;");
          println();
  
          line("List rangeList = new ArrayList();");
          println();
          line("for(int i=0; i<arg.getChildNodes().getLength(); i++)");
          sblock();
            line("Node n = arg.getChildNodes().item(i);");
            line("if (n.getNodeName().equals(\"Foundation.Data_Types.Multiplicity.range\"))");
            sblock();
              line("for(int j=0; j<n.getChildNodes().getLength(); j++)");
              sblock();
                line("Node n2 = n.getChildNodes().item(j);");
                line("MMultiplicityRange el = (MMultiplicityRange)process(n2);");
                line("if (null != el)");
                sblock();
                  line("rangeList.add(el);");
                eblock();
              eblock();
              line("continue;");
            eblock();
          eblock();
          println();
  
          sline("o = new "); printUMLMName(p_cls); println("(rangeList);");
          line("putObject(arg, o);");
  
          line("return o;");
        }
        else if (p_cls.getName().equals("MultiplicityRange"))
        {
          sline(); printUMLMName(p_cls); println(" o = null;");
          println();
  
          line("int iLower = -1;");
          line("int iUpper = -1;");
          println();
  
          line("for(int i=0; i<arg.getChildNodes().getLength(); i++)");
          sblock();
            line("Node n = arg.getChildNodes().item(i);");
  
            line("if (n.getNodeName().equals(\"Foundation.Data_Types.MultiplicityRange.lower\"))");
            sblock();
              line("if (n.getChildNodes().getLength()>0)");
              sblock();
                line("iLower = Integer.parseInt(n.getChildNodes().item(0).getNodeValue());");
              eblock();
              line("continue;");
            eblock();
        
            line("if (n.getNodeName().equals(\"Foundation.Data_Types.MultiplicityRange.upper\"))");
            sblock();
              line("if (n.getChildNodes().getLength()>0)");
              sblock();
                line("iUpper = Integer.parseInt(n.getChildNodes().item(0).getNodeValue());");
              eblock();
              line("continue;");
            eblock();
  
          eblock();
          println();
  
          sline("o = new "); printUMLMName(p_cls); println("(iLower, iUpper);");
          line("putObject(arg, o);");
  
          line("return o;");
        }
        else
        {
          sline(); printUMLMName(p_cls); println(" o = null;");
          println();
  
          line("String sLanguage = null;");
          line("String sBody = null;");
          println();
  
          line("for(int i=0; i<arg.getChildNodes().getLength(); i++)");
          sblock();
          line("Node n = arg.getChildNodes().item(i);");
      
          line("if (n.getNodeName().equals(\"Foundation.Data_Types.Expression.language\"))");
          sblock();
            line("if (n.getChildNodes().getLength()>0)");
            sblock();
              line("sLanguage = n.getChildNodes().item(0).getNodeValue();");
            eblock();
            line("else");
            sblock();
              line("sLanguage = \"\";");
            eblock();
            line("continue;");
          eblock();
      
          line("if (n.getNodeName().equals(\"Foundation.Data_Types.Expression.body\"))");
          sblock();
            line("if (n.getChildNodes().getLength()>0)");
            sblock();
              line("sBody = n.getChildNodes().item(0).getNodeValue();");
            eblock();
            line("else");
            sblock();
              line("sBody = \"\";");
            eblock();
            line("continue;");
          eblock();
      
          eblock();
          println();
  
          sline("o = new "); printUMLMName(p_cls); println("(sLanguage, sBody);");
          line("putObject(arg, o);");
  
          line("return o;");
        }
      }
      else
      {
        sline(); printUMLMName(p_cls); print(" o = ("); printUMLMName(p_cls); println(")getObject(arg);");
        line("if (null == o)");
        sblock();
        sline("o = factory.create"); printUMLName(p_cls); println("();");
        line("Node nodeXMIUUID = arg.getAttributes().getNamedItem(\"xmi.uuid\");");
        line("if (null != nodeXMIUUID)");
        sblock();
        line("o.setUUID(nodeXMIUUID.getNodeValue());");
        eblock();
        line("putObject(arg, o);");
        eblock();
        println();
    
        line("for(int i=0; i<arg.getChildNodes().getLength(); i++)");
        sblock();
        line("Node n = arg.getChildNodes().item(i);");
    
        sline("if ("); printProcessAttributesName(p_cls); println("(arg, o, n))");
        sblock();
        line("continue;");
        eblock();
        println();
    
        sline("if ("); printProcessRolesName(p_cls); println("(arg, o, n))");
        sblock();
        line("continue;");
        eblock();
        eblock();
        println();
    
        line("return o;");
      }

      eblock();
      println();
    }

    if (!(p_cls instanceof MDataType))
    {
      genClassAttributes(p_cls);
      genClassRoles(p_cls);
    }
  }

  protected void genClassAttributes(MClass p_cls)
  {
    sline("public boolean "); printProcessAttributesName(p_cls); print("(Node arg, "); printUMLMName(p_cls); println(" o, Node n)");
    sblock();

    HashSet all = new HashSet();
    HashSet sc1 = new HashSet();

    Iterator i = p_cls.getSuperClasses().iterator();
    MClass sc = null;
    if (i.hasNext())
    {
      sc = (MClass)i.next();

      sline("if ("); printProcessAttributesName(sc); println("(arg, o, n))");
      sblock();
      line("return true;");
      eblock();
    }

    getSuperclasses(p_cls, all);
    getSuperclasses(sc, sc1);

    HashSet notImpl = new HashSet(all);

    notImpl.removeAll(sc1);
    notImpl.remove(sc);
    notImpl.add(p_cls);

    i = notImpl.iterator();
    while (i.hasNext())
    {
      MClass ic = (MClass)i.next();

      Iterator j = ic.getAttributes().iterator();
      if (j.hasNext())
      {
        sline("if (n.getNodeName().startsWith(\""); print(getFullXMITagName(ic)); println(".\"))");
        sblock();
        sline("String lastName = n.getNodeName().substring("); print(getFullXMITagName(ic).length() + 1); println(");");
        println();

        while(j.hasNext())
        {
          MAttribute attr = (MAttribute)j.next();
          genClassAttribute(p_cls, attr);
        }

        eblock();
      }
    }

    line("return false;");
    eblock();
    println();
  }

  protected void genClassAttribute(MClass p_cls, MAttribute p_attr)
  {
    sline("if (lastName.equals(\""); print(p_attr.getName()); println("\"))");
    sblock();

    if (p_attr.getType().getName().equals("Name") || p_attr.getType().getName().equals("String") || p_attr.getType().getName().equals("LocationReference") || p_attr.getType().getName().equals("Geometry"))
    {
      line("if (n.getChildNodes().getLength()>0)");
      sblock();
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(n.getChildNodes().item(0).getNodeValue());");
      eblock();
      line("else");
      sblock();
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(\"\");");
      eblock();
    }
    else if (p_attr.getType().getName().equals("Boolean"))
    {
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(convertXMIBooleanValue(n.getAttributes().getNamedItem(\"xmi.value\").getNodeValue()));");
    }
    else if (p_attr.getType() instanceof MEnum)
    {
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); print("("); printUMLMName(p_attr.getType()); println(".forName(n.getAttributes().getNamedItem(\"xmi.value\").getNodeValue()));");
    }
    else if(p_attr.getType().getName().equals("MultiplicityRange"))
    {
      throw new IllegalArgumentException("Attributes with MultiplicityRange type are not supported.");
    }
    else if (p_attr.getType().getName().equals("Integer") || p_attr.getType().getName().equals("UnlimitedInteger"))
    {
      line("if (n.getChildNodes().getLength()>0)");
      sblock();
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(Integer.parseInt(n.getChildNodes().item(0).getNodeValue()));");
      eblock();
      line("else");
      sblock();
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); println("(0);");
      eblock();
    }
    else if (p_attr.getType() instanceof MDataType)
    {
      line("for(int i=0; i<n.getChildNodes().getLength(); i++)");
      sblock();
      line("Node n2 = n.getChildNodes().item(i);");
      line("Object e = process(n2);");
      line("if (e instanceof Link)");
      sblock();
      line("Link l = (Link)e;");
      line("l.sourceObject = o;");
      sline("l.methodName = \""); print(p_attr.getName()); println("\";");
      line("l.methodType = true;");
      line("link(l);");
      line("break;");
      eblock();
      line("else if (null != e)");
      sblock();
      sline("o."); printSetterUML(p_attr.getType(), p_attr.getName()); print("(("); printUMLMName(p_attr.getType()); println(")e);");
      line("break;");
      eblock();
      eblock();
    }
    else
    {
      System.out.println("Unknown primitive type: " + p_attr.getType().getName());
    }

    line("return true;");
    eblock();
    println();
  }

  protected void genClassRoles(MClass p_cls)
  {
    sline("public boolean "); printProcessRolesName(p_cls); print("(Node arg, "); printUMLMName(p_cls); println(" o, Node n)");
    sblock();

    HashSet all = new HashSet();
    HashSet sc1 = new HashSet();

    Iterator i = p_cls.getSuperClasses().iterator();
    MClass sc = null;
    if (i.hasNext())
    {
      sc = (MClass)i.next();

      sline("if ("); printProcessRolesName(sc); println("(arg, o, n))");
      sblock();
      line("return true;");
      eblock();
    }

    getSuperclasses(p_cls, all);
    getSuperclasses(sc, sc1);

    HashSet notImpl = new HashSet(all);

    notImpl.removeAll(sc1);
    notImpl.remove(sc);
    notImpl.add(p_cls);

    i = notImpl.iterator();
    while (i.hasNext())
    {
      MClass ic = (MClass)i.next();

      Iterator j = ic.getRoles().iterator();

      if (j.hasNext())
      {
        sline("if (n.getNodeName().startsWith(\""); print(getFullXMITagName(ic)); println(".\"))");
        sblock();
        sline("String lastName = n.getNodeName().substring("); print(getFullXMITagName(ic).length() + 1); println(");");
        println();

        while(j.hasNext())
        {
          MRole role = (MRole)j.next();
          genClassRole(ic, oppositeRole(role));
        }

        eblock();
      }
    }
    println();

    line("return processXMIExtension(o, n);");

    eblock();
    println();
  }

  protected void genClassRole(MClass p_cls, MRole p_role)
  {
    if (!p_role.getName().equals(""))
    {
      MRole roleOp = oppositeRole(p_role);
      if (!p_role.getName().substring(0, 1).equals("/") && !roleOp.getName().substring(0, 1).equals("/"))
      {
        sline("if (lastName.equals(\""); printXMIRoleName(p_role); println("\"))");
        sblock();

        line("for(int i=0; i<n.getChildNodes().getLength(); i++)");
        sblock();
        line("Node n2 = n.getChildNodes().item(i);");
        {
          if (p_role.getKind().equals("bag") || p_role.getKind().equals("list"))
          {
            MClass rt = p_role.getType();
  
            sline(); printUMLMName(rt); print(" el = ("); printUMLMName(rt); println(")process(n2);");
  
            if ((!roleOp.isNavigable() && p_role.isNavigable()) ||
              roleOp.isComposite() || 
              (!p_role.isComposite() && (roleOp.getKind().equals("ref") && (p_role.getKind().equals("bag") && p_role.getKind().equals("list")))) ||
              (!p_role.isComposite() && (roleOp == roleOp.getAssociation().getRoles().get(0))))
            {
              line("if (null != el)");
              sblock();
              sline("o.add"); printJavaName(p_role.getName()); println("(el);");
              eblock();
            }

            //line("return true;");
          }
          else
          {
            sline(); printUMLMName(p_role.getType()); print(" el = ("); printUMLMName(p_role.getType()); println(")process(n2);");

            if ((!roleOp.isNavigable() && p_role.isNavigable()) ||
              roleOp.isComposite() || 
              (!p_role.isComposite() && (roleOp.getKind().equals("ref") && (p_role.getKind().equals("bag") && p_role.getKind().equals("list")))) ||
              (!p_role.isComposite() && (roleOp == roleOp.getAssociation().getRoles().get(0))))
            {
              line("if (null != el)");
              sblock();
              sline("o.set"); printJavaName(p_role.getName()); println("(el);");
              eblock();
            }

            //line("return true;");
          }
        }

        eblock();
        line("return true;");
        eblock();
      }
    }
  }

  protected void genSelectorPackage(MPackage p_mpackage, int p_level)
  {
    String packageName = p_mpackage.getName();
    boolean bFirst = true;

    if (null == packageName)
    {
      packageName = "";
    }

    sline("if (nodeName.startsWith(\""); print(packageName); 
      print(".\","); print(p_level); println("))");
    sblock();

    Iterator i = p_mpackage.getElements().iterator();
    while(i.hasNext())
    {
      Object o = i.next();
      if (o instanceof MPackage)
      {
        genSelectorPackage((MPackage)o, p_level+packageName.length() + 1);
      }
    } 

    i = p_mpackage.getElements().iterator();
    while(i.hasNext())
    {
      Object o = i.next();
      if(o instanceof MElement || o instanceof MDataType)
      {
        if (bFirst)
        {
          bFirst = false;
          sline("lastName = nodeName.substring("); print(p_level+packageName.length() + 1); println(");");
          println();
        }

        genSelector((MClass)o);
      }
    }

    eblock();
  }

  protected void genSelector(MClass p_cls)
  {
    if (!p_cls.isAbstract())
    {
      sline("if (lastName.equals(\"");
        print(p_cls.getName().replace(' ', '_')); println("\"))");
      sblock();
      line("if (ref)");
      sblock();

      if (p_cls instanceof MDataType)
      {
        if (p_cls.getName().equals("MultiplicityRange"))
        {
          line("throw new IllegalArgumentException(\"Reference to MultiplicityRange not supported!!!\");");
        }
        else
        {
          line("Object o = getObjectByRef(arg);");
          line("if (null == o || this == o)");
          sblock();
          line("putObjectByRef(arg, this);");
          line("Link l = new Link();");
          line("l.parameter = arg;");
          line("return l;");
          eblock();
          println();
          line("return o;");
        }
      }
      else
      {
        sline(); printUMLMName(p_cls); print(" o = ("); printUMLMName(p_cls); println(")getObjectByRef(arg);");
        line("if (null == o)");
        sblock();
        sline("o = factory.create"); printUMLName(p_cls); println("();");
        line("Node nodeXMIUUID = arg.getAttributes().getNamedItem(\"xmi.uuidref\");");
        println();
        line("if (null != nodeXMIUUID)");
        sblock();
        line("o.setUUID(nodeXMIUUID.getNodeValue());");
        eblock();
        line("putObjectByRef(arg, o);");
        eblock();
        println();
        line("return o;");
      }

      eblock();
      line("else");
      sblock();
      sline("return "); printProcessMainName(p_cls); println("(arg);");
      eblock();
      eblock();
      println();
    }
  }

  protected String getFullXMITagName(MClass p_cls)
  {
    MPackage pkg = p_cls.getPackage();
    String s = "";

    while (pkg != root)
    {
      s = pkg.getName() + "." + s;
      pkg = pkg.getPackage();
    }

    return s + p_cls.getName().replace(' ', '_');
  }

  public void printProcessMainName(MClass p_cls)
  {
    print("process"); print(p_cls.getName()); print("Main");
  }

  public void printProcessAttributesName(MClass p_cls)
  {
    print("process"); print(p_cls.getName()); print("Attributes");
  }

  public void printProcessRolesName(MClass p_cls)
  {
    print("process"); print(p_cls.getName()); print("Roles");
  }

  public void printUMLMName(MClass p_cls)
  {
    print("M"); print(p_cls.getName());
  }

  public void printUMLName(MClass p_cls)
  {
    print(p_cls.getName());
  }

  public void printJavaName(String p_name)
  {
    print(p_name.substring(0, 1).toUpperCase() + p_name.substring(1));
  }

  public String xmiElementName(String s)
  {
    String s2 = s.replace(' ', '_');
    return s2.substring(0, 1).toUpperCase() + s2.substring(1);
  }

  public void printGetterUML(MClass p_cls, String p_name)
  {
    if (p_cls.getName().equals("Boolean"))
    {
      print(p_name);
    }

    print("get"); printJavaName(p_name);
  }

  public void printSetterUML(MClass p_cls, String p_name)
  {
    print("set");
    if (p_cls.getName().equals("Boolean"))
    {
      printJavaName(p_name.substring(2));
    }
    else
    {
      printJavaName(p_name);
    }
  }

  protected void printXMIRoleName(MRole p_role)
  {
    String xminame = p_role.getXMIName();
    if (null == xminame || xminame.equals(""))
    {
      xminame = p_role.getName();
    }

    print(xminame);
  }

}