package ru.novosoft.uml.gen;
import java.util.*;
import java.io.*;
import ru.novosoft.uml.gen.mmm.*;

public class GenMMEnum extends GenMMWriter
{
  GenMMEnum(GenMM g, MEnum c)  throws IOException
  {
    super(g, getPackage(c), cname(c)+".java");
    try
    {
      prolog();
      line("package "+getPackage(c)+";");
      sline("import "); print(getGenerator().getCollectionsPackage()); println(".HashMap;");
      line();
      line("public final class "+cname(c)+" implements java.io.Serializable");
      sblock();
      line("private final transient int _value;");
      line("private final String _name;");
      line("private final static HashMap _name2literal = new HashMap();");
      line("private final static HashMap _value2literal = new HashMap();");
      line("private "+cname(c)+"(int n, String name)");
      sblock();
      line("this._value = n;");
      line("this._name = name;");
      line("_name2literal.put(name,this);");
      line("_value2literal.put(new Integer(n),this);");
      eblock();
      line("public static "+cname(c)+" forName(String name)");
      sblock();
      line("return ("+cname(c)+")_name2literal.get(name);");
      eblock();
      line("public static "+cname(c)+" forValue(int n)");
      sblock();
      line("return ("+cname(c)+")_value2literal.get(new Integer(n));");
      eblock();
      line("public int getValue()");
      sblock();
      line("return _value;");
      eblock();
      line("public String getName()");
      sblock();
      line("return _name;");
      eblock();

      line("protected Object readResolve() throws java.io.ObjectStreamException");
      sblock();
      line("return forName(_name);");
      eblock();

      Iterator i = c.getLiterals().iterator();
      int n=0;
      while (i.hasNext())
      {
        genConstant(c, (MEnumLiteral)i.next(), n++);
      }
      eblock();
    }
    finally
    {
      close();
    }
  }

  void genConstant(MEnum c, MEnumLiteral l, int n)
  {
    String ec = convertEnumValue(l.getName()).toUpperCase();
    String eic = "_"+ec;
    line("public static final int "+eic+" = "+n+";");
    line("public static final "+cname(c)+" "+ec+" = new "+cname(c)+"("+n+",\""+l.getName()+"\");");
  }

  protected String convertEnumValue(String s)
  {
    StringBuffer str = new StringBuffer();

    int len = (s != null) ? s.length() : 0;
    for(int i = 0; i < len; i++)
    {
      char ch = s.charAt(i);
      if (i>0 && Character.isUpperCase(ch))
      {
        str.append('_');
        str.append(ch);
      }
      else
      {
        str.append(ch);
      }
    }

    return str.toString();
  }

}

