# Web::Response
# Copyright(c) 2002 MoonWolf <moonwolf@moonwolf.com>
require 'web/common'

module Web
  # X|X
  class Response
    STATUS_Continue                     = '100 Continue'
    STATUS_SwitchingProtocols           = '101 Switching Protocols'
    STATUS_OK                           = '200 OK'
    STATUS_Created                      = '201 Created'
    STATUS_Accepted                     = '202 Accepted'
    STATUS_NonAuthoritativeInformation  = '203 Non-Authoritative Information'
    STATUS_NoContent                    = '204 No Content'
    STATUS_ResetContent                 = '205 Reset Content'
    STATUS_PartialContent               = '206 Partial Content'
    STATUS_MultipleChoices              = '300 Multiple Choices'
    STATUS_MovedPermanently             = '301 Moved Permanently'
    STATUS_Found                        = '302 Found'
    STATUS_SeeOther                     = '303 See Other'
    STATUS_NotModified                  = '304 Not Modified'
    STATUS_UseProxy                     = '305 Use Proxy'
    STATUS_TemporaryRedirect            = '307 Temporary Redirect'
    STATUS_BadRequest                   = '400 Bad Request'
    STATUS_Unauthorized                 = '401 Unauthorized'
    STATUS_PaymentRequired              = '402 Payment Required'
    STATUS_Forbidden                    = '403 Forbidden'
    STATUS_NotFound                     = '404 Not Found'
    STATUS_MethodNotAllowed             = '405 Method Not Allowed'
    STATUS_NotAcceptable                = '406 Not Acceptable'
    STATUS_ProxyAuthenticationRequired  = '407 Proxy Authentication Required'
    STATUS_RequestTimeout               = '408 Request Timeout'
    STATUS_Conflict                     = '409 Conflict'
    STATUS_Gone                         = '410 Gone'
    STATUS_LengthRequired               = '411 Length Required'
    STATUS_PreconditionFailed           = '412 Precondition Failed'
    STATUS_RequestEntityTooLarge        = '413 Request Entity Too Large'
    STATUS_RequestURITooLong            = '414 Request-URI Too Long'
    STATUS_UnsupportedMediaType         = '415 Unsupported Media Type'
    STATUS_RequestedRangeNotSatisfiable = '416 Requested Range Not Satisfiable'
    STATUS_ExpectationFailed            = '417 Expectation Failed'
    STATUS_InternalServerError          = '500 Internal Server Error'
    STATUS_NotImplemented               = '501 Not Implemented'
    STATUS_BadGateway                   = '502 Bad Gateway'
    STATUS_ServiceUnavailable           = '503 Service Unavailable'
    STATUS_GatewayTimeout               = '504 Gateway Timeout'
    STATUS_HTTPVersionNotSupported      = '505 HTTP Version Not Supported'
    
    def initialize
      @http_ver = 'HTTP/1.1'
      @status   = STATUS_OK
      @header   = Common::Header.new
      @body     = ''
      @cookies  = Cookie::Cookies.new
    end
    attr_reader :header, :cookies
    attr_accessor :http_ver, :body

    def status
      @status
    end

    def status=(stat)
      raise "HTTP Status code error :#{stat}" if stat !~ /^\d\d\d\s*/
      @status = stat
    end

    # Getter/Setter
    %w(
      Allow
      Age
      Accept-Ranges
      Content-Type
      Content-Encoding
      Content-Language
      Content-Length
      Content-Location
      Content-MD5
      Content-Range
      Date
      ETag
      Expect
      Expires
      Last-Modified
      Location
      Pragma
      Retry-After
      Transfer-Encoding
      Upgrade
      Vary
      Warning
      WWW-Authenticate
    ).each {|field|
      method = field.downcase.tr('-','_')
      eval( <<-END )
        def #{method}(index=0)
          @header['#{field}',index]
        end
        def #{method}=(value)
          @header['#{field}']=value
        end
      END
    }
    
    def <<(obj)
      @body << obj.to_s
      self
    end
    
    def write(obj)
      @body << obj.to_s
    end
    
    def print(obj)
      @body << obj.to_s
    end
    
    def puts(obj)
      @body << obj.to_s << "\n"
    end
    
  end # Response
end # Web
