/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;

import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

/**
 * The SSL socket factory for RMI connections. <p>
 * The implementation relies on SSLSocketFactory.getDefault() that creates a default SSLContext;
 * this context is initialized with a trust store that must contain the certificate of the server,
 * otherwise a javax.net.ssl.SSLException: untrusted server cert chain is thrown.
 * The default trust store is searched in this order
 * <ul>
 * <li> the file pointed by the javax.net.ssl.trustStore system property
 * <li> the file <jdk_home>/lib/security/jssecacerts
 * <li> the file <jdk_home>/lib/security/cacerts
 * </ul>
 * So the client normally must have the certificate of the server, and have it in one of the above positions
 * for RMI over SSL to work.
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class SSLRMIClientSocketFactory implements RMIClientSocketFactory, Serializable
{
	public Socket createSocket(String host, int port) throws IOException
	{
		SSLSocketFactory sslFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
		SSLSocket socket = (SSLSocket)sslFactory.createSocket(host, port);
		return socket;
	}
}
