dnl Copyright (C) 2004 EDF
dnl
dnl This file is part of the MEI software package.  For license
dnl information, see the COPYING file in the top level directory of the
dnl MEI source distribution.

# MEI_AC_CONFIG_PUBL_INIT([OUPUT FILE NAME])
#-------------------------------------------
# Initialize file

AC_DEFUN([MEI_AC_CONFIG_PUBL_INIT],[

# First arg is output file name
if test "$1" = "" ; then
  mei_ac_config_publ_h="config_publ.h"
else
  mei_ac_config_publ_h=$1
fi
mei_ac_lower='abcdefghijklmnopqrstuvwxyz.'
mei_ac_upper='ABCDEFGHIJKLMNOPQRSTUVWXYZ_'
mei_ac_config_publ_upname=`echo $mei_ac_config_publ_h | sed y/$mei_ac_lower/$mei_ac_upper/`
unset mei_ac_lower
unset mei_ac_upper
echo "#ifndef __"${mei_ac_config_publ_upname}"__" >  "$mei_ac_config_publ_h"-tmp
echo "#define __"${mei_ac_config_publ_upname}"__" >> "$mei_ac_config_publ_h"-tmp
echo >> "$mei_ac_config_publ_h"-tmp
echo "/* $mei_ac_config_publ_h. Generated by configure */" >> "$mei_ac_config_publ_h"-tmp
echo >> "$mei_ac_config_publ_h"-tmp

AC_MSG_NOTICE([initializing $mei_ac_config_publ_h])
])dnl


# MEI_AC_CONFIG_PUBL_FINALIZE
#----------------------------
# Finalize file

AC_DEFUN([MEI_AC_CONFIG_PUBL_FINALIZE],[

AC_REQUIRE([MEI_AC_CONFIG_PUBL_INIT])dnl

echo "#endif /* __"${mei_ac_config_publ_upname}"__ */" >>  "$mei_ac_config_publ_h"-tmp

AC_MSG_NOTICE([closing $mei_ac_config_publ_h])

diff $mei_ac_config_publ_h $mei_ac_config_publ_h-tmp  > /dev/null 2>&1
if test $? -eq 0 ; then
  AC_MSG_NOTICE([$mei_ac_config_publ_h  is unchanged])
  rm -f $mei_ac_config_publ_h-tmp
else
  mv $mei_ac_config_publ_h-tmp $mei_ac_config_publ_h
fi

unset mei_ac_config_publ_h
unset mei_ac_config_publ_upname

])dnl


# MEI_AC_CONFIG_PUBL_VERBATIM([VERBATIM TEXT])
#---------------------------------------------
# Add text to config file

AC_DEFUN([MEI_AC_CONFIG_PUBL_VERBATIM],[

AC_REQUIRE([MEI_AC_CONFIG_PUBL_INIT])dnl

echo "$1" >> "$mei_ac_config_publ_h"-tmp
echo ""   >> "$mei_ac_config_publ_h"-tmp

])dnl


# MEI_AC_CONFIG_PUBL_DEFINE(VARIABLE NAME, VALUE, [COMMENT])
#-----------------------------------------------------------
# Define variable

AC_DEFUN([MEI_AC_CONFIG_PUBL_DEFINE],[

AC_REQUIRE([MEI_AC_CONFIG_PUBL_INIT])dnl

unset mei_ac_lower
unset mei_ac_upper
if test "$3" != "" ; then
  echo "/* $3 */" >> "$mei_ac_config_publ_h"-tmp
fi
echo "#define $1 $2" >> "$mei_ac_config_publ_h"-tmp
echo >> "$mei_ac_config_publ_h"-tmp

])dnl


# MEI_AC_CONFIG_PUBL_DEFINE_STRING(VARIABLE NAME, VALUE, [COMMENT])
#------------------------------------------------------------------
# Define string variable

AC_DEFUN([MEI_AC_CONFIG_PUBL_DEFINE_STRING],[

AC_REQUIRE([MEI_AC_CONFIG_PUBL_INIT])dnl

unset mei_ac_lower
unset mei_ac_upper
if test "$3" != "" ; then
  echo "/* $3 */" >> "$mei_ac_config_publ_h"-tmp
fi
echo '#define $1 "$2"' >> "$mei_ac_config_publ_h"-tmp
echo >> "$mei_ac_config_publ_h"-tmp

])dnl


# MEI_AC_CONFIG_PUBL_SET(VARIABLE NAME, YES OR NO, [COMMENT])
#------------------------------------------------------------
# Set variable (define to 1 if second arg is yes, undefine if no )

AC_DEFUN([MEI_AC_CONFIG_PUBL_SET],[

# First arg is variable name, second arg is value, optional third arg is comment

AC_REQUIRE([MEI_AC_CONFIG_PUBL_INIT])dnl

unset mei_ac_lower
unset mei_ac_upper
if test "$3" != "" ; then
  echo "/* $3 */" >> "$mei_ac_config_publ_h"-tmp
fi
if test "$2" = "yes" ; then
  echo "#define $1 1" >> "$mei_ac_config_publ_h"-tmp
else
  echo "#undef $1" >> "$mei_ac_config_publ_h"-tmp
fi
echo >> "$mei_ac_config_publ_h"-tmp

])dnl

