# -*- ruby -*-
# This file is a part of test scripts of LDAP extension module.

require "test/conf"
require "ldap"

conn = LDAP::Conn.new($HOST, $PORT)
conn.bind{
  conn.perror("bind")
  if( defined?(LDAP::LDAP_OPT_HOST_NAME) &&
      defined?(LDAP::LDAP_OPT_PROTOCOL_VERSION) &&
      defined?(LDAP::LDAP_OPT_API_INFO) ) # checking for LDAPv3 API
    conn.set_option(LDAP::LDAP_OPT_PROTOCOL_VERSION, 3)
    host = conn.get_option(LDAP::LDAP_OPT_HOST_NAME)
    proto = conn.get_option(LDAP::LDAP_OPT_PROTOCOL_VERSION)
    begin
      info = conn.get_option(LDAP::LDAP_OPT_API_INFO)
    rescue LDAP::Error
      info = nil
    end
    print("host = #{host}, proto = #{proto}\n",
  	  "info = #{info.inspect}\n")
  end
}
