/* user-sentence-dictionary.c generated by valac 0.24.0.131-42e78, the Vala compiler
 * generated from user-sentence-dictionary.vala, do not modify */

/*
 * Copyright (C) 2011-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gstdio.h>


#define KKC_TYPE_DICTIONARY (kkc_dictionary_get_type ())
#define KKC_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY, KkcDictionary))
#define KKC_IS_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY))
#define KKC_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_DICTIONARY, KkcDictionaryIface))

typedef struct _KkcDictionary KkcDictionary;
typedef struct _KkcDictionaryIface KkcDictionaryIface;

#define KKC_TYPE_SENTENCE_DICTIONARY (kkc_sentence_dictionary_get_type ())
#define KKC_SENTENCE_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SENTENCE_DICTIONARY, KkcSentenceDictionary))
#define KKC_IS_SENTENCE_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SENTENCE_DICTIONARY))
#define KKC_SENTENCE_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_SENTENCE_DICTIONARY, KkcSentenceDictionaryIface))

typedef struct _KkcSentenceDictionary KkcSentenceDictionary;
typedef struct _KkcSentenceDictionaryIface KkcSentenceDictionaryIface;

#define KKC_TYPE_SEGMENT (kkc_segment_get_type ())
#define KKC_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT, KkcSegment))
#define KKC_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SEGMENT, KkcSegmentClass))
#define KKC_IS_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT))
#define KKC_IS_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SEGMENT))
#define KKC_SEGMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SEGMENT, KkcSegmentClass))

typedef struct _KkcSegment KkcSegment;
typedef struct _KkcSegmentClass KkcSegmentClass;

#define KKC_TYPE_USER_SENTENCE_DICTIONARY (kkc_user_sentence_dictionary_get_type ())
#define KKC_USER_SENTENCE_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_USER_SENTENCE_DICTIONARY, KkcUserSentenceDictionary))
#define KKC_USER_SENTENCE_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_USER_SENTENCE_DICTIONARY, KkcUserSentenceDictionaryClass))
#define KKC_IS_USER_SENTENCE_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_USER_SENTENCE_DICTIONARY))
#define KKC_IS_USER_SENTENCE_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_USER_SENTENCE_DICTIONARY))
#define KKC_USER_SENTENCE_DICTIONARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_USER_SENTENCE_DICTIONARY, KkcUserSentenceDictionaryClass))

typedef struct _KkcUserSentenceDictionary KkcUserSentenceDictionary;
typedef struct _KkcUserSentenceDictionaryClass KkcUserSentenceDictionaryClass;
typedef struct _KkcUserSentenceDictionaryPrivate KkcUserSentenceDictionaryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KKC_USER_SENTENCE_DICTIONARY_TYPE_USER_SENTENCE_STATE (kkc_user_sentence_dictionary_user_sentence_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _KkcDictionaryIface {
	GTypeInterface parent_iface;
	void (*reload) (KkcDictionary* self, GError** error);
	void (*save) (KkcDictionary* self, GError** error);
};

struct _KkcSentenceDictionaryIface {
	GTypeInterface parent_iface;
	gboolean (*lookup_constraint) (KkcSentenceDictionary* self, const gchar* input, gint** constraint, int* constraint_length1);
	gboolean (*lookup_phrase) (KkcSentenceDictionary* self, gchar** input, int input_length1, gchar*** phrase, int* phrase_length1);
	gboolean (*select_segments) (KkcSentenceDictionary* self, KkcSegment** input, int input_length1);
};

struct _KkcUserSentenceDictionary {
	GObject parent_instance;
	KkcUserSentenceDictionaryPrivate * priv;
};

struct _KkcUserSentenceDictionaryClass {
	GObjectClass parent_class;
};

struct _KkcUserSentenceDictionaryPrivate {
	GFile* file;
	gchar* etag;
	gboolean is_dirty;
	GeeMap* constraint_entries;
	GeeMap* phrase_entries;
};

typedef enum  {
	KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_NONE,
	KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_CONSTRAINT,
	KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_PHRASE
} KkcUserSentenceDictionaryUserSentenceState;

typedef enum  {
	KKC_DICTIONARY_ERROR_NOT_READABLE,
	KKC_DICTIONARY_ERROR_MALFORMED_INPUT
} KkcDictionaryError;
#define KKC_DICTIONARY_ERROR kkc_dictionary_error_quark ()

static gpointer kkc_user_sentence_dictionary_parent_class = NULL;
static KkcDictionaryIface* kkc_user_sentence_dictionary_kkc_dictionary_parent_iface = NULL;
static KkcSentenceDictionaryIface* kkc_user_sentence_dictionary_kkc_sentence_dictionary_parent_iface = NULL;

GType kkc_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_segment_get_type (void) G_GNUC_CONST;
GType kkc_sentence_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_user_sentence_dictionary_get_type (void) G_GNUC_CONST;
#define KKC_USER_SENTENCE_DICTIONARY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_USER_SENTENCE_DICTIONARY, KkcUserSentenceDictionaryPrivate))
enum  {
	KKC_USER_SENTENCE_DICTIONARY_DUMMY_PROPERTY
};
static GType kkc_user_sentence_dictionary_user_sentence_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void kkc_user_sentence_dictionary_load (KkcUserSentenceDictionary* self, GError** error);
static guint8* _vala_array_dup4 (guint8* self, int length);
GQuark kkc_dictionary_error_quark (void);
gchar* kkc_dictionary_utils_unescape (const gchar* input);
static gint kkc_user_sentence_dictionary_compare_constraint_entry (GeeMapEntry* a, GeeMapEntry* b);
static gint kkc_user_sentence_dictionary_compare_phrase_entry (GeeMapEntry* a, GeeMapEntry* b);
static void kkc_user_sentence_dictionary_write_constraint_entries (KkcUserSentenceDictionary* self, GString* builder, GeeArrayList* entries);
static void kkc_user_sentence_dictionary_write_phrase_entries (KkcUserSentenceDictionary* self, GString* builder, GeeArrayList* entries);
gchar* kkc_dictionary_utils_escape (const gchar* input);
static void kkc_user_sentence_dictionary_real_save (KkcDictionary* base, GError** error);
static gint _kkc_user_sentence_dictionary_compare_constraint_entry_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gint _kkc_user_sentence_dictionary_compare_phrase_entry_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void kkc_user_sentence_dictionary_real_reload (KkcDictionary* base, GError** error);
static gboolean kkc_user_sentence_dictionary_real_lookup_constraint (KkcSentenceDictionary* base, const gchar* input, gint** constraint, int* constraint_length1);
static gboolean kkc_user_sentence_dictionary_real_lookup_phrase (KkcSentenceDictionary* base, gchar** input, int input_length1, gchar*** phrase, int* phrase_length1);
static gboolean kkc_user_sentence_dictionary_real_select_segments (KkcSentenceDictionary* base, KkcSegment** segments, int segments_length1);
const gchar* kkc_segment_get_input (KkcSegment* self);
const gchar* kkc_segment_get_output (KkcSegment* self);
KkcUserSentenceDictionary* kkc_user_sentence_dictionary_new (const gchar* path, GError** error);
KkcUserSentenceDictionary* kkc_user_sentence_dictionary_construct (GType object_type, const gchar* path, GError** error);
void kkc_dictionary_reload (KkcDictionary* self, GError** error);
static void kkc_user_sentence_dictionary_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType kkc_user_sentence_dictionary_user_sentence_state_get_type (void) {
	static volatile gsize kkc_user_sentence_dictionary_user_sentence_state_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_user_sentence_dictionary_user_sentence_state_type_id__volatile)) {
		static const GEnumValue values[] = {{KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_NONE, "KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_NONE", "none"}, {KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_CONSTRAINT, "KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_CONSTRAINT", "constraint"}, {KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_PHRASE, "KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_PHRASE", "phrase"}, {0, NULL, NULL}};
		GType kkc_user_sentence_dictionary_user_sentence_state_type_id;
		kkc_user_sentence_dictionary_user_sentence_state_type_id = g_enum_register_static ("KkcUserSentenceDictionaryUserSentenceState", values);
		g_once_init_leave (&kkc_user_sentence_dictionary_user_sentence_state_type_id__volatile, kkc_user_sentence_dictionary_user_sentence_state_type_id);
	}
	return kkc_user_sentence_dictionary_user_sentence_state_type_id__volatile;
}


static guint8* _vala_array_dup4 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void kkc_user_sentence_dictionary_load (KkcUserSentenceDictionary* self, GError** error) {
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	GFile* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	gsize _tmp2_;
	gchar* _tmp3_ = NULL;
	GMemoryInputStream* memory = NULL;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GDestroyNotify _tmp6_ = NULL;
	GMemoryInputStream* _tmp7_ = NULL;
	GDataInputStream* data = NULL;
	GMemoryInputStream* _tmp8_ = NULL;
	GDataInputStream* _tmp9_ = NULL;
	gchar* line = NULL;
	gsize length = 0UL;
	gchar* _tmp10_ = NULL;
	GDataInputStream* _tmp11_ = NULL;
	gsize _tmp12_ = 0UL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	KkcUserSentenceDictionaryUserSentenceState state = 0;
	KkcUserSentenceDictionaryUserSentenceState _tmp25_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file;
	g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
	contents = (g_free (contents), NULL);
	contents = _tmp1_;
	contents_length1 = _tmp2_;
	_contents_size_ = contents_length1;
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		contents = (g_free (contents), NULL);
		return;
	}
	_tmp4_ = contents;
	_tmp4__length1 = contents_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup4 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = g_free;
	_tmp7_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp5_, _tmp5__length1, _tmp6_);
	memory = _tmp7_;
	_tmp8_ = memory;
	_tmp9_ = g_data_input_stream_new ((GInputStream*) _tmp8_);
	data = _tmp9_;
	line = NULL;
	_tmp11_ = data;
	_tmp13_ = g_data_input_stream_read_line (_tmp11_, &_tmp12_, NULL, &_inner_error_);
	length = _tmp12_;
	_tmp10_ = _tmp13_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	_tmp14_ = _tmp10_;
	_tmp10_ = NULL;
	_g_free0 (line);
	line = _tmp14_;
	_tmp15_ = line;
	if (_tmp15_ == NULL) {
		_g_free0 (_tmp10_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	state = KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_NONE;
	while (TRUE) {
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gchar* _tmp19_ = NULL;
		GDataInputStream* _tmp20_ = NULL;
		gsize _tmp21_ = 0UL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		_tmp16_ = line;
		if (!(_tmp16_ != NULL)) {
			break;
		}
		_tmp17_ = line;
		_tmp18_ = g_str_has_prefix (_tmp17_, ";; constraint entries.");
		if (_tmp18_) {
			state = KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_CONSTRAINT;
			break;
		}
		_tmp20_ = data;
		_tmp22_ = g_data_input_stream_read_line (_tmp20_, &_tmp21_, NULL, &_inner_error_);
		length = _tmp21_;
		_tmp19_ = _tmp22_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp10_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp23_ = _tmp19_;
		_tmp19_ = NULL;
		_g_free0 (line);
		line = _tmp23_;
		_tmp24_ = line;
		if (_tmp24_ == NULL) {
			_g_free0 (_tmp19_);
			break;
		}
		_g_free0 (_tmp19_);
	}
	_tmp25_ = state;
	if (_tmp25_ == KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_NONE) {
		GError* _tmp26_ = NULL;
		_tmp26_ = g_error_new_literal (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "no constraints boundary");
		_inner_error_ = _tmp26_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (_tmp10_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	while (TRUE) {
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		GDataInputStream* _tmp29_ = NULL;
		gsize _tmp30_ = 0UL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		gint index = 0;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gchar* midasi = NULL;
		const gchar* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* candidates_str = NULL;
		const gchar* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		const gchar* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gboolean _tmp56_ = FALSE;
		const gchar* _tmp57_ = NULL;
		gboolean _tmp58_ = FALSE;
		KkcUserSentenceDictionaryUserSentenceState _tmp63_ = 0;
		_tmp27_ = line;
		if (!(_tmp27_ != NULL)) {
			break;
		}
		_tmp29_ = data;
		_tmp31_ = g_data_input_stream_read_line (_tmp29_, &_tmp30_, NULL, &_inner_error_);
		length = _tmp30_;
		_tmp28_ = _tmp31_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp10_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp32_ = _tmp28_;
		_tmp28_ = NULL;
		_g_free0 (line);
		line = _tmp32_;
		_tmp33_ = line;
		if (_tmp33_ == NULL) {
			_g_free0 (_tmp28_);
			break;
		}
		_tmp34_ = line;
		_tmp35_ = g_str_has_prefix (_tmp34_, ";; phrase entries.");
		if (_tmp35_) {
			state = KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_PHRASE;
			_g_free0 (_tmp28_);
			continue;
		}
		_tmp36_ = line;
		_tmp37_ = string_index_of (_tmp36_, "/", 0);
		index = _tmp37_;
		_tmp38_ = index;
		if (_tmp38_ < 2) {
			const gchar* _tmp39_ = NULL;
			GError* _tmp40_ = NULL;
			_tmp39_ = line;
			_tmp40_ = g_error_new (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "can't extract midasi from line %s", _tmp39_);
			_inner_error_ = _tmp40_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp10_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp41_ = line;
		_tmp42_ = index;
		_tmp43_ = string_slice (_tmp41_, (glong) 0, (glong) _tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = string_strip (_tmp44_);
		_tmp46_ = _tmp45_;
		_g_free0 (_tmp44_);
		midasi = _tmp46_;
		_tmp47_ = line;
		_tmp48_ = index;
		_tmp49_ = line;
		_tmp50_ = strlen (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = string_slice (_tmp47_, (glong) _tmp48_, (glong) _tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = string_strip (_tmp53_);
		_tmp55_ = _tmp54_;
		_g_free0 (_tmp53_);
		candidates_str = _tmp55_;
		_tmp57_ = candidates_str;
		_tmp58_ = g_str_has_prefix (_tmp57_, "/");
		if (!_tmp58_) {
			_tmp56_ = TRUE;
		} else {
			const gchar* _tmp59_ = NULL;
			gboolean _tmp60_ = FALSE;
			_tmp59_ = candidates_str;
			_tmp60_ = g_str_has_suffix (_tmp59_, "/");
			_tmp56_ = !_tmp60_;
		}
		if (_tmp56_) {
			const gchar* _tmp61_ = NULL;
			GError* _tmp62_ = NULL;
			_tmp61_ = candidates_str;
			_tmp62_ = g_error_new (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "can't parse candidates list %s", _tmp61_);
			_inner_error_ = _tmp62_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (candidates_str);
			_g_free0 (midasi);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp10_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp63_ = state;
		switch (_tmp63_) {
			case KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_CONSTRAINT:
			{
				GeeArrayList* numbers = NULL;
				GeeArrayList* _tmp64_ = NULL;
				gchar** strv = NULL;
				const gchar* _tmp65_ = NULL;
				gchar* _tmp66_ = NULL;
				gchar* _tmp67_ = NULL;
				gchar** _tmp68_ = NULL;
				gchar** _tmp69_ = NULL;
				gchar** _tmp70_ = NULL;
				gint _tmp70__length1 = 0;
				gint strv_length1 = 0;
				gint _strv_size_ = 0;
				gchar** _tmp71_ = NULL;
				gint _tmp71__length1 = 0;
				GeeMap* _tmp76_ = NULL;
				const gchar* _tmp77_ = NULL;
				GeeArrayList* _tmp78_ = NULL;
				_tmp64_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
				numbers = _tmp64_;
				_tmp65_ = candidates_str;
				_tmp66_ = string_slice (_tmp65_, (glong) 1, (glong) (-1));
				_tmp67_ = _tmp66_;
				_tmp69_ = _tmp68_ = g_strsplit (_tmp67_, ",", 0);
				_tmp70_ = _tmp69_;
				_tmp70__length1 = _vala_array_length (_tmp68_);
				_g_free0 (_tmp67_);
				strv = _tmp70_;
				strv_length1 = _tmp70__length1;
				_strv_size_ = strv_length1;
				_tmp71_ = strv;
				_tmp71__length1 = strv_length1;
				{
					gchar** str_collection = NULL;
					gint str_collection_length1 = 0;
					gint _str_collection_size_ = 0;
					gint str_it = 0;
					str_collection = _tmp71_;
					str_collection_length1 = _tmp71__length1;
					for (str_it = 0; str_it < _tmp71__length1; str_it = str_it + 1) {
						gchar* _tmp72_ = NULL;
						gchar* str = NULL;
						_tmp72_ = g_strdup (str_collection[str_it]);
						str = _tmp72_;
						{
							GeeArrayList* _tmp73_ = NULL;
							const gchar* _tmp74_ = NULL;
							gint _tmp75_ = 0;
							_tmp73_ = numbers;
							_tmp74_ = str;
							_tmp75_ = atoi (_tmp74_);
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp73_, (gpointer) ((gintptr) _tmp75_));
							_g_free0 (str);
						}
					}
				}
				_tmp76_ = self->priv->constraint_entries;
				_tmp77_ = midasi;
				_tmp78_ = numbers;
				gee_map_set (_tmp76_, _tmp77_, (GeeList*) _tmp78_);
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (numbers);
				break;
			}
			case KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_PHRASE:
			{
				GeeArrayList* segments = NULL;
				GeeArrayList* _tmp79_ = NULL;
				gchar** strv = NULL;
				const gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_ = NULL;
				gchar** _tmp83_ = NULL;
				gchar** _tmp84_ = NULL;
				gchar** _tmp85_ = NULL;
				gint _tmp85__length1 = 0;
				gint strv_length1 = 0;
				gint _strv_size_ = 0;
				gchar** _tmp86_ = NULL;
				gint _tmp86__length1 = 0;
				GeeMap* _tmp92_ = NULL;
				const gchar* _tmp93_ = NULL;
				GeeArrayList* _tmp94_ = NULL;
				_tmp79_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
				segments = _tmp79_;
				_tmp80_ = candidates_str;
				_tmp81_ = string_slice (_tmp80_, (glong) 1, (glong) (-1));
				_tmp82_ = _tmp81_;
				_tmp84_ = _tmp83_ = g_strsplit (_tmp82_, "/", 0);
				_tmp85_ = _tmp84_;
				_tmp85__length1 = _vala_array_length (_tmp83_);
				_g_free0 (_tmp82_);
				strv = _tmp85_;
				strv_length1 = _tmp85__length1;
				_strv_size_ = strv_length1;
				_tmp86_ = strv;
				_tmp86__length1 = strv_length1;
				{
					gchar** str_collection = NULL;
					gint str_collection_length1 = 0;
					gint _str_collection_size_ = 0;
					gint str_it = 0;
					str_collection = _tmp86_;
					str_collection_length1 = _tmp86__length1;
					for (str_it = 0; str_it < _tmp86__length1; str_it = str_it + 1) {
						gchar* _tmp87_ = NULL;
						gchar* str = NULL;
						_tmp87_ = g_strdup (str_collection[str_it]);
						str = _tmp87_;
						{
							GeeArrayList* _tmp88_ = NULL;
							const gchar* _tmp89_ = NULL;
							gchar* _tmp90_ = NULL;
							gchar* _tmp91_ = NULL;
							_tmp88_ = segments;
							_tmp89_ = str;
							_tmp90_ = kkc_dictionary_utils_unescape (_tmp89_);
							_tmp91_ = _tmp90_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp88_, _tmp91_);
							_g_free0 (_tmp91_);
							_g_free0 (str);
						}
					}
				}
				_tmp92_ = self->priv->phrase_entries;
				_tmp93_ = midasi;
				_tmp94_ = segments;
				gee_map_set (_tmp92_, _tmp93_, (GeeList*) _tmp94_);
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (segments);
				break;
			}
			default:
			break;
		}
		_g_free0 (candidates_str);
		_g_free0 (midasi);
		_g_free0 (_tmp28_);
	}
	_g_free0 (_tmp10_);
	_g_free0 (line);
	_g_object_unref0 (data);
	_g_object_unref0 (memory);
	contents = (g_free (contents), NULL);
}


static gint kkc_user_sentence_dictionary_compare_constraint_entry (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	GeeMapEntry* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GeeMapEntry* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = a;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static gint kkc_user_sentence_dictionary_compare_phrase_entry (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_ = NULL;
	GeeMapEntry* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GeeMapEntry* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = b;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = a;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == (-1)) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != (-1)) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == (-1)) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static void kkc_user_sentence_dictionary_write_constraint_entries (KkcUserSentenceDictionary* self, GString* builder, GeeArrayList* entries) {
	GeeIterator* iter = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (entries != NULL);
	_tmp0_ = entries;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeMapEntry* entry = NULL;
		GeeIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gchar** strv = NULL;
		GeeMapEntry* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		GeeList* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gchar** _tmp11_ = NULL;
		gint strv_length1 = 0;
		gint _strv_size_ = 0;
		gchar* line = NULL;
		GeeMapEntry* _tmp25_ = NULL;
		gconstpointer _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar** _tmp28_ = NULL;
		gint _tmp28__length1 = 0;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		GString* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		_tmp2_ = iter;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_get (_tmp4_);
		entry = (GeeMapEntry*) _tmp5_;
		_tmp6_ = entry;
		_tmp7_ = gee_map_entry_get_value (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) ((GeeList*) _tmp8_));
		_tmp10_ = _tmp9_;
		_tmp11_ = g_new0 (gchar*, _tmp10_ + 1);
		strv = _tmp11_;
		strv_length1 = _tmp10_;
		_strv_size_ = strv_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					gchar** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					GeeMapEntry* _tmp18_ = NULL;
					gconstpointer _tmp19_ = NULL;
					GeeList* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					gpointer _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					if (!_tmp12_) {
						gint _tmp13_ = 0;
						_tmp13_ = i;
						i = _tmp13_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp14_ = i;
					_tmp15_ = strv;
					_tmp15__length1 = strv_length1;
					if (!(_tmp14_ < _tmp15__length1)) {
						break;
					}
					_tmp16_ = strv;
					_tmp16__length1 = strv_length1;
					_tmp17_ = i;
					_tmp18_ = entry;
					_tmp19_ = gee_map_entry_get_value (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = i;
					_tmp22_ = gee_list_get ((GeeList*) _tmp20_, _tmp21_);
					_tmp23_ = g_strdup_printf ("%i", (gint) ((gintptr) _tmp22_));
					_g_free0 (_tmp16_[_tmp17_]);
					_tmp16_[_tmp17_] = _tmp23_;
					_tmp24_ = _tmp16_[_tmp17_];
				}
			}
		}
		_tmp25_ = entry;
		_tmp26_ = gee_map_entry_get_key (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = strv;
		_tmp28__length1 = strv_length1;
		_tmp29_ = _vala_g_strjoinv (",", _tmp28_, _tmp28__length1);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strdup_printf ("%s /%s/\n", (const gchar*) _tmp27_, _tmp30_);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp30_);
		line = _tmp32_;
		_tmp33_ = builder;
		_tmp34_ = line;
		g_string_append (_tmp33_, _tmp34_);
		_g_free0 (line);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (iter);
}


static void kkc_user_sentence_dictionary_write_phrase_entries (KkcUserSentenceDictionary* self, GString* builder, GeeArrayList* entries) {
	GeeIterator* iter = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeIterator* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (entries != NULL);
	_tmp0_ = entries;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeMapEntry* entry = NULL;
		GeeIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		gchar** strv = NULL;
		GeeMapEntry* _tmp6_ = NULL;
		gconstpointer _tmp7_ = NULL;
		GeeList* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gchar** _tmp11_ = NULL;
		gint strv_length1 = 0;
		gint _strv_size_ = 0;
		gchar* line = NULL;
		GeeMapEntry* _tmp26_ = NULL;
		gconstpointer _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gchar** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		GString* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		_tmp2_ = iter;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_get (_tmp4_);
		entry = (GeeMapEntry*) _tmp5_;
		_tmp6_ = entry;
		_tmp7_ = gee_map_entry_get_value (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) ((GeeList*) _tmp8_));
		_tmp10_ = _tmp9_;
		_tmp11_ = g_new0 (gchar*, _tmp10_ + 1);
		strv = _tmp11_;
		strv_length1 = _tmp10_;
		_strv_size_ = strv_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					gchar** _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					GeeMapEntry* _tmp18_ = NULL;
					gconstpointer _tmp19_ = NULL;
					GeeList* _tmp20_ = NULL;
					gint _tmp21_ = 0;
					gpointer _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					if (!_tmp12_) {
						gint _tmp13_ = 0;
						_tmp13_ = i;
						i = _tmp13_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp14_ = i;
					_tmp15_ = strv;
					_tmp15__length1 = strv_length1;
					if (!(_tmp14_ < _tmp15__length1)) {
						break;
					}
					_tmp16_ = strv;
					_tmp16__length1 = strv_length1;
					_tmp17_ = i;
					_tmp18_ = entry;
					_tmp19_ = gee_map_entry_get_value (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = i;
					_tmp22_ = gee_list_get ((GeeList*) _tmp20_, _tmp21_);
					_tmp23_ = (gchar*) _tmp22_;
					_tmp24_ = kkc_dictionary_utils_escape (_tmp23_);
					_g_free0 (_tmp16_[_tmp17_]);
					_tmp16_[_tmp17_] = _tmp24_;
					_tmp25_ = _tmp16_[_tmp17_];
					_g_free0 (_tmp23_);
				}
			}
		}
		_tmp26_ = entry;
		_tmp27_ = gee_map_entry_get_key (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = strv;
		_tmp29__length1 = strv_length1;
		_tmp30_ = _vala_g_strjoinv ("/", _tmp29_, _tmp29__length1);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup_printf ("%s /%s/\n", (const gchar*) _tmp28_, _tmp31_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		line = _tmp33_;
		_tmp34_ = builder;
		_tmp35_ = line;
		g_string_append (_tmp34_, _tmp35_);
		_g_free0 (line);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (iter);
}


/**
         * {@inheritDoc}
         */
static gint _kkc_user_sentence_dictionary_compare_constraint_entry_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = kkc_user_sentence_dictionary_compare_constraint_entry ((GeeMapEntry*) a, (GeeMapEntry*) b);
	return result;
}


static gint _kkc_user_sentence_dictionary_compare_phrase_entry_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = kkc_user_sentence_dictionary_compare_phrase_entry ((GeeMapEntry*) a, (GeeMapEntry*) b);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void kkc_user_sentence_dictionary_real_save (KkcDictionary* base, GError** error) {
	KkcUserSentenceDictionary * self;
	gboolean _tmp0_ = FALSE;
	GString* builder = NULL;
	GString* _tmp1_ = NULL;
	GString* _tmp2_ = NULL;
	GeeArrayList* _constraint_entries = NULL;
	GeeArrayList* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeMap* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	GeeSet* _tmp7_ = NULL;
	GeeSet* _tmp8_ = NULL;
	GeeArrayList* _tmp9_ = NULL;
	GString* _tmp10_ = NULL;
	GeeArrayList* _tmp11_ = NULL;
	GString* _tmp12_ = NULL;
	GeeArrayList* _phrase_entries = NULL;
	GeeArrayList* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	GeeMap* _tmp15_ = NULL;
	GeeSet* _tmp16_ = NULL;
	GeeSet* _tmp17_ = NULL;
	GeeSet* _tmp18_ = NULL;
	GeeArrayList* _tmp19_ = NULL;
	GString* _tmp20_ = NULL;
	GeeArrayList* _tmp21_ = NULL;
	GFile* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* contents = NULL;
	GString* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GFile* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	guint8* _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	guint8* _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	const gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcUserSentenceDictionary*) base;
	_tmp0_ = self->priv->is_dirty;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	_tmp2_ = builder;
	g_string_append (_tmp2_, ";; constraint entries.\n");
	_tmp3_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_constraint_entries = _tmp3_;
	_tmp4_ = _constraint_entries;
	_tmp5_ = self->priv->constraint_entries;
	_tmp6_ = gee_map_get_entries (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	gee_array_list_add_all (_tmp4_, (GeeCollection*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = _constraint_entries;
	gee_list_sort ((GeeList*) _tmp9_, _kkc_user_sentence_dictionary_compare_constraint_entry_gcompare_data_func, NULL, NULL);
	_tmp10_ = builder;
	_tmp11_ = _constraint_entries;
	kkc_user_sentence_dictionary_write_constraint_entries (self, _tmp10_, _tmp11_);
	_tmp12_ = builder;
	g_string_append (_tmp12_, ";; phrase entries.\n");
	_tmp13_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_phrase_entries = _tmp13_;
	_tmp14_ = _phrase_entries;
	_tmp15_ = self->priv->phrase_entries;
	_tmp16_ = gee_map_get_entries (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	gee_array_list_add_all (_tmp14_, (GeeCollection*) _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = _phrase_entries;
	gee_list_sort ((GeeList*) _tmp19_, _kkc_user_sentence_dictionary_compare_phrase_entry_gcompare_data_func, NULL, NULL);
	_tmp20_ = builder;
	_tmp21_ = _phrase_entries;
	kkc_user_sentence_dictionary_write_phrase_entries (self, _tmp20_, _tmp21_);
	_tmp22_ = self->priv->file;
	_tmp23_ = g_file_get_path (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_path_get_dirname (_tmp24_);
	_tmp26_ = _tmp25_;
	g_mkdir_with_parents (_tmp26_, 448);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_tmp27_ = builder;
	_tmp28_ = _tmp27_->str;
	_tmp29_ = g_strdup (_tmp28_);
	contents = _tmp29_;
	_tmp30_ = self->priv->file;
	_tmp31_ = contents;
	_tmp32_ = string_get_data (_tmp31_, &_tmp32__length1);
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _tmp32__length1;
	_tmp34_ = self->priv->etag;
	g_file_replace_contents (_tmp30_, _tmp33_, (gsize) _tmp33__length1, _tmp34_, FALSE, G_FILE_CREATE_PRIVATE, &_tmp35_, NULL, &_inner_error_);
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp35_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_object_unref0 (_phrase_entries);
		_g_object_unref0 (_constraint_entries);
		_g_string_free0 (builder);
		return;
	}
	self->priv->is_dirty = FALSE;
	_g_free0 (contents);
	_g_object_unref0 (_phrase_entries);
	_g_object_unref0 (_constraint_entries);
	_g_string_free0 (builder);
}


/**
         * {@inheritDoc}
         */
static void kkc_user_sentence_dictionary_real_reload (KkcDictionary* base, GError** error) {
	KkcUserSentenceDictionary * self;
	gchar* attributes = NULL;
	gchar* _tmp0_ = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcUserSentenceDictionary*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = attributes;
	_tmp3_ = g_file_query_info (_tmp1_, _tmp2_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp3_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp4_ = info;
	_tmp5_ = g_file_info_get_etag (_tmp4_);
	_tmp6_ = self->priv->etag;
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
		GeeMap* _tmp7_ = NULL;
		GeeMap* _tmp8_ = NULL;
		_tmp7_ = self->priv->constraint_entries;
		gee_map_clear (_tmp7_);
		_tmp8_ = self->priv->phrase_entries;
		gee_map_clear (_tmp8_);
		kkc_user_sentence_dictionary_load (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	self->priv->is_dirty = FALSE;
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_user_sentence_dictionary_real_lookup_constraint (KkcSentenceDictionary* base, const gchar* input, gint** constraint, int* constraint_length1) {
	KkcUserSentenceDictionary * self;
	gint* _vala_constraint = NULL;
	int _vala_constraint_length1 = 0;
	gboolean result = FALSE;
	GeeList* entry = NULL;
	GeeMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	GeeList* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gpointer* _tmp7_ = NULL;
	self = (KkcUserSentenceDictionary*) base;
	g_return_val_if_fail (input != NULL, FALSE);
	_tmp0_ = self->priv->constraint_entries;
	_tmp1_ = input;
	_tmp2_ = gee_map_get (_tmp0_, _tmp1_);
	entry = (GeeList*) _tmp2_;
	_tmp3_ = entry;
	if (_tmp3_ == NULL) {
		gint* _tmp4_ = NULL;
		_tmp4_ = g_new0 (gint, 0);
		_vala_constraint = (g_free (_vala_constraint), NULL);
		_vala_constraint = _tmp4_;
		_vala_constraint_length1 = 0;
		result = FALSE;
		_g_object_unref0 (entry);
		if (constraint) {
			*constraint = _vala_constraint;
		} else {
			_vala_constraint = (g_free (_vala_constraint), NULL);
		}
		if (constraint_length1) {
			*constraint_length1 = _vala_constraint_length1;
		}
		return result;
	}
	_tmp5_ = entry;
	_tmp7_ = gee_collection_to_array ((GeeCollection*) _tmp5_, &_tmp6_);
	_vala_constraint = (g_free (_vala_constraint), NULL);
	_vala_constraint = _tmp7_;
	_vala_constraint_length1 = _tmp6_;
	result = TRUE;
	_g_object_unref0 (entry);
	if (constraint) {
		*constraint = _vala_constraint;
	} else {
		_vala_constraint = (g_free (_vala_constraint), NULL);
	}
	if (constraint_length1) {
		*constraint_length1 = _vala_constraint_length1;
	}
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_user_sentence_dictionary_real_lookup_phrase (KkcSentenceDictionary* base, gchar** input, int input_length1, gchar*** phrase, int* phrase_length1) {
	KkcUserSentenceDictionary * self;
	gchar** _vala_phrase = NULL;
	int _vala_phrase_length1 = 0;
	gboolean result = FALSE;
	gchar* _input = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar* _tmp1_ = NULL;
	GeeList* entry = NULL;
	GeeMap* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	GeeList* _tmp5_ = NULL;
	GeeList* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gpointer* _tmp9_ = NULL;
	self = (KkcUserSentenceDictionary*) base;
	_tmp0_ = input;
	_tmp0__length1 = input_length1;
	_tmp1_ = _vala_g_strjoinv (" ", _tmp0_, _tmp0__length1);
	_input = _tmp1_;
	_tmp2_ = self->priv->phrase_entries;
	_tmp3_ = _input;
	_tmp4_ = gee_map_get (_tmp2_, _tmp3_);
	entry = (GeeList*) _tmp4_;
	_tmp5_ = entry;
	if (_tmp5_ == NULL) {
		gchar** _tmp6_ = NULL;
		_tmp6_ = g_new0 (gchar*, 0 + 1);
		_vala_phrase = (_vala_array_free (_vala_phrase, _vala_phrase_length1, (GDestroyNotify) g_free), NULL);
		_vala_phrase = _tmp6_;
		_vala_phrase_length1 = 0;
		result = FALSE;
		_g_object_unref0 (entry);
		_g_free0 (_input);
		if (phrase) {
			*phrase = _vala_phrase;
		} else {
			_vala_phrase = (_vala_array_free (_vala_phrase, _vala_phrase_length1, (GDestroyNotify) g_free), NULL);
		}
		if (phrase_length1) {
			*phrase_length1 = _vala_phrase_length1;
		}
		return result;
	}
	_tmp7_ = entry;
	_tmp9_ = gee_collection_to_array ((GeeCollection*) _tmp7_, &_tmp8_);
	_vala_phrase = (_vala_array_free (_vala_phrase, _vala_phrase_length1, (GDestroyNotify) g_free), NULL);
	_vala_phrase = _tmp9_;
	_vala_phrase_length1 = _tmp8_;
	result = TRUE;
	_g_object_unref0 (entry);
	_g_free0 (_input);
	if (phrase) {
		*phrase = _vala_phrase;
	} else {
		_vala_phrase = (_vala_array_free (_vala_phrase, _vala_phrase_length1, (GDestroyNotify) g_free), NULL);
	}
	if (phrase_length1) {
		*phrase_length1 = _vala_phrase_length1;
	}
	return result;
}


/**
         * {@inheritDoc}
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean kkc_user_sentence_dictionary_real_select_segments (KkcSentenceDictionary* base, KkcSegment** segments, int segments_length1) {
	KkcUserSentenceDictionary * self;
	gboolean result = FALSE;
	gint offset = 0;
	GeeArrayList* input = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* constraint = NULL;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* phrase = NULL;
	GeeArrayList* _tmp2_ = NULL;
	KkcSegment** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp21_ = 0;
	GeeArrayList* _tmp22_ = NULL;
	gchar** array = NULL;
	GeeArrayList* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gpointer* _tmp25_ = NULL;
	gint array_length1 = 0;
	gint _array_size_ = 0;
	gint _tmp26_ = 0;
	GeeMap* _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	GeeArrayList* _tmp31_ = NULL;
	GeeMap* _tmp32_ = NULL;
	gchar** _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GeeArrayList* _tmp36_ = NULL;
	self = (KkcUserSentenceDictionary*) base;
	offset = 0;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	input = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	constraint = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	phrase = _tmp2_;
	_tmp3_ = segments;
	_tmp3__length1 = segments_length1;
	{
		KkcSegment** segment_collection = NULL;
		gint segment_collection_length1 = 0;
		gint _segment_collection_size_ = 0;
		gint segment_it = 0;
		segment_collection = _tmp3_;
		segment_collection_length1 = _tmp3__length1;
		for (segment_it = 0; segment_it < _tmp3__length1; segment_it = segment_it + 1) {
			KkcSegment* _tmp4_ = NULL;
			KkcSegment* segment = NULL;
			_tmp4_ = _g_object_ref0 (segment_collection[segment_it]);
			segment = _tmp4_;
			{
				gint count = 0;
				KkcSegment* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				GeeArrayList* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				GeeArrayList* _tmp13_ = NULL;
				KkcSegment* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				GeeArrayList* _tmp17_ = NULL;
				KkcSegment* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				_tmp5_ = segment;
				_tmp6_ = kkc_segment_get_input (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_utf8_strlen (_tmp7_, (gssize) (-1));
				count = _tmp8_;
				_tmp9_ = offset;
				_tmp10_ = count;
				offset = _tmp9_ + _tmp10_;
				_tmp11_ = constraint;
				_tmp12_ = offset;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, (gpointer) ((gintptr) _tmp12_));
				_tmp13_ = phrase;
				_tmp14_ = segment;
				_tmp15_ = kkc_segment_get_output (_tmp14_);
				_tmp16_ = _tmp15_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp16_);
				_tmp17_ = input;
				_tmp18_ = segment;
				_tmp19_ = kkc_segment_get_input (_tmp18_);
				_tmp20_ = _tmp19_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp20_);
				_g_object_unref0 (segment);
			}
		}
	}
	_tmp21_ = offset;
	if (_tmp21_ < 3) {
		result = FALSE;
		_g_object_unref0 (phrase);
		_g_object_unref0 (constraint);
		_g_object_unref0 (input);
		return result;
	}
	_tmp22_ = input;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, NULL);
	_tmp23_ = input;
	_tmp25_ = gee_collection_to_array ((GeeCollection*) _tmp23_, &_tmp24_);
	array = _tmp25_;
	array_length1 = _tmp24_;
	_array_size_ = array_length1;
	array_length1 = -1;
	_tmp26_ = array_length1;
	_tmp27_ = self->priv->constraint_entries;
	_tmp28_ = array;
	_tmp28__length1 = array_length1;
	_tmp29_ = _vala_g_strjoinv ("", _tmp28_, _tmp28__length1);
	_tmp30_ = _tmp29_;
	_tmp31_ = constraint;
	gee_map_set (_tmp27_, _tmp30_, (GeeList*) _tmp31_);
	_g_free0 (_tmp30_);
	_tmp32_ = self->priv->phrase_entries;
	_tmp33_ = array;
	_tmp33__length1 = array_length1;
	_tmp34_ = _vala_g_strjoinv (" ", _tmp33_, _tmp33__length1);
	_tmp35_ = _tmp34_;
	_tmp36_ = phrase;
	gee_map_set (_tmp32_, _tmp35_, (GeeList*) _tmp36_);
	_g_free0 (_tmp35_);
	self->priv->is_dirty = TRUE;
	result = TRUE;
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (phrase);
	_g_object_unref0 (constraint);
	_g_object_unref0 (input);
	return result;
}


/**
         * Create a new UserSentenceDictionary.
         *
         * @param path a path to the file
         *
         * @return a new UserDictionary
         * @throws GLib.Error if opening the file is failed
         */
KkcUserSentenceDictionary* kkc_user_sentence_dictionary_construct (GType object_type, const gchar* path, GError** error) {
	KkcUserSentenceDictionary * self = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (KkcUserSentenceDictionary*) g_object_new (object_type, NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	if (_tmp4_) {
		kkc_dictionary_reload ((KkcDictionary*) self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		}
	}
	return self;
}


KkcUserSentenceDictionary* kkc_user_sentence_dictionary_new (const gchar* path, GError** error) {
	return kkc_user_sentence_dictionary_construct (KKC_TYPE_USER_SENTENCE_DICTIONARY, path, error);
}


static void kkc_user_sentence_dictionary_class_init (KkcUserSentenceDictionaryClass * klass) {
	kkc_user_sentence_dictionary_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcUserSentenceDictionaryPrivate));
	G_OBJECT_CLASS (klass)->finalize = kkc_user_sentence_dictionary_finalize;
}


static void kkc_user_sentence_dictionary_kkc_dictionary_interface_init (KkcDictionaryIface * iface) {
	kkc_user_sentence_dictionary_kkc_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->save = (void (*)(KkcDictionary*, GError**)) kkc_user_sentence_dictionary_real_save;
	iface->reload = (void (*)(KkcDictionary*, GError**)) kkc_user_sentence_dictionary_real_reload;
}


static void kkc_user_sentence_dictionary_kkc_sentence_dictionary_interface_init (KkcSentenceDictionaryIface * iface) {
	kkc_user_sentence_dictionary_kkc_sentence_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->lookup_constraint = (gboolean (*)(KkcSentenceDictionary*, const gchar*, gint**, int*)) kkc_user_sentence_dictionary_real_lookup_constraint;
	iface->lookup_phrase = (gboolean (*)(KkcSentenceDictionary*, gchar**, int, gchar***, int*)) kkc_user_sentence_dictionary_real_lookup_phrase;
	iface->select_segments = (gboolean (*)(KkcSentenceDictionary*, KkcSegment**, int)) kkc_user_sentence_dictionary_real_select_segments;
}


static void kkc_user_sentence_dictionary_instance_init (KkcUserSentenceDictionary * self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	self->priv = KKC_USER_SENTENCE_DICTIONARY_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->constraint_entries = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->phrase_entries = (GeeMap*) _tmp1_;
}


static void kkc_user_sentence_dictionary_finalize (GObject* obj) {
	KkcUserSentenceDictionary * self;
	GeeMapIterator* constraint_iter = NULL;
	GeeMap* _tmp0_ = NULL;
	GeeMapIterator* _tmp1_ = NULL;
	GeeMap* _tmp7_ = NULL;
	GeeMapIterator* phrase_iter = NULL;
	GeeMap* _tmp8_ = NULL;
	GeeMapIterator* _tmp9_ = NULL;
	GeeMap* _tmp15_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_USER_SENTENCE_DICTIONARY, KkcUserSentenceDictionary);
	_tmp0_ = self->priv->constraint_entries;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	constraint_iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GeeMapIterator* _tmp4_ = NULL;
		gpointer _tmp5_ = NULL;
		GeeList* _tmp6_ = NULL;
		_tmp2_ = constraint_iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = constraint_iter;
		_tmp5_ = gee_map_iterator_get_value (_tmp4_);
		_tmp6_ = (GeeList*) _tmp5_;
		gee_collection_clear ((GeeCollection*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	_tmp7_ = self->priv->constraint_entries;
	gee_map_clear (_tmp7_);
	_tmp8_ = self->priv->phrase_entries;
	_tmp9_ = gee_map_map_iterator (_tmp8_);
	phrase_iter = _tmp9_;
	while (TRUE) {
		GeeMapIterator* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		GeeMapIterator* _tmp12_ = NULL;
		gpointer _tmp13_ = NULL;
		GeeList* _tmp14_ = NULL;
		_tmp10_ = phrase_iter;
		_tmp11_ = gee_map_iterator_next (_tmp10_);
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = phrase_iter;
		_tmp13_ = gee_map_iterator_get_value (_tmp12_);
		_tmp14_ = (GeeList*) _tmp13_;
		gee_collection_clear ((GeeCollection*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = self->priv->phrase_entries;
	gee_map_clear (_tmp15_);
	_g_object_unref0 (phrase_iter);
	_g_object_unref0 (constraint_iter);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->constraint_entries);
	_g_object_unref0 (self->priv->phrase_entries);
	G_OBJECT_CLASS (kkc_user_sentence_dictionary_parent_class)->finalize (obj);
}


/**
     * File based implementation of SentenceDictionary with write access.
     */
GType kkc_user_sentence_dictionary_get_type (void) {
	static volatile gsize kkc_user_sentence_dictionary_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_user_sentence_dictionary_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcUserSentenceDictionaryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_user_sentence_dictionary_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcUserSentenceDictionary), 0, (GInstanceInitFunc) kkc_user_sentence_dictionary_instance_init, NULL };
		static const GInterfaceInfo kkc_dictionary_info = { (GInterfaceInitFunc) kkc_user_sentence_dictionary_kkc_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo kkc_sentence_dictionary_info = { (GInterfaceInitFunc) kkc_user_sentence_dictionary_kkc_sentence_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_user_sentence_dictionary_type_id;
		kkc_user_sentence_dictionary_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcUserSentenceDictionary", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_user_sentence_dictionary_type_id, KKC_TYPE_DICTIONARY, &kkc_dictionary_info);
		g_type_add_interface_static (kkc_user_sentence_dictionary_type_id, KKC_TYPE_SENTENCE_DICTIONARY, &kkc_sentence_dictionary_info);
		g_once_init_leave (&kkc_user_sentence_dictionary_type_id__volatile, kkc_user_sentence_dictionary_type_id);
	}
	return kkc_user_sentence_dictionary_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



