package org.jboss.cache.factories.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation is used for components that will be registered in the {@link org.jboss.cache.factories.ComponentRegistry},
 * that are resilient to changes in configuration.  Examples are the {@link org.jboss.cache.CacheSPI} implementation used, which does
 * not change regardless of the configuration.
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
// ensure this annotation is available at runtime.
@Retention(RetentionPolicy.RUNTIME)

// only applies to classes.
@Target(ElementType.TYPE)
public @interface NonVolatile
{
}
