/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  fontset.cc - PangoFontset C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "fontset.h"
#include "font.h"

using namespace Inti;

/*  Pango::Fontset
 */

Pango::Fontset::Fontset(PangoFontset *fontset, bool reference)
: G::Object((GObject*)fontset, reference)
{
}

Pango::Fontset::~Fontset()
{
}

Pango::Fontset::operator PangoFontset* () const
{
	return this ? pango_fontset() : 0;
}

Pointer<Pango::Font>
Pango::Fontset::get_font(unsigned int wc) const
{
	return G::Object::wrap<Font>(pango_fontset_get_font(pango_fontset(), wc), true);
}

Pointer<Pango::FontMetrics>
Pango::Fontset::get_metrics() const
{
	return G::Boxed::wrap<FontMetrics>(PANGO_TYPE_FONT_METRICS, pango_fontset_get_metrics(pango_fontset()), false);
}

