/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  stock.cc - GtkStockItem C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "stock.h"
#include "accelgroup.h"
#include <glib/gstrfuncs.h>

using namespace Inti;


/*  Gtk::StockItem
 */

Gtk::StockItem::StockItem()
{
	item_.stock_id = 0;
	item_.label = 0;
	item_.modifier = (GdkModifierType)0;
	item_.keyval = 0;
	item_.translation_domain = 0;
}

const char*
Gtk::StockItem::stock_id() const
{
	return item_.stock_id;
}

const char*
Gtk::StockItem::label() const
{
	return item_.label;
}

Gdk::ModifierTypeField
Gtk::StockItem::modifier() const
{
	return (Gdk::ModifierTypeField)item_.modifier;
}

unsigned int
Gtk::StockItem::keyval() const
{
	return item_.keyval;
}

const char*
Gtk::StockItem::translation_domain() const
{
	return item_.translation_domain;
}

Gtk::AccelKey
Gtk::StockItem::accel_key() const
{
	return AccelKey(keyval(), modifier());
}

/*  Gtk::Stock
 */

void
Gtk::Stock::add(const char *stock_id, const char *label)
{
	add(stock_id, label, 0, 0, 0);
}

void
Gtk::Stock::add(const char *stock_id, const char *label, Gdk::ModifierTypeField modifier, unsigned int key)
{
	add(stock_id, label, modifier, key, 0);
}


void
Gtk::Stock::add(const char *stock_id, const char *label, Gdk::ModifierTypeField modifier, unsigned int key, const char *domain)
{
	GtkStockItem *item = g_new(GtkStockItem, 1);
	item->stock_id = g_strdup(stock_id);
	item->label = g_strdup(label);
	item->modifier = (GdkModifierType)modifier;
	item->keyval = key;
	item->translation_domain = g_strdup(domain);
	gtk_stock_add(item, 1);
	gtk_stock_item_free(item);
}

bool
Gtk::Stock::lookup(const char *stock_id, StockItem& item)
{
	return gtk_stock_lookup(stock_id, item.gtk_stock_item());
}

std::vector<String>
Gtk::Stock::list_ids()
{
	std::vector<String> ids;
	GSList *first = gtk_stock_list_ids();
	GSList *next = first;

	while (next)
	{
		char *stock_id = (char*)next->data;
		ids.push_back(stock_id);
		g_free(stock_id);
		next = g_slist_next(next);
	}

	g_slist_free(first);
	return ids;
};

