/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  ruler.cc - GtkRuler, GtkHRuler and GtkVRuler C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "ruler.h"
#include "private/ruler_p.h"

using namespace Inti;

/*  Gtk::Ruler
 */

Gtk::Ruler::Ruler(GtkRuler *ruler, bool reference)
: Widget((GtkWidget*)ruler, reference)
{
}
	
Gtk::Ruler::Ruler()
: Widget((GtkWidget*)RulerClass::create())
{
}

Gtk::Ruler::~Ruler()
{
}

GtkRulerClass*
Gtk::Ruler::gtk_ruler_class() const 
{ 
	return get_class<GtkRulerClass>();
}
	
Gtk::Ruler::operator GtkRuler* () const 
{ 
	return this ? gtk_ruler() : 0; 
}
	
Gtk::MetricType
Gtk::Ruler::get_metric() const
{
	return (MetricType)gtk_ruler_get_metric(gtk_ruler());
}

double
Gtk::Ruler::get_lower() const
{
	return gtk_ruler()->lower;
}

double
Gtk::Ruler::get_upper() const
{
	return gtk_ruler()->upper;
}

double 
Gtk::Ruler::get_position() const
{
	return gtk_ruler()->position;
}

void 
Gtk::Ruler::get_range(double *lower, double *upper, double *position, double *max_size)
{
	gtk_ruler_get_range(gtk_ruler(), lower, upper, position, max_size);
}

void 
Gtk::Ruler::set_metric(MetricType metric)
{
	gtk_ruler_set_metric(gtk_ruler(), (GtkMetricType)metric);
}

void 
Gtk::Ruler::set_range(double lower, double upper, double position, double max_size)
{
	gtk_ruler_set_range(gtk_ruler(), lower, upper, position, max_size);
}

void 
Gtk::Ruler::draw_ticks()
{
	gtk_ruler_draw_ticks(gtk_ruler());
}

void 
Gtk::Ruler::draw_pos()
{
	gtk_ruler_draw_pos(gtk_ruler());
}

/*  Gtk::RulerClass
 */

void
Gtk::RulerClass::init(GtkRulerClass *g_class)
{
	WidgetClass::init((GtkWidgetClass*)g_class);
	g_class->draw_ticks = &draw_ticks_proxy;
	g_class->draw_pos = &draw_pos_proxy;
}

GType
Gtk::RulerClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_RULER, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::RulerClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::RulerClass::draw_ticks_proxy(GtkRuler *ruler)
{
	Ruler *tmp_ruler = G::Object::pointer<Ruler>(ruler);
	if (tmp_ruler)
		tmp_ruler->do_draw_ticks();
	else
	{
		GtkRulerClass *g_class = G::TypeInstance::class_peek_parent<GtkRulerClass>(GTK_RULER_GET_CLASS(ruler));
		if (g_class->draw_ticks)
			g_class->draw_ticks(ruler);
	}
}

void
Gtk::RulerClass::draw_pos_proxy(GtkRuler *ruler)
{
	Ruler *tmp_ruler = G::Object::pointer<Ruler>(ruler);
	if (tmp_ruler)
		tmp_ruler->do_draw_pos();
	else
	{
		GtkRulerClass *g_class = G::TypeInstance::class_peek_parent<GtkRulerClass>(GTK_RULER_GET_CLASS(ruler));
		if (g_class->draw_pos)
			g_class->draw_pos(ruler);
	}
}

/*  Gtk::Ruler Overridable methods
 */

void
Gtk::Ruler::do_draw_ticks()
{
	GtkRulerClass *g_class = class_peek_parent<GtkRulerClass>(gtk_ruler_class());
	if (g_class->draw_ticks)
		g_class->draw_ticks(gtk_ruler());
}

void
Gtk::Ruler::do_draw_pos()
{
	GtkRulerClass *g_class = class_peek_parent<GtkRulerClass>(gtk_ruler_class());
	if (g_class->draw_pos)
		g_class->draw_pos(gtk_ruler());
}

/*  Gtk::Ruler properties
 */

const Gtk::Ruler::LowerPropertyType Gtk::Ruler::lower_property("lower");

const Gtk::Ruler::UpperPropertyType Gtk::Ruler::upper_property("upper");

const Gtk::Ruler::PositionPropertyType Gtk::Ruler::position_property("position");

const Gtk::Ruler::MaxSizePropertyType Gtk::Ruler::max_size_property("max_size");

/*  Gtk::HRuler
 */

Gtk::HRuler::HRuler(GtkHRuler *hruler, bool reference)
: Ruler((GtkRuler*)hruler, reference)
{
}
	
Gtk::HRuler::	HRuler()
: Ruler((GtkRuler*)gtk_hruler_new())
{
}
	
Gtk::HRuler::~HRuler()
{
}
	
GtkHRulerClass* 
Gtk::HRuler::gtk_hruler_class() const 
{ 
	return get_class<GtkHRulerClass>(); 
}
	
Gtk::HRuler::operator GtkHRuler* () const 
{ 
	return this ? gtk_hruler() : 0; 
}
	
/*  Gtk::HRulerClass
 */

void
Gtk::HRulerClass::init(GtkHRulerClass *g_class)
{
	RulerClass::init((GtkRulerClass*)g_class);
}

GType
Gtk::HRulerClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_HRULER, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::HRulerClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::VRuler
 */

Gtk::VRuler::VRuler(GtkVRuler *vruler, bool reference)
: Ruler((GtkRuler*)vruler, reference)
{
}
	
Gtk::VRuler::VRuler()
: Ruler((GtkRuler*)gtk_vruler_new())
{
}

Gtk::VRuler::~VRuler() 
{
}
	
GtkVRulerClass* 
Gtk::VRuler::gtk_vruler_class() const 
{ 
	return get_class<GtkVRulerClass>();
}
	
Gtk::VRuler::operator GtkVRuler* () const 
{ 
	return this ? gtk_vruler() : 0; 
}
	
/*  Gtk::VRulerClass
 */

void
Gtk::VRulerClass::init(GtkVRulerClass *g_class)
{
	RulerClass::init((GtkRulerClass*)g_class);
}

GType
Gtk::VRulerClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_VRULER, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::VRulerClass::create()
{
	return g_object_new(get_type(), 0);
}

