/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  cellrenderer_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GTK_CELL_RENDERER_CLASS_H
#define INTI_GTK_CELL_RENDERER_CLASS_H

#include <inti/gtk/private/object_p.h>

namespace Inti {

namespace Gtk {

/*  CellRendererClass
 */

class CellRendererClass
{
public:
	static void init(GtkCellRendererClass *g_class);

	static GType get_type();

	static void* create();

	static void get_size_proxy(GtkCellRenderer *cell, GtkWidget *widget, GdkRectangle *cell_area,
	                           gint *x_offset, gint *y_offset, gint *width,  gint *height);

	static void render_proxy(GtkCellRenderer *cell, GdkWindow *window, GtkWidget *widget, GdkRectangle *background_area,
	                         GdkRectangle *cell_area, GdkRectangle *expose_area, GtkCellRendererState flags);

	static gboolean activate_proxy(GtkCellRenderer *cell, GdkEvent *event, GtkWidget *widget, const gchar *path,
	                               GdkRectangle *background_area, GdkRectangle *cell_area, GtkCellRendererState flags);

	static GtkCellEditable* start_editing_proxy(GtkCellRenderer *cell, GdkEvent *event, GtkWidget *widget, const gchar *path,
	                                            GdkRectangle *background_area, GdkRectangle *cell_area, GtkCellRendererState flags);
};

/*  CellRendererPixbufClass
 */

class CellRendererPixbufClass
{
public:
	static void init(GtkCellRendererPixbufClass *g_class);

	static GType get_type();

	static void* create();
};

/*  CellRendererTextClass
 */

class CellRendererTextClass
{
public:
	static void init(GtkCellRendererTextClass *g_class);

	static GType get_type();

	static void* create();

	static void edited_proxy(GtkCellRendererText *cell_renderer_text, const gchar *path, const gchar *new_text);
};

/*  CellRendererToggleClass
 */

class CellRendererToggleClass
{
public:
	static void init(GtkCellRendererToggleClass *g_class);

	static GType get_type();

	static void* create();

	static void toggled_proxy(GtkCellRendererToggle *cell_renderer_toggle, const gchar *path);
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_CELL_RENDERER_CLASS_H
