/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  paned.cc - GtkPaned, GtkHPaned and GtkVPaned C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "paned.h"
#include "private/paned_p.h"
#include "../gdk/window.h"

using namespace Inti;

/*  Gtk::Paned
 */

Gtk::Paned::Paned(GtkPaned *paned, bool reference)
: Container((GtkContainer*)paned, reference)
{
}

Gtk::Paned::Paned()
: Container((GtkContainer*)PanedClass::create())
{
}

Gtk::Paned::~Paned()
{
}

GtkPanedClass*
Gtk::Paned::gtk_paned_class() const 
{ 
	return get_class<GtkPanedClass>(); 
}
	
Gtk::Paned::operator GtkPaned* () const 
{ 
	return this ? gtk_paned() : 0; 
}
	
Gtk::Widget*
Gtk::Paned::child1() const
{
	return G::Object::wrap<Widget>(gtk_paned()->child1);
}

Gtk::Widget*
Gtk::Paned::child2() const
{
	return G::Object::wrap<Widget>(gtk_paned()->child2);
}

Gdk::Window*
Gtk::Paned::handle() const
{
	return G::Object::wrap<Gdk::Window>(gtk_paned()->handle);
}

int
Gtk::Paned::get_position() const
{
	return gtk_paned_get_position(gtk_paned());
}

void 
Gtk::Paned::add1(Widget& child)
{
	gtk_paned_add1(gtk_paned(), child.gtk_widget());
}

void 
Gtk::Paned::add2(Widget& child)
{
	gtk_paned_add2(gtk_paned(), child.gtk_widget());
}


void 
Gtk::Paned::pack1(Widget& child, bool resize, bool shrink)
{
	gtk_paned_pack1(gtk_paned(), child.gtk_widget(), resize, shrink);
}

void 
Gtk::Paned::pack2(Widget& child, bool resize, bool shrink)
{
	gtk_paned_pack2(gtk_paned(), child.gtk_widget(), resize, shrink);
}

void 
Gtk::Paned::set_position(int position)
{
	gtk_paned_set_position(gtk_paned(), position);
}

/*  Gtk::PanedClass
 */

void
Gtk::PanedClass::init(GtkPanedClass *g_class)
{
	ContainerClass::init((GtkContainerClass*)g_class);
}

GType
Gtk::PanedClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_PANED, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::PanedClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::Paned properties
 */

const Gtk::Paned::PositionPropertyType Gtk::Paned::position_property("position");

const Gtk::Paned::PositionSetPropertyType Gtk::Paned::position_set_property("position_set");

/*  Gtk::HPaned
 */

Gtk::HPaned::HPaned(GtkHPaned *hpaned, bool reference)
: Paned((GtkPaned*)hpaned, reference)
{
}

Gtk::HPaned::HPaned()
: Paned((GtkPaned*)HPanedClass::create())
{
}

Gtk::HPaned::~HPaned()
{
}

GtkHPanedClass* 
Gtk::HPaned::gtk_hpaned_class() const 
{ 
	return get_class<GtkHPanedClass>(); 
}
	
Gtk::HPaned::operator GtkHPaned* () const 
{ 
	return this ? gtk_hpaned() : 0;
}
	
/*  Gtk::HPanedClass
 */

void
Gtk::HPanedClass::init(GtkHPanedClass *g_class)
{
	PanedClass::init((GtkPanedClass*)g_class);
}

GType
Gtk::HPanedClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_HPANED, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::HPanedClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::VPaned
 */

Gtk::VPaned::VPaned(GtkVPaned *vpaned, bool reference)
: Paned((GtkPaned*)vpaned, reference)
{
}

Gtk::VPaned::VPaned() 
: Paned((GtkPaned*)VPanedClass::create())
{
}

Gtk::VPaned::~VPaned()
{
}

GtkVPanedClass* 
Gtk::VPaned::gtk_vpaned_class() const 
{ 
	return get_class<GtkVPanedClass>(); 
}
	
Gtk::VPaned::operator GtkVPaned* () const 
{ 
	return this ? gtk_vpaned() : 0; 
}
	
/*  Gtk::VPanedClass
 */

void
Gtk::VPanedClass::init(GtkVPanedClass *g_class)
{
	PanedClass::init((GtkPanedClass*)g_class);
}

GType
Gtk::VPanedClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_VPANED, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::VPanedClass::create()
{
	return g_object_new(get_type(), 0);
}

