/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  label.cc - GtkLabel C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "label.h"
#include "private/label_p.h"
#include "menu.h"
#include "../pango/attributes.h"
#include "../pango/layout.h"

using namespace Inti;

/*  Gtk::Label
 */

Gtk::Label::Label(GtkLabel* label, bool reference)
: Misc((GtkMisc*)label, reference)
{
}

Gtk::Label::Label()
: Misc((GtkMisc*)LabelClass::create())
{
}

Gtk::Label::Label(const String& str, bool use_underline)
: Misc((GtkMisc*)LabelClass::create())
{
	set_text(str);
	set_use_underline(use_underline);
}

Gtk::Label::~Label()
{
}

GtkLabelClass*
Gtk::Label::gtk_label_class() const 
{ 
	return get_class<GtkLabelClass>(); 
}
	
Gtk::Label::operator GtkLabel* () const 
{ 
	return this ? gtk_label() : 0;
}
	
String 
Gtk::Label::get_text() const
{
	return gtk_label_get_text(gtk_label());
}

Pointer<Pango::AttrList>
Gtk::Label::get_attributes() const
{
	return G::Boxed::wrap<Pango::AttrList>(PANGO_TYPE_ATTR_LIST, gtk_label_get_attributes(gtk_label()));
}

String 
Gtk::Label::get_label() const
{
	return gtk_label_get_label(gtk_label());
}

bool 
Gtk::Label::get_use_markup() const
{
	return gtk_label_get_use_markup(gtk_label());
}

bool 
Gtk::Label::get_use_underline() const
{
	return gtk_label_get_use_underline(gtk_label());
}

unsigned int
Gtk::Label::get_mnemonic_keyval() const
{
	return gtk_label_get_mnemonic_keyval(gtk_label());
}

Gtk::Widget*
Gtk::Label::get_mnemonic_widget () const
{
	return G::Object::wrap<Widget>(gtk_label_get_mnemonic_widget(gtk_label()));
}

Gtk::Justification
Gtk::Label::get_justify() const
{
	return (Justification)gtk_label_get_justify(gtk_label());
}

bool 
Gtk::Label::get_line_wrap() const
{
	return gtk_label_get_line_wrap(gtk_label());
}

bool 
Gtk::Label::get_selectable() const
{
	return gtk_label_get_selectable(gtk_label());
}

void
Gtk::Label::get_layout_offsets(int *x, int *y) const
{
	gtk_label_get_layout_offsets(gtk_label(), x, y);
}

bool 
Gtk::Label::get_selection_bounds(int *start, int *end) const
{
	return gtk_label_get_selection_bounds(gtk_label(), start, end);
}

Pango::Layout*
Gtk::Label::get_layout() const
{
	return G::Object::wrap<Pango::Layout>(gtk_label_get_layout(gtk_label()));
}

void
Gtk::Label::set_text(const String& str)
{
	gtk_label_set_text(gtk_label(), str.c_str());
}

void 
Gtk::Label::set_attributes(Pango::AttrList& attrs)
{
	gtk_label_set_attributes(gtk_label(), attrs.pango_attr_list());
}

void 
Gtk::Label::set_markup(const String& str)
{
	gtk_label_set_markup(gtk_label(), str.c_str());
}

void 
Gtk::Label::set_label(const String& str)
{
	gtk_label_set_label(gtk_label(), str.c_str());
}

void
Gtk::Label::set_markup_with_mnemonic(const String& str)
{
	gtk_label_set_markup_with_mnemonic(gtk_label(), str.c_str());
}
                                            
void 
Gtk::Label::set_mnemonic_widget(Widget *widget)
{
	gtk_label_set_mnemonic_widget(gtk_label(), *widget);
}

void 
Gtk::Label::set_text_with_mnemonic(const String& str)
{
	gtk_label_set_text_with_mnemonic(gtk_label(), str.c_str());
}

void 
Gtk::Label::set_justify(Justification jtype)
{
	gtk_label_set_justify(gtk_label(), (GtkJustification)jtype);
}

void
Gtk::Label::set_pattern(const String& pattern)
{
	gtk_label_set_pattern(gtk_label(), pattern.c_str());
}

void
Gtk::Label::set_line_wrap(bool wrap)
{
	gtk_label_set_line_wrap(gtk_label(), wrap);
}

void
Gtk::Label::set_selectable(bool setting)
{
	gtk_label_set_selectable(gtk_label(), setting);
}

void 
Gtk::Label::select_region(int start_offset, int end_offset)
{
	gtk_label_select_region(gtk_label(), start_offset, end_offset);
}

void 
Gtk::Label::set_use_markup(bool setting)
{
	gtk_label_set_use_markup(gtk_label(), setting);
}

void 
Gtk::Label::set_use_underline(bool setting)
{
	gtk_label_set_use_underline(gtk_label(), setting);
}

/*  Gtk::LabelClass
 */

void
Gtk::LabelClass::init(GtkLabelClass *g_class)
{
	MiscClass::init((GtkMiscClass*)g_class);
	g_class->move_cursor = &move_cursor_proxy;
	g_class->copy_clipboard = &copy_clipboard_proxy;
	g_class->populate_popup = &populate_popup_proxy;
}

GType
Gtk::LabelClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_LABEL, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::LabelClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::LabelClass::move_cursor_proxy(GtkLabel *label, GtkMovementStep step, gint count, gboolean extend_selection)
{
	Label *tmp_label = G::Object::pointer<Label>(label);
	if (tmp_label)
		tmp_label->on_move_cursor((MovementStep)step, count, extend_selection);
	else
	{
		GtkLabelClass *g_class = G::TypeInstance::class_peek_parent<GtkLabelClass>(GTK_LABEL_GET_CLASS(label));
		if (g_class->move_cursor)
			g_class->move_cursor(label, step, count, extend_selection);
	}
}

void
Gtk::LabelClass::copy_clipboard_proxy(GtkLabel *label)
{
	Label *tmp_label = G::Object::pointer<Label>(label);
	if (tmp_label)
		tmp_label->on_copy_clipboard();
	else
	{
		GtkLabelClass *g_class = G::TypeInstance::class_peek_parent<GtkLabelClass>(GTK_LABEL_GET_CLASS(label));
		if (g_class->copy_clipboard)
			g_class->copy_clipboard(label);
	}
}

void
Gtk::LabelClass::populate_popup_proxy(GtkLabel *label, GtkMenu *menu)
{
	Label *tmp_label = G::Object::pointer<Label>(label);
	if (tmp_label)
		tmp_label->on_populate_popup(*G::Object::wrap<Gtk::Menu>(menu));
	else
	{
		GtkLabelClass *g_class = G::TypeInstance::class_peek_parent<GtkLabelClass>(GTK_LABEL_GET_CLASS(label));
		if (g_class->populate_popup)
			g_class->populate_popup(label, menu);
	}
}

/*  Signal handlers
 */

void
Gtk::Label::on_move_cursor(MovementStep step, int count, bool extend_selection)
{
	GtkLabelClass *g_class = class_peek_parent<GtkLabelClass>(gtk_label_class());
	if (g_class->move_cursor)
		g_class->move_cursor(gtk_label(), (GtkMovementStep)step, count, extend_selection);
}

void
Gtk::Label::on_copy_clipboard()
{
	GtkLabelClass *g_class = class_peek_parent<GtkLabelClass>(gtk_label_class());
	if (g_class->copy_clipboard)
		g_class->copy_clipboard(gtk_label());
}

void
Gtk::Label::on_populate_popup(Menu& menu)
{
	GtkLabelClass *g_class = class_peek_parent<GtkLabelClass>(gtk_label_class());
	if (g_class->populate_popup)
		g_class->populate_popup(gtk_label(), menu.gtk_menu());
}

/*  Properties
 */

const Gtk::Label::LabelPropertyType Gtk::Label::label_property("label");

const Gtk::Label::AttributesPropertyType Gtk::Label::attributes_property("attributes");

const Gtk::Label::UseMarkupPropertyType Gtk::Label::use_markup_property("use_markup");

const Gtk::Label::UseUnderlinePropertyType Gtk::Label::use_underline_property("use_underline");

const Gtk::Label::JustifyPropertyType Gtk::Label::justify_property("justify");

const Gtk::Label::PatternPropertyType Gtk::Label::pattern_property("pattern");

const Gtk::Label::WrapPropertyType Gtk::Label::wrap_property("wrap");

const Gtk::Label::SelectablePropertyType Gtk::Label::selectable_property("selectable");

const Gtk::Label::MnemonicKeyvalPropertyType Gtk::Label::mnemonic_keyval_property("mnemonic_keyval");

const Gtk::Label::MnemonicWidgetPropertyType Gtk::Label::mnemonic_widget_property("mnemonic_widget");

const Gtk::Label::CursorPositionPropertyType Gtk::Label::cursor_position_property("cursor_position");

const Gtk::Label::SelectionBoundPropertyType Gtk::Label::selection_bound_property("selection_bound");

/*  Signals
 */

const Gtk::Label::MoveCursorSignalType Gtk::Label::move_cursor_signal("move_cursor");

const Gtk::Label::CopyClipboardSignalType Gtk::Label::copy_clipboard_signal("copy_clipboard");

const Gtk::Label::PopulatePopupSignalType Gtk::Label::populate_popup_signal("populate_popup");

