/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  frame.cc - GtkFrame C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "frame.h"
#include "private/frame_p.h"
#include <gtk/gtklabel.h>

using namespace Inti;

/*  Gtk::Frame
 */

Gtk::Frame::Frame(GtkFrame *frame, bool reference)
: Bin((GtkBin*)frame, reference)
{
}

Gtk::Frame::Frame(ShadowType type)
: Bin((GtkBin*)FrameClass::create())
{
	set_shadow_type(type);
}

Gtk::Frame::Frame(const String& label, ShadowType type)
: Bin((GtkBin*)FrameClass::create())
{
	set_label(label);
	set_shadow_type(type);
}

Gtk::Frame::~Frame()
{
}

GtkFrameClass* 
Gtk::Frame::gtk_frame_class() const 
{ 
	return get_class<GtkFrameClass>(); 
}
	
Gtk::Frame::operator GtkFrame* () const 
{ 
	return this ? gtk_frame() : 0; 
}
	
String 
Gtk::Frame::get_label() const
{
	return gtk_frame_get_label(gtk_frame());
}

Gtk::Widget*
Gtk::Frame::get_label_widget() const
{
	return G::Object::wrap<Widget>(gtk_frame_get_label_widget(gtk_frame()));
}

void 
Gtk::Frame::get_label_align(float *xalign, float *yalign) const
{
	return gtk_frame_get_label_align(gtk_frame(), xalign, yalign);
}

Gtk::ShadowType
Gtk::Frame::get_shadow_type() const
{
	return (ShadowType)gtk_frame_get_shadow_type(gtk_frame());
}

void
Gtk::Frame::remove_label()
{
	gtk_frame_set_label(gtk_frame(), 0);
}

void
Gtk::Frame::set_label(const String& label)
{
	gtk_frame_set_label(gtk_frame(), label.c_str());
}

void
Gtk::Frame::set_label_widget(Widget& label_widget)
{
	gtk_frame_set_label_widget(gtk_frame(), label_widget.gtk_widget());
}

void 
Gtk::Frame::set_label_align(float xalign, float yalign)
{
	gtk_frame_set_label_align(gtk_frame(), xalign, yalign);
}

void 
Gtk::Frame::set_shadow_type(ShadowType type)
{
	gtk_frame_set_shadow_type(gtk_frame(), (GtkShadowType)type);
}

/*  Gtk::FrameClass
 */

void
Gtk::FrameClass::init(GtkFrameClass *g_class)
{
	BinClass::init((GtkBinClass*)g_class);
	g_class->compute_child_allocation = &compute_child_allocation_proxy;
}

GType
Gtk::FrameClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_FRAME, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::FrameClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::FrameClass::compute_child_allocation_proxy(GtkFrame *frame, GtkAllocation *allocation)
{
	Frame *tmp_frame = G::Object::pointer<Frame>(frame);
	if (tmp_frame)
		tmp_frame->do_compute_child_allocation(allocation);
	else
	{
		GtkFrameClass *g_class = G::TypeInstance::class_peek_parent<GtkFrameClass>(GTK_FRAME_GET_CLASS(allocation));
		if (g_class->compute_child_allocation)
			g_class->compute_child_allocation(frame, allocation);
	}
}

/*  Overridable methods
 */

void
Gtk::Frame::do_compute_child_allocation(GtkAllocation *allocation)
{
	GtkFrameClass *g_class = class_peek_parent<GtkFrameClass>(gtk_frame_class());
	if (g_class->compute_child_allocation)
		g_class->compute_child_allocation(gtk_frame(), allocation);
}

/*  Properties
 */

const Gtk::Frame::LabelPropertyType Gtk::Frame::label_property("label");

const Gtk::Frame::LabelXalignPropertyType Gtk::Frame::label_xalign_property("label_xalign");

const Gtk::Frame::LabelYalignPropertyType Gtk::Frame::label_yalign_property("label_yalign");

const Gtk::Frame::ShadowTypePropertyType Gtk::Frame::shadow_type_property("shadow_type");

const Gtk::Frame::LabelWidgetPropertyType Gtk::Frame::label_widget_property("label_widget");

