/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  checkmenuitem.cc - GtkCheckMenuItem C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "checkmenuitem.h"
#include "private/checkmenuitem_p.h"

using namespace Inti;

Gtk::CheckMenuItem::CheckMenuItem(GtkCheckMenuItem *check_menu_item, bool reference)
: MenuItem((GtkMenuItem*)check_menu_item, reference)
{
}

Gtk::CheckMenuItem::CheckMenuItem()
: MenuItem((GtkMenuItem*)CheckMenuItemClass::create())
{
}

Gtk::CheckMenuItem::CheckMenuItem(const String& label, bool use_underline)
: MenuItem((GtkMenuItem*)CheckMenuItemClass::create())
{
	add_label(label, use_underline);
}

Gtk::CheckMenuItem::~CheckMenuItem()
{
}

GtkCheckMenuItemClass*
Gtk::CheckMenuItem::gtk_check_menu_item_class() const 
{ 
	return get_class<GtkCheckMenuItemClass>(); 
}
	
Gtk::CheckMenuItem::operator GtkCheckMenuItem* () const 
{ 
	return this ? gtk_check_menu_item() : 0; 
}
	
bool
Gtk::CheckMenuItem::get_active() const
{
	return gtk_check_menu_item_get_active(gtk_check_menu_item());
}

bool
Gtk::CheckMenuItem::get_inconsistent() const
{
	return gtk_check_menu_item_get_inconsistent(gtk_check_menu_item());
}

void
Gtk::CheckMenuItem::set_active(bool is_active)
{
	gtk_check_menu_item_set_active(gtk_check_menu_item(), is_active);
}

void
Gtk::CheckMenuItem::set_inconsistent(bool setting)
{
	gtk_check_menu_item_set_inconsistent(gtk_check_menu_item(), setting);
}

void
Gtk::CheckMenuItem::toggled()
{
	gtk_check_menu_item_toggled(gtk_check_menu_item());
}

/*  Gtk::CheckMenuItemClass
 */

void
Gtk::CheckMenuItemClass::init(GtkCheckMenuItemClass *g_class)
{
	MenuItemClass::init((GtkMenuItemClass*)g_class);
	g_class->draw_indicator = &draw_indicator_proxy;	
	g_class->toggled = &toggled_proxy;
}

GType
Gtk::CheckMenuItemClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CHECK_MENU_ITEM, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::CheckMenuItemClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CheckMenuItemClass::draw_indicator_proxy(GtkCheckMenuItem *check_menu_item, GdkRectangle *area)
{
	CheckMenuItem *tmp_check_menu_item = G::Object::pointer<CheckMenuItem>(check_menu_item);
	if (tmp_check_menu_item)
		tmp_check_menu_item->do_draw_indicator(area);
	else
	{
		GtkCheckMenuItemClass *tmp_class = GTK_CHECK_MENU_ITEM_GET_CLASS(check_menu_item);
		GtkCheckMenuItemClass *g_class = G::TypeInstance::class_peek_parent<GtkCheckMenuItemClass>(tmp_class);
		if (g_class->draw_indicator)
			g_class->draw_indicator(check_menu_item, area);
	}
}

void
Gtk::CheckMenuItemClass::toggled_proxy(GtkCheckMenuItem *check_menu_item)
{
	CheckMenuItem *tmp_check_menu_item = G::Object::pointer<CheckMenuItem>(check_menu_item);
	if (tmp_check_menu_item)
		tmp_check_menu_item->on_toggled();
	else
	{
		GtkCheckMenuItemClass *tmp_class = GTK_CHECK_MENU_ITEM_GET_CLASS(check_menu_item);
		GtkCheckMenuItemClass *g_class = G::TypeInstance::class_peek_parent<GtkCheckMenuItemClass>(tmp_class);
		if (g_class->toggled)
			g_class->toggled(check_menu_item);
	}
}

/*  Overridable methods
 */

void
Gtk::CheckMenuItem::do_draw_indicator(GdkRectangle *area)
{
	GtkCheckMenuItemClass *g_class = class_peek_parent<GtkCheckMenuItemClass>(gtk_check_menu_item_class());
	if (g_class->draw_indicator)
		g_class->draw_indicator(gtk_check_menu_item(), area);
}

/*  Signal handlers
 */

void
Gtk::CheckMenuItem::on_toggled()
{
	GtkCheckMenuItemClass *g_class = class_peek_parent<GtkCheckMenuItemClass>(gtk_check_menu_item_class());
	if (g_class->toggled)
		g_class->toggled(gtk_check_menu_item());
}

/*  Properties
 */

const Gtk::CheckMenuItem::ActivePropertyType Gtk::CheckMenuItem::active_property("active");

const Gtk::CheckMenuItem::InconsistentPropertyType Gtk::CheckMenuItem::inconsistent_property("inconsistent");

/*  Signals
 */

const Gtk::CheckMenuItem::ToggledSignalType Gtk::CheckMenuItem::toggled_signal("toggled");


