/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  input.cc - GdkDevice C++ wrapper interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "input.h"
#include "display.h"
#include "window.h"

using namespace Inti;

/*  Gdk::devices_list
 */
 
bool 
Gdk::devices_list(std::vector<Device*>& devices)
{
	Display *display = Display::get_default();
	return display->list_devices(devices);
}

/*  Gdk::Device
 */

Gdk::Device::Device(GdkDevice *device, bool reference)
: G::Object((GObject*)device, reference)
{
}
	
Gdk::Device::~Device()
{
}
	
GdkDeviceClass*
Gdk::Device::gdk_device_class() const
{
	return get_class<GdkDeviceClass>();
}

Gdk::Device::operator GdkDevice* () const
{
	return this ? gdk_device() : 0;
}

String
Gdk::Device::name() const
{
	return gdk_device()->name;
}

Gdk::InputSource
Gdk::Device::source() const
{
	return (InputSource)gdk_device()->source;
}

Gdk::InputMode
Gdk::Device::mode() const
{
	return (InputMode)gdk_device()->mode;
}

bool
Gdk::Device::has_cursor() const
{
	return gdk_device()->has_cursor;
}

void
Gdk::Device::get_state(Window& window, double *axes, ModifierTypeField *mask) const
{
	gdk_device_get_state(gdk_device(), window.gdk_window(), axes, (GdkModifierType*)mask);
}

bool
Gdk::Device::get_history(Window& window, unsigned long start, unsigned long stop, GdkTimeCoord ***events, int *n_events) const
{
	return gdk_device_get_history(gdk_device(), window.gdk_window(), start, stop, events, n_events);
}

void
Gdk::Device::free_history(GdkTimeCoord **events, int n_events)
{
	gdk_device_free_history(events, n_events);
}

bool
Gdk::Device::get_axis(double *axes, AxisUse use, double *value) const
{
	return gdk_device_get_axis(gdk_device(), axes, (GdkAxisUse)use, value) != 0;
}

Gdk::Device*
Gdk::Device::get_core_pointer(const Display *display)
{
	GdkDisplay *tmp_display = display ? display->gdk_display() : gdk_display_get_default();
	return G::Object::wrap<Device>(gdk_display_get_core_pointer(tmp_display));
}

void
Gdk::Device::set_source(InputSource source)
{
	gdk_device_set_source(gdk_device(), (GdkInputSource)source);
}
	  
bool
Gdk::Device::set_mode(InputMode mode)
{
	return gdk_device_set_mode(gdk_device(), (GdkInputMode)mode);
}

void
Gdk::Device::set_key(unsigned int index, unsigned int keyval, ModifierTypeField modifiers)
{
	gdk_device_set_key(gdk_device(), index, keyval, (GdkModifierType)modifiers);
}

void
Gdk::Device::set_axis_use(unsigned int index, AxisUse use)
{
	gdk_device_set_axis_use(gdk_device(), index, (GdkAxisUse)use);
}

