/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  image.cc - GdkImage C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "image.h"
#include "private/image_p.h"
#include "color.h"
#include "drawable.h"
#include "visual.h"
#include "../gdk-pixbuf/pixbuf.h"
#include <gdk/gdkpixbuf.h>

using namespace Inti;

/*  Gdk::Image
 */

Gdk::Image::Image(GdkImage *image, bool reference)
: G::Object((GObject*)image, reference)
{
}
	
Gdk::Image::~Image()
{
}
	
GdkImageClass*
Gdk::Image::gdk_image_class() const 
{ 
	return get_class<GdkImageClass>(); 
}
	
Gdk::Image::operator GdkImage* () const
{
	return this ? gdk_image() : 0; 
}
	
Pointer<Gdk::Image>
Gdk::Image::create(ImageType type, const Visual& visual, int width, int height)
{
	return G::Object::wrap<Image>(gdk_image_new((GdkImageType)type, visual.gdk_visual(), width, height));
}

const Gdk::Visual&
Gdk::Image::visual() const
{
	return *G::Object::wrap<Visual>(gdk_image()->visual);
}

Gdk::ImageType
Gdk::Image::image_type() const
{
	return (ImageType)gdk_image()->type;
}

Gdk::ByteOrder
Gdk::Image::byte_order() const
{
	return (ByteOrder)gdk_image()->byte_order;
}

int 
Gdk::Image::width() const
{
	return gdk_image()->width;
}

int
Gdk::Image::height() const
{
	return gdk_image()->height;
}

unsigned short 
Gdk::Image::depth() const
{
	return gdk_image()->depth;
}

unsigned short 
Gdk::Image::bytes_per_pixel() const
{
	return gdk_image()->bpp;
}

unsigned short 
Gdk::Image::bytes_per_line() const
{
	return gdk_image()->bpl;
}

unsigned int
Gdk::Image::get_pixel(int x, int y) const
{
	return gdk_image_get_pixel(gdk_image(), x, y);
}

Gdk::Colormap*
Gdk::Image::get_colormap() const
{
	GdkColormap *colormap = gdk_image_get_colormap(gdk_image());
	return colormap ? G::Object::wrap<Colormap>(colormap) : 0;
}

void
Gdk::Image::put_pixel(int x, int y, unsigned int pixel)
{
	gdk_image_put_pixel(gdk_image(), x, y, pixel);
}

void 
Gdk::Image::set_colormap(Colormap& colormap)
{
	gdk_image_set_colormap(gdk_image(), colormap.gdk_colormap());
}

/*  Gdk::ImageClass
 */

void
Gdk::ImageClass::init(GdkImageClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
}

GType
Gdk::ImageClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GDK_TYPE_IMAGE, (GClassInitFunc)init);
	}
	return type;
}

void*
Gdk::ImageClass::create()
{
	return g_object_new(get_type(), 0);
}

