/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  selection.cc - AtkSelection C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "selection.h"
#include "private/selection_p.h"
#include "object.h"

using namespace Inti;

/*  Atk::Selection
 */

Atk::Selection::~Selection()
{
}
	
AtkSelectionIface* 
Atk::Selection::atk_selection_iface() const 
{ 
	return peek<AtkSelectionIface>(ATK_TYPE_SELECTION); 
}
	
Atk::Selection::operator AtkSelection* () const 
{ 
	return this ? atk_selection() : 0;
}
	
int
Atk::Selection::get_selection_count() const
{
	return atk_selection_get_selection_count(atk_selection());
}

bool
Atk::Selection::is_child_selected(int i) const
{
	return atk_selection_is_child_selected(atk_selection(), i);
}

bool 
Atk::Selection::add_selection(int i)
{
	return atk_selection_add_selection(atk_selection(), i);
}

bool 
Atk::Selection::clear_selection()
{
	return atk_selection_clear_selection(atk_selection());
}

Atk::Object*
Atk::Selection::ref_selection(int i)
{
	AtkObject *object = atk_selection_ref_selection(atk_selection(), i);
	return object ? G::Object::wrap<Atk::Object>(object) : 0;
}

bool 
Atk::Selection::remove_selection(int i)
{
	return atk_selection_remove_selection(atk_selection(), i);
}

bool 
Atk::Selection::select_all_selection()
{
	return atk_selection_select_all_selection(atk_selection());
}

/*  Atk::SelectionIface
 */

void
Atk::SelectionIface::init(AtkSelectionIface *g_iface)
{
	g_iface->add_selection = &add_selection_proxy;
	g_iface->clear_selection = &clear_selection_proxy;
	g_iface->ref_selection = &ref_selection_proxy;
	g_iface->get_selection_count = &get_selection_count_proxy;
	g_iface->is_child_selected = &is_child_selected_proxy;
	g_iface->remove_selection = &remove_selection_proxy;
	g_iface->select_all_selection = &select_all_selection_proxy;
	g_iface->selection_changed = &selection_changed_proxy;
}

gboolean
Atk::SelectionIface::add_selection_proxy(AtkSelection *selection, gint i)
{
	gboolean result = false;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(selection));
	Atk::Selection *tmp_selection = dynamic_cast<Atk::Selection*>(object);
	if (tmp_selection)
		result =tmp_selection->do_add_selection(i);
	else
	{
		AtkSelectionIface *tmp_iface = ATK_SELECTION_GET_IFACE(selection);
		AtkSelectionIface *g_iface = static_cast<AtkSelectionIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->add_selection)
			result =g_iface->add_selection(selection, i);
	}
	return result;
}

gboolean
Atk::SelectionIface::clear_selection_proxy(AtkSelection *selection)
{
	gboolean result = false;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(selection));
	Atk::Selection *tmp_selection = dynamic_cast<Atk::Selection*>(object);
	if (tmp_selection)
		result =tmp_selection->do_clear_selection();
	else
	{
		AtkSelectionIface *tmp_iface = ATK_SELECTION_GET_IFACE(selection);
		AtkSelectionIface *g_iface = static_cast<AtkSelectionIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->clear_selection)
			result =g_iface->clear_selection(selection);
	}
	return result;
}

AtkObject*
Atk::SelectionIface::ref_selection_proxy(AtkSelection *selection, gint i)
{
	AtkObject *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(selection));
	Atk::Selection *tmp_selection = dynamic_cast<Atk::Selection*>(object);
	if (tmp_selection)
		result =tmp_selection->do_ref_selection(i);
	else
	{
		AtkSelectionIface *tmp_iface = ATK_SELECTION_GET_IFACE(selection);
		AtkSelectionIface *g_iface = static_cast<AtkSelectionIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->ref_selection)
			result =g_iface->ref_selection(selection, i);
	}
	return result;
}

gint
Atk::SelectionIface::get_selection_count_proxy(AtkSelection *selection)
{
	gint result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(selection));
	Atk::Selection *tmp_selection = dynamic_cast<Atk::Selection*>(object);
	if (tmp_selection)
		result =tmp_selection->do_get_selection_count();
	else
	{
		AtkSelectionIface *tmp_iface = ATK_SELECTION_GET_IFACE(selection);
		AtkSelectionIface *g_iface = static_cast<AtkSelectionIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->get_selection_count)
			result =g_iface->get_selection_count(selection);
	}
	return result;
}

gboolean
Atk::SelectionIface::is_child_selected_proxy(AtkSelection *selection, gint i)
{
	gboolean result = false;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(selection));
	Atk::Selection *tmp_selection = dynamic_cast<Atk::Selection*>(object);
	if (tmp_selection)
		result =tmp_selection->do_is_child_selected(i);
	else
	{
		AtkSelectionIface *tmp_iface = ATK_SELECTION_GET_IFACE(selection);
		AtkSelectionIface *g_iface = static_cast<AtkSelectionIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->is_child_selected)
			result =g_iface->is_child_selected(selection, i);
	}
	return result;
}

gboolean
Atk::SelectionIface::remove_selection_proxy(AtkSelection *selection, gint i)
{
	gboolean result = false;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(selection));
	Atk::Selection *tmp_selection = dynamic_cast<Atk::Selection*>(object);
	if (tmp_selection)
		result =tmp_selection->do_remove_selection(i);
	else
	{
		AtkSelectionIface *tmp_iface = ATK_SELECTION_GET_IFACE(selection);
		AtkSelectionIface *g_iface = static_cast<AtkSelectionIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->remove_selection)
			result =g_iface->remove_selection(selection, i);
	}
	return result;
}

gboolean
Atk::SelectionIface::select_all_selection_proxy(AtkSelection *selection)
{
	gboolean result = false;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(selection));
	Atk::Selection *tmp_selection = dynamic_cast<Atk::Selection*>(object);
	if (tmp_selection)
		result =tmp_selection->do_select_all_selection();
	else
	{
		AtkSelectionIface *tmp_iface = ATK_SELECTION_GET_IFACE(selection);
		AtkSelectionIface *g_iface = static_cast<AtkSelectionIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->select_all_selection)
			result =g_iface->select_all_selection(selection);
	}
	return result;
}

void
Atk::SelectionIface::selection_changed_proxy(AtkSelection *selection)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(selection));
	Atk::Selection *tmp_selection = dynamic_cast<Atk::Selection*>(object);
	if (tmp_selection)
		tmp_selection->on_selection_changed();
	else
	{
		AtkSelectionIface *tmp_iface = ATK_SELECTION_GET_IFACE(selection);
		AtkSelectionIface *g_iface = static_cast<AtkSelectionIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->selection_changed)
			g_iface->selection_changed(selection);
	}
}

/*  Overridable methods
 */

bool
Atk::Selection::do_add_selection(int i)
{
	bool result = false;
	AtkSelectionIface *g_iface = peek_parent<AtkSelectionIface>(atk_selection_iface());
	if (g_iface->add_selection)
		result = g_iface->add_selection(atk_selection(), i);
	return result;
}

bool
Atk::Selection::do_clear_selection()
{
	bool result = false;
	AtkSelectionIface *g_iface = peek_parent<AtkSelectionIface>(atk_selection_iface());
	if (g_iface->clear_selection)
		result = g_iface->clear_selection(atk_selection());
	return result;
}

AtkObject*
Atk::Selection::do_ref_selection(int i)
{
	AtkObject *result = 0;
	AtkSelectionIface *g_iface = peek_parent<AtkSelectionIface>(atk_selection_iface());
	if (g_iface->ref_selection)
		result = g_iface->ref_selection(atk_selection(), i);
	return result;
}

int
Atk::Selection::do_get_selection_count()
{
	int result = 0;
	AtkSelectionIface *g_iface = peek_parent<AtkSelectionIface>(atk_selection_iface());
	if (g_iface->get_selection_count)
		result = g_iface->get_selection_count(atk_selection());
	return result;
}

bool
Atk::Selection::do_is_child_selected(int i)
{
	bool result = false;
	AtkSelectionIface *g_iface = peek_parent<AtkSelectionIface>(atk_selection_iface());
	if (g_iface->is_child_selected)
		result = g_iface->is_child_selected(atk_selection(), i);
	return result;
}

bool
Atk::Selection::do_remove_selection(int i)
{
	bool result = false;
	AtkSelectionIface *g_iface = peek_parent<AtkSelectionIface>(atk_selection_iface());
	if (g_iface->remove_selection)
		result = g_iface->remove_selection(atk_selection(), i);
	return result;
}

bool
Atk::Selection::do_select_all_selection()
{
	bool result = false;
	AtkSelectionIface *g_iface = peek_parent<AtkSelectionIface>(atk_selection_iface());
	if (g_iface->select_all_selection)
		result = g_iface->select_all_selection(atk_selection());
	return result;
}

/*  Signal handlers
 */

void
Atk::Selection::on_selection_changed()
{
	AtkSelectionIface *g_iface = peek_parent<AtkSelectionIface>(atk_selection_iface());
	if (g_iface->selection_changed)
		g_iface->selection_changed(atk_selection());
}

/*  Signals
 */

const Atk::Selection::SelectionChangedSignalType Atk::Selection::selection_changed_signal("selection_changed");

