#include "filesel.h"
#include <inti/gtk/button.h>
#include <iostream>

FileSelection::FileSelection()
: Gtk::FileSelection("File selection")
{
	ok_button()->sig_clicked().connect(slot(this, &FileSelection::on_ok));
	cancel_button()->sig_clicked().connect(slot(this, &FileSelection::dispose));

	// Lets set the filename, as if this were a save dialog, and we are giving a default filename.
	set_filename("penguin.png");
}

FileSelection::~FileSelection()
{
}

void
FileSelection::on_ok()
{
	std::cout << get_filename().c_str() << '\n';
}

INTI_MAIN(FileSelection)

