/** Copyright  2003 by Jean-Hugues de Raigniac <jhraigniac@workingfrog.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.workingfrog.i18n.util;

import java.io.InputStream;
import java.io.IOException;

import java.util.Properties;

/**
 * Maps "legacy" keys with i18n keys.
 *
 * @author Jean-Hugues de Raigniac
 */
public class Wrapper {

    /** mapping between "legacy" keys and i18n keys */
    private static Properties keys = new Properties();

    /**   
     * Loads key bindings from a file.
     * @param appClass Class of the Caller
     * @param file the properties file
     */
    public static void loadKeyFile (Class appClass, String file) {

        InputStream inputStream = null;

        try {
            inputStream = appClass.getResourceAsStream(file);
            keys.load(inputStream);
            inputStream.close();
        } catch (IOException ex) {
            System.out.println("Unable to load properties from file: " + file);
            System.exit(1);
        }
    }

    /**
     * Return the i18n version of the key provided.
     * @param name the "legacy" key
     * @return the i18n version
     */
    public static String getI18NKey (String name) {
        return keys.getProperty(name, name);
    }
}
