/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: HoverEvent.java,v 1.6 2005/05/28 23:12:01 pietschy Exp $
 */

package org.pietschy.command;

import javax.swing.*;
import java.awt.*;
import java.util.EventObject;


/**
 * Fired when the mouse enters and exits a command.
 *
 * @see CommandManager#addHoverListener
 * @see Command#addHoverListener
 * @see HoverListener
 */
public class
HoverEvent
extends EventObject
{
   private Face face;
   private Component component;

   public HoverEvent(Command command, Face face, Component component)
   {
      super(command);
      this.face = face;
      this.component = component;
   }

   /**
    * Gets the command associated with the HoverEvent.
    *
    * @return the command associated with the HoverEvent.
    */
   public Command getCommand()
   {
      return (Command) getSource();
   }

   /**
    * Gets the Face associated with the hover event.
    *
    * @return the Face associated with the hover event.
    */
   public Face getFace()
   {
      return face;
   }

   /**
    * Checks if the specified window contains the the  on which that raised the hover event.
    * <p>
    * This method can be used to filter out hover events that are raised on a shared
    *
    * @param window the component.
    * @return <tt>true</tt> if the the hovered component is in the same window as the specified
    *         component.
    */
   public boolean
   isInWindow(Window window)
   {
      Window w = SwingUtilities.getWindowAncestor(this.component);

      if ((window == null || w == null))
         return false;

      return window.equals(w);
   }
}
