/**
 * GUI Commands
 * Copyright 2005 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: GroupMemberFactory.java,v 1.3 2005/06/15 23:43:00 pietschy Exp $
 */

package org.pietschy.command;

/**
 * This factory interface is used by the library to create instances of {@link GroupMember}.
 * The factory can be configured by calling {@link CommandManager#setGroupMemberFactory(GroupMemberFactory)}.
 * @version $Revision: 1.3 $
 * @author andrewp
 * @see CommandManager#setGroupMemberFactory(GroupMemberFactory)
 */
public interface
GroupMemberFactory
{

   GroupMember
   createGlueMember();

   GroupMember
   createSeparatorMember();

   GroupMember
   createSimpleMember(CommandGroup parent, Command command);

   GroupMember
   createLazyMember(CommandGroup parent, String commandId, boolean inline);

   GroupMember
   createInlineMember(CommandGroup parent, CommandGroup inlineGroup);

   ExpansionGroupMember
   createExpansionMember(String name);

   GroupContainerManager
   createContainerManager();
}
