/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: CommandManagerListener.java,v 1.2 2004/12/12 05:29:20 pietschy Exp $
 */

package org.pietschy.command;

import java.util.EventListener;

/**
 * A listener interface for monitoring a {@link CommandManager}.  This method defines
 * the single method {@link #commandRegistered}.
 */
public interface
CommandManagerListener
extends EventListener
{
   /**
    * Invoked when a new command is registered with the container.  This method will be invoked
    * for all commands added to the container or any parent container.
    * @param event the event detailing the registered command.
    */
   public void commandRegistered(CommandManagerEvent event);
}
