/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ActionAdapter.java,v 1.5 2004/12/12 05:29:18 pietschy Exp $
 */

package org.pietschy.command;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/**
 * The class provides an adaptor between commands and swing Actions.
 */
class
ActionAdapter
extends AbstractAction
implements PropertyChangeListener
{
   private ActionCommand command;
   private String faceId;
   private ActionListener delegate;

   protected ActionAdapter(ActionCommand command, ActionListener delegate)
   {
      this(command, Face.DEFAULT, delegate);
   }

   protected ActionAdapter(ActionCommand command, String faceId, ActionListener delegate)
   {
      this.command = command;
      this.faceId = faceId;
      this.delegate = delegate;
      command.addPropertyChangeListener(this);
      configure();
   }

   /**
    * Invoked when an action occurs.
    */
   public void actionPerformed(ActionEvent e)
   {
      delegate.actionPerformed(e);
   }

   /**
    * This method gets called when a bound property is changed.
    * @param evt A PropertyChangeEvent object describing the event source
    *   	and the property that has changed.
    */
   public void propertyChange(PropertyChangeEvent evt)
   {
      configure();
   }

   protected void
   configure()
   {
      Face face = command.getFace(faceId);

      setEnabled(command.isEnabled());
      putValue(AbstractAction.ACTION_COMMAND_KEY, command.getActionCommand());
      putValue(AbstractAction.NAME, face.getText());
      putValue(AbstractAction.MNEMONIC_KEY, face.getMnemonic());
      putValue(AbstractAction.SMALL_ICON, face.getIcon());
      putValue(AbstractAction.ACCELERATOR_KEY, face.getAccelerator());
      putValue(AbstractAction.SHORT_DESCRIPTION, face.getDescription());
      putValue(AbstractAction.LONG_DESCRIPTION, face.getLongDescription());
   }

}
