/*******************************************************************************************************************************************
 cmessagedialog.c
*******************************************************************************************************************************************/

#include "cmessagedialog.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_DYNAMIC_METACLASS (CMessageDialog);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CMessageDialog::CMessageDialog  (CForm *inOwner, const CString &inCaption, const CString &inLabel, const int inButtons, 
				 const TMessageDialog inMessageDialog, const bool inModal, const CDialogListener *inListener)
	       :CDialog	        (NULL, inCaption, inButtons, inModal, inListener),
		m_Message       (inLabel),
		m_MessageDialog (inMessageDialog)
{
	// request the gtk widget instanciation process
	if (inOwner != NULL) SetOwner (inOwner);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CMessageDialog::~CMessageDialog ()
{
	// gtk widget deletion coherence requested
	CWidget::DestroyWidget (this);
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget instanciation
//-----------------------------------------------------------------------------------------------------------------------------------------
GtkWidget * CMessageDialog::PerformWidgetInstanciate ()
{
	// get the form owner
	CForm *inForm = static_cast <CForm *> (GetOwner (__metaclass(CForm)));

	// pointer check
	if (inForm == NULL || inForm -> GetGtkWidget() == NULL) return NULL;

	// message type
	GtkMessageType inMessageDialog = GTK_MESSAGE_INFO;

	// message type analyse
	switch (m_MessageDialog)
	{
		case MESSAGEDIALOG_INFORMATION  : inMessageDialog = GTK_MESSAGE_INFO;     break;
		case MESSAGEDIALOG_WARNING      : inMessageDialog = GTK_MESSAGE_WARNING;  break;
		case MESSAGEDIALOG_QUESTION     : inMessageDialog = GTK_MESSAGE_QUESTION; break;
		case MESSAGEDIALOG_ERROR        : inMessageDialog = GTK_MESSAGE_ERROR;    break;
	}

	// ok, instanciate the gtk widget
	return ::gtk_message_dialog_new (GTK_WINDOW(inForm -> GetGtkWidget()), (GtkDialogFlags)0, inMessageDialog, GTK_BUTTONS_NONE,
					 m_Message.Get());
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// gtk widget initialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CMessageDialog::PerformWidgetInitialize ()
{
	// generic call, no more to initialize
	CDialog::PerformWidgetInitialize();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// xml serialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CMessageDialog::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// serialization request analyse
	switch (inMode)
	{
		// xml dump
		case XML_WRITE :
		{
			// generic call first
			CDialog::Serialize (ioXMLElementNode, inMode);

			// allocate a new xml element
			CXMLElement *newXMLElement = new CXMLElement (ioXMLElementNode, XML_MESSAGEDIALOG_ELEMENT);

			// modify the io xml node so that derived definition would serialize under the current node
			ioXMLElementNode = newXMLElement -> GetXMLElementNode ();

			// set the out message dialog type attribute
			CString outMessageDialog; switch (m_MessageDialog)
			{
				case MESSAGEDIALOG_INFORMATION	: outMessageDialog = CString("information"); break;
				case MESSAGEDIALOG_WARNING	: outMessageDialog = CString("warning");     break;
				case MESSAGEDIALOG_QUESTION	: outMessageDialog = CString("question");    break;
				case MESSAGEDIALOG_ERROR	: outMessageDialog = CString("error");       break;
			}

			// add the message dialog type attribute
			newXMLElement -> AddAttribute (XML_MESSAGEDIALOG_ATTR_TYPE, outMessageDialog);

			// create the label xml element
			new CXMLElement (ioXMLElementNode, XML_MESSAGEDIALOG_MESSAGE_ELEMENT, m_Message);
		}
		break;
	
		// xml load
		case XML_READ :
		{
			// get the xml element node the cmessagedialog is expected to read from
			CXMLElementNode *inXMLNode = ::xml_node_search (ioXMLElementNode, XML_MESSAGEDIALOG_ELEMENT);

			// check we got it !
			if (inXMLNode == NULL)
				throw new CException (CString("CMessageDialog::Serialize, specified xml node is not a \"") + 
							      XML_MESSAGEDIALOG_ELEMENT + CString("\" element one."), 
						      __exception(XMLPARSE));

			// get the message dialog type attribute, defaults to informational
			m_MessageDialog = MESSAGEDIALOG_INFORMATION;
			CString inMessageDialog (::xml_node_get_attribute (inXMLNode, XML_MESSAGEDIALOG_ATTR_TYPE).GetValue());

			// set the message dialog type property
			if (inMessageDialog == CString("warning"))  m_MessageDialog = MESSAGEDIALOG_WARNING;  else
			if (inMessageDialog == CString("question")) m_MessageDialog = MESSAGEDIALOG_QUESTION; else
			if (inMessageDialog == CString("error"))    m_MessageDialog = MESSAGEDIALOG_ERROR;

			// get the message xml element
			CXMLElementNode *inMessageXMLNode = ::xml_node_get_child (inXMLNode, XML_MESSAGEDIALOG_MESSAGE_ELEMENT);

			// check we got it !
			if (inMessageXMLNode == NULL)
				throw new CException (CString("CMessageDialog::Serialize, specified xml node is not a \"") + 
							      XML_MESSAGEDIALOG_MESSAGE_ELEMENT + CString("\" element one."), 
						      __exception(XMLPARSE));

			// set the message property from the xml node value
			m_Message = ::xml_node_get_value (inMessageXMLNode);

			// the dialog properties are set, so call the generic definition that will perform the instanciation process
			CDialog::Serialize (ioXMLElementNode, inMode);

			// modify the io xml element node pointer so that overwritten definition continue
			ioXMLElementNode = inXMLNode;
		}
		break;
	}
}


