/*******************************************************************************************************************************************
 capplication.h
 
 CClass
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
   	     |--CApplication

 gtkol main application component definition. The gtkol CApplication component should be the first one to be instanciated. It is the 
 hierarchy absolute component and always has its id set to 1L so any gtkol instance may retreive the application pointer by calling 
 CComponent::GetComponent (1L). The CApplication retains the command line parameters so that it is able to launch again from serialization 
 process with the same arguments.
*******************************************************************************************************************************************/

#ifndef __CAPPLICATION_H__
#define __CAPPLICATION_H__

#include "cform.h"
#include "cdialog.h"
#include "cmessagedialog.h"
#include "cfiledialog.h"
#include "cfilechooserdialog.h"
#include "caboutdialog.h"
#include "cmenu.h"
#include "cbutton.h"
#include "ctogglebutton.h"
#include "ccheckbutton.h"
#include "cradiobutton.h"
#include "cspinbutton.h"
#include "ccolorbutton.h"
#include "cfontbutton.h"
#include "cvboxlayout.h"
#include "chboxlayout.h"
#include "chpaned.h"
#include "cvpaned.h"
#include "ctablelayout.h"
#include "cnotebook.h"
#include "cscrollview.h"
#include "ctreeview.h"
#include "ctextview.h"
#include "ciconview.h"
#include "centry.h"
#include "ccombobox.h"
#include "ccomboboxentry.h"
#include "ctoolbar.h"
#include "cprogressbar.h"
#include "cstatusbar.h"
#include "cexpander.h"
#include "chseparator.h"
#include "cvseparator.h"
#include "chscale.h"
#include "cvscale.h"
#include "clabel.h"
#include "cframe.h"
#include "cimage.h"

//------------------------------------------------------------------------------------------------------------------------------------------
// capplication xml serialization constants
//------------------------------------------------------------------------------------------------------------------------------------------
// <capplication>
//     <argv>string</argv>
//   [ <argv>string</argv> ]
//     ...
// </capplication>
//------------------------------------------------------------------------------------------------------------------------------------------
static CString XML_APPLICATION_ELEMENT		("capplication");
static CString XML_APPLICATION_ARGV_ELEMENT	("argv");

//------------------------------------------------------------------------------------------------------------------------------------------
// CApplication class
//------------------------------------------------------------------------------------------------------------------------------------------
class CApplication : public CComponent
{
	// instanciation section
	public :

		// the gtk library is initialized only if those parameters are specified, otherwise it is the serialization process that
		// holds the gtk initialization; if you declare a CApplication instance, be carefull to give it your command line arguments
		CApplication			(int argc=0, char **argv=NULL) THROWABLE;
		virtual ~CApplication		();

	// specific functions
	public :

		// application execution, messages queue analyse, dispatching and flush request
		void				Run			();
		static void			Flush			();

		// get the screen size
		static TSize			GetScreenSize		();

		// get the user home directory
		static CString			GetHomeDir		();

	// gtkol application serialization
	public :

		// xml instance specific serialization
		virtual void			Serialize		(CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE;

	// protected attributes and functions
	protected :

		// command line local copy
		CStrings			m_Argv;

		// initialize the gtk library
		void				InitializeGtk		();

		// metaclass specifications
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag definition
DECLARE_DYNAMIC_METACLASS ('appl', CApplication, CComponent);

#endif
