------------------------------------------------------------------------------
--                                                                          --
--                	        G N A T . RAVENSCAR                         --
--                                                                          --
--                      Copyright (C) 2008-2015, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

with GNAT.Ravenscar.Report;

package body Test_All.Multiple_Queue_Cyclic_Server is

   --------------
   -- Dispatch --
   --------------

   procedure Dispatch (Params : Param_T) is
   begin
      case Params.Req is
         when REQ1 =>
            GNAT.Ravenscar.Report.Print ("REQ1 with I = " &
                                        Natural'Image (Params.REQ1_I));
         when REQ2 =>
            GNAT.Ravenscar.Report.Print ("REQ2 with I = " &
                                        Natural'Image (Params.REQ2_I));
      end case;
      --  Update_Counter;
   end Dispatch;

   ---------------
   -- Cyclic_OP --
   ---------------

   procedure Cyclic_OP is
   begin
      GNAT.Ravenscar.Report.Print ("Cyclic_OP");
      Update_Counter;
   end Cyclic_OP;

end Test_All.Multiple_Queue_Cyclic_Server;
