------------------------------------------------------------------------------
--                                                                          --
--                	        G N A T . RAVENSCAR                         --
--                                                                          --
--                      Copyright (C) 2008-2015, AdaCore                    --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the  Free Software Foundation,  51  Franklin  Street,  Fifth  Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- Extensive contributions were provided by Ada Core Technologies Inc.      --
--                                                                          --
------------------------------------------------------------------------------

pragma Profile (Ravenscar);

with Ada.Real_Time; use Ada.Real_Time;
with System;
with Test_All;
with Test_All.Sporadic_Server_With_Callback;
use Test_All.Sporadic_Server_With_Callback;

procedure Test_Sporadic_Server_With_Callback is
   pragma Priority (System.Priority'First);
   Req : In_Request_T;
begin
   Req.I := 0;
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
   Req.I := Req.I + 1;
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
   Req.I := Req.I + 1;
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
   Req.I := Req.I + 1;
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
   Req.I := Req.I + 1;
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
   Req.I := Req.I + 1;
   delay until Test_All.System_Start_Up + Milliseconds (300);
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
   Req.I := Req.I + 1;
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
   Req.I := Req.I + 1;
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
   Req.I := Req.I + 1;
   delay until Test_All.System_Start_Up + Milliseconds (700);
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
   Req.I := Req.I + 1;
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
   Req.I := Req.I + 1;
   My_Sporadic_Server.Put_Request (Req, Callback'Access);
end Test_Sporadic_Server_With_Callback;
