/* $Id: order.c,v 1.2 2002/12/08 01:56:52 skids Exp $
******************************************************************************

   Graphics library for GGI. WMH stuff.

   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "xwmh.h"


int GGIwmh_x_zorder  (ggi_visual_t vis,enum ordercmd command)
{
	ggi_x_priv *priv;                                                   
	priv=LIBGGI_PRIVATE(vis);

	switch(command)
	{
		case ZO_TOP:
			ggLock(priv->xliblock);
			XRaiseWindow(priv->disp, priv->parentwin);
		        XSync(priv->disp,0);
			ggUnlock(priv->xliblock);
			return 0;
		case ZO_BOTTOM:
			ggLock(priv->xliblock);
			XLowerWindow(priv->disp, priv->parentwin);
		        XSync(priv->disp,0);
			ggUnlock(priv->xliblock);
			return 0;
		default:
			return -1;
	}
	return -1;
}

