#include "cfile.h"
#include "cserialized.h"

class CSerializedString : public CSerialized
{
	public :
		CString String;
	public :
		CSerializedString (const CString &inString=CString()) : String (inString)
		{ }
	public :
		virtual void Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode)
		{
			CSerialized::Serialize (ioXMLElementNode, inMode);
			switch (inMode)
			{
				case XML_READ :
				{
					CString xmlNodeName ("string-value");
					CXMLElementNode *xmlElementNode (::xml_node_get_child (ioXMLElementNode, xmlNodeName));
					if (xmlElementNode != NULL) String = ::xml_node_get_value (xmlElementNode);
				}
				break;
				case XML_WRITE :
				{
					CString xmlNodeName ("string-value");
					new CXMLElement (ioXMLElementNode, xmlNodeName, String);
				}
				break;
			}
		}
		SECTION_DYNAMIC_METACLASS;
};
DECLARE_DYNAMIC_METACLASS ('szsr', CSerializedString, CSerialized);
RESOLVE_DYNAMIC_METACLASS (CSerializedString);


int main (int argc, char **argv)
{
	if (!CFile::Exists (CString("./demo-base.xml")))
	{
		CSerializedString str1 (CString("GRemi"));
		CSerializedString str2 (CString("Lili"));

		CXMLDocument XMLDocument (CString("./demo-base.xml"), XML_WRITE, CString("demo"));

		XMLDocument << str1;
		XMLDocument << str2;
	}
	else
	{
		CXMLDocument XMLDocument (CString("./demo-base.xml"), XML_READ, CString("demo"));
		CXMLElementNode *inRoot = XMLDocument.GetRootElement ();

		for (size_t i=0; i<xml_node_get_children_number(inRoot); i++)
		{
			CSerializedString *str = 
				static_cast <CSerializedString *> (CSerialized::Instanciate (::xml_node_get_child (inRoot, i)));

			if (str != NULL)
			{
				::fprintf (stdout, "%s\n", str->String.Get());
				delete str;
			}
		}

		delete inRoot;
	}
	
	return 0;
}
