/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Firewall.hh,v 1.3 2001/12/19 12:46:23 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __FIREWALL_HH_FLAG__
#define __FIREWALL_HH_FLAG__

#include <fwbuilder/Host.hh>

namespace libfwbuilder
{

class Policy;
class NAT;

class Firewall : public Host 
{
    
    protected:
    
    public:
    
    Firewall();
    virtual ~Firewall();
    
    virtual void fromXML(xmlNodePtr parent);
    virtual xmlNodePtr toXML      (xmlNodePtr parent);
    
    
    DECLARE_FWOBJECT_SUBTYPE(Firewall);
    
    /**
     * verify whether given object type is approppriate as a child
     */
    virtual bool    validateChild(FWObject *o);

    virtual void    setDefaults();
    virtual FWOptions* getOptionsObject();

    Policy  *getPolicy();
    NAT     *getNAT();
};

}

#endif //__FIREWALL_HH_FLAG__
