/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#if 0

/* XML parser options */

#define XML_LOG_WARN (1 << 0)
#define XML_LOG_ERR  (1 << 1)
#define XML_STRICT   (1 << 2)
#define XML_DESCEND  (1 << 3)

/* Fragment types returned by xml_frag_type() */

enum
{
  XML_UNKNOWN = -1, XML_DOC_END = 1, XML_END, XML_DATA,
  XML_TAG_SPAN, XML_TAG_EMPTY, XML_ATTR
};

/* Obsolete function names */

#define xml_dtd_to_ttree xml_dtd_to_t
#define xml_f_to_ttree xml_f_to_t
#define xml_ttree_to_xml_f xml_t_to_f
#define xmltree_space_collapse xml_t_trim

/* Input/output */

TTREE *xml_dtd_to_t(char *source_file, char *root_name, unsigned long options);
TTREE *xml_f_to_t(FILE *source_file, unsigned long options);
int xml_t_to_f(TTREE *xml_tree, FILE *out);

/* Treatment */

int xml_t_trim(TTREE *xml);

/* Traversing */

int xml_frag_type(TTREE *x);
unsigned char *xml_frag_name(TTREE *x);
unsigned char *xml_frag_data(TTREE *x);
TTREE *xml_frag_next(TTREE *x);
TTREE *xml_frag_prev(TTREE *x);
TTREE *xml_frag_enter(TTREE *x);
TTREE *xml_frag_enter_name(TTREE *x, char *name);
TTREE *xml_frag_enter_sibling_name(TTREE *x, char *name);
TTREE *xml_frag_exit(TTREE *x);

/* Obsolete traversing */

int tag_type(TTREE **x);
int tag_enter_name(TTREE **x, char *name);
int tag_enter_name_sibling(TTREE **x, char *name);
int tag_enter(TTREE **x);
int tag_exit(TTREE **x);
int tag_next(TTREE **x);
char *tag_name(TTREE **x);
char *tag_data(TTREE **x);

#endif
