/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http.servlet;

import java.text.ParseException;
import java.util.Date;

import junit.framework.TestCase;

public class HttpDateFormatTest extends TestCase {
	
	HttpDateFormat hdf = new HttpDateFormat();
	
	public void testBasic() throws ParseException {
		Date parse = hdf.parse("Sun, 06 Nov 1994 08:49:37 GMT");
		Date parse2 = hdf.parse("Sunday, 06-Nov-94 08:49:37 GMT");
		Date parse3 = hdf.parse("Sun Nov  6 08:49:37 1994");
		Date parse4 = hdf.parse("Sun Nov 16 08:49:37 1994");
		long at = 784111777000L;
		assertEquals(at, parse.getTime());
		assertEquals(at, parse2.getTime());
		assertEquals(at, parse3.getTime());
		long day = 1000 * 60 * 60 * 24;
		assertEquals(at + day * 10, parse4.getTime());
	}
}
