#include <ept/config.h>
#include <ept/tests/test-utils.h>
#include <ept/cache/relation.h>

namespace tut {
using namespace ept;
using namespace configuration::apt;
using namespace cache;

struct cache_relation_shar : common {
    Packages c;
    Relation a;
    Version v;
    Relation r;
    wibble::Range<Relation> rr;
    wibble::Range<Version> vr;
    wibble::Range<Package> pr;
};

TESTGRP( cache_relation );

template<> template<>
void to::test<1> ()
{
    v = c.index().packageByName("postfix").candidateVersion();
    rr = v.relations();
    ensure( !rr.empty() );
}

template<> template<>
void to::test<2>()
{
    v = c.index().packageByName("postfix").candidateVersion();
    rr = v.relations();

    ensure ( !rr.empty() );

    ensure( !rr.head().targetPackages().empty() );
    ensure_equals( rr.head().targetPackages().head().name(), "libc6" );
    rr = rr.tail();
    ensure_equals( rr.head().targetPackages().head().name(), "libdb4.2" );
    rr = rr.tail();
    ensure_equals( rr.head().targetPackages().head().name(), "libgdbm3" );
    rr = rr.tail();
    pr = rr.head().targetPackages();
    ensure_equals( pr.head().name(), "debconf" );
    pr = pr.tail();
    // ensure_equals( pr->name(), "debconf-2.0" );
    // ++ pr;
    ensure( pr.empty() );

    rr = rr.tail();
    ensure_equals( rr.head().targetPackages().head().name(), "netbase" );
    rr = rr.tail();
    ensure_equals( rr.head().targetPackages().head().name(), "adduser" );
    rr = rr.tail();
    ensure_equals( rr.head().targetPackages().head().name(), "dpkg" );
    rr = rr.tail();
    ensure_equals( rr.head().targetPackages().head().name(), "debconf" );

    rr = rr.tail();
    ensure_equals( rr.head().targetPackages().head().name(), "procmail" );
    rr = rr.tail(); rr = rr.tail(); rr = rr.tail(); rr = rr.tail(); rr = rr.tail(); rr = rr.tail(); // no target versions in there
    ensure_equals( rr.head().targetPackages().head().name(), "resolvconf" );
    rr = rr.tail(); rr = rr.tail(); rr = rr.tail();
    rr = rr.tail(); rr = rr.tail(); // not here either
    /* ensure_equals( rr.head().targetPackages()->name(), "postfix-doc" );
       rr = rr.tail(); rr = rr.tail(); */
    rr = rr.tail(); rr = rr.tail();
    ensure( rr.empty() );

    while ( !rr.empty() ) {
        if ( !rr.head().targetPackages().empty() )
            std::cerr << rr.head().targetPackages().head().name() << std::endl;
        else
            std::cerr << "no target packages" << std::endl;
        rr = rr.tail();
    }
    // rr = rr.tail();
    // ensure_equals( rr.head().targetPackages()->name(), "postfix-mysql" );
}

template<> template<>
void to::test<3>()
{
    v = c.index().packageByName("postfix").candidateVersion();
    rr = v.relations();

    ensure( !rr.head().targetPackages().empty() );
    ensure_equals( rr.head().format(), "required: libc6 >= 2.3.2.ds1-4" );
    rr = rr.tail();
    ensure_equals( rr.head().format(), "required: libdb4.2" );
    rr = rr.tail();
    ensure_equals( rr.head().format(), "required: libgdbm3" );
    rr = rr.tail();
    ensure_equals( rr.head().format(), "required: debconf >= 0.5 or debconf-2.0" );
    rr = rr.tail();
    ensure_equals( rr.head().format(), "required: netbase" );
    rr = rr.tail();
    ensure_equals( rr.head().format(), "required: adduser >= 3.48" );
    rr = rr.tail();
    ensure_equals( rr.head().format(), "required: dpkg >= 1.8.3" );
    rr = rr.tail();
    ensure_equals( rr.head().format(), "required: debconf" );
    rr = rr.tail();

    rr = rr.tail();
    ensure_equals( rr.head().format(), "suggested: postfix-mysql" );
}

template<> template<>
void to::test<4>()
{
    v = c.index().packageByName("postfix").candidateVersion();
    rr = v.relations();
    std::string rels;

    while ( !rr.empty() ) {
        rels += rr.head().format() + "\n ";
        rr = rr.tail();
    }

    ensure_equals( rels,
                   "required: libc6 >= 2.3.2.ds1-4\n required: libdb4.2\n "
                   "required: libgdbm3\n "
                   "required: debconf >= 0.5 or debconf-2.0\n required: netbase\n "
                   "required: adduser >= 3.48\n required: dpkg >= 1.8.3\n "
                   "required: debconf\n "
                   "suggested: procmail\n "
                   "suggested: postfix-mysql\n suggested: postfix-pgsql\n "
                   "suggested: postfix-ldap\n suggested: postfix-pcre\n "
                   "recommended: mail-reader\n recommended: resolvconf\n "
                   "conflict: mail-transport-agent\n conflict: smail\n "
                   "conflict: libnss-db < 2.2-3\n conflict: postfix-tls < 2.0-0\n "
                   "replaces: postfix-doc < 1.1.7-0\n replaces: postfix-tls\n " );

}

template<> template<>
void to::test< 5 >()
{
    const char *sat[] = { "exim4", "exim", "postfix", "fetchmail" };
    v = c.index().packageByName( "procmail" ).candidateVersion();
    rr = v.relations();
    rr = rr.tail(); // libc6
    pr = rr.head().targetPackages(); // exim4 | mail-transport-agent | fetchmail

    int i = 0;
    while ( !pr.empty() ) {
        ensure_equals( pr.head().name(), sat[i] );
        // std::cerr << pr->name() << std::endl;
        pr = pr.tail();
        ++i;
    };
    ensure_equals( i, 4 );
}

}

#include <ept/cache/apt/index.tcc>
#include <ept/cache/relation.tcc>
// vim:set ts=4 sw=4:
