/** -*- C++ -*-
    @file cache/cache.h
    @author Peter Rockai <me@mornfall.net>
*/

#ifndef EPT_CACHE_COMPONENT_H
#define EPT_CACHE_COMPONENT_H

#include <wibble/amorph.h>

namespace ept {
namespace t {
namespace cache {

template< typename C >
struct Pointer {
    typedef typename C::Aggregator Aggregator;
    const Aggregator &aggregator() const { return *m_aggregator; }
    Pointer( const Aggregator &c ) : m_aggregator( &c ) {}
    Pointer() : m_aggregator( 0 ) {}
    bool valid() const { return m_aggregator; }
private:
    const Aggregator *m_aggregator;
};

}
}
}

#endif
